/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.opengles;

import com.yy.mediaframework.model.YMFImageBuffer;
import com.yy.mediaframework.opengles.IProgram;
import com.yy.mediaframework.opengles.IRender;
import com.yy.mediaframework.opengles.YMFFramebuffer;
import com.yy.mediaframework.opengles.YMFProgramFactory;
import com.yy.mediaframework.opengles.YMFTexture;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;

public class YMFRender
implements IRender {
    private static final String TAG = "YMFRender";
    private IProgram mProgram;
    private YMFTexture[] mInputImageTextures;
    private YMFTexture mInput2dTexture;
    private YMFTexture mWaterMarkTexture;
    private YMFFramebuffer mFrameBuffer;

    public YMFRender(int programType) {
        this.mProgram = YMFProgramFactory.craeteProgram(programType);
    }

    private void createProgram(YMFImageBuffer buffer) {
        switch (buffer.mFormat) {
            case 2: {
                this.mProgram = YMFProgramFactory.craeteProgram(3);
                break;
            }
            case 1: {
                this.mProgram = YMFProgramFactory.craeteProgram(2);
                break;
            }
            case 0: {
                this.mProgram = YMFProgramFactory.craeteProgram(1);
                break;
            }
            case 36: {
                this.mProgram = YMFProgramFactory.craeteProgram(0);
                break;
            }
            default: {
                YMFLog.error((Object)this, "[Util    ]", "createProgram unsupported image format. ");
            }
        }
    }

    private void createYuv420pTexture(int width, int height) {
        this.mInputImageTextures = new YMFTexture[3];
        this.mInputImageTextures[0] = new YMFTexture(3553, width, height, 6409, 33984);
        this.mInputImageTextures[1] = new YMFTexture(3553, width / 2, height / 2, 6409, 33985);
        this.mInputImageTextures[2] = new YMFTexture(3553, width / 2, height / 2, 6409, 33986);
    }

    private void createYuv420spTexture(int width, int height) {
        this.mInputImageTextures = new YMFTexture[2];
        this.mInputImageTextures[0] = new YMFTexture(3553, width, height, 6409, 33984);
        this.mInputImageTextures[1] = new YMFTexture(3553, width / 2, height / 2, 6410, 33985);
    }

    private void createRGBATexture(int width, int height) {
        this.mInputImageTextures = new YMFTexture[1];
        this.mInputImageTextures[0] = new YMFTexture(3553, width, height, 6408, 33984);
    }

    private void createInputTexture(YMFImageBuffer buffer) {
        switch (buffer.mFormat) {
            case 2: {
                this.createYuv420pTexture(buffer.mWidth, buffer.mHeight);
                break;
            }
            case 1: {
                this.createYuv420spTexture(buffer.mWidth, buffer.mHeight);
                break;
            }
            case 0: {
                this.createYuv420spTexture(buffer.mWidth, buffer.mHeight);
                break;
            }
            case 36: {
                this.createRGBATexture(buffer.mWidth, buffer.mHeight);
                break;
            }
        }
    }

    public static int imageFormatToProgramType(int imageFormat) {
        switch (imageFormat) {
            case 2: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 1;
            }
            case 36: {
                return 0;
            }
        }
        return 4;
    }

    private void checkUpdateProgram(YMFImageBuffer buffer) {
        boolean bNeedUpdateProgram = false;
        boolean bNeedUpdateTexture = false;
        if (this.mProgram == null || this.mProgram.programType() != YMFRender.imageFormatToProgramType(buffer.mFormat)) {
            this.releaseProgram();
            bNeedUpdateProgram = true;
        }
        if (this.mInputImageTextures == null || this.mInputImageTextures[0].getWidth() != buffer.mWidth || this.mInputImageTextures[0].getHeight() != buffer.mHeight) {
            this.releaseInYuvTextures();
            bNeedUpdateTexture = true;
        }
        if (bNeedUpdateProgram) {
            this.createProgram(buffer);
        }
        if (bNeedUpdateTexture) {
            this.createInputTexture(buffer);
        }
    }

    @Override
    public boolean prepareInputImageData(YMFImageBuffer buffer) {
        if (buffer == null || buffer.mData == null) {
            YMFLog.error((Object)this, "[Util    ]", "invalid input YMFImageBuffer.");
            return false;
        }
        int width = buffer.mWidth;
        int height = buffer.mHeight;
        int yPos = buffer.getYoffset();
        int uPos = buffer.getUoffset();
        int vPos = buffer.getVoffset();
        ByteBuffer data = buffer.mData;
        this.checkUpdateProgram(buffer);
        data.rewind();
        switch (buffer.mFormat) {
            case 2: {
                this.mInputImageTextures[0].updateTextureData(data.position(yPos), width, height);
                this.mInputImageTextures[1].updateTextureData(data.position(uPos), width / 2, height / 2);
                this.mInputImageTextures[2].updateTextureData(data.position(vPos), width / 2, height / 2);
                break;
            }
            case 0: 
            case 1: {
                this.mInputImageTextures[0].updateTextureData(data.position(yPos), width, height);
                this.mInputImageTextures[1].updateTextureData(data.position(uPos), width / 2, height / 2);
                break;
            }
            case 36: {
                this.mInputImageTextures[0].updateTextureData(data.position(0), width, height);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean prepareInputTexture(YMFTexture texture) {
        if (texture == null || !texture.validate()) {
            return false;
        }
        boolean bUpdateProgram = false;
        if (this.mProgram == null) {
            bUpdateProgram = true;
        }
        if (this.mProgram != null && this.mProgram.programType() != 0 && this.mProgram.programType() != 4) {
            bUpdateProgram = true;
        }
        if (bUpdateProgram) {
            this.releaseProgram();
            if (texture.getFormat() == 69) {
                this.mProgram = YMFProgramFactory.craeteProgram(0);
            } else if (texture.getFormat() == 70) {
                this.mProgram = YMFProgramFactory.craeteProgram(4);
            }
        }
        this.mInput2dTexture = texture;
        this.mInput2dTexture.bind();
        return true;
    }

    @Override
    public boolean prepareInputTextureTransformMatrix(float[] matrix) {
        if (this.mProgram != null) {
            this.mProgram.prepareInputTextureTransformMatrix(matrix);
        }
        return true;
    }

    @Override
    public void prepareWaterTexture(YMFTexture texture) {
        if (texture != null && texture.validate()) {
            this.mProgram.enableWaterMarker(true);
            if (this.mProgram.programType() != 0 && this.mProgram.programType() != 4) {
                texture.setTextureUnit(33987);
            }
            texture.bind();
            this.mWaterMarkTexture = texture;
        } else {
            this.mProgram.enableWaterMarker(false);
        }
    }

    @Override
    public boolean prepareOutputTexture(YMFTexture texture) {
        if (texture == null || !texture.validate()) {
            return false;
        }
        if (this.mFrameBuffer == null) {
            this.mFrameBuffer = new YMFFramebuffer();
        }
        this.mFrameBuffer.attachTexture(texture.getTextureId());
        return true;
    }

    @Override
    public void flipReset() {
        if (this.mProgram != null) {
            this.mProgram.flipReset();
        }
    }

    @Override
    public void flipHorizontal() {
        if (this.mProgram != null) {
            this.mProgram.flipHorizontal();
        }
    }

    @Override
    public void flipVertical() {
        if (this.mProgram != null) {
            this.mProgram.flipVertical();
        }
    }

    @Override
    public void rotate(int angle) {
        if (this.mProgram != null) {
            this.mProgram.rotation(angle);
        }
    }

    @Override
    public void flipResetWater() {
        if (this.mProgram != null) {
            this.mProgram.flipResetWater();
        }
    }

    @Override
    public void flipHorizontalWater() {
        if (this.mProgram != null) {
            this.mProgram.flipHorizontalWater();
        }
    }

    @Override
    public void flipVerticalWater() {
        if (this.mProgram != null) {
            this.mProgram.flipVerticalWater();
        }
    }

    @Override
    public void clip(int inWidth, int inHeight, int outWidth, int outHeight) {
        if (this.mProgram != null) {
            this.mProgram.clip(inWidth, inHeight, outWidth, outHeight);
        }
    }

    @Override
    public void render() {
        if (this.mProgram != null) {
            this.mProgram.useProgram();
            this.mProgram.drawFrame();
            this.reStoreGlContext();
        }
    }

    private void reStoreGlContext() {
        switch (this.mProgram.programType()) {
            case 0: 
            case 4: {
                if (this.mInput2dTexture == null) break;
                this.mInput2dTexture.unBind();
                break;
            }
        }
        for (int i = 0; this.mInputImageTextures != null && i < this.mInputImageTextures.length; ++i) {
            this.mInputImageTextures[i].unBind();
        }
        if (this.mFrameBuffer != null) {
            this.mFrameBuffer.unBind();
        }
        if (this.mWaterMarkTexture != null) {
            this.mWaterMarkTexture.unBind();
        }
    }

    private void releaseProgram() {
        if (this.mProgram != null) {
            this.mProgram.release();
            this.mProgram = null;
        }
    }

    private void releaseInYuvTextures() {
        for (int i = 0; this.mInputImageTextures != null && i < this.mInputImageTextures.length; ++i) {
            this.mInputImageTextures[i].release();
        }
        this.mInputImageTextures = null;
    }

    @Override
    public void release() {
        this.releaseInYuvTextures();
        this.releaseProgram();
        if (this.mFrameBuffer != null) {
            this.mFrameBuffer.release();
            this.mFrameBuffer = null;
        }
    }
}

