/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.opengles;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.IMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.model.YMFImageBuffer;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.opengles.IRender;
import com.yy.mediaframework.opengles.YMFRender;
import com.yy.mediaframework.opengles.YMFTexture;
import com.yy.mediaframework.utils.ImageUtil;
import com.yy.mediaframework.utils.VideoSizeUtils;
import com.yy.mediaframework.utils.YMFLog;
import com.yy.mediaframework.watermark.WaterMark;
import com.yy.mediaframework.watermark.WaterMarkTexture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class YMFPreviewView
extends GLSurfaceView
implements GLSurfaceView.Renderer,
IMediaFilter,
SurfaceHolder.Callback,
VideoLiveFilterContext.waterMarkUpdate {
    private static final String TAG = "YMFPreviewView";
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mClipWidth;
    private int mClipHeight;
    private int mImageYuvFormat;
    private boolean mSurfaceCreated = false;
    private boolean mPreviewMirror = false;
    private IRender mRender = null;
    private YMFImageBuffer mVideoFrame = null;
    private YMFTexture mWaterMarkInputTexture = null;
    private WaterMarkTexture mWaterMarkTexture = null;
    private VideoSizeUtils.Size mSize = new VideoSizeUtils.Size();
    private ReentrantLock mRenderLock = new ReentrantLock(true);
    private AtomicBoolean mInited = new AtomicBoolean(false);
    private AtomicBoolean mDataArrive = new AtomicBoolean(false);
    private Constant.ScaleMode mScaleMode = Constant.ScaleMode.AspectFit;
    private VideoLiveFilterContext mFilterContext;

    public YMFPreviewView(Context context) {
        super(context);
        this.init();
    }

    public YMFPreviewView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setEGLContextClientVersion(2);
        this.setEGLConfigChooser(new ConfigChooser(5, 6, 5, 0, 0, 0));
        this.setRenderer(this);
        this.setRenderMode(0);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        YMFLog.info(this, "[Preview ]", "init finish.");
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        YMFLog.info(this, "[Preview ]", "surfaceDestroyed start.");
        this.mRenderLock.lock();
        this.mSurfaceCreated = false;
        this.mRenderLock.unlock();
        this.postToGlThread(new Runnable(){

            @Override
            public void run() {
                YMFPreviewView.this.releaseRender();
                YMFPreviewView.this.destroyWaterMark();
            }
        });
        super.surfaceDestroyed(holder);
        YMFLog.info(this, "[Preview ]", "surfaceDestroyed done.");
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        YMFLog.info(this, "[Preview ]", "onSurfaceCreated .");
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.mRenderLock.lock();
        this.mSurfaceCreated = true;
        if (this.mSurfaceWidth != width || this.mSurfaceHeight != height) {
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
            this.updateDrawPosition();
        }
        YMFLog.info(this, "[Preview ]", "onSurfaceChanged width:" + width + " height:" + height);
        this.mRenderLock.unlock();
    }

    private void releaseRender() {
        if (this.mRender != null) {
            this.mRender.release();
            this.mRender = null;
        }
        this.mInited.set(false);
        YMFLog.info(this, "[Preview ]", "releaseRender.");
    }

    private void setFlipHorizontal(boolean flip) {
        if (this.mRender != null) {
            this.mRender.flipReset();
            this.mRender.flipResetWater();
            this.mRender.flipVertical();
            this.mRender.flipVerticalWater();
            if (flip) {
                this.mRender.flipHorizontal();
            }
            this.mPreviewMirror = flip;
        }
    }

    private boolean createRender(int width, int height, int imageFormat) {
        if (width <= 0 || height <= 0) {
            return false;
        }
        this.mRender = new YMFRender(YMFRender.imageFormatToProgramType(imageFormat));
        this.setFlipHorizontal(this.mPreviewMirror);
        YMFLog.info(this, "[Preview ]", "initRender width:" + width + " height:" + height + " format:" + ImageUtil.getImageFormatName(imageFormat) + " mirror:" + this.mPreviewMirror);
        return true;
    }

    public void postToGlThread(Runnable runable) {
        this.queueEvent(runable);
    }

    public void setVideoFilterContext(VideoLiveFilterContext ctx) {
        this.mFilterContext = ctx;
    }

    private void destroyWaterMark() {
        if (this.mWaterMarkTexture != null) {
            this.mWaterMarkTexture.destroy();
            this.mWaterMarkTexture = null;
        }
        if (this.mWaterMarkInputTexture != null) {
            this.mWaterMarkInputTexture.release();
            this.mWaterMarkInputTexture = null;
        }
    }

    @Override
    public void onWaterMarkUpdate(final WaterMark mark) {
        this.postToGlThread(new Runnable(){

            @Override
            public void run() {
                YMFPreviewView.this.destroyWaterMark();
                if (mark != null) {
                    YMFPreviewView.this.mWaterMarkTexture = new WaterMarkTexture(mark);
                    YMFPreviewView.this.mWaterMarkInputTexture = new YMFTexture(((YMFPreviewView)YMFPreviewView.this).mWaterMarkTexture.mWaterMarkTextureId, 3553, ((YMFPreviewView)YMFPreviewView.this).mWaterMarkTexture.mWatermarkWidth, ((YMFPreviewView)YMFPreviewView.this).mWaterMarkTexture.mWatermarkHeight, 6408, 33985);
                }
                YMFLog.info(this, "[Preview ]", "set water marker:" + (mark == null ? "disable" : "enable"));
            }
        });
    }

    private void prepareWaterMark() {
        if (this.mWaterMarkInputTexture != null) {
            this.mRender.prepareWaterTexture(this.mWaterMarkInputTexture);
        } else {
            this.mRender.prepareWaterTexture(null);
        }
    }

    public void onDrawFrame(GL10 gl) {
        this.mRenderLock.lock();
        GlUtil.checkGlError(" onDrawFrame enter ");
        if (this.mInited.get() && this.mVideoFrame != null && this.mRender != null && this.mDataArrive.get()) {
            gl.glViewport(this.mSize.x, this.mSize.y, this.mSize.width, this.mSize.height);
            if (this.mScaleMode.compareTo(Constant.ScaleMode.AspectFit) == 0) {
                gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                gl.glClear(16384);
            }
            if (this.mRender.prepareInputImageData(this.mVideoFrame)) {
                this.prepareWaterMark();
                this.mRender.render();
            }
            this.mDataArrive.set(false);
        }
        GlUtil.checkGlError(" onDrawFrame out ");
        this.mRenderLock.unlock();
    }

    private void updateDrawPosition() {
        this.mSize = VideoSizeUtils.CalcFitSize(this.mVideoWidth, this.mVideoHeight, this.mSurfaceWidth, this.mSurfaceHeight, this.mScaleMode);
    }

    private void updateDrawPositionByClip() {
        this.mSize = VideoSizeUtils.CalcFitSize(this.mClipWidth, this.mClipHeight, this.mSurfaceWidth, this.mSurfaceHeight, this.mScaleMode);
    }

    public YMFImageBuffer selectDataSource(YYMediaSample sample) {
        YMFImageBuffer srcBuffer = null;
        switch (sample.mImageFormat) {
            case 2: {
                srcBuffer = sample.mI420;
                break;
            }
            case 3: {
                srcBuffer = sample.mYV12;
                break;
            }
            case 0: {
                srcBuffer = sample.mNV21;
                break;
            }
            case 1: {
                srcBuffer = sample.mNV12;
                break;
            }
            case 36: {
                YMFImageBuffer buffer = new YMFImageBuffer(sample.mWidth, sample.mHeight, 36, false);
                srcBuffer = buffer.wrap(sample.mRGBABytes, sample.mWidth, sample.mHeight, 36);
                break;
            }
        }
        return srcBuffer;
    }

    private boolean checkFromat(int format) {
        return format == 1 || format == 2 || format == 0 || format == 3 || format == 36;
    }

    private boolean checkRenderUpdate(int width, int height, int format) {
        return !this.mInited.get() || this.mRender == null || this.mVideoFrame == null || format != this.mImageYuvFormat || this.mVideoWidth != width || this.mVideoHeight != height;
    }

    private boolean checkMirrorUpdate(YYMediaSample sample) {
        return this.mPreviewMirror != sample.mIsPreviewMirrorEnable;
    }

    private void prepareVideoFrame(int width, int height, int format) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        this.mImageYuvFormat = format;
        this.mVideoFrame = new YMFImageBuffer(this.mVideoWidth, this.mVideoHeight, format, true);
        this.mDataArrive.set(false);
        this.updateDrawPosition();
    }

    public void setScaleMode(Constant.ScaleMode mode) {
        this.mScaleMode = mode;
        this.updateDrawPosition();
    }

    private void updateRender(YYMediaSample sample, int w, int h, int f) {
        final int width = w;
        final int height = h;
        final int format = f;
        final boolean bUpdateRender = this.checkRenderUpdate(w, h, f);
        final boolean bUpdateMirror = this.checkMirrorUpdate(sample);
        final boolean bMirror = sample.mIsPreviewMirrorEnable;
        if (bUpdateRender || bUpdateMirror) {
            this.postToGlThread(new Runnable(){

                @Override
                public void run() {
                    if (bUpdateRender) {
                        YMFPreviewView.this.releaseRender();
                        if (width != YMFPreviewView.this.mVideoWidth || height != YMFPreviewView.this.mVideoHeight || format != YMFPreviewView.this.mImageYuvFormat) {
                            YMFPreviewView.this.prepareVideoFrame(width, height, format);
                        }
                        if (!YMFPreviewView.this.mInited.get() && YMFPreviewView.this.mSurfaceCreated && YMFPreviewView.this.createRender(YMFPreviewView.this.mVideoWidth, YMFPreviewView.this.mVideoHeight, YMFPreviewView.this.mImageYuvFormat)) {
                            YMFPreviewView.this.mInited.set(true);
                        }
                    }
                    if (bUpdateMirror && YMFPreviewView.this.mRender != null) {
                        YMFLog.info(this, "[Preview ]", "mirror update:" + YMFPreviewView.this.mPreviewMirror + " -> " + bMirror);
                        YMFPreviewView.this.setFlipHorizontal(bMirror);
                    }
                }
            });
        }
    }

    private void updateClipInfo(YYMediaSample sample) {
        if (this.mClipWidth != sample.mClipWidth || this.mClipHeight != sample.mClipHeight) {
            this.mClipWidth = sample.mClipWidth;
            this.mClipHeight = sample.mClipHeight;
            final int clipW = this.mClipWidth;
            final int clipH = this.mClipHeight;
            this.postToGlThread(new Runnable(){

                @Override
                public void run() {
                    if (YMFPreviewView.this.mInited.get() && YMFPreviewView.this.mRender != null) {
                        YMFLog.info(this, "[Preview ]", "clip " + clipW + "x" + clipH);
                        YMFPreviewView.this.mRender.clip(YMFPreviewView.this.mVideoWidth, YMFPreviewView.this.mVideoHeight, clipW, clipH);
                        YMFPreviewView.this.updateDrawPositionByClip();
                    }
                }
            });
        }
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (!this.mSurfaceCreated) {
            return false;
        }
        if (sample == null || !this.checkFromat(sample.mImageFormat)) {
            YMFLog.error((Object)this, "[Preview ]", "Invalid sample.");
            return false;
        }
        YMFImageBuffer src = this.selectDataSource(sample);
        if (src == null || src.mData == null) {
            return false;
        }
        this.updateRender(sample, src.mWidth, src.mHeight, src.mFormat);
        if (!sample.mCliped && sample.mUseGPUBeauty) {
            this.updateClipInfo(sample);
        }
        this.mRenderLock.lock();
        if (this.mVideoFrame != null && this.mVideoFrame.mData != null) {
            this.mDataArrive.set(this.mVideoFrame.deepCopy(src));
        }
        if (this.mDataArrive.get()) {
            this.requestRender();
        }
        this.mRenderLock.unlock();
        return true;
    }

    private static class ConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private int mRedSize;
        private int mGreenSize;
        private int mBlueSize;
        private int mAlphaSize;
        private int mDepthSize;
        private int mStencilSize;
        private int EGL_OPENGL_ES2_BIT = 4;
        private int[] mDefaultValue = new int[1];
        private int[] mConfigAttr = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, this.EGL_OPENGL_ES2_BIT, 12344};

        private ConfigChooser(int r, int g, int b, int a, int d, int s) {
            this.mRedSize = r;
            this.mGreenSize = g;
            this.mBlueSize = b;
            this.mAlphaSize = a;
            this.mDepthSize = d;
            this.mStencilSize = s;
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] numConfig = new int[1];
            egl.eglChooseConfig(display, this.mConfigAttr, null, 0, numConfig);
            int num = numConfig[0];
            if (num > 0) {
                EGLConfig[] configs = new EGLConfig[num];
                egl.eglChooseConfig(display, this.mConfigAttr, configs, num, numConfig);
                return this.chooseConfig(egl, display, configs);
            }
            return null;
        }

        private EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mDefaultValue)) {
                return this.mDefaultValue[0];
            }
            return defaultValue;
        }
    }
}

