/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.model;

import android.graphics.ImageFormat;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;

public class YMFImageBuffer {
    private static int mDirectoryBufferOffset;
    public int mFormat;
    public int mWidth;
    public int mHeight;
    public int mBufSize;
    public ByteBuffer mData;

    public YMFImageBuffer(int width, int height, int format, boolean allocMemory) {
        if (width <= 0 || height <= 0) {
            YMFLog.error((Object)this, "[Util    ]", "invalid width or height.");
            return;
        }
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
        if (format == 1 || format == 2 || format == 0 || format == 3) {
            this.mBufSize = this.mWidth * this.mHeight * ImageFormat.getBitsPerPixel((int)17) / 8;
        } else if (format == 36) {
            this.mBufSize = this.mWidth * this.mHeight * this.getBitsPerRgbPixel(format) / 8;
        } else {
            YMFLog.error((Object)this, "[Util    ]", " unsupported format:" + format);
        }
        if (allocMemory && this.mBufSize > 0) {
            this.mData = ByteBuffer.allocateDirect(this.mBufSize + YMFImageBuffer.offset());
        }
    }

    private int getBitsPerRgbPixel(int format) {
        switch (format) {
            case 20: {
                return 24;
            }
            case 36: {
                return 32;
            }
            case 52: {
                return 16;
            }
        }
        return -1;
    }

    public static int offset() {
        return mDirectoryBufferOffset;
    }

    public YMFImageBuffer wrap(byte[] buf, int width, int height, int format) {
        if (this.mWidth != width || this.mHeight != height || this.mFormat != format) {
            this.mBufSize = format == 36 ? width * height * this.getBitsPerRgbPixel(format) / 8 : width * height * ImageFormat.getBitsPerPixel((int)17) / 8;
            this.mWidth = width;
            this.mHeight = height;
            this.mFormat = format;
        }
        if (this.mBufSize >= buf.length) {
            this.mData = ByteBuffer.wrap(buf);
        }
        return this;
    }

    public boolean deepCopy(YMFImageBuffer src) {
        if (this.mWidth != src.mWidth || this.mHeight != src.mHeight || this.mBufSize != src.mBufSize) {
            YMFLog.error((Object)this, "[Util    ]", "copy with different buffer size.");
            return false;
        }
        this.mWidth = src.mWidth;
        this.mHeight = src.mHeight;
        this.mFormat = src.mFormat;
        System.arraycopy(src.mData.array(), src.mData.arrayOffset(), this.mData.array(), this.mData.arrayOffset(), this.mBufSize);
        return true;
    }

    public int getYoffset() {
        return 0;
    }

    public int getUoffset() {
        return this.mWidth * this.mHeight;
    }

    public int getVoffset() {
        return this.mWidth * this.mHeight * 5 / 4;
    }

    static {
        ByteBuffer b = ByteBuffer.allocateDirect(4);
        if (b.hasArray()) {
            mDirectoryBufferOffset = b.arrayOffset();
        }
    }
}

