/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.inteligence.framerate;

import com.yy.mediaframework.inteligence.framerate.IFrameRateModify;
import com.yy.mediaframework.utils.YMFLog;

public class DefaultFrameRateModify
implements IFrameRateModify {
    public static final String TAG = DefaultFrameRateModify.class.getSimpleName();
    protected static final long ONE_SECOND = 1000000000L;
    protected static final int FRAMERATE_FLOOR = 10;
    private long mLastTimestampNanos;
    private long mStepNanos;
    private int mConfigFrameRate;
    private int mConfigCodeRate;
    private int mNetworkCodeRate;
    private int mMinCodeRate;
    private int mCurrentFrameRate;
    private float mReduceFrameWeight;
    private float mNewFrameRate;
    private long mLastSecondNanos;
    private int mDropCount;
    private int mDropThreshold;
    private boolean mNeedIntercept = false;

    public void init(int configFrameRate, int configCodeRate, int minCodeRate, float reduceFrameWeight) {
        this.mConfigFrameRate = configFrameRate;
        this.mConfigCodeRate = configCodeRate;
        this.mMinCodeRate = minCodeRate;
        this.mReduceFrameWeight = reduceFrameWeight;
        this.mStepNanos = 1000000000L / (long)this.mConfigFrameRate;
        this.mDropThreshold = 0;
        this.mNetworkCodeRate = configCodeRate;
        this.mCurrentFrameRate = 0;
        YMFLog.info(this, "[Encoder ]", "init cfr:%d ccr:%d mcr:%d rfw:%f", this.mConfigFrameRate, this.mConfigCodeRate, this.mMinCodeRate, Float.valueOf(this.mReduceFrameWeight));
    }

    @Override
    public boolean onInterceptDoFrame(long timeStampNanos) {
        if (!this.mNeedIntercept) {
            return false;
        }
        if (this.mLastTimestampNanos != -1L && timeStampNanos - this.mLastTimestampNanos < this.mStepNanos && this.mDropCount <= this.mDropThreshold) {
            ++this.mDropCount;
            return true;
        }
        if (timeStampNanos - this.mLastSecondNanos > 1000000000L) {
            YMFLog.debug(this, "[Encoder ]", "mDropCount:%d", this.mDropCount);
            this.mDropCount = 0;
            this.mLastSecondNanos = timeStampNanos;
        }
        this.mLastTimestampNanos = timeStampNanos;
        return false;
    }

    @Override
    public void publishNetworkCodeRate(int networkCodeRate) {
        this.mNetworkCodeRate = networkCodeRate;
        if (this.mNetworkCodeRate < this.mMinCodeRate && this.mCurrentFrameRate != 0) {
            this.mNeedIntercept = true;
            this.mNewFrameRate = (float)(this.mCurrentFrameRate + this.mDropThreshold) * this.mReduceFrameWeight;
            if (this.mNewFrameRate < 10.0f) {
                this.mNewFrameRate = 10.0f;
            }
            this.mStepNanos = (long)(1.0E9f / this.mNewFrameRate);
            YMFLog.info(this, "[Encoder ]", "publishNetworkCodeRate nfr:%f ncr:%d sn:%d", Float.valueOf(this.mNewFrameRate), networkCodeRate, this.mStepNanos);
        } else {
            this.mNeedIntercept = false;
            this.mDropThreshold = 0;
        }
    }

    @Override
    public void publishCurrentFrameRate(int currentFrameRate) {
        this.mCurrentFrameRate = currentFrameRate;
        if (this.mNeedIntercept) {
            int newFrameRateInt = (int)this.mNewFrameRate;
            if (this.mCurrentFrameRate > newFrameRateInt) {
                ++this.mDropThreshold;
            } else if (this.mCurrentFrameRate != newFrameRateInt) {
                --this.mDropThreshold;
            }
            YMFLog.info(this, "[Encoder ]", "publishCurrentFrameRate currentFrameRate:%d mDropThreshold:%d", currentFrameRate, this.mDropThreshold);
        }
    }

    @Override
    public void publishCurrentResolution(int width, int height, int codeRate) {
    }

    @Override
    public void release() {
    }

    @Override
    public float getLastFrameRate() {
        return 0.0f;
    }

    @Override
    public void setLastFrameRate(float frameRate) {
    }
}

