/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.inteligence.coderate;

import android.os.Handler;
import com.yy.mediaframework.inteligence.coderate.ICodeRateByFrame;
import com.yy.mediaframework.utils.YMFLog;

public class DefaultCodeRateByFrame
implements ICodeRateByFrame {
    protected int mConfigCodeRate;
    protected int mConfigFrameRate;
    protected int mNotifyStep;
    protected int mSuggestCodeRate;
    protected int mCurrentFrameRate;
    protected int mCurrentCodeRate;
    protected int mCurrentCodeRatePerFrame;
    protected int mLastSuggestCodeRate;
    protected float mRatio;
    static final int MAX_CODE_RATE = 2000000;
    static final int MIN_CODE_RATE = 800000;

    @Override
    public void init(int configCodeRate, int configFrameRate, int notifyStep, Handler handler) {
        YMFLog.info(this, "[Encoder ]", "init coderate:%d, framerate:%d, notifystep:%d", configCodeRate, configFrameRate, notifyStep);
        if (handler == null) {
            throw new RuntimeException("handler must not be null");
        }
        if (configCodeRate <= 0 || configFrameRate <= 0 || notifyStep <= 0) {
            throw new RuntimeException("coderate/framerate/notifystep must not less than 0");
        }
        this.mConfigCodeRate = configCodeRate;
        this.mConfigFrameRate = configFrameRate;
        this.mNotifyStep = notifyStep;
        this.mSuggestCodeRate = configCodeRate;
        this.mCurrentFrameRate = configFrameRate;
        this.mCurrentCodeRate = configCodeRate;
        this.mCurrentCodeRatePerFrame = this.mCurrentCodeRate / this.mCurrentFrameRate;
        this.mLastSuggestCodeRate = this.mSuggestCodeRate;
        this.mRatio = 1.0f;
    }

    @Override
    public void publishCurrentFrameRate(int currentFrameRate, int currentCodeRate) {
        if (currentFrameRate <= 0) {
            YMFLog.error((Object)this, "[Encoder ]", "publish currentFrameRate less than 0");
            return;
        }
        this.mCurrentFrameRate = currentFrameRate;
        this.mCurrentCodeRate = currentCodeRate;
        this.mCurrentCodeRatePerFrame = currentCodeRate / currentFrameRate;
        int lastSuggestCodeRatePerFrame = this.mLastSuggestCodeRate / this.mConfigFrameRate;
        this.mRatio = (float)lastSuggestCodeRatePerFrame / (float)this.mCurrentCodeRatePerFrame;
        if ((double)this.mRatio > 1.2) {
            this.mRatio = 1.2f;
        } else if ((double)this.mRatio < 0.8) {
            this.mRatio = 0.8f;
        }
        YMFLog.info(this, "[Encoder ]", "Current SuggestCodeRate:%d LastSuggestCodeRate:%d currentCodeRate:%d currentFrameRate:%d lastSuggestCodeRatePerFrame:%d CurrentCodeRatePerFrame:%d ratio:%f", this.mSuggestCodeRate, this.mLastSuggestCodeRate, currentCodeRate, currentFrameRate, lastSuggestCodeRatePerFrame, this.mCurrentCodeRatePerFrame, Float.valueOf(this.mRatio));
        this.mLastSuggestCodeRate = this.mSuggestCodeRate;
    }

    @Override
    public void publishNetworkCodeRate(int networkCodeRate) {
        YMFLog.info(this, "[Encoder ]", "Network notify CodeRate:%d CurrentCodeRate:%d suggestCodeRate:%d", networkCodeRate, this.mCurrentCodeRate, this.mSuggestCodeRate);
        if (this.mCurrentFrameRate <= 0 || this.mConfigFrameRate <= 0) {
            YMFLog.warn(this, "[Encoder ]", "Error current:%d or config framerate:%d", this.mCurrentFrameRate, this.mConfigFrameRate);
            return;
        }
        if (this.mCurrentFrameRate == this.mConfigFrameRate) {
            YMFLog.info(null, "[Encoder ]", "Network current FrameRate equals to config FrameRate");
            this.mSuggestCodeRate = networkCodeRate;
        } else {
            this.mSuggestCodeRate = (int)((float)(networkCodeRate / this.mCurrentFrameRate * this.mConfigFrameRate) * this.mRatio);
            if (this.mSuggestCodeRate <= 0) {
                this.mSuggestCodeRate = 800000;
            } else if (this.mSuggestCodeRate > 2000000) {
                this.mSuggestCodeRate = 2000000;
            }
            YMFLog.info(null, "[Encoder ]", "setNetworkBitrateSuggest do codeByFrame:" + this.mSuggestCodeRate);
        }
        YMFLog.info(null, "[Encoder ]", "Network adjust CodeRate:%d ratio:%f", this.mSuggestCodeRate, Float.valueOf(this.mRatio));
    }

    @Override
    public int getSuggestCodeRate() {
        return this.mSuggestCodeRate;
    }

    @Override
    public void release() {
        YMFLog.info(null, "[Encoder ]", "release");
    }
}

