/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage.util;

public class VideoSizeUtil {
    public static Size CalcFitSize(int imageWidth, int imageHeight, int frameWidth, int frameHeight, ScaleMode scaleMode) {
        Size rs = new Size(imageWidth, imageHeight);
        if (ScaleMode.ASPECTFIT == scaleMode) {
            if (frameHeight * imageWidth < frameWidth * imageHeight) {
                double f = 1.0 * (double)frameHeight / (double)imageHeight;
                rs.width = (int)(f * (double)imageWidth + 0.5);
                rs.height = frameHeight;
                rs.x = (frameWidth - rs.width) / 2;
                rs.y = 0;
            } else {
                double f = 1.0 * (double)frameWidth / (double)imageWidth;
                rs.width = frameWidth;
                rs.height = (int)(f * (double)imageHeight + 0.5);
                rs.x = 0;
                rs.y = (frameHeight - rs.height) / 2;
            }
        } else if (ScaleMode.CLIP_TO_BOUNDS == scaleMode) {
            if (frameHeight * imageWidth < frameWidth * imageHeight) {
                double f = 1.0 * (double)frameWidth / (double)imageWidth;
                rs.width = frameWidth;
                rs.height = (int)(f * (double)imageHeight + 0.5);
                rs.x = 0;
                rs.y = (frameHeight - rs.height) / 2;
            } else {
                double f = 1.0 * (double)frameHeight / (double)imageHeight;
                rs.width = (int)(f * (double)imageWidth + 0.5);
                rs.height = frameHeight;
                rs.x = (frameWidth - rs.width) / 2;
                rs.y = 0;
            }
        } else if (ScaleMode.FULL_FILL == scaleMode) {
            rs.height = frameHeight;
            rs.width = frameWidth;
            rs.x = 0;
            rs.y = 0;
        }
        return rs;
    }

    public static class Size {
        public int width;
        public int height;
        public int x;
        public int y;

        public Size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public Size() {
            this.width = 0;
            this.height = 0;
        }
    }

    public static enum ScaleMode {
        CLIP_TO_BOUNDS,
        ASPECTFIT,
        FULL_FILL;

    }
}

