/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.RectF;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import com.yy.mediaframework.PictureInPictureDisplayInfo;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gles.Drawable2d;
import com.yy.mediaframework.gles.FullFrameRect;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.gles.Texture2dProgram;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.GLUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GlTextureBlender {
    private static final String TAG = "GlTextureBlender";
    private int mWidth = 0;
    private int mHeight = 0;
    private int mInputWidth = 0;
    private int mInputHeight = 0;
    private int mClipWidth = 0;
    private int mClipHeight = 0;
    private int mEncodeWidth = 0;
    private int mEncodeHeight = 0;
    private int mOffScreenFrameBuffer = -1;
    private int mOffScreenTextureId = -1;
    private boolean mFlipHorizontal = false;
    private boolean mFlipVertical = false;
    private FullFrameRect mOffScreen = null;
    Drawable2d.Prefab mDrawable2d;
    final float[] SLAVE_VEX_RIGHT_BOTTOM = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 1.0f, -1.0f};
    private FloatBuffer mSlaveVertexBuffer;
    VideoLiveFilterContext mFilterContext;
    public int fakeTextureId = -1;
    private int mScreenWidth = 0;
    private int mScreenHeight = 0;
    private RectF mLastScreenCropArea = new RectF();

    public GlTextureBlender(VideoLiveFilterContext context) {
        this.mFilterContext = context;
        this.init(this.mFilterContext.getVideoEncoderConfig().getEncodeWidth(), this.mFilterContext.getVideoEncoderConfig().getEncodeHeight());
        this.mSlaveVertexBuffer = ByteBuffer.allocateDirect(this.SLAVE_VEX_RIGHT_BOTTOM.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mSlaveVertexBuffer.put(this.SLAVE_VEX_RIGHT_BOTTOM).position(0);
        Context context2 = this.mFilterContext.getAndroidContext();
        this.mFilterContext.getAndroidContext();
        WindowManager wm = (WindowManager)context2.getSystemService("window");
        if (Build.VERSION.SDK_INT >= 17) {
            Point point = new Point();
            Display display = wm.getDefaultDisplay();
            display.getRealSize(point);
            this.mScreenWidth = point.x;
            this.mScreenHeight = point.y;
        }
    }

    private void init(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.mOffScreenTextureId = GLUtil.genTexture(3553, this.mWidth, this.mHeight);
        int[] frameBuffers = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
        this.mOffScreenFrameBuffer = frameBuffers[0];
        GLES20.glBindFramebuffer((int)36160, (int)this.mOffScreenFrameBuffer);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mOffScreenTextureId, (int)0);
        this.mOffScreen = new FullFrameRect(new Texture2dProgram(Texture2dProgram.ProgramType.TEXTURE_2D_WITH_EXTRA_TXT_2), Drawable2d.Prefab.FULL_RECTANGLE, GlUtil.createFloatBuffer(Drawable2d.FULL_RECTANGLE_TEX_COORDS), GlUtil.createFloatBuffer(Drawable2d.FULL_RECTANGLE_TEX_COORDS));
        this.setEncoderFlipY();
        this.fakeWatermarkBackground(width, height);
    }

    private void fakeWatermarkBackground(int width, int height) {
        this.fakeTextureId = this.createTextureFromBitmap(this.createColorBitmap(width, height));
    }

    private Bitmap createColorBitmap(int width, int height) {
        YMFLog.info(this, "[Beauty  ]", "createColorBitmap");
        Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bmp);
        canvas.drawColor(0);
        return bmp;
    }

    private int createTextureFromBitmap(Bitmap bitmap) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        return textures[0];
    }

    private void setEncoderFlipY() {
        if (this.mOffScreen != null) {
            YMFLog.info(this, "[Encoder ]", "encoder setEncoderFlipY");
            this.mOffScreen.setTextureFlipY(3);
        }
    }

    private void checkImageSize(int width, int height) {
        if (this.mWidth == width && this.mHeight == height) {
            return;
        }
        this.destroy();
        this.init(width, height);
    }

    public int blend(YYMediaSample sample, int watermarkTextureID, int dynamicTextureId, boolean flipFlag) {
        this.checkImageSize(sample.mEncodeWidth, sample.mEncodeHeight);
        if (this.mFilterContext != null) {
            try {
                GLES20.glViewport((int)0, (int)0, (int)this.mWidth, (int)this.mHeight);
                GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GLES20.glClear((int)16384);
                GLES20.glBindFramebuffer((int)36160, (int)this.mOffScreenFrameBuffer);
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mOffScreenTextureId, (int)0);
                if (sample.mScreenCropArea != null && !sample.mScreenCropArea.equals((Object)this.mLastScreenCropArea)) {
                    YMFLog.info(this, "[Beauty  ]", "soft-ScreenLiveSession sample.mScreenCropArea:" + sample.mScreenCropArea);
                    this.mLastScreenCropArea.set(sample.mScreenCropArea);
                    if (this.mEncodeWidth != sample.mEncodeWidth && this.mEncodeHeight != sample.mEncodeHeight) {
                        YMFLog.info(this, "[Beauty  ]", "soft-ScreenLiveSession adjustTextureArea...");
                        this.mOffScreen.adjustTextureArea(sample.mScreenCropArea, this.mScreenWidth, this.mScreenHeight, true);
                    } else {
                        YMFLog.warn(this, "[Beauty  ]", "soft-screen clip ratio and encode ratio not change at the same time...");
                    }
                } else if (sample.mScreenCropArea == null && this.checkClipRatioChanged(sample.mWidth, sample.mHeight, sample.mClipWidth, sample.mClipHeight)) {
                    YMFLog.info(this, "[Beauty  ]", "soft-VideoLiveSession adjustTexture..");
                    this.mOffScreen.adjustTexture(sample.mWidth, sample.mHeight, sample.mClipWidth, sample.mClipHeight);
                }
                if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_DUALCAMERA) {
                    this.flip(sample);
                    this.updateVertexBuffer(this.mSlaveVertexBuffer, sample.mPictureInPictureDisplayInfo);
                    this.mOffScreen.drawFrame(sample.mMasterTextureId, sample.mMainTransformer, watermarkTextureID, dynamicTextureId, sample.mSlaveTextureId, sample.mSlaveTransformer, this.mSlaveVertexBuffer, GlUtil.adjustDualCameraSlaveTexture(sample, this.mFilterContext.mCameraPreviewConfig.getWidth(), this.mFilterContext.mCameraPreviewConfig.getHeight()));
                } else if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_PERIPHERALS) {
                    this.drawPeripherals(sample);
                } else {
                    this.flip(sample);
                    this.mOffScreen.drawFrame(sample.mMasterTextureId, sample.mMainTransformer, watermarkTextureID, dynamicTextureId, -1, null, null);
                }
                GLES20.glBindFramebuffer((int)36160, (int)0);
            }
            catch (Throwable t) {
                YMFLog.error((Object)this, "[Beauty  ]", "blend exception:" + t.getMessage());
                GLES20.glBindFramebuffer((int)36160, (int)0);
            }
        }
        return this.mOffScreenTextureId;
    }

    private boolean checkClipRatioChanged(int inputWidth, int inputHeight, int clipWidth, int clipHeight) {
        boolean ret = false;
        if (this.mInputWidth != inputWidth || this.mInputHeight != inputHeight || this.mClipWidth != clipWidth || this.mClipHeight != clipHeight) {
            YMFLog.info(this, "[Encoder ]", "inputWidth:" + inputWidth + " inputHeight:" + inputHeight + " clipWidth:" + clipWidth + " clipHeight:" + clipHeight);
            this.mInputWidth = inputWidth;
            this.mInputHeight = inputHeight;
            this.mClipWidth = clipWidth;
            this.mClipHeight = clipHeight;
            ret = true;
        }
        return ret;
    }

    private void drawPeripherals(YYMediaSample sample) {
        FloatBuffer peripheralsVertexCoord = this.mFilterContext.mPeripheralsPosition.getPositionBuffer(false);
        FloatBuffer peripheralsTexCoord = GlUtil.setFlipY(this.mFilterContext.mPeripheralsPosition.getDefaultTextureBuffer());
        if (this.mFilterContext.mPeripheralsPosition.fillMode == 1) {
            peripheralsVertexCoord = this.mFilterContext.mPeripheralsPosition.convertPositionBuffer(sample.mEncodeWidth, sample.mEncodeHeight, this.mFilterContext.mPeripheralsPosition.srcWidth, this.mFilterContext.mPeripheralsPosition.srcHeight);
            peripheralsTexCoord = this.mFilterContext.mPeripheralsPosition.getDefaultTextureBuffer();
        }
        this.mOffScreen.drawFrame(this.mFilterContext.getBackgroundTextureId(), sample.mMainTransformer, this.mFilterContext.getWatermarkTextureID(), this.mFilterContext.getDynamicTextureID(), sample.mSlaveTextureId, sample.mSlaveTransformer, GlUtil.setFlipY(peripheralsVertexCoord), peripheralsTexCoord);
        if (this.mFilterContext.mPeripheralsOrientation != 1 && this.fakeTextureId > -1) {
            GLES20.glEnable((int)3042);
            GLES20.glBlendFunc((int)770, (int)771);
            this.mOffScreen.drawFrame(this.fakeTextureId, this.mFilterContext.mPeripheralsPosition.getDefaultVertexBuffer(), this.mFilterContext.mPeripheralsPosition.getDefaultTextureBuffer(), sample.mMainTransformer, this.mFilterContext.getWatermarkTextureID(), this.mFilterContext.getDynamicTextureID(), -1, null, null, null);
            GLES20.glDisable((int)3042);
        }
        FloatBuffer textureBuffer = this.mFilterContext.mCameraPostion.getDefaultTextureBuffer();
        if (this.mFilterContext.mCameraPostion.fillMode == 2) {
            int dstWidth = 1;
            int dstHeight = 1;
            if (this.mFilterContext.mCameraPostion.dstWidth != 0 && this.mFilterContext.mCameraPostion.dstHeight != 0) {
                dstWidth = this.mFilterContext.mCameraPostion.dstWidth;
                dstHeight = this.mFilterContext.mCameraPostion.dstHeight;
            }
            textureBuffer = GlUtil.setFlipY(this.mFilterContext.mCameraPostion.convertTextureBuffer(dstWidth, dstHeight, this.mFilterContext.mCameraPostion.srcWidth, this.mFilterContext.mCameraPostion.srcHeight));
        }
        if (sample.mCameraFacing == 1 && !sample.mIsMirrorEnable) {
            textureBuffer = GlUtil.setFlipX(textureBuffer);
        }
        this.mOffScreen.drawFrame(sample.mMasterTextureId, this.mFilterContext.mCameraPostion.getPositionBuffer(true), textureBuffer, sample.mMainTransformer, -1, -1, -1, null, null, null);
    }

    public void flip(YYMediaSample sample) {
        this.mOffScreen.resetFlip();
        if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_DUALCAMERA) {
            if (sample.mCameraFacing == 1) {
                if (sample.mOrientation == 2) {
                    if (sample.mOrginalCameraFacing == sample.mCameraFacing) {
                        if (!sample.mIsMirrorEnable) {
                            this.mOffScreen.flipXMasterPicture();
                        }
                    } else if (!sample.mIsMirrorEnable) {
                        this.mOffScreen.flipXSlavePicture();
                    } else {
                        this.mOffScreen.flipXScreen();
                    }
                } else if (sample.mOrginalCameraFacing != sample.mCameraFacing) {
                    if (!sample.mIsMirrorEnable) {
                        this.mOffScreen.flipYScreenXMaster();
                    } else {
                        this.mOffScreen.flipYScreen();
                    }
                } else if (!sample.mIsMirrorEnable) {
                    this.mOffScreen.flipXMasterPicture();
                }
            } else if (sample.mOrientation == 2) {
                if (sample.mOrginalCameraFacing == sample.mCameraFacing) {
                    if (!sample.mIsMirrorEnable) {
                        this.mOffScreen.flipXSlavePicture();
                    }
                } else if (!sample.mIsMirrorEnable) {
                    this.mOffScreen.flipXMasterPicture();
                } else {
                    this.mOffScreen.flipXScreen();
                }
            } else if (sample.mOrginalCameraFacing != sample.mCameraFacing) {
                if (!sample.mIsMirrorEnable) {
                    this.mOffScreen.flipYScreenXSlave();
                } else {
                    this.mOffScreen.flipYScreen();
                }
            } else if (!sample.mIsMirrorEnable) {
                this.mOffScreen.flipXSlavePicture();
            }
        } else if (sample.mCameraFacing == 1 && !sample.mIsMirrorEnable) {
            this.mOffScreen.flipXMasterPicture();
        }
    }

    public void updateVertexBuffer(FloatBuffer buffer, PictureInPictureDisplayInfo info) {
        if (info == null) {
            YMFLog.error((Object)this, "[Util    ]", "updateVertexBuffer, invalid PictureInPictureDisplayInfo");
            return;
        }
        buffer.put(0, 1.0f - info.scaleRatio);
        buffer.put(1, info.bottomOffset + info.scaleRatio);
        buffer.put(2, 1.0f);
        buffer.put(3, info.bottomOffset + info.scaleRatio);
        buffer.put(4, 1.0f - info.scaleRatio);
        buffer.put(5, info.bottomOffset);
        buffer.put(6, 1.0f);
        buffer.put(7, info.bottomOffset);
    }

    private String transform2String(FloatBuffer buffer) {
        StringBuilder builder = new StringBuilder("vertex buffer::");
        for (int i = 0; i < buffer.capacity(); ++i) {
            builder.append(buffer.get(i) + " ");
        }
        return builder.toString();
    }

    public int blend(int textureID, float[] texMatrix, int extraTextureID1, int extraTextureID2, int width, int height) {
        this.checkImageSize(width, height);
        GLES20.glViewport((int)0, (int)0, (int)this.mWidth, (int)this.mHeight);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16384);
        GLES20.glBindFramebuffer((int)36160, (int)this.mOffScreenFrameBuffer);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mOffScreenTextureId, (int)0);
        this.mOffScreen.drawFrame(textureID, texMatrix, extraTextureID1, extraTextureID2, -1, null, null);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        return this.mOffScreenTextureId;
    }

    public void destroy() {
        int[] textures;
        if (this.mOffScreenTextureId > 0) {
            textures = new int[]{this.mOffScreenTextureId};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.mOffScreenTextureId = -1;
        }
        if (this.mOffScreenFrameBuffer > 0) {
            int[] framebuffers = new int[]{this.mOffScreenFrameBuffer};
            GLES20.glDeleteFramebuffers((int)1, (int[])framebuffers, (int)0);
            this.mOffScreenFrameBuffer = -1;
        }
        if (this.mOffScreen != null) {
            this.mOffScreen.release(true);
            this.mOffScreen = null;
        }
        if (this.fakeTextureId > 0) {
            textures = new int[]{this.fakeTextureId};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.fakeTextureId = -1;
        }
    }
}

