/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage;

import android.opengl.GLES20;
import com.yy.mediaframework.gpuimage.GPUImageFilter;
import com.yy.mediaframework.gpuimage.GPUImageFilterGroup;

public class GPUImageTwoPassTextureFilter
extends GPUImageFilterGroup {
    public GPUImageTwoPassTextureFilter(String firstVertexShader, String firstFragmentShader, String secondVertexShader, String secondFragmentShader) {
        super(null);
        this.addFilter(new GPUImageFilter(firstVertexShader, firstFragmentShader));
        this.addFilter(new GPUImageFilter(secondVertexShader, secondFragmentShader));
    }

    @Override
    public void onInit() {
        super.onInit();
        this.initTexelOffsets();
    }

    protected void initTexelOffsets() {
        float ratio = this.getHorizontalTexelOffsetRatio();
        GPUImageFilter filter = (GPUImageFilter)this.mFilters.get(0);
        int texelWidthOffsetLocation = GLES20.glGetUniformLocation((int)filter.getProgram(), (String)"texelWidthOffset");
        int texelHeightOffsetLocation = GLES20.glGetUniformLocation((int)filter.getProgram(), (String)"texelHeightOffset");
        int mDistanceNormalizationFactor = GLES20.glGetUniformLocation((int)filter.getProgram(), (String)"distanceNormalizationFactor");
        int mGamaVal = GLES20.glGetUniformLocation((int)filter.getProgram(), (String)"gamaVal");
        filter.setFloat(mDistanceNormalizationFactor, ratio);
        filter.setFloat(mGamaVal, 0.9f);
        if (this.mOutputHeight != 0) {
            filter.setFloat(texelHeightOffsetLocation, 2.0f / (float)this.mOutputHeight);
        }
        filter.setFloat(texelWidthOffsetLocation, 0.0f);
        filter = (GPUImageFilter)this.mFilters.get(1);
        texelWidthOffsetLocation = GLES20.glGetUniformLocation((int)filter.getProgram(), (String)"texelWidthOffset");
        texelHeightOffsetLocation = GLES20.glGetUniformLocation((int)filter.getProgram(), (String)"texelHeightOffset");
        filter.setFloat(texelWidthOffsetLocation, 0.0f);
        if (this.mOutputWidth != 0) {
            filter.setFloat(texelHeightOffsetLocation, 2.0f / (float)this.mOutputWidth);
        }
        mDistanceNormalizationFactor = GLES20.glGetUniformLocation((int)filter.getProgram(), (String)"distanceNormalizationFactor");
        mGamaVal = GLES20.glGetUniformLocation((int)filter.getProgram(), (String)"gamaVal");
        filter.setFloat(mDistanceNormalizationFactor, ratio);
        filter.setFloat(mGamaVal, 0.9f);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        this.initTexelOffsets();
    }

    public float getVerticalTexelOffsetRatio() {
        return 1.0f;
    }

    public float getHorizontalTexelOffsetRatio() {
        return 1.0f;
    }
}

