/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage;

import android.annotation.TargetApi;
import android.opengl.GLES20;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.gpuimage.GPUImageFilter;
import com.yy.mediaframework.gpuimage.GPUImageFilterGroup;
import com.yy.mediaframework.gpuimage.util.Rotation;
import com.yy.mediaframework.gpuimage.util.TextureRotationUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GPUImageSingleFilter
extends GPUImageFilter {
    public static final String FILTER_VERTEX_SHADER = "attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nuniform mat4 uTexMatrix;\nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (uTexMatrix * inputTextureCoordinate).xy;\n}";
    public static final String FILTER_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n \nuniform sampler2D inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}";
    protected int mGLProgId;
    private GPUImageFilter mFilter;
    private boolean mIsInitialized;
    private int[] mFrameBuffers;
    private int[] mFrameBufferTextures;
    private FloatBuffer mGLTextureFlipBuffer;

    public GPUImageSingleFilter() {
        this(new GPUImageFilter(FILTER_VERTEX_SHADER, GPUImageSingleFilter.FStoOESFS(FILTER_FRAGMENT_SHADER)));
    }

    public static String FStoOESFS(String fragShader) {
        String res = fragShader;
        if (!fragShader.startsWith("#extension GL_OES_EGL_image_external : require")) {
            res = fragShader.replace("sampler2D inputImageTexture;", "samplerExternalOES inputImageTexture;");
            res = "#extension GL_OES_EGL_image_external : require\n".concat(res);
        }
        return res;
    }

    public GPUImageSingleFilter(GPUImageFilter filter) {
        if (filter instanceof GPUImageFilterGroup) {
            throw new RuntimeException("GPUImageSingleFilter can't wrap GPUImageFilterGroup");
        }
        this.mFilter = filter;
        float[] flipTexture = TextureRotationUtil.getRotation(Rotation.NORMAL, false, true);
        this.mGLTextureFlipBuffer = ByteBuffer.allocateDirect(flipTexture.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mGLTextureFlipBuffer.put(flipTexture).position(0);
    }

    public GPUImageFilter getGPUImageFilter() {
        return this.mFilter;
    }

    @Override
    public void onImageSizeChanged(int width, int height) {
        this.mFilter.onImageSizeChanged(width, height);
    }

    @Override
    public int getLastTextureID() {
        return this.mFrameBufferTextures[0];
    }

    @Override
    public void onInit() {
        this.mFilter.initForExternalTextureInput();
    }

    @Override
    public void onDestroy() {
        this.destroyFramebuffers();
        this.mFilter.destroy();
    }

    private void destroyFramebuffers() {
        if (this.mFrameBufferTextures != null) {
            GLES20.glDeleteTextures((int)this.mFrameBufferTextures.length, (int[])this.mFrameBufferTextures, (int)0);
            this.mFrameBufferTextures = null;
        }
        if (this.mFrameBuffers != null) {
            GLES20.glDeleteFramebuffers((int)this.mFrameBuffers.length, (int[])this.mFrameBuffers, (int)0);
            this.mFrameBuffers = null;
        }
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        this.mFilter.onOutputSizeChanged(width, height);
        if (this.mFrameBuffers != null) {
            this.destroyFramebuffers();
        }
        this.mFrameBuffers = new int[1];
        this.mFrameBufferTextures = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])this.mFrameBuffers, (int)0);
        GLES20.glGenTextures((int)1, (int[])this.mFrameBufferTextures, (int)0);
        GLES20.glBindTexture((int)3553, (int)this.mFrameBufferTextures[0]);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffers[0]);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mFrameBufferTextures[0], (int)0);
        int status = GLES20.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            throw new RuntimeException("Framebuffer not complete, status=" + status);
        }
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    @Override
    public void checkTextureTypeUpdate(int textureTarget) {
        this.mFilter.checkTextureTypeUpdate(textureTarget);
    }

    @Override
    @TargetApi(value=15)
    public void onDraw(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer, int textureTarget, float[] texMatrix, boolean background) {
        GlUtil.checkGlError("glFramebufferRenderbuffer");
        this.runPendingOnDrawTasks();
        GlUtil.checkGlError("glFramebufferRenderbuffer");
        if (!this.isInitialized() || this.mFrameBuffers == null || this.mFrameBufferTextures == null) {
            return;
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffers[0]);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlUtil.checkGlError("glFramebufferRenderbuffer");
        this.mFilter.onDraw(textureId, cubeBuffer, textureBuffer, 36197, texMatrix, background);
    }
}

