/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gles;

import android.opengl.EGLContext;
import android.os.Build;
import android.view.SurfaceHolder;
import com.yy.mediaframework.gles.EglCore;
import com.yy.mediaframework.gles.EglCoreKhronos;
import com.yy.mediaframework.gles.IEglCore;
import com.yy.mediaframework.gles.IWindowSurface;
import com.yy.mediaframework.model.AbstractSurfaceInfo;
import com.yy.mediaframework.model.SurfaceHolderInfo;
import com.yy.mediaframework.model.SurfaceInfo;

public class EglFactory {
    private static IEglCore mIEglCore;

    public static IEglCore createEGL() {
        IEglCore core = null;
        core = Build.VERSION.SDK_INT >= 17 ? new EglCore() : new EglCoreKhronos();
        return core;
    }

    public static IEglCore createEGL(Object sharedContext, int flags) {
        IEglCore core = null;
        core = Build.VERSION.SDK_INT >= 17 && (sharedContext == null || sharedContext instanceof EGLContext) ? new EglCore(sharedContext, flags) : (sharedContext != null && sharedContext instanceof javax.microedition.khronos.egl.EGLContext ? new EglCoreKhronos((javax.microedition.khronos.egl.EGLContext)sharedContext) : new EglCoreKhronos());
        mIEglCore = core;
        return core;
    }

    public static boolean android_opengl_egl_support() {
        return Build.VERSION.SDK_INT >= 17;
    }

    public static AbstractSurfaceInfo newSurfaceInfo(SurfaceHolder holder, int with, int height) {
        if (EglFactory.android_opengl_egl_support()) {
            return new SurfaceInfo(holder.getSurface(), with, height);
        }
        return new SurfaceHolderInfo(holder, with, height);
    }

    public static IWindowSurface newWindowSurface(IEglCore elgCore, AbstractSurfaceInfo sfInfo, boolean releaseSurace) {
        if (EglFactory.android_opengl_egl_support()) {
            SurfaceInfo surfaceInfo = (SurfaceInfo)sfInfo;
            return elgCore.createWindowSurface(surfaceInfo.mSurface, releaseSurace);
        }
        SurfaceHolderInfo holderInfo = (SurfaceHolderInfo)sfInfo;
        return elgCore.createWindowSurface(holderInfo.mSurfaceHolder, releaseSurace);
    }

    public Object getEGLContext() {
        return mIEglCore.getEGLContext();
    }
}

