/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.opengles.YMFFramebuffer;
import com.yy.mediaframework.opengles.YMFShaderData;
import com.yy.mediaframework.stat.VideoDataStatUtil;

public class YMFTextureCallbackFilter
extends AbstractYYMediaFilter {
    private static final String TAG = "YMFTextureCallbackFilter";
    private int mTextureWidth;
    private int mTextureHeight;
    private boolean mCallBackInited;
    private IGPUProcess mGpuProcess;
    private YMFFramebuffer mTextureCBFrameBuffer;
    private VideoLiveFilterContext mFilterContext;
    private YMFShaderData mShaderData;

    public YMFTextureCallbackFilter(VideoLiveFilterContext ctx) {
        this.mFilterContext = ctx;
        this.mShaderData = new YMFShaderData();
    }

    public void setGpuProcess(IGPUProcess gpuProcess) {
        if (gpuProcess == null) {
            if (this.mGpuProcess != null) {
                this.mGpuProcess.onDestroy();
            }
            this.mCallBackInited = false;
        }
        this.mGpuProcess = gpuProcess;
    }

    private void onInitCB(int width, int height, int target) {
        if (this.mGpuProcess != null) {
            this.mGpuProcess.onInit(target, width, height);
            this.mTextureWidth = width;
            this.mTextureHeight = height;
            this.mCallBackInited = true;
        }
    }

    private void onTextureSizeChange(int width, int height) {
        if (this.mGpuProcess != null) {
            this.mGpuProcess.onOutputSizeChanged(width, height);
        }
    }

    private void onTextureCallback(YYMediaSample sample) {
        if (this.mGpuProcess != null) {
            if (this.mTextureCBFrameBuffer == null) {
                this.mTextureCBFrameBuffer = new YMFFramebuffer();
            }
            this.mTextureCBFrameBuffer.attachTexture(sample.mMasterTextureId);
            long mStartTime = System.currentTimeMillis();
            this.mGpuProcess.onDraw(sample.mMasterTextureId, this.mShaderData.getTextureCoordData());
            VideoDataStatUtil.putBeautyTime(System.currentTimeMillis() - mStartTime);
            this.mTextureCBFrameBuffer.unBind();
        }
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        sample.addRef();
        if (!this.mCallBackInited) {
            this.onInitCB(sample.mWidth, sample.mHeight, sample.mTextureTarget);
        }
        if (this.mTextureWidth != sample.mWidth || this.mTextureHeight != sample.mHeight) {
            this.onTextureSizeChange(sample.mWidth, sample.mHeight);
            this.mTextureWidth = sample.mWidth;
            this.mTextureHeight = sample.mHeight;
        }
        this.onTextureCallback(sample);
        this.deliverToDownStream(sample);
        sample.decRef();
        return false;
    }

    @Override
    public void deInit() {
        super.deInit();
        if (this.mGpuProcess != null) {
            this.mGpuProcess.onDestroy();
        }
        if (this.mTextureCBFrameBuffer != null) {
            this.mTextureCBFrameBuffer.release();
        }
    }
}

