/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.opengl.GLES20;
import android.opengl.Matrix;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.opengles.IRender;
import com.yy.mediaframework.opengles.YMFRender;
import com.yy.mediaframework.opengles.YMFTexture;

public class YMFOesToTexture2DFilter
extends AbstractYYMediaFilter {
    private static final String TAG = "YMFOesToTexture2DFilter";
    private VideoLiveFilterContext mFilterContext;
    private boolean mInited;
    private IRender mRender;
    private YMFTexture mOutputTexture;

    public YMFOesToTexture2DFilter(VideoLiveFilterContext ctx) {
        this.mFilterContext = ctx;
    }

    private void init() {
        if (this.mRender == null) {
            this.mRender = new YMFRender(4);
            this.mRender.flipVertical();
        }
        this.mInited = true;
    }

    private void checkUpdate(YYMediaSample sample) {
        if (this.mOutputTexture == null || this.mOutputTexture.getWidth() != sample.mWidth || this.mOutputTexture.getHeight() != sample.mHeight) {
            if (this.mOutputTexture != null) {
                this.mOutputTexture.release();
                this.mOutputTexture = null;
            }
            this.mOutputTexture = new YMFTexture(3553, sample.mWidth, sample.mHeight, 6408, 33984);
        }
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (sample == null || sample.mImageFormat != 70) {
            return false;
        }
        GlUtil.checkGlError("YMFOesToTexture2DFilter enter");
        sample.addRef();
        if (!this.mInited) {
            this.init();
        }
        this.checkUpdate(sample);
        GLES20.glViewport((int)0, (int)0, (int)sample.mWidth, (int)sample.mHeight);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        YMFTexture input = new YMFTexture(sample.mMasterTextureId, 36197, sample.mWidth, sample.mHeight, 6408, 33984);
        this.mRender.prepareInputTextureTransformMatrix(sample.mMainTransformer);
        if (this.mRender.prepareInputTexture(input) && this.mRender.prepareOutputTexture(this.mOutputTexture)) {
            this.mRender.render();
            sample.mMasterTextureId = this.mOutputTexture.getTextureId();
            sample.mImageFormat = 69;
            sample.mTextureTarget = 3553;
            Matrix.setIdentityM((float[])sample.mMainTransformer, (int)0);
            if (YYVideoSDK.getInstance().isUseGLSurfaceView() && sample.mCameraFacing == 1) {
                sample.mIsPreviewMirrorEnable = !sample.mIsPreviewMirrorEnable;
            }
        }
        GlUtil.checkGlError("YMFOesToTexture2DFilter out");
        this.deliverToDownStream(sample);
        sample.decRef();
        return true;
    }

    @Override
    public void deInit() {
        super.deInit();
        if (this.mRender != null) {
            this.mRender.release();
            this.mRender = null;
        }
        if (this.mOutputTexture != null) {
            this.mOutputTexture.release();
            this.mOutputTexture = null;
        }
    }
}

