/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.YMFImageBuffer;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.ImageUtil;
import com.yy.mediaframework.utils.YMFLog;
import com.yy.mediaframework.watermark.WaterMark;
import java.nio.Buffer;

public class YMFI420WaterMarkFilter
extends AbstractYYMediaFilter {
    private static final String TAG = "YMFI420WaterMarkFilter";
    private boolean mInited = false;
    private Paint mPaint = null;
    private Canvas mCanvas = null;
    private Bitmap mBitmap = null;
    private YMFImageBuffer mRGBABuffer;
    private VideoLiveFilterContext mFilterContex;

    public YMFI420WaterMarkFilter(VideoLiveFilterContext ctx) {
        this.mFilterContex = ctx;
    }

    private void init(int width, int height) {
        if (this.mBitmap == null) {
            this.mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        if (this.mCanvas == null) {
            this.mCanvas = new Canvas(this.mBitmap);
        }
        if (this.mPaint == null) {
            this.mPaint = new Paint();
        }
        if (this.mRGBABuffer == null) {
            this.mRGBABuffer = new YMFImageBuffer(width, height, 36, true);
        }
        this.mInited = true;
    }

    private void checkUpdata(YMFImageBuffer image) {
        if (this.mRGBABuffer == null || this.mRGBABuffer.mWidth != image.mWidth || this.mRGBABuffer.mHeight != image.mHeight) {
            this.mRGBABuffer = new YMFImageBuffer(image.mWidth, image.mHeight, 36, true);
        }
        if (this.mBitmap == null || this.mBitmap.getWidth() != image.mWidth || this.mBitmap.getHeight() != image.mHeight) {
            if (this.mBitmap != null) {
                this.mBitmap.recycle();
                this.mBitmap = null;
            }
            if (this.mCanvas != null) {
                this.mCanvas = null;
            }
            this.mBitmap = Bitmap.createBitmap((int)image.mWidth, (int)image.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mCanvas = new Canvas(this.mBitmap);
        }
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (sample.mImageFormat != 2 || sample.mI420 == null || sample.mI420.mData == null) {
            return false;
        }
        sample.addRef();
        WaterMark water = this.mFilterContex.getWatermark();
        if (water != null) {
            if (!this.mInited) {
                this.init(sample.mI420.mWidth, sample.mI420.mHeight);
            }
            this.checkUpdata(sample.mI420);
            int ret = ImageUtil.I420ToABGR(sample.mI420.mData.array(), sample.mI420.mWidth, sample.mI420.mHeight, this.mRGBABuffer.mData.array(), false);
            if (ret != 0) {
                YMFLog.error((Object)this, "[Preproce]", "I420ToABGR failed, return " + ret);
                sample.decRef();
                return false;
            }
            this.mRGBABuffer.mData.rewind();
            this.mBitmap.copyPixelsFromBuffer((Buffer)this.mRGBABuffer.mData);
            this.mBitmap.setHasAlpha(true);
            this.mCanvas.drawBitmap(water.bitmap, (float)water.offsetX, (float)water.offsetY, this.mPaint);
            this.mRGBABuffer.mData.rewind();
            this.mBitmap.copyPixelsToBuffer((Buffer)this.mRGBABuffer.mData);
            ret = ImageUtil.ABGRToI420(this.mRGBABuffer.mData.array(), this.mRGBABuffer.mWidth, this.mRGBABuffer.mHeight, sample.mI420.mData.array(), sample.mI420.mData.arrayOffset(), false);
            if (ret != 0) {
                YMFLog.error((Object)this, "[Preproce]", "ABGRToI420 failed, return " + ret);
                sample.decRef();
                return false;
            }
        }
        this.deliverToDownStream(sample);
        sample.decRef();
        return true;
    }

    @Override
    public void deInit() {
        super.deInit();
        if (this.mCanvas != null) {
            this.mCanvas = null;
        }
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
        if (this.mPaint != null) {
            this.mPaint = null;
        }
    }
}

