/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.YMFImageBuffer;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.ImageUtil;
import com.yy.mediaframework.utils.YMFLog;

public class YMFI420ToNV12Filter
extends AbstractYYMediaFilter {
    private static final String TAG = "YMFI420ToNV12Filter";
    private YMFImageBuffer mNV12;
    private VideoLiveFilterContext mFilterContex;

    public YMFI420ToNV12Filter(VideoLiveFilterContext ctx) {
        this.mFilterContex = ctx;
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        int success;
        if (sample.mImageFormat != 2 || sample.mI420 == null || sample.mI420.mData == null) {
            YMFLog.error((Object)this, "[Preproce]", "invalid I420 input buffer.");
            return false;
        }
        sample.addRef();
        if (this.mNV12 == null || this.mNV12.mWidth != sample.mI420.mWidth || this.mNV12.mHeight != sample.mI420.mHeight) {
            this.mNV12 = new YMFImageBuffer(sample.mI420.mWidth, sample.mI420.mHeight, 1, true);
        }
        if ((success = ImageUtil.I420ToNV12(sample.mI420.mData.array(), sample.mI420.mData.arrayOffset(), sample.mI420.mWidth, sample.mI420.mHeight, this.mNV12.mData.array(), false)) != 0) {
            YMFLog.error((Object)this, "[Preproce]", " I420ToNV12 failed, return " + success);
            sample.decRef();
            return false;
        }
        sample.mNV12 = this.mNV12;
        sample.mImageFormat = 1;
        this.deliverToDownStream(sample);
        sample.decRef();
        return true;
    }

    @Override
    public void deInit() {
        super.deInit();
    }
}

