/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.GlManager;
import com.yy.mediaframework.VideoRenderPosition;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.background.Background;
import com.yy.mediaframework.background.BackgroundTexture;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.YYUserLiveConfig;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.VideoQoeFilter;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.inteligence.dynamictexture.IDynamicTexture;
import com.yy.mediaframework.model.Rect;
import com.yy.mediaframework.screenshot.ScreenShot;
import com.yy.mediaframework.sensor.RotationVectorSensor;
import com.yy.mediaframework.stat.LocalEncodeParamTipsMgr;
import com.yy.mediaframework.utils.CPUTool;
import com.yy.mediaframework.utils.VideoEntities;
import com.yy.mediaframework.utils.YMFLog;
import com.yy.mediaframework.watermark.WaterMark;
import com.yy.mediaframework.watermark.WaterMarkTexture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

public class VideoLiveFilterContext {
    private static final String TAG = "VideoLiveFilterContext";
    private LiveSessionType mLiveSessionType = LiveSessionType.LIVE_MODE_NORMAL;
    public GlManager mGlManager = null;
    public VideoEncoderConfig mVideoEncoderConfig = new VideoEncoderConfig();
    public VideoEncoderConfig mDefaultVideoEncoderConfig = new VideoEncoderConfig();
    public VideoEntities.CameraPreviewConfig mCameraPreviewConfig = new VideoEntities.CameraPreviewConfig();
    public VideoEntities.ScreenRecordConfig mScreenRecordConfig = new VideoEntities.ScreenRecordConfig();
    public Context mAndroidContext = null;
    public boolean mHardwareEncode = true;
    private boolean mDoHaveReceiveIFrame = false;
    private IDynamicTexture mDynamicTexture = null;
    private ScreenShot mScreenShot = null;
    private AtomicReference<YYUserLiveConfig> mUserLiveConfig = new AtomicReference<Object>(null);
    private LocalEncodeParamTipsMgr mEncodeParamTipsMgr = null;
    private RotationVectorSensor mRotationVectorSensor;
    private AtomicBoolean mMirrorFlag = new AtomicBoolean(false);
    private AtomicBoolean mPreviewMirrorFlag = new AtomicBoolean(true);
    private AtomicBoolean mPictureInPictureFlag = new AtomicBoolean(false);
    private AtomicBoolean mPictureSwitch = new AtomicBoolean(true);
    private Constant.EncoderInputMode mEncoderInputMode = Constant.EncoderInputMode.SURFACE;
    public WaterMarkTexture mWaterMarkTexture = null;
    private WaterMark mWatermark = null;
    private waterMarkUpdate mWaterMarkUpdateCB = null;
    public BackgroundTexture mBackgroundTexture = null;
    private AtomicBoolean mColorChartLiveEnable = new AtomicBoolean(false);
    public VideoRenderPosition mCameraPostion;
    public VideoRenderPosition mPeripheralsPosition;
    public int mPeripheralsOrientation = 1;
    private AtomicBoolean mScreenLiveMode = new AtomicBoolean(false);
    private int mScreenLiveTextureId = -1;
    public ReentrantLock mSurfaceDestoryStateLock = new ReentrantLock(true);
    public AtomicBoolean mSurfaceDestoryState = new AtomicBoolean(false);
    public Boolean mPsnrFlag = false;
    public Boolean mUsedPbo = false;
    public Boolean mUseGPUBeauty = false;
    public int mLoopTime = 20000;
    public int mVirtualDisplayWidth = 0;
    public int mVirtualDisplayHeight = 0;
    public int mScreenWidth;
    public int mScreenHeight;
    public int mScreenDensityDpi;
    private boolean mIsEmulator;
    public VideoQoeFilter mVideoQoeFilter = null;
    public boolean mUsedAbroadNetWorkStrategy = false;
    public boolean mEnableUnderflowStrategy = true;
    public AtomicBoolean mChangeEncoderFlag = new AtomicBoolean(false);

    public VideoLiveFilterContext(Context context, int type) {
        this.mGlManager = new GlManager(type, null);
        this.mGlManager.setVideoLiveFilterContext(this);
        this.mAndroidContext = context.getApplicationContext();
        this.mEncodeParamTipsMgr = new LocalEncodeParamTipsMgr();
        this.mCameraPostion = new VideoRenderPosition(0, new Rect(0.6f, 0.4f, 1.0f, 0.0f), 1);
        this.mPeripheralsPosition = new VideoRenderPosition(0, new Rect(0.0f, 0.0f, 1.0f, 1.0f), 1);
        this.mIsEmulator = CPUTool.isEmulator();
    }

    public VideoLiveFilterContext(Context context, int type, Object sharedContext) {
        this.mGlManager = new GlManager(type, sharedContext);
        this.mGlManager.setVideoLiveFilterContext(this);
        this.mAndroidContext = context.getApplicationContext();
        this.mEncodeParamTipsMgr = new LocalEncodeParamTipsMgr();
        this.mCameraPostion = new VideoRenderPosition(0, new Rect(0.6f, 0.4f, 1.0f, 0.0f), 1);
        this.mPeripheralsPosition = new VideoRenderPosition(0, new Rect(0.0f, 0.0f, 1.0f, 1.0f), 1);
        this.mIsEmulator = CPUTool.isEmulator();
    }

    public VideoQoeFilter getQoeFilter() {
        return this.startQoeFilter();
    }

    private VideoQoeFilter startQoeFilter() {
        if (this.mVideoQoeFilter == null) {
            this.mVideoQoeFilter = new VideoQoeFilter(this);
        }
        return this.mVideoQoeFilter;
    }

    public GlManager getGlManager() {
        return this.mGlManager;
    }

    public void setGlManager(GlManager glManager) {
        this.mGlManager = glManager;
    }

    public void setWaterMarkTexture(WaterMark watermark) {
        if (this.mWaterMarkTexture != null) {
            this.mWaterMarkTexture.destroy();
            this.mWaterMarkTexture = null;
        }
        if (this.mWatermark != null) {
            this.mWatermark = null;
        }
        if (watermark != null) {
            this.mWaterMarkTexture = new WaterMarkTexture(watermark);
            this.mWatermark = watermark;
        } else {
            this.mWaterMarkTexture = null;
            this.mWatermark = null;
        }
        if (this.mWaterMarkUpdateCB != null) {
            this.mWaterMarkUpdateCB.onWaterMarkUpdate(this.mWatermark);
        }
    }

    public void setWaterMarkUpdateCB(waterMarkUpdate callback) {
        this.mWaterMarkUpdateCB = callback;
    }

    public BackgroundTexture getBackgroundTexture() {
        return this.mBackgroundTexture;
    }

    public void setBackgroundTexture(Background background) {
        if (this.mBackgroundTexture != null) {
            this.mBackgroundTexture.destroy();
            this.mBackgroundTexture = null;
        }
        this.mBackgroundTexture = background != null ? new BackgroundTexture(background) : new BackgroundTexture(new Background(null, this.mVideoEncoderConfig.getEncodeWidth(), this.mVideoEncoderConfig.getEncodeHeight(), 0, 0, Background.Align.FullScreen));
    }

    public int getBackgroundTextureId() {
        if (this.mBackgroundTexture == null) {
            return -1;
        }
        return this.mBackgroundTexture.mbackgroundTextureId;
    }

    public int getWatermarkTextureID() {
        if (this.mWaterMarkTexture == null) {
            return -1;
        }
        return this.mWaterMarkTexture.mWaterMarkTextureId;
    }

    public VideoEncoderConfig getVideoEncoderConfig() {
        return this.mVideoEncoderConfig;
    }

    public void setVideoConfig(VideoEncoderConfig vconfig) {
        this.mVideoEncoderConfig.assign(vconfig);
    }

    public VideoEncoderConfig getDefaultVideoEncoderConfig() {
        return this.mDefaultVideoEncoderConfig;
    }

    public void setDefaultVideoConfig(VideoEncoderConfig vconfig) {
        this.mDefaultVideoEncoderConfig.assign(vconfig);
    }

    public Context getAndroidContext() {
        return this.mAndroidContext;
    }

    public VideoEntities.CameraPreviewConfig getCameraPreviewConfig() {
        return this.mCameraPreviewConfig;
    }

    public VideoEntities.ScreenRecordConfig getScreenRecordConfig() {
        return this.mScreenRecordConfig;
    }

    public void updateCameraPreviewConfig(int previewWidth, int previewHeight, int cameraFacing, CameraInterface.CameraResolutionMode resMode) {
        this.mCameraPreviewConfig.setPreviewSize(previewWidth, previewHeight);
        this.mCameraPreviewConfig.setCameraFacing(cameraFacing);
        this.mCameraPreviewConfig.setResMode(resMode);
    }

    public void setAndroidContext(Context context) {
        this.mAndroidContext = context.getApplicationContext();
    }

    public void setHardwareEncode(boolean enable) {
        YMFLog.warn(this, "[Encoder ]", " setHardwareEncode " + enable);
        this.mHardwareEncode = enable;
    }

    public boolean isHardwareEncode() {
        return this.mHardwareEncode;
    }

    public IDynamicTexture getDynamicTexture() {
        return this.mDynamicTexture;
    }

    public WaterMarkTexture getWaterMarkTexture() {
        return this.mWaterMarkTexture;
    }

    public WaterMark getWatermark() {
        return this.mWatermark;
    }

    public void setDynamicTexture(IDynamicTexture dynamicTexture) {
        this.mDynamicTexture = dynamicTexture;
    }

    public int getDynamicTextureID() {
        if (this.mDynamicTexture != null) {
            return this.mDynamicTexture.getDynamicTextureId();
        }
        return -1;
    }

    public GlManager getGLManager() {
        return this.mGlManager;
    }

    public ScreenShot getScreenShot() {
        return this.mScreenShot;
    }

    public void setScreenShot(ScreenShot screenShot) {
        this.mScreenShot = screenShot;
    }

    public YYUserLiveConfig getUserLiveConfig() {
        return this.mUserLiveConfig.get();
    }

    public void setUserLiveConfig(YYUserLiveConfig userLiveConfig) {
        this.mUserLiveConfig.set(userLiveConfig);
    }

    public LocalEncodeParamTipsMgr getEncodeParamTipsMgr() {
        return this.mEncodeParamTipsMgr;
    }

    public void setSwitchPicture() {
        this.mPictureSwitch.set(!this.mPictureSwitch.get());
    }

    @Deprecated
    public boolean getSwithPictureFlag() {
        return this.mPictureSwitch.get();
    }

    public boolean getPictureInPictureFlag() {
        return this.mPictureInPictureFlag.get();
    }

    public void setPictureInPictureFlag(boolean flag) {
        this.mPictureInPictureFlag.set(flag);
        if (!flag) {
            this.mPictureSwitch.set(true);
        }
    }

    private void initBitmapTexture(Bitmap bitmap) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GlUtil.checkGlError("glGenTextures");
        this.mScreenLiveTextureId = textures[0];
        GLES20.glBindTexture((int)3553, (int)this.mScreenLiveTextureId);
        GlUtil.checkGlError("glBindTexture " + this.mScreenLiveTextureId);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlUtil.checkGlError("glTexParameter");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.mScreenLiveTextureId);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        YMFLog.info(this, "[SCapture]", "setmScreenLiveMode  initBitmapTexture");
    }

    private void deinitBitmapTexture() {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mScreenLiveTextureId}, (int)0);
        this.mScreenLiveTextureId = -1;
        YMFLog.info(this, "[SCapture]", "setmScreenLiveMode  deinitBitmapTexture");
    }

    public void setScreenLiveMode(boolean normal, Bitmap bitmap) {
        this.mScreenLiveMode.set(normal);
        if (normal) {
            if (this.mScreenLiveTextureId == -1) {
                this.initBitmapTexture(bitmap);
            }
        } else {
            this.deinitBitmapTexture();
        }
        YMFLog.info(this, "[SCapture]", "setmScreenLiveMode:" + normal + " ," + bitmap);
    }

    public AtomicBoolean getScreenLiveMode() {
        return this.mScreenLiveMode;
    }

    public int getScreenLiveTextureId() {
        return this.mScreenLiveTextureId;
    }

    public void setColorChartLiveEnable(boolean enable) {
        this.mColorChartLiveEnable.set(enable);
    }

    public boolean getColorChartLiveEnable() {
        return this.mColorChartLiveEnable.get();
    }

    public void setRvSensor(RotationVectorSensor rvSensor) {
        this.mRotationVectorSensor = rvSensor;
    }

    public RotationVectorSensor getRotationVectorSensor() {
        return this.mRotationVectorSensor;
    }

    public void setVideoRenderPostion(VideoRenderPosition postion) {
        if (postion.channalId < 1000) {
            this.mCameraPostion = postion;
        } else if (postion.channalId > 1000) {
            this.mPeripheralsPosition = postion;
        }
    }

    public void setDoHaveReceiveIFrame(boolean DoHaveReceiveIFrame) {
        this.mDoHaveReceiveIFrame = DoHaveReceiveIFrame;
    }

    public boolean getDoHaveReceiveIFrame() {
        return this.mDoHaveReceiveIFrame;
    }

    public void setMirrorFlag(boolean enable) {
        this.mMirrorFlag.set(enable);
    }

    public boolean getMirrorFlag() {
        return this.mMirrorFlag.get();
    }

    public void setPreviewMirrorFlag(boolean enable) {
        this.mPreviewMirrorFlag.set(enable);
    }

    public boolean getPreviwMirrorFlag() {
        return this.mPreviewMirrorFlag.get();
    }

    public void setLiveMode(LiveSessionType type) {
        this.mLiveSessionType = type;
    }

    public LiveSessionType getLiveMode() {
        return this.mLiveSessionType;
    }

    public void setEncoderInputMode(Constant.EncoderInputMode mode) {
        YMFLog.info(this, "[Encoder ]", " setEncoderInputMode:" + (Object)((Object)this.mEncoderInputMode) + " ->" + (Object)((Object)mode));
        this.mEncoderInputMode = mode;
    }

    public Constant.EncoderInputMode getEncoderInputMode() {
        return this.mEncoderInputMode;
    }

    public boolean useYUVCapture() {
        if (!this.mUseGPUBeauty.booleanValue() && YYVideoSDK.getInstance().isUseGLSurfaceView()) {
            return true;
        }
        return this.isEmulator();
    }

    public boolean isEmulator() {
        return this.mIsEmulator;
    }

    public void setAbroadNetWorkStrategy(boolean flag) {
        this.mUsedAbroadNetWorkStrategy = flag;
    }

    public void setEnableUnderflowStrategy(boolean flag) {
        this.mEnableUnderflowStrategy = flag;
    }

    public static interface waterMarkUpdate {
        public void onWaterMarkUpdate(WaterMark var1);
    }
}

