/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.ILiveSession;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.filters.VideoLiveQualityFilter;
import com.yy.mediaframework.inteligence.common.ResolutionModifyNotFoundException;
import com.yy.mediaframework.inteligence.framerate.CaptureSyncEncodeFrameRateModify;
import com.yy.mediaframework.inteligence.resolution.DefaultResolutionModify;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.YMFLog;

public class HardEncodeVideoLiveQualityFilter
extends VideoLiveQualityFilter {
    public HardEncodeVideoLiveQualityFilter(VideoLiveFilterContext filterContext, ILiveSession liveSession) {
        super(filterContext, liveSession);
        YMFLog.info(this, "[Encoder ]", "HardEncodeVideoLiveQualityFilter construct");
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (this.mHasAdaptor && this.mFrameRateModify != null) {
            if (this.mFrameRateModify instanceof CaptureSyncEncodeFrameRateModify) {
                CaptureSyncEncodeFrameRateModify realModify = (CaptureSyncEncodeFrameRateModify)this.mFrameRateModify;
                VideoEncoderConfig cfg = this.mFilterContext.getVideoEncoderConfig();
                cfg.mFrameRate = realModify.checkFrameRate(cfg.mFrameRate, cfg.mEncodeParameter, cfg.mEncodeType);
            }
            this.mFrameRateModify.onInterceptDoFrame(sample.mAndoridPtsNanos);
        }
        this.deliverToDownStream(sample);
        return false;
    }

    @Override
    public void installAdaptor() {
        if (this.mHasAdaptor) {
            YMFLog.info(this, "[Encoder ]", "installAdaptor, has installed");
            return;
        }
        VideoEncoderConfig encoderConfig = this.mFilterContext.getVideoEncoderConfig();
        if (this.mResolutionModifyConfigs != null && this.mResolutionModifyConfigs.size() > 0) {
            this.mFrameRateModify = new CaptureSyncEncodeFrameRateModify();
            ((CaptureSyncEncodeFrameRateModify)this.mFrameRateModify).init(encoderConfig.mFrameRate, encoderConfig.mBitRate, encoderConfig.getEncodeWidth(), encoderConfig.getEncodeHeight(), this.mResolutionModifyConfigs);
            try {
                this.mResolutionModify = new DefaultResolutionModify();
                ((DefaultResolutionModify)this.mResolutionModify).init(encoderConfig.mFrameRate, encoderConfig.mBitRate, encoderConfig.getEncodeWidth(), encoderConfig.getEncodeHeight(), this.mResolutionModifyInterval, this.mResolutionModifyConfigs, this.mResolutionModifyListener);
            }
            catch (ResolutionModifyNotFoundException e) {
                YMFLog.error(this, "[Encoder ]", "init ResolutinModify exception:%s", e.toString());
                this.mResolutionModify = null;
            }
        }
        this.mHasAdaptor = true;
        YMFLog.info(this, "[Encoder ]", "installAdaptor, done");
    }
}

