/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Surface;
import com.yy.mediaframework.ExternalInterface;
import com.yy.mediaframework.decoder.BaseHardwareDecoder;
import com.yy.mediaframework.decoder.H264HardwareDecoder;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.model.DecodeVideoConfig;
import com.yy.mediaframework.model.DecodeVideoSample;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.model.YYMediaSampleAlloc;
import com.yy.mediaframework.utils.YMFLog;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExternalDecoderFilter
extends AbstractYYMediaFilter
implements SurfaceTexture.OnFrameAvailableListener,
BaseHardwareDecoder.OnDecoderSizeChangeListener {
    private static final byte[] header = new byte[]{0, 0, 0, 1};
    private static final String TAG = "ExternalDecoderFilter";
    H264HardwareDecoder mH264HardwareDecoder;
    VideoLiveFilterContext mVideoLiveFilterContext;
    private int mRenderTextureId = -1;
    private Surface mRenderSurface;
    private SurfaceTexture mRenderSurfaceTexture;
    private static final byte[] SYNC_FLAG = new byte[1];
    private boolean isInited = false;
    private boolean mGetFirstIDR = false;
    private DecodeVideoConfig mDecoderConfig;
    private AtomicBoolean onExternalEnd = new AtomicBoolean(true);
    private Handler mWorkerHandler;
    private HandlerThread mHandlerThread;
    private static final String FILE_PATH_BEFORE = "/sdcard/stream_before.264";
    private static final String FILE_PATH_AFTER = "/sdcard/stream_after.264";
    FileOutputStream fos = null;
    private Timer mInitiativeTimer = null;
    private TimerTask mInitiativeTimeTask;
    private long mTime = 0L;
    private boolean mIsDjiIDRFrame = false;
    private ExternalInterface.IExternalDecode mIExternalDecode;
    private long mPts;
    private LinkedList<Long> mCachedPtsList = new LinkedList();
    int frameCount = 0;
    long lastTimestamp = 0L;
    long time = 0L;
    boolean writen = false;
    int feedFrameCounter = 0;
    long feedCurrentTime = 0L;
    long lastPrintTime = 0L;

    public ExternalDecoderFilter(VideoLiveFilterContext context) {
        this.mVideoLiveFilterContext = context;
        this.mDecoderConfig = new DecodeVideoConfig();
    }

    private void initWorkerHandler() {
        if (this.mWorkerHandler != null) {
            YMFLog.info(this, "[Decoder ]", "workder handle has already been inited.");
            return;
        }
        this.mHandlerThread = new HandlerThread("YY_yyvideolib_ExternalDecoderFilter_Thread");
        this.mHandlerThread.start();
        this.mWorkerHandler = new Handler(this.mHandlerThread.getLooper());
    }

    private void initInitiativeTimer() {
        if (this.mInitiativeTimer != null) {
            this.uninitInitiativeTimer();
        }
        this.mInitiativeTimer = new Timer();
        this.mInitiativeTimeTask = new TimerTask(){

            @Override
            public void run() {
                ExternalDecoderFilter.this.mVideoLiveFilterContext.getGlManager().post(new Runnable(){

                    @Override
                    public void run() {
                        ExternalDecoderFilter.this.handleFrameAvailable(ExternalDecoderFilter.this.mRenderSurfaceTexture);
                    }
                });
            }
        };
        this.mInitiativeTimer.schedule(this.mInitiativeTimeTask, 0L, 41L);
    }

    private void uninitInitiativeTimer() {
        if (this.mInitiativeTimer != null) {
            this.mInitiativeTimer.cancel();
            this.mInitiativeTimer = null;
        }
        if (this.mInitiativeTimeTask != null) {
            this.mInitiativeTimeTask.cancel();
            this.mInitiativeTimeTask = null;
        }
    }

    private void releaseWorkerHandler() {
        YMFLog.info(this, "[Decoder ]", "releaseWorkerHandler");
        if (this.mWorkerHandler != null) {
            this.mWorkerHandler.removeCallbacksAndMessages(null);
            this.mWorkerHandler = null;
        }
        if (this.mHandlerThread != null) {
            this.mHandlerThread.getLooper().quit();
            this.mHandlerThread = null;
        }
    }

    public void setRenderSurface(Surface surface) {
        this.mRenderSurface = surface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (this.mRenderSurface != null) {
                this.mRenderSurface.release();
                this.mRenderSurface = null;
            }
            if (this.mRenderSurfaceTexture != null) {
                this.mRenderSurfaceTexture.setOnFrameAvailableListener(null);
                this.mRenderSurfaceTexture.detachFromGLContext();
                this.mRenderSurfaceTexture.release();
                this.mRenderSurfaceTexture = null;
            }
            if (this.mRenderTextureId >= 0) {
                int[] tempTexture = new int[]{this.mRenderTextureId};
                GLES20.glDeleteTextures((int)1, (int[])tempTexture, (int)0);
            }
            this.isInited = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.releaseWorkerHandler();
            this.uninitInitiativeTimer();
            return;
        }
    }

    @Override
    @TargetApi(value=16)
    public void deInit() {
        super.deInit();
        if (this.mWorkerHandler == null) {
            return;
        }
        if (this.mVideoLiveFilterContext.getGlManager().checkSameThread()) {
            this.release();
        } else {
            this.mVideoLiveFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    ExternalDecoderFilter.this.release();
                }
            });
        }
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    private void initTextureSurface(int width, int height) {
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            this.mRenderTextureId = GlUtil.createOESTexture();
            this.mRenderSurfaceTexture = new SurfaceTexture(this.mRenderTextureId);
            this.mRenderSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            this.mRenderSurface = new Surface(this.mRenderSurfaceTexture);
            this.isInited = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        if (this.onExternalEnd.get()) {
            YMFLog.info(this, "[Decoder ]", "peripherals video end.");
            return;
        }
        if (this.mInitiativeTimer == null) {
            this.initInitiativeTimer();
        }
    }

    private void printDecoderRenderFrameRate() {
        ++this.frameCount;
        this.time = System.currentTimeMillis();
        if (this.time - this.lastTimestamp > 1000L) {
            YMFLog.info(this, "[Decoder ]", "decoder render frame rate:" + this.frameCount);
            this.frameCount = 0;
            this.lastTimestamp = this.time;
        }
    }

    private void handleFrameAvailable(SurfaceTexture surfaceTexture) {
        if (!this.isInited) {
            YMFLog.warn(this, "[Decoder ]", "not ready.");
            return;
        }
        this.printDecoderRenderFrameRate();
        surfaceTexture.updateTexImage();
        YYMediaSample sample = YYMediaSampleAlloc.instance().alloc();
        sample.mWidth = this.mDecoderConfig.width;
        sample.mHeight = this.mDecoderConfig.height;
        sample.mClipWidth = this.mDecoderConfig.width;
        sample.mClipHeight = this.mDecoderConfig.height;
        sample.mEncodeWidth = this.mVideoLiveFilterContext.getVideoEncoderConfig().getEncodeWidth();
        sample.mEncodeHeight = this.mVideoLiveFilterContext.getVideoEncoderConfig().getEncodeHeight();
        sample.mMasterTextureId = this.mRenderTextureId;
        surfaceTexture.getTransformMatrix(sample.mMainTransformer);
        this.mVideoLiveFilterContext.mPeripheralsPosition.fillMode = 1;
        this.mVideoLiveFilterContext.mPeripheralsOrientation = sample.mOrientation = this.mDecoderConfig.width >= this.mDecoderConfig.height ? 2 : 1;
        sample.mTextureTarget = 36197;
        long pts = 0L;
        if (this.mCachedPtsList != null && this.mCachedPtsList.size() > 0) {
            pts = this.mCachedPtsList.pop();
        }
        sample.mYYPtsMillions = pts;
        this.deliverToDownStream(sample);
        sample.decRef();
    }

    public void setExternalDecodeInterface(ExternalInterface.IExternalDecode IExternalDecode2) {
        this.mIExternalDecode = IExternalDecode2;
    }

    public String getFrameTypeStr(DecodeVideoSample sample) {
        switch (sample.frameType) {
            case 4: {
                return " IDR ";
            }
            case 0: {
                return " I frame";
            }
            case 1: {
                return " P frame";
            }
            case 2: {
                return " B frame";
            }
            case 5: {
                return " SPS ";
            }
            case 6: {
                return " PPS ";
            }
            case 3: {
                return " SEI ";
            }
        }
        return "Unknown";
    }

    public void handleOutdoorVideoData(final DecodeVideoSample sample) {
        if (this.mWorkerHandler == null) {
            this.initWorkerHandler();
        }
        this.printPeripheralsFeedFrameRate();
        this.mWorkerHandler.post(new Runnable(){

            @Override
            public void run() {
                if (sample.width < 0 || sample.height < 0 || sample.data == null || sample.data.length < 0) {
                    YMFLog.info(this, "[Decoder ]", "invalid data params.");
                    sample.decRef();
                    return;
                }
                if (ExternalDecoderFilter.this.mH264HardwareDecoder == null || !ExternalDecoderFilter.this.mH264HardwareDecoder.isInited()) {
                    YMFLog.info(this, "[Decoder ]", "Decoder not ready yet.");
                    sample.decRef();
                    return;
                }
                if (sample.frameType == 4 || sample.frameType == 0) {
                    ExternalDecoderFilter.this.mVideoLiveFilterContext.setDoHaveReceiveIFrame(true);
                }
                if (!ExternalDecoderFilter.this.mVideoLiveFilterContext.getDoHaveReceiveIFrame()) {
                    YMFLog.info(this, "[Decoder ]", "getDoHaveReceiveIFrame false , continue wait ... ");
                    sample.decRef();
                    return;
                }
                if (!ExternalDecoderFilter.this.mGetFirstIDR) {
                    if (sample.frameType == 0 || sample.frameType == 4) {
                        ExternalDecoderFilter.this.mGetFirstIDR = true;
                    } else {
                        sample.decRef();
                        return;
                    }
                }
                if (ExternalDecoderFilter.this.isInited) {
                    ExternalDecoderFilter.this.mPts = ExternalDecoderFilter.this.mH264HardwareDecoder.drainDecoder(sample);
                    ExternalDecoderFilter.this.mCachedPtsList.add(ExternalDecoderFilter.this.mPts);
                }
                ExternalDecoderFilter.this.onExternalEnd.set(false);
            }
        });
    }

    private void replaceWithStandardStartCode(DecodeVideoSample sample) {
        int position = 5;
        int offset = 5;
        if (sample.dataLenght <= 3 + position) {
            return;
        }
        while (position > 0 && position <= sample.dataLenght - 4) {
            int length = 0;
            length |= sample.data[0 + position] << 24 & 0xFF000000;
            length |= sample.data[1 + position] << 16 & 0xFF0000;
            length |= sample.data[2 + position] << 8 & 0xFF00;
            System.arraycopy(header, 0, sample.data, position, 4);
            position = position + 4 + (length |= sample.data[3 + position] & 0xFF);
        }
        System.arraycopy(header, 0, sample.data, 0, 4);
        int headerLength = 5;
        int copyLength = sample.dataLenght - headerLength - 4;
        System.arraycopy(sample.data, headerLength + 4, sample.data, 4, copyLength);
        sample.dataLenght -= headerLength;
    }

    private void printPeripheralsFeedFrameRate() {
        ++this.feedFrameCounter;
        this.feedCurrentTime = System.currentTimeMillis();
        if (this.feedCurrentTime - this.lastPrintTime > 1000L) {
            YMFLog.info(this, "[Decoder ]", "peripherals feed data frame rate:" + this.feedFrameCounter);
            this.feedFrameCounter = 0;
            this.lastPrintTime = this.feedCurrentTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStreamToFile(String filePath, byte[] data, int length) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath, true);
            fos.write(data, 0, length);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            YMFLog.error((Object)this, "[Decoder ]", "save 264 stream exception:" + e);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                YMFLog.error((Object)this, "[Decoder ]", "close 264 stream exception:" + e);
            }
        }
    }

    public void handleExternalVideoEnd() {
        this.mCachedPtsList.clear();
        this.onExternalEnd.set(true);
        if (this.mWorkerHandler == null) {
            if (this.mH264HardwareDecoder != null) {
                this.mH264HardwareDecoder.release();
                this.mH264HardwareDecoder = null;
            }
        } else {
            this.mWorkerHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (null != ExternalDecoderFilter.this.mWorkerHandler) {
                        ExternalDecoderFilter.this.mWorkerHandler.removeCallbacksAndMessages(null);
                    }
                    if (ExternalDecoderFilter.this.mH264HardwareDecoder != null) {
                        ExternalDecoderFilter.this.mH264HardwareDecoder.release();
                        ExternalDecoderFilter.this.mH264HardwareDecoder = null;
                    }
                }
            });
        }
    }

    public boolean isExternalHasEnd() {
        return this.onExternalEnd.get();
    }

    public void handleOutdoorVideoConfig(final DecodeVideoConfig config, final BaseHardwareDecoder.OnDecoderSizeChangeListener SizeChangeListener) {
        if (this.mWorkerHandler == null) {
            this.initWorkerHandler();
        }
        this.mWorkerHandler.post(new Runnable(){

            @Override
            public void run() {
                config.parseOutdoorSpsPps();
                if (ExternalDecoderFilter.this.mH264HardwareDecoder == null) {
                    ExternalDecoderFilter.this.mH264HardwareDecoder = new H264HardwareDecoder(config.width, config.height);
                    ExternalDecoderFilter.this.initTextureSurface(config.width, config.height);
                }
                config.mRenderSurface = ExternalDecoderFilter.this.mRenderSurface;
                if (ExternalDecoderFilter.this.mH264HardwareDecoder != null && !ExternalDecoderFilter.this.mH264HardwareDecoder.isInited()) {
                    YMFLog.info(this, "[Decoder ]", "init external video stream decoder, config:" + config.toString());
                    ExternalDecoderFilter.this.mH264HardwareDecoder.initDecoder(config);
                    ExternalDecoderFilter.this.mH264HardwareDecoder.setOnDecoderSizeChangeListener(SizeChangeListener);
                    ExternalDecoderFilter.this.mDecoderConfig.assign(config);
                    ExternalDecoderFilter.this.mGetFirstIDR = false;
                } else if (!config.equals(ExternalDecoderFilter.this.mDecoderConfig)) {
                    YMFLog.warn(this, "[Decoder ]", "stream video config changed, need to reset decoder, config:" + config.toString());
                    config.mRenderSurface = ExternalDecoderFilter.this.mRenderSurface;
                    ExternalDecoderFilter.this.mVideoLiveFilterContext.setDoHaveReceiveIFrame(false);
                    ExternalDecoderFilter.this.mH264HardwareDecoder.resetDecoder(config);
                    ExternalDecoderFilter.this.mDecoderConfig.assign(config);
                    ExternalDecoderFilter.this.mGetFirstIDR = false;
                }
            }
        });
    }

    @Override
    public void onDecoderSizeChanged(int width, int height) {
        if (this.mDecoderConfig != null && (this.mDecoderConfig.width != width || this.mDecoderConfig.height != height)) {
            this.mDecoderConfig.width = width;
            this.mDecoderConfig.height = height;
            YMFLog.info(this, "[Decoder ]", String.format(Locale.getDefault(), "onDecoderSizeChanged, width:%d height:%d", width, height));
        }
    }
}

