/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.PreviewFilter;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.YMFLog;

public class ClipFilter
extends AbstractYYMediaFilter {
    private int mLastSampleWidth = 0;
    private int mLastSampleHeight = 0;
    public PreviewFilter mPreviewFilter;

    public void setPreviewFilter(PreviewFilter p) {
        this.mPreviewFilter = p;
    }

    private boolean checkOutputChanged(YYMediaSample sample, int width, int height) {
        if (sample.mEncodeWidth == 0 && sample.mEncodeHeight == 0) {
            YMFLog.error((Object)this, "[Encoder ]", "invalid encoder width or height");
            return false;
        }
        double origRation = (double)this.mOutputWidth * 1.0 / (double)this.mOutputHeight;
        double newRation = (double)sample.mEncodeWidth * 1.0 / (double)sample.mEncodeHeight;
        if (Math.abs(origRation - newRation) <= 0.01 && width == this.mLastSampleWidth && height == this.mLastSampleHeight) {
            return false;
        }
        YMFLog.info(this, "[Encoder ]", "input size(width:%d height:%d), encode size(width:%d height:%d)", width, height, sample.mEncodeWidth, sample.mEncodeHeight);
        StringBuilder logSb = new StringBuilder();
        logSb.append("checkOutputChanged, origOutputWidth:").append(this.mOutputWidth);
        logSb.append(",origOutputHeight:").append(this.mOutputHeight);
        double inputRation = (double)width * 1.0 / (double)height;
        double outputRation = newRation;
        if (inputRation > outputRation) {
            this.mOutputHeight = height;
            this.mOutputWidth = (int)((double)height * outputRation);
        } else {
            this.mOutputWidth = width;
            this.mOutputHeight = (int)((double)width / outputRation);
        }
        this.mLastSampleWidth = width;
        this.mLastSampleHeight = height;
        logSb.append(", newOutputWidth:").append(this.mOutputWidth);
        logSb.append(" newOutputHeight:").append(this.mOutputHeight);
        YMFLog.info(this, "[Encoder ]", logSb.toString());
        return true;
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        sample.addRef();
        if (sample.mIsYUVBuffer) {
            if (sample.mSwapWidthHeight) {
                this.checkOutputChanged(sample, sample.mHeight, sample.mWidth);
                sample.mClipWidth = this.mOutputHeight;
                sample.mClipHeight = this.mOutputWidth;
            } else {
                this.checkOutputChanged(sample, sample.mWidth, sample.mHeight);
                sample.mClipWidth = this.mOutputWidth;
                sample.mClipHeight = this.mOutputHeight;
            }
            sample.mClipX = (sample.mWidth - sample.mClipWidth) / 2 & 0xFFFFFFFE;
            sample.mClipY = (sample.mHeight - sample.mClipHeight) / 2 & 0xFFFFFFFE;
        } else {
            this.checkOutputChanged(sample, sample.mWidth, sample.mHeight);
            sample.mClipWidth = this.mOutputWidth;
            sample.mClipHeight = this.mOutputHeight;
        }
        sample.mClipWidth &= 0xFFFFFFFC;
        sample.mClipHeight &= 0xFFFFFFFC;
        this.deliverToDownStream(sample);
        sample.decRef();
        return false;
    }
}

