/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.yy.mediaframework.IMediaFilter;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.model.YYMediaSampleAlloc;
import com.yy.mediaframework.utils.TimeUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractSurfaceTextureCaptureFilter
extends AbstractYYMediaFilter
implements SurfaceTexture.OnFrameAvailableListener {
    protected Context mContext;
    public int mCaptureTextureId = -1;
    public SurfaceTexture mCaptureSurfaceTexture = null;
    public long mTextureCreatedThreadId = -1L;
    AtomicBoolean mInited = new AtomicBoolean(false);
    VideoLiveFilterContext mFilterContext = null;
    private long mLastTimeStamp = 0L;
    private int mCount = 0;
    private long mLastAndoridPtsNanos = 0L;
    private long mLastYYPtsMillions = 0L;
    private int mTimerInterval = 33;
    private long feedFrameCounter = 0L;
    private long feedCurrentTime = 0L;
    private long lastPrintTime = 0L;
    private List<Long> mCaptureRateList = new ArrayList<Long>();
    private long maxDealTime = 0L;
    private long averageDealTime = 0L;
    private List<Long> mCaptureAverageDealTimeList = new ArrayList<Long>();
    private List<Long> mCaptureMaxDealTimeList = new ArrayList<Long>();
    private RectF mScreenCropArea = null;
    private AtomicBoolean mStopFlag = new AtomicBoolean(true);
    private Handler mWorkerHandler;
    private HandlerThread mHandlerThread;
    private static final int MSG_CAPTURE = 0;
    private AtomicBoolean mNewFrameArrived = new AtomicBoolean(false);

    public AbstractSurfaceTextureCaptureFilter(VideoLiveFilterContext filterContext) {
        YMFLog.info(this, "[SCapture]", "new AbstractSurfaceTextureCaptureFilter...");
        this.mFilterContext = filterContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=15)
    protected void doInit() {
        YMFLog.info(this, "[SCapture]", "AbstractSurfaceTextureCaptureFilter doInit begin");
        AtomicBoolean atomicBoolean = this.mInited;
        synchronized (atomicBoolean) {
            if (this.mInited.get()) {
                return;
            }
            int[] textures = new int[1];
            GLES20.glGenTextures((int)1, (int[])textures, (int)0);
            this.mCaptureTextureId = textures[0];
            GLES20.glBindTexture((int)36197, (int)this.mCaptureTextureId);
            GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
            GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
            this.mCaptureSurfaceTexture = new SurfaceTexture(this.mCaptureTextureId);
            this.mFilterContext.mVirtualDisplayWidth = this.mFilterContext.getScreenRecordConfig().getWidth();
            this.mFilterContext.mVirtualDisplayHeight = this.mFilterContext.getScreenRecordConfig().getHeight();
            this.mCaptureSurfaceTexture.setDefaultBufferSize(this.mFilterContext.mVirtualDisplayWidth, this.mFilterContext.mVirtualDisplayHeight);
            this.mCaptureSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            this.mTextureCreatedThreadId = Thread.currentThread().getId();
            YMFLog.info(this, "[SCapture]", "screenRecord fps:" + this.mFilterContext.getVideoEncoderConfig().mFrameRate);
            this.mTimerInterval = 1000 / this.mFilterContext.getVideoEncoderConfig().mFrameRate;
            this.mHandlerThread = new HandlerThread("YY_yyvideolib_Screen_Thread");
            this.mHandlerThread.start();
            this.mWorkerHandler = new WorkerHandler(this, this.mHandlerThread.getLooper());
            this.mInited.set(true);
            this.mInited.notifyAll();
        }
        YMFLog.info(this, "[SCapture]", "AbstractSurfaceTextureCaptureFilter doInit done, surface texture width:" + this.mFilterContext.mVirtualDisplayWidth + " height:" + this.mFilterContext.mVirtualDisplayHeight);
    }

    @Override
    public void deInit() {
        YMFLog.info(this, "[SCapture]", "AbstractSurfaceTextureCaptureFilter deInit begin");
        if (this.mFilterContext.getGlManager().checkSameThread()) {
            this.doDeInit();
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    AbstractSurfaceTextureCaptureFilter.this.doDeInit();
                }
            });
        }
        if (this.mWorkerHandler != null) {
            this.mWorkerHandler.removeCallbacksAndMessages(null);
            this.mWorkerHandler = null;
        }
        if (this.mHandlerThread != null) {
            this.mHandlerThread.getLooper().quit();
            this.mHandlerThread = null;
        }
        YMFLog.info(this, "[SCapture]", "AbstractSurfaceTextureCaptureFilter deInit done");
    }

    @TargetApi(value=16)
    protected void doDeInit() {
        if (!this.mInited.getAndSet(false)) {
            YMFLog.info(this, "[SCapture]", "doDeInit: no Initalized state, so return");
            return;
        }
        YMFLog.info(this, "[SCapture]", "doDeInit begin");
        if (this.mCaptureTextureId > 0) {
            int[] textures = new int[]{this.mCaptureTextureId};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.mCaptureTextureId = -1;
        }
        if (this.mCaptureSurfaceTexture != null) {
            this.mCaptureSurfaceTexture.detachFromGLContext();
            this.mCaptureSurfaceTexture.release();
            this.mCaptureSurfaceTexture = null;
        }
        this.stopCapture();
        YMFLog.info(this, "[SCapture]", "doDeInit done");
    }

    public void updateScreenSize() {
        int[] textures;
        YMFLog.info(this, "[SCapture]", "ScreenCaptureFilter updateScreenSize begin");
        this.mCaptureSurfaceTexture.setOnFrameAvailableListener(null);
        this.mNewFrameArrived.set(false);
        if (this.mCaptureTextureId > 0) {
            textures = new int[]{this.mCaptureTextureId};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.mCaptureTextureId = -1;
        }
        if (this.mCaptureSurfaceTexture != null) {
            this.mCaptureSurfaceTexture.detachFromGLContext();
            this.mCaptureSurfaceTexture.release();
            this.mCaptureSurfaceTexture = null;
        }
        textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        this.mCaptureTextureId = textures[0];
        GLES20.glBindTexture((int)36197, (int)this.mCaptureTextureId);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        this.mCaptureSurfaceTexture = new SurfaceTexture(this.mCaptureTextureId);
        this.mFilterContext.mVirtualDisplayWidth = this.mFilterContext.getScreenRecordConfig().getWidth();
        this.mFilterContext.mVirtualDisplayHeight = this.mFilterContext.getScreenRecordConfig().getHeight();
        this.mCaptureSurfaceTexture.setDefaultBufferSize(this.mFilterContext.mVirtualDisplayWidth, this.mFilterContext.mVirtualDisplayHeight);
        this.mCaptureSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.mNewFrameArrived.set(false);
        YMFLog.info(this, "[SCapture]", "updateScreenSize surface texture width:" + this.mFilterContext.mVirtualDisplayWidth + " height:" + this.mFilterContext.mVirtualDisplayHeight);
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.mCaptureSurfaceTexture;
    }

    private void handleFrameAvailable(SurfaceTexture surfaceTexture) {
        long startTime = System.currentTimeMillis();
        if (!this.mInited.get() || !surfaceTexture.equals(this.mCaptureSurfaceTexture)) {
            YMFLog.error((Object)this, "[SCapture]", "handleFrameAvailble, not same surfaceTexture or not initialized");
            return;
        }
        if (!this.mNewFrameArrived.get()) {
            return;
        }
        long currentTimeStamp = TimeUtil.getTickCountLong();
        long diffTimeStamp = currentTimeStamp - this.mLastTimeStamp;
        this.mLastTimeStamp = currentTimeStamp;
        surfaceTexture.updateTexImage();
        YYMediaSample sample = YYMediaSampleAlloc.instance().alloc();
        if (this.mLastTimeStamp == 0L) {
            sample.mAndoridPtsNanos = surfaceTexture.getTimestamp();
            sample.mYYPtsMillions = TimeUtil.getTickCountLong();
        } else {
            sample.mAndoridPtsNanos = this.mLastAndoridPtsNanos + diffTimeStamp * 1000000L;
            sample.mYYPtsMillions = this.mLastYYPtsMillions + diffTimeStamp;
        }
        sample.mWidth = this.mFilterContext.mVirtualDisplayWidth;
        sample.mHeight = this.mFilterContext.mVirtualDisplayHeight;
        this.mLastAndoridPtsNanos = sample.mAndoridPtsNanos;
        this.mLastYYPtsMillions = sample.mYYPtsMillions;
        if (this.mFilterContext.mVirtualDisplayWidth != this.mFilterContext.getScreenRecordConfig().getWidth() || this.mFilterContext.mVirtualDisplayHeight != this.mFilterContext.getScreenRecordConfig().getHeight()) {
            this.updateScreenSize();
            return;
        }
        sample.mResMode = this.mFilterContext.getCameraPreviewConfig().getResMode();
        sample.mImageFormat = 17;
        sample.mCameraFacing = 0;
        sample.mOrientation = 0;
        surfaceTexture.getTransformMatrix(sample.mMainTransformer);
        sample.mMasterTextureId = this.mCaptureTextureId;
        sample.mTextureTarget = 36197;
        sample.mTextureCreatedThreadId = this.mTextureCreatedThreadId;
        sample.mEncodeWidth = this.mFilterContext.getVideoEncoderConfig().getEncodeWidth();
        sample.mEncodeHeight = this.mFilterContext.getVideoEncoderConfig().getEncodeHeight();
        sample.mEncoderType = this.mFilterContext.getVideoEncoderConfig().mEncodeType;
        sample.mScreenCropArea = this.mScreenCropArea;
        this.deliverToDownStream(sample);
        sample.decRef();
        this.printScreenRecordFrameRate(System.currentTimeMillis() - startTime);
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.mNewFrameArrived.set(true);
    }

    private void handlerScreenCaptureLoop() {
        if (!this.mStopFlag.get()) {
            this.mWorkerHandler.removeMessages(0);
            this.mWorkerHandler.sendEmptyMessageDelayed(0, (long)(1000 / this.mFilterContext.getVideoEncoderConfig().mFrameRate));
        }
        final CountDownLatch barrier = new CountDownLatch(1);
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                if (AbstractSurfaceTextureCaptureFilter.this.mCaptureSurfaceTexture != null) {
                    AbstractSurfaceTextureCaptureFilter.this.handleFrameAvailable(AbstractSurfaceTextureCaptureFilter.this.mCaptureSurfaceTexture);
                }
                barrier.countDown();
            }
        });
        try {
            barrier.await(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            YMFLog.info(this, "[SCapture]", "handlerScreenCaptureLoop:" + e.toString());
        }
    }

    public void startCapture() {
        YMFLog.info(this, "[SCapture]", "startCapture...");
        if (!this.mStopFlag.get()) {
            return;
        }
        this.mStopFlag.set(false);
        if (!this.mStopFlag.get() && this.mWorkerHandler != null) {
            this.mWorkerHandler.sendEmptyMessageDelayed(0, (long)(1000 / this.mFilterContext.getVideoEncoderConfig().mFrameRate));
        }
    }

    public void stopCapture() {
        YMFLog.info(this, "[SCapture]", "stopCapture...");
        this.mStopFlag.set(true);
        if (this.mWorkerHandler != null) {
            this.mWorkerHandler.removeCallbacksAndMessages(null);
        }
    }

    private void printScreenRecordFrameRate(long dealTime) {
        try {
            ++this.feedFrameCounter;
            this.feedCurrentTime = System.currentTimeMillis();
            this.maxDealTime = this.maxDealTime < dealTime ? dealTime : this.maxDealTime;
            this.averageDealTime += dealTime;
            if (this.feedCurrentTime - this.lastPrintTime >= 1000L) {
                this.mCaptureRateList.add(this.feedFrameCounter);
                this.mCaptureAverageDealTimeList.add(this.averageDealTime / this.feedFrameCounter);
                this.mCaptureMaxDealTimeList.add(this.maxDealTime);
                if (this.mCaptureRateList.size() >= 5) {
                    this.printFrameRate("ScreenCapture", this.mCaptureRateList, this.mCaptureAverageDealTimeList, this.mCaptureMaxDealTimeList);
                    this.mCaptureRateList.clear();
                    this.mCaptureMaxDealTimeList.clear();
                    this.mCaptureAverageDealTimeList.clear();
                }
                this.feedFrameCounter = 0L;
                this.lastPrintTime = this.feedCurrentTime;
                this.maxDealTime = 0L;
                this.averageDealTime = 0L;
            }
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[SCapture]", "printScreenRecordFrameRate exception:" + e.toString());
        }
    }

    private void printFrameRate(String type, List<Long> list, List<Long> list2, List<Long> list3) {
        if (null == list) {
            return;
        }
        String str = " ";
        for (int i = 0; i < list.size(); ++i) {
            str = str + list.get(i) + ":" + list2.get(i) + ":" + list3.get(i) + ", ";
        }
        YMFLog.info(this, "[SCapture]", "handleFrameAvailable feed data frame rate:[" + str + "] tyoe:[" + type + "] gpu:" + this.mFilterContext.mUseGPUBeauty);
    }

    public void setScreenCropArea(RectF rectF) {
        YMFLog.info(this, "[SCapture]", "setScreenCropArea, rectF:" + rectF);
        this.mScreenCropArea = rectF;
    }

    private static class WorkerHandler
    extends Handler {
        private WeakReference<AbstractSurfaceTextureCaptureFilter> mWeakFilter;

        public WorkerHandler(AbstractSurfaceTextureCaptureFilter filter, Looper looper) {
            super(looper);
            this.mWeakFilter = new WeakReference<AbstractSurfaceTextureCaptureFilter>(filter);
        }

        public void handleMessage(Message msg) {
            int what = msg.what;
            AbstractSurfaceTextureCaptureFilter captureFilter = (AbstractSurfaceTextureCaptureFilter)this.mWeakFilter.get();
            if (captureFilter == null) {
                YMFLog.warn(IMediaFilter.TAG, "[SCapture]", "captureFilter is null");
                return;
            }
            switch (what) {
                case 0: {
                    captureFilter.handlerScreenCaptureLoop();
                    break;
                }
            }
        }
    }
}

