/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.Constant;
import com.yy.mediaframework.IEncoderListener;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.filters.IEncodeFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.mediaframework.stat.YMFLiveExceptionStat;
import com.yy.mediaframework.stat.YMFLiveExceptionType;
import com.yy.mediaframework.utils.YMFLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractEncoderFilter
extends IEncodeFilter {
    private long mlastCountTime = System.currentTimeMillis();
    private int mInputByteSize = 0;
    private int mOutputByteSize = 0;
    private int mFrameCnt = 0;
    private int mBitRate = 0;
    private int mFrameRate = 0;
    private long lastCapCountTime = 0L;
    private int capFrameRate;
    private long encodeTime = 0L;
    private IEncoderListener mEncoderListener = null;
    VideoEncoderConfig mEncoderConfig = null;
    protected int mRetryCnt = 0;
    protected VideoLiveFilterContext mFilterContext = null;
    private boolean mbFirstFrame = true;
    public boolean mbEncodingState = false;
    private boolean mHasBFrame = false;
    private boolean mEncoderSwitchEnable = true;
    public String mEncodeParam = null;
    protected Constant.EncoderInputMode mInputMode;
    public long currentPrintTime = 0L;
    public long lastPrintTime = 0L;
    public long mEncodeFrameCount = 0L;
    private int statisticCnt = 0;
    private List<Integer> mFrameRateLister = new ArrayList<Integer>();
    private List<Integer> mBitrateRateLister = new ArrayList<Integer>();
    protected IEncodedDataOutCallBack encodedCallBack;
    protected AtomicBoolean mFirstEncoderDataOut = new AtomicBoolean(false);
    protected IEncodeStateCallBack mEncodeStateCallBack;

    @Override
    public void setEncoderListener(IEncoderListener listener) {
        this.mEncoderListener = listener;
    }

    public IEncoderListener getEncoderListener() {
        return this.mEncoderListener;
    }

    public void handleEncodedFrameStats(long outputFrameSize, int inputFrameSize, int frameType) {
        float interval;
        if (this.mbFirstFrame && this.mEncoderListener != null) {
            YMFLog.info(this, "[Encoder ]", "handleEncodedFrameStats onEncodeFirstFrame:" + frameType);
            this.mEncoderListener.onEncodeFirstFrame();
        }
        if (!this.mbEncodingState) {
            YMFLiveExceptionStat.getInstance().notifyException(YMFLiveExceptionType.AnchorStatus_BACK_TO_NORMAL);
            this.mbEncodingState = true;
        }
        this.mbFirstFrame = false;
        if (frameType == 5 || frameType == 6) {
            return;
        }
        if (frameType == 2 && !this.mHasBFrame) {
            YMFLog.info(this, "[Encoder ]", "handleEncodedFrameStats B frame enable");
            this.mHasBFrame = true;
            if (this.mEncoderListener != null) {
                this.mEncoderListener.onEncodeEncParam(this.mEncodeParam + ":haveBFrame:true");
            }
        }
        ++this.mFrameCnt;
        this.mOutputByteSize = (int)((long)this.mOutputByteSize + outputFrameSize);
        this.mInputByteSize += inputFrameSize;
        if (this.mlastCountTime == 0L) {
            this.mlastCountTime = System.currentTimeMillis();
        }
        if ((interval = (float)(System.currentTimeMillis() - this.mlastCountTime) / 1000.0f) >= 1.0f) {
            this.mBitRate = (int)((float)(8 * this.mOutputByteSize) / interval);
            this.mFrameRate = (int)((float)this.mFrameCnt / interval);
            VideoDataStat.getInstance().setEncodeFrameRate(this.mFrameRate);
            if (this.mEncoderListener != null) {
                this.mEncoderListener.onEncodeStat(this.mBitRate, this.mFrameRate);
            }
            this.mFrameRateLister.add(this.mFrameRate);
            this.mBitrateRateLister.add(this.mBitRate);
            this.mlastCountTime = System.currentTimeMillis();
            this.mOutputByteSize = 0;
            this.mInputByteSize = 0;
            this.mFrameCnt = 0;
            if (this.statisticCnt++ >= 3) {
                int bitRate = 0;
                int frameRate = 0;
                for (int i = 0; i < this.mFrameRateLister.size(); ++i) {
                    bitRate += this.mBitrateRateLister.get(i).intValue();
                    frameRate += this.mFrameRateLister.get(i).intValue();
                }
                VideoDataStat.getInstance().setEncodeFrameRate(frameRate /= this.mFrameRateLister.size());
                YMFLog.info(this, "[Encoder ]", "encoded bitRate:" + (bitRate /= this.mFrameRateLister.size()) + ", mFrameCnt:" + frameRate);
                this.statisticCnt = 0;
                this.mBitrateRateLister.clear();
                this.mFrameRateLister.clear();
            }
        }
        this.mRetryCnt = 0;
    }

    @Override
    public void reSetEncodingState() {
        this.mbEncodingState = false;
    }

    public void handleEncodeResolution(int width, int height) {
        if (this.mEncoderListener != null) {
            YMFLog.info(this, "[Encoder ]", "handleEncodeResolution:" + width + "x" + height);
            this.mEncoderListener.onEncodeResolution(width, height);
        }
    }

    public void handleCaptureFrameStats() {
        if (System.currentTimeMillis() - this.lastCapCountTime >= 3000L) {
            this.capFrameRate /= 3;
            YMFLog.info(this, "[Encoder ]", "encoded capture mFrameCnt:" + this.capFrameRate);
            this.lastCapCountTime = System.currentTimeMillis();
            this.capFrameRate = 0;
        }
        ++this.capFrameRate;
    }

    public void setEncodeCfg(VideoEncoderConfig cfg) {
        YMFLog.info(this, "[Encoder ]", "setEncodeCfg:" + cfg.toString());
        if (this.mEncoderConfig == null) {
            this.mEncoderConfig = new VideoEncoderConfig(cfg);
        } else {
            this.mEncoderConfig.assign(cfg);
        }
    }

    public void notifyEncoderParam(String param) {
        if (this.mEncoderListener != null) {
            this.mEncoderListener.onEncodeEncParam(param);
        }
    }

    public void handleEncoderSwitch() {
        if (this.mEncoderListener != null && this.mEncoderSwitchEnable) {
            YMFLog.info(this, "[Encoder ]", "encoder switch in AbstractEncoderFilter");
            if (this.mFilterContext.getGLManager().checkSameThread()) {
                this.mEncoderListener.onEncoderSwitch();
                this.mEncoderSwitchEnable = false;
            } else {
                this.mFilterContext.getGlManager().post(new Runnable(){

                    @Override
                    public void run() {
                        AbstractEncoderFilter.this.mEncoderListener.onEncoderSwitch();
                        AbstractEncoderFilter.this.mEncoderSwitchEnable = false;
                    }
                });
            }
        }
    }

    public boolean checkEncodeUpdate(int width, int height, boolean bLowDelay, int frameRate, int bitRate, String encodeParameter, Constant.EncoderInputMode inputMode) {
        boolean ret = false;
        if (this.mEncoderConfig.getEncodeHeight() != height || this.mEncoderConfig.getEncodeWidth() != width) {
            YMFLog.info(this, "[Encoder ]", "checkEncodeUpdate:" + this.mEncoderConfig.getEncodeWidth() + "x" + this.mEncoderConfig.getEncodeHeight() + " -> " + width + "x" + height);
            this.mEncoderConfig.setEncodeSize(width, height);
            ret = true;
        }
        if (this.mEncoderConfig.mLowDelay != bLowDelay) {
            YMFLog.info(this, "[Encoder ]", "checkEncodeUpdate lowDelay:" + this.mEncoderConfig.mLowDelay + " -> " + bLowDelay);
            this.mEncoderConfig.mLowDelay = bLowDelay;
            ret = true;
        }
        if (this.mEncoderConfig.mBitRate != bitRate) {
            YMFLog.info(this, "[Encoder ]", "checkEncodeUpdate biteRate:" + this.mEncoderConfig.mBitRate + " -> " + bitRate);
            this.adjustBitRate((bitRate + 999) / 1000);
            this.mEncoderConfig.mBitRate = bitRate;
            ret = false;
        }
        if (!(this.mEncoderConfig.mLowDelay && this.mEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264 || this.mEncoderConfig == null || this.mEncoderConfig.mEncodeParameter == null || this.mEncoderConfig.mEncodeParameter.equals(encodeParameter))) {
            YMFLog.info(this, "[Encoder ]", "checkEncodeUpdate param:" + this.mEncoderConfig.mEncodeParameter + " -> " + encodeParameter);
            this.mEncoderConfig.mEncodeParameter = encodeParameter;
            ret = true;
        }
        if (this.mInputMode != inputMode) {
            YMFLog.info(this, "[Encoder ]", "Encoder input mode change:" + (Object)((Object)this.mInputMode) + " -> " + (Object)((Object)inputMode) + ", restart encoder.");
            this.mInputMode = inputMode;
            return true;
        }
        return ret;
    }

    public boolean checkEncoderSwitch() {
        if (this.mFilterContext.mVideoEncoderConfig.mEncodeType.equals((Object)this.getEncoderFilterType())) {
            return false;
        }
        YMFLog.info(this, "[Encoder ]", "encoder switch, new encoder:%s", new Object[]{this.mFilterContext.mVideoEncoderConfig.mEncodeType});
        return true;
    }

    public void setEncodedCallback(IEncodedDataOutCallBack callBack) {
        this.encodedCallBack = callBack;
        YMFLog.info(this, "[Encoder ]", "setEncodedCallback");
    }

    public void setEncodeStateCallback(IEncodeStateCallBack callBack) {
        this.mEncodeStateCallBack = callBack;
        YMFLog.info(this, "[Encoder ]", "setEncodeStateCallback");
    }

    public static interface IEncodeStateCallBack {
        public void onEncodeError(String var1);
    }

    public static interface IEncodedDataOutCallBack {
        public void onNoEncodedDataOut();

        public void onFirstEncodedDataOut();
    }
}

