/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.encoder;

import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.encoder.VideoStreamFormat;
import com.yy.mediaframework.model.JVideoEncodedData;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;
import java.util.HashSet;

public class X264SoftEncoder {
    private static HashSet<X264SoftEncoder> mEncoders = new HashSet();
    private long mNativeEncoderHandle = 0L;
    private VideoStreamFormat mVideoFormat = new VideoStreamFormat();
    private String mSoftConfig = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X264SoftEncoder createEncoder() {
        X264SoftEncoder encoder = new X264SoftEncoder();
        HashSet<X264SoftEncoder> hashSet = mEncoders;
        synchronized (hashSet) {
            mEncoders.add(encoder);
        }
        return encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyEncoder(X264SoftEncoder encoder) {
        if (encoder == null) {
            return;
        }
        encoder.destroy();
        HashSet<X264SoftEncoder> hashSet = mEncoders;
        synchronized (hashSet) {
            mEncoders.remove(encoder);
        }
    }

    public X264SoftEncoder() {
        this.mVideoFormat.iUsedBitContorlParams = 0L;
        this.nativeCreateEncoder();
    }

    public void setSteadyBitrateControl(boolean flag) {
        this.mVideoFormat.iUsedBitContorlParams = flag ? 1L : 0L;
        YMFLog.info(this, "[Encoder ]", "setSteadyBitrateControl " + this.mVideoFormat.iUsedBitContorlParams);
    }

    public void initEncoder(VideoEncoderConfig videoEncoderConfig) {
        this.mVideoFormat.iBitRate = videoEncoderConfig.mBitRate / 1000;
        this.mVideoFormat.iFrameRate = videoEncoderConfig.mFrameRate;
        this.mVideoFormat.iHeight = videoEncoderConfig.getEncodeHeight();
        this.mVideoFormat.iWidth = videoEncoderConfig.getEncodeWidth();
        this.mVideoFormat.iPicFormat = 3;
        this.mVideoFormat.iProfile = 0;
        this.mVideoFormat.iEncodePreset = 0L;
        this.nativeInitEncoder(this.mVideoFormat, videoEncoderConfig.mEncodeParameter.getBytes());
        this.mSoftConfig = videoEncoderConfig.mEncodeParameter;
        YYVideoCodec.setCurrentEncodeName("x264");
        YMFLog.info(this, "[Encoder ]", "software encoder, configure:" + (videoEncoderConfig.mEncodeParameter == null ? "null" : videoEncoderConfig.toString()));
    }

    public JVideoEncodedData[] encode(ByteBuffer input, long iPts, int frameType) {
        return this.nativeProcess(input.array(), input.remaining(), iPts, frameType);
    }

    public void adjustBitRate(int bitRate) {
        if (this.mNativeEncoderHandle != 0L) {
            this.nativeAdjuestBitRate(bitRate);
            this.mVideoFormat.iBitRate = bitRate;
        }
    }

    private void deInitEncoder() {
        if (this.mNativeEncoderHandle != 0L) {
            this.nativeDeinitEncoder();
        }
    }

    public void setEnocderImageSize(int width, int height) {
        this.mVideoFormat.iWidth = width;
        this.mVideoFormat.iHeight = height;
    }

    public void restartEncoder() {
        this.deInitEncoder();
        this.nativeInitEncoder(this.mVideoFormat, this.mSoftConfig.getBytes());
    }

    public JVideoEncodedData[] getCacheEncodedData() {
        return this.nativeGetCacheData();
    }

    private void destroy() {
        this.nativeDeinitEncoder();
        this.nativeDestroyEncoder();
    }

    private native JVideoEncodedData[] nativeProcess(byte[] var1, int var2, long var3, int var5);

    private native void nativeInitEncoder(VideoStreamFormat var1, byte[] var2);

    private native void nativeDeinitEncoder();

    private native void nativeCreateEncoder();

    private native void nativeDestroyEncoder();

    private native void nativeAdjuestBitRate(int var1);

    private native JVideoEncodedData[] nativeGetCacheData();

    private static native void nativeClassInit();

    static {
        X264SoftEncoder.nativeClassInit();
    }
}

