/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.content.Context;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.IVideoLibInfo;
import com.yy.mediaframework.IYYVideoLib2YCloud;
import com.yy.mediaframework.gpuimage.custom.PhonePerformanceLevel;
import com.yy.mediaframework.utils.CPUTool;
import com.yy.mediaframework.utils.YMFLog;
import java.util.HashMap;

public class YYVideoSDK {
    private String mAppVersion = "";
    private Context mApplicationContext = null;
    private String mAppName = "";
    private String mDeviceOsVersion = "";
    private String mDeviceModel = "";
    private String mLogPath = null;
    private boolean mUseMultiLianmai = false;
    private static volatile YYVideoSDK instance;
    private static byte[] SYNC_FLAG;
    private boolean mIsEnableSTLibrary = false;
    private boolean mIsEnableVenusLibrary = false;
    private boolean mIsEnableMTLibrary = false;
    private static long sDeltaPtsDts;
    private boolean mUseGLClear = false;
    private boolean mUseGLSurfaceView = false;
    private int mNewPtsStrategy = 0;
    private IVideoLibInfo mVideoLibInfo = null;
    private PhonePerformanceLevel mPhonePerformanceLevel = PhonePerformanceLevel.Level_0;
    private IYYVideoLib2YCloud mYYVideoLib2YCloudListener = null;
    private Constant.MultiLianmaiMode mMultiLianmaiMode = Constant.MultiLianmaiMode.NormalMode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YYVideoSDK getInstance() {
        if (instance != null) return instance;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (instance != null) return instance;
            instance = new YYVideoSDK();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initSDK(Context applicationContext, String strAppVersion, String strAppName, String deviceOsVersion, String deviceModel, String logPath) {
        this.mApplicationContext = applicationContext.getApplicationContext();
        this.mAppVersion = strAppVersion;
        this.mAppName = strAppName;
        this.setDeviceOsVersion(deviceOsVersion);
        this.setDeviceModel(deviceModel);
        this.mLogPath = logPath;
        YMFLog.setFilePath(this.mLogPath);
        YMFLog.info(this, "[Api     ]", "initSDK");
        YMFLog.info(this, "[Api     ]", "********************************************************************");
        YMFLog.info(this, "[Api     ]", "YYVideoLib Version  : 200.2.9.16-3-SNAPSHOT");
        YMFLog.info(this, "[Api     ]", "Application Name    : " + this.mAppName);
        YMFLog.info(this, "[Api     ]", "Device Model        : " + this.mDeviceModel);
        YMFLog.info(this, "[Api     ]", "Android Version     : " + this.mDeviceOsVersion);
        YMFLog.info(this, "[Api     ]", "********************************************************************");
    }

    public void setMultiVideoLianmaiMode(boolean value) {
        YMFLog.info(this, "[Procedur]", "setMultiVideoLianmaiMode:" + value);
        this.mUseMultiLianmai = value;
    }

    public void setMultiVideoLianmaiMode(Constant.MultiLianmaiMode mode) {
        YMFLog.info(this, "[Procedur]", "setMultiVideoLianmaiMode:" + (Object)((Object)mode));
        this.mMultiLianmaiMode = mode;
        this.mUseMultiLianmai = this.mMultiLianmaiMode != Constant.MultiLianmaiMode.NormalMode;
    }

    public boolean isMultiVideoLianmaiMode() {
        return this.mUseMultiLianmai;
    }

    public Constant.MultiLianmaiMode getMultiVideoLianmaiMode() {
        return this.mMultiLianmaiMode;
    }

    public long getUid() {
        if (this.mVideoLibInfo == null) {
            return 0L;
        }
        return this.mVideoLibInfo.getUid();
    }

    public long getTopSid() {
        if (this.mVideoLibInfo == null) {
            return 0L;
        }
        return this.mVideoLibInfo.getTopSid();
    }

    public long getSubSid() {
        if (this.mVideoLibInfo == null) {
            return 0L;
        }
        return this.mVideoLibInfo.getSubSid();
    }

    public String getPackageName() {
        if (this.mVideoLibInfo == null) {
            return "";
        }
        return this.mVideoLibInfo.getPackageName();
    }

    public String getAppName() {
        return this.mAppName;
    }

    public void setAppVersion(String strAppVersion) {
        this.mAppVersion = strAppVersion;
    }

    public String getAppVersion() {
        return this.mAppVersion;
    }

    public Context getAppContext() {
        return this.mApplicationContext;
    }

    public void setAppContext(Context context) {
        this.mApplicationContext = context;
    }

    public String getDeviceOsVersion() {
        return this.mDeviceOsVersion;
    }

    public void setDeviceOsVersion(String deviceOsVersion) {
        this.mDeviceOsVersion = deviceOsVersion;
    }

    public String getDeviceModel() {
        return this.mDeviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.mDeviceModel = deviceModel;
    }

    public void setVideoInfoListener(IVideoLibInfo listener) {
        this.mVideoLibInfo = listener;
    }

    public void setPhonePerformanceLevel(PhonePerformanceLevel level) {
        YMFLog.info(this, "[Beauty  ]", "set beauty_level:" + (Object)((Object)level));
        this.mPhonePerformanceLevel = level;
    }

    public PhonePerformanceLevel getPhonePerformanceLevel() {
        return this.mPhonePerformanceLevel;
    }

    public void setUseGLClear(boolean b) {
        this.mUseGLClear = b;
    }

    public boolean enableGLClear() {
        return this.mUseGLClear;
    }

    public void setUseGLSurfaceView(boolean b) {
        this.mUseGLSurfaceView = b;
    }

    public boolean isUseGLSurfaceView() {
        return this.mUseGLSurfaceView;
    }

    public boolean isUseGPUImage() {
        boolean result = !CPUTool.isEmulator();
        YMFLog.info(this, "[Beauty  ]", "isUseGPUImage:" + result);
        return result;
    }

    public void enableSTLibrary(boolean on) {
        this.mIsEnableSTLibrary = on;
        YMFLog.info(this, "[Beauty  ]", "enableSTLibrary:" + on);
        this.mIsEnableMTLibrary = false;
        this.mIsEnableVenusLibrary = false;
    }

    public void enableVenusLibrary(boolean on) {
        this.mIsEnableVenusLibrary = on;
        YMFLog.info(this, "[Beauty  ]", "enableVenusLibrary:" + on);
        this.mIsEnableMTLibrary = false;
        this.mIsEnableSTLibrary = false;
    }

    public void enableMTLibrary(boolean on) {
        this.mIsEnableMTLibrary = on;
        YMFLog.info(this, "[Beauty  ]", "enableVenusLibrary:" + on);
        this.mIsEnableSTLibrary = false;
        this.mIsEnableSTLibrary = false;
    }

    public boolean isEnableSTLibrary() {
        return this.mIsEnableSTLibrary;
    }

    public boolean isEnableMTLibrary() {
        return this.mIsEnableMTLibrary;
    }

    public boolean isEnableVenusLibrary() {
        return this.mIsEnableVenusLibrary;
    }

    public void setDeltaYYPtsMillions(long deltaPtsDts) {
        sDeltaPtsDts = deltaPtsDts;
    }

    public long getDeltaYYPtsMillions() {
        return sDeltaPtsDts;
    }

    public void setPtsStrategy(int ptsStrategy) {
        YMFLog.info(this, "[Encoder ]", "setPtsStrategy:" + ptsStrategy);
        this.mNewPtsStrategy = ptsStrategy;
    }

    public int getPtsStrategy() {
        YMFLog.info(this, "[Encoder ]", "getPtsStrategy:" + this.mNewPtsStrategy);
        return this.mNewPtsStrategy;
    }

    public void setYYVideoLib2YCloudListener(IYYVideoLib2YCloud listener) {
        this.mYYVideoLib2YCloudListener = listener;
    }

    public IYYVideoLib2YCloud getYYVideoLib2YCloudListener() {
        return this.mYYVideoLib2YCloudListener;
    }

    public void setPassthroughDataDown(int type, HashMap value) {
        switch (type) {
            case 1: {
                this.handlePassthroughPtsStrategy((Integer)value.get("DATA_USE_NEW_PTS_STRATEGY"));
                break;
            }
        }
    }

    private void handlePassthroughPtsStrategy(Integer value) {
        YMFLog.info(this, "[Encoder ]", "handlePassthroughPtsStrategy:" + value);
        this.setPtsStrategy(value);
    }

    static {
        SYNC_FLAG = new byte[1];
        sDeltaPtsDts = 0L;
    }
}

