/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.view.Surface;
import com.yy.mediaframework.utils.YMFLog;
import java.util.concurrent.atomic.AtomicReference;

public class YYVideoCodec {
    public static final String TAG = "YYVideoCodec";
    public static final int IFRAME_INTERVAL = 3;
    public static final String MIME_H264 = "video/avc";
    public static final String MIME_H265 = "video/hevc";
    private static String mEncoderH264Name = "";
    private static String mEncoderH265Name = "";
    private static AtomicReference<Support> mSupportH264 = new AtomicReference<Support>(Support.SUPPORTED);
    private static AtomicReference<Support> mSupportH265 = new AtomicReference<Support>(Support.SUPPORTED);
    private static AtomicReference<String> mCurrentEncodeName = new AtomicReference<String>("noEncoder");
    private static String mEncoderName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    private static boolean testVideoEncoderCrash(String mime) {
        boolean crashed = false;
        MediaCodec encoder = null;
        Surface surface = null;
        try {
            MediaFormat format = MediaFormat.createVideoFormat((String)mime, (int)720, (int)1280);
            format.setInteger("color-format", 2130708361);
            format.setInteger("bitrate", 2000000);
            format.setInteger("frame-rate", 30);
            format.setInteger("i-frame-interval", 3);
            if (Build.VERSION.SDK_INT >= 21) {
                format.setInteger("bitrate-mode", 2);
            }
            YMFLog.info(null, "[Encoder ]", "testVideoEncoder mime:" + mime + ", MediaCodec format:" + format);
            encoder = MediaCodec.createEncoderByType((String)mime);
            String encoderName = encoder.getName();
            if (mime.equals(MIME_H264)) {
                mEncoderH264Name = encoderName;
            } else if (mime.equals(MIME_H265)) {
                mEncoderH265Name = encoderName;
            }
            YMFLog.info(null, "[Encoder ]", "testVideoEncoder mime:" + mime + ", MediaCodec encoder:" + encoderName);
            encoder.configure(format, null, null, 1);
            surface = encoder.createInputSurface();
            encoder.start();
        }
        catch (Throwable throwable) {
            crashed = true;
            YMFLog.error(null, "[Encoder ]", "testVideoEncoderCrash, mime:" + mime + ", reason:" + throwable);
        }
        finally {
            if (encoder != null) {
                try {
                    if (surface != null) {
                        surface.release();
                    }
                    encoder.stop();
                    encoder.release();
                }
                catch (Throwable throwable) {
                    YMFLog.error(null, "[Encoder ]", "release test encoder error! mime:" + mime + ", reason:" + throwable);
                }
            }
        }
        return crashed;
    }

    public static boolean testVideoEncoderCrash() {
        boolean h265Crashed;
        boolean h264Crashed = YYVideoCodec.testVideoEncoderCrash(MIME_H264);
        if (h264Crashed) {
            mSupportH264.set(Support.UNSUPPORTED);
            YMFLog.info(null, "[Encoder ]", "testVideoEncoderCrash h264 encoder crash");
        }
        if (h265Crashed = YYVideoCodec.testVideoEncoderCrash(MIME_H265)) {
            mSupportH265.set(Support.UNSUPPORTED);
            YMFLog.info(null, "[Encoder ]", "testVideoEncoderCrash h265 encoder crash");
        }
        return h265Crashed && h264Crashed;
    }

    public static Support getSupportH264() {
        return mSupportH264.get();
    }

    public static Support getSupportH265() {
        return mSupportH265.get();
    }

    public static String getH264EncodeName() {
        return mEncoderH264Name;
    }

    public static String getH265EncodeName() {
        return mEncoderH265Name;
    }

    public static void setCurrentEncodeName(String encodeName) {
        mCurrentEncodeName.set(encodeName);
    }

    public static String getCurrentEncodeName() {
        return mCurrentEncodeName.get();
    }

    public static void resetCurrentEncodeName() {
        mCurrentEncodeName.set("noEncoder");
    }

    public static enum Support {
        SUPPORTED,
        UNSUPPORTED,
        ISSUE;

    }
}

