/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import com.yy.mediaframework.gpuimage.util.TextureRotationUtil;
import com.yy.mediaframework.model.Rect;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class VideoRenderPosition {
    private static final String TAG = "VideoRenderPositon";
    public static final int FILLMODE_INNERFIT = 1;
    public static final int FILLMODE_OUTERFIT = 2;
    public int srcWidth = -1;
    public int srcHeight = -1;
    public int dstWidth = -1;
    public int dstHeight = -1;
    public int channalId;
    public Rect position;
    public int fillMode;
    FloatBuffer mTargetVertexBuffer;
    private FloatBuffer mGLTextureBuffer;
    static final float[] VERTEX_COOR = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};

    public VideoRenderPosition(int id, Rect r, int mode) {
        this.channalId = id;
        this.position = r;
        this.fillMode = mode;
        this.mTargetVertexBuffer = ByteBuffer.allocateDirect(VERTEX_COOR.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mTargetVertexBuffer.put(VERTEX_COOR).position(0);
        this.mGLTextureBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.FULL_RECTANGLE_TEX_COORDS.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mGLTextureBuffer.put(TextureRotationUtil.TEXTURE_NO_ROTATION).position(0);
    }

    public FloatBuffer getPositionBuffer(boolean flip) {
        if (this.position == null) {
            YMFLog.info(this, "[Util    ]", "getPositionBuffer:: position is null.");
            return this.mTargetVertexBuffer;
        }
        float left = -1.0f + this.position.left * 2.0f;
        float right = -1.0f + this.position.right * 2.0f;
        float top = -1.0f + this.position.top * 2.0f;
        float bottom = -1.0f + this.position.bottom * 2.0f;
        if (flip) {
            top = 0.0f - top;
            bottom = 0.0f - bottom;
        }
        this.mTargetVertexBuffer.put(0, left);
        this.mTargetVertexBuffer.put(1, bottom);
        this.mTargetVertexBuffer.put(2, right);
        this.mTargetVertexBuffer.put(3, bottom);
        this.mTargetVertexBuffer.put(4, left);
        this.mTargetVertexBuffer.put(5, top);
        this.mTargetVertexBuffer.put(6, right);
        this.mTargetVertexBuffer.put(7, top);
        return this.mTargetVertexBuffer;
    }

    public FloatBuffer convertPositionBuffer(int dstWidth, int dstHeight, int srcWidth, int srcHeight) {
        float bottom;
        float top;
        float right;
        float left;
        float srcAr = 1.0f * (float)srcWidth / (float)srcHeight;
        float dstAr = 1.0f * (float)dstWidth / (float)dstHeight;
        if (srcAr <= dstAr) {
            left = -(srcAr / dstAr);
            right = srcAr / dstAr;
            top = 1.0f;
            bottom = -1.0f;
        } else {
            left = -1.0f;
            right = 1.0f;
            top = dstAr / srcAr;
            bottom = -(dstAr / srcAr);
        }
        this.mTargetVertexBuffer.put(0, left);
        this.mTargetVertexBuffer.put(1, bottom);
        this.mTargetVertexBuffer.put(2, right);
        this.mTargetVertexBuffer.put(3, bottom);
        this.mTargetVertexBuffer.put(4, left);
        this.mTargetVertexBuffer.put(5, top);
        this.mTargetVertexBuffer.put(6, right);
        this.mTargetVertexBuffer.put(7, top);
        return this.mTargetVertexBuffer;
    }

    public FloatBuffer convertTextureBuffer(int dw, int dh, int sw, int sh) {
        if (0 == this.srcWidth || 0 == this.srcHeight || 0 == this.dstWidth || 0 == this.dstHeight) {
            YMFLog.warn(this, "[Util    ]", "invalid size, return default texture coordinations");
            return this.mGLTextureBuffer;
        }
        float srcAr = 1.0f * (float)this.srcWidth / (float)this.srcHeight;
        float dstAr = 1.0f * (float)this.dstWidth / (float)this.dstHeight;
        float xoffset = 0.0f;
        float yoffset = 0.0f;
        if (this.srcWidth * this.dstHeight != this.srcHeight * this.dstWidth) {
            if (this.srcWidth == 720 && this.srcHeight == 1280) {
                if (srcAr < dstAr) {
                    yoffset = 0.5f * (1.0f - srcAr / dstAr);
                }
            } else if (this.srcWidth == 1280 && this.srcHeight == 720) {
                if (srcAr > dstAr) {
                    xoffset = 0.5f * (1.0f - dstAr / srcAr);
                }
            } else if (this.srcWidth == 480 && this.srcHeight == 640) {
                if (srcAr > dstAr) {
                    xoffset = 0.5f * (1.0f - dstAr);
                } else {
                    yoffset = 0.0f;
                }
            } else if (this.srcWidth == 640 && this.srcHeight == 480) {
                if (srcAr < dstAr) {
                    yoffset = 0.0f;
                } else {
                    xoffset = 0.21875f;
                }
            }
        }
        float left = xoffset;
        float right = 1.0f - xoffset;
        float bottom = yoffset;
        float top = 1.0f - yoffset;
        this.mGLTextureBuffer.put(0, left);
        this.mGLTextureBuffer.put(1, bottom);
        this.mGLTextureBuffer.put(2, right);
        this.mGLTextureBuffer.put(3, bottom);
        this.mGLTextureBuffer.put(4, left);
        this.mGLTextureBuffer.put(5, top);
        this.mGLTextureBuffer.put(6, right);
        this.mGLTextureBuffer.put(7, top);
        return this.mGLTextureBuffer;
    }

    public FloatBuffer getDefaultTextureBuffer() {
        this.mGLTextureBuffer.rewind();
        this.mGLTextureBuffer.put(TextureRotationUtil.TEXTURE_NO_ROTATION).position(0);
        return this.mGLTextureBuffer;
    }

    public FloatBuffer getDefaultVertexBuffer() {
        this.mTargetVertexBuffer.rewind();
        this.mTargetVertexBuffer.put(VERTEX_COOR).position(0);
        return this.mTargetVertexBuffer;
    }
}

