/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;

public class PublishVideoConfig
extends VideoEncoderConfig {
    public static final int PUBLISH_VIDEO_MODE_NORMAL = 0;
    public static final int PUBLISH_VIDEO_MODE_HIGHQULITY = 1;
    public static final int PUBLISH_VIDEO_MODE_SCREEN_RECORD_NORMAL = 2;
    public static final int PUBLISH_VIDEO_MODE_SCREEN_RECORD_HIGHQULITY = 3;
    public static final int PUBLISH_VIDEO_MODE_SCREEN_RECORD_ULTRA_HIGHQULITY = 4;

    public PublishVideoConfig(int mode) {
        if (mode == 0) {
            this.mEncodeType = VideoEncoderType.HARD_ENCODER_H264;
            this.mLowDelay = false;
            this.setEncodeSize(368, 640);
            this.mFrameRate = 24;
            this.mBitRate = 1200000;
            this.mEncodeParameter = "";
            this.videoStabilization = true;
        } else if (mode == 1) {
            this.mEncodeType = VideoEncoderType.HARD_ENCODER_H264;
            this.mLowDelay = false;
            this.setEncodeSize(544, 960);
            this.mFrameRate = 24;
            this.mBitRate = 1200000;
            this.mEncodeParameter = "";
            this.videoStabilization = true;
        } else if (mode == 2) {
            this.mEncodeType = VideoEncoderType.HARD_ENCODER_H264;
            this.mLowDelay = false;
            this.setEncodeSize(368, 640);
            this.mFrameRate = 30;
            this.mBitRate = 800000;
            this.mEncodeParameter = "";
            this.videoStabilization = true;
        } else if (mode == 3) {
            this.mEncodeType = VideoEncoderType.HARD_ENCODER_H264;
            this.mLowDelay = false;
            this.setEncodeSize(480, 864);
            this.mFrameRate = 30;
            this.mBitRate = 1200000;
            this.mEncodeParameter = "";
            this.videoStabilization = true;
        } else if (mode == 4) {
            this.mEncodeType = VideoEncoderType.HARD_ENCODER_H264;
            this.mLowDelay = false;
            this.setEncodeSize(720, 1280);
            this.mFrameRate = 30;
            this.mBitRate = 2000000;
            this.mEncodeParameter = "";
            this.videoStabilization = true;
        }
    }

    @Override
    public void assign(VideoEncoderConfig config) {
        this.setEncodeSize(config.getEncodeWidth(), config.getEncodeHeight());
        this.mFrameRate = config.mFrameRate;
        this.videoStabilization = config.videoStabilization;
        this.mEncodeType = config.mEncodeType;
        this.mBitRate = config.mBitRate;
        this.mEncodeParameter = config.mEncodeParameter;
        this.mLowDelay = config.mLowDelay;
    }

    @Override
    public void setEncodeSize(int width, int height) {
        this.mEncodeWidth = width;
        this.mEncodeHeight = height;
    }

    public PublishVideoConfig() {
        this(544, 960, 24, 1200000, VideoEncoderType.HARD_ENCODER_H264.ordinal(), "");
    }

    public PublishVideoConfig(int encodeWidth, int encodeHeight, int frameRate, int bitRate, int encoderType, String encodeParam) {
        VideoEncoderType type = null;
        if (encoderType == VideoEncoderType.HARD_ENCODER_H264.ordinal()) {
            type = VideoEncoderType.HARD_ENCODER_H264;
        } else if (encoderType == VideoEncoderType.SOFT_ENCODER_X264.ordinal()) {
            type = VideoEncoderType.SOFT_ENCODER_X264;
        } else if (encoderType == VideoEncoderType.SOFT_ENCODER_H265.ordinal()) {
            type = VideoEncoderType.SOFT_ENCODER_H265;
        }
        this.mEncodeType = VideoEncoderType.HARD_ENCODER_H264;
        this.mEncodeParameter = null;
        this.mLowDelay = false;
        this.setEncodeSize(encodeWidth, encodeHeight);
        this.mFrameRate = frameRate;
        this.mBitRate = bitRate;
        this.mEncodeType = type;
        this.mEncodeParameter = encodeParam;
        this.videoStabilization = true;
    }
}

