/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.hardware.Camera;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.utils.YMFLog;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CameraUtils2 {
    private static final String TAG = "CameraUtils2";
    private static final float RATIO_16_9 = 1.7777778f;
    private static final float RATIO_9_16 = 0.5625f;
    private static final float RATIO_4_3 = 1.3333334f;
    private static final float RATIO_3_4 = 0.75f;

    public static void chooseBestAspectPreviewSize(int displayOrientation, int width, int height, Camera.Parameters parameters, double threshold, CameraInterface.CameraResolutionMode mode) {
        YMFLog.info(null, "[CCapture]", "chooseBestAspectPreviewSize width:" + width + "  height:" + height);
        Camera.Size ppsfv = parameters.getPreferredPreviewSizeForVideo();
        if (ppsfv != null) {
            YMFLog.info(null, "[CCapture]", "Camera preferred preview size:" + ppsfv.width + "x" + ppsfv.height);
        }
        if (mode == CameraInterface.CameraResolutionMode.CAMERA_RESOLUTION_RANGE_MODE) {
            float ratio = (float)width * 1.0f / (float)height;
            if (width > height) {
                if (Math.abs(ratio - 1.7777778f) > Math.abs(ratio - 1.3333334f)) {
                    width = 640;
                    height = 480;
                } else {
                    width = 1280;
                    height = 720;
                }
            } else if (Math.abs(ratio - 0.5625f) > Math.abs(ratio - 0.75f)) {
                width = 480;
                height = 640;
            } else {
                width = 720;
                height = 1280;
            }
        }
        YMFLog.info(null, "[CCapture]", "chooseBestAspectPreviewSize secondly width:" + width + ", height:" + height + " , displayOrientation:" + displayOrientation);
        Camera.Size bestSize = CameraUtils2.getBestAspectPreviewSize(displayOrientation, width, height, parameters, threshold);
        if (bestSize != null) {
            YMFLog.info(null, "[CCapture]", "prefer preview size secondly size:" + width + "x" + height + ", choose " + bestSize.width + "x" + bestSize.height);
            parameters.setPreviewSize(bestSize.width, bestSize.height);
            return;
        }
        YMFLog.warn(null, "[CCapture]", "Unable to set preview size:" + width + "x" + height);
        if (ppsfv != null) {
            parameters.setPreviewSize(ppsfv.width, ppsfv.height);
        }
    }

    public static Camera.Size getBestAspectPreviewSize(int displayOrientation, int width, int height, Camera.Parameters parameters) {
        return CameraUtils2.getBestAspectPreviewSize(displayOrientation, width, height, parameters, 0.0);
    }

    public static Camera.Size getBestAspectPreviewSize(int displayOrientation, int width, int height, Camera.Parameters parameters, double threshold) {
        List sizes;
        double targetRatio = (double)height / (double)width;
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int optimalGap = Integer.MAX_VALUE;
        int gap = 0x7FFFFFFE;
        if ((displayOrientation == 90 || displayOrientation == 270) && width > height) {
            targetRatio = (double)width / (double)height;
        }
        if ((sizes = parameters.getSupportedPreviewSizes()) == null) {
            return null;
        }
        Collections.sort(sizes, Collections.reverseOrder(new SizeComparator()));
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            YMFLog.info(null, "[CCapture]", "getSupportedPreviewSizes:" + size.width + "x" + size.height + ", ratio:" + ratio);
            gap = displayOrientation == 90 || displayOrientation == 270 ? Math.abs(size.width - width) + Math.abs(size.height - height) : Math.abs(size.width - height) + Math.abs(size.height - width);
            if (Math.abs(ratio - targetRatio) < minDiff) {
                optimalSize = size;
                minDiff = Math.abs(ratio - targetRatio);
                optimalGap = gap;
            }
            if (!(Math.abs(Math.abs(ratio - targetRatio) - minDiff) <= threshold) || gap >= optimalGap) continue;
            optimalSize = size;
            minDiff = Math.abs(ratio - targetRatio);
            optimalGap = gap;
        }
        return optimalSize;
    }

    static class SizeComparator
    implements Comparator<Camera.Size> {
        SizeComparator() {
        }

        @Override
        public int compare(Camera.Size lhs, Camera.Size rhs) {
            int left = lhs.width * lhs.height;
            int right = rhs.width * rhs.height;
            if (left < right) {
                return -1;
            }
            if (left > right) {
                return 1;
            }
            return 0;
        }
    }
}

