#pragma once
#include "TransPacket.h"
#include "Header.h"

static const uint8_t CDNP2P_PROTO_VERSION = 1;
static const uint8_t CDNP2P_PACKET_HEAD_SIZE = 7;

namespace mediaCore{
	class Request;

	class Sender
		: public Header
	{
	public:
		Sender()
		: m_pb()
		, m_hpk(m_pb)
		, m_pk(m_pb, HEADER_SIZE)
		{

		}

		Sender(uint32_t u, const mediaSox::Marshallable &m)
		: m_pb()
		, m_hpk(m_pb)
		, m_pk(m_pb, HEADER_SIZE)
		{
			marshall(u, m);
		}

		Sender(const Sender &s)
		: m_pb()
		, m_hpk(m_pb)
		, m_pk(m_pb, HEADER_SIZE)
		{
			m_length = s.m_length;
			m_uri = s.m_uri;
			m_resCode = s.m_resCode;
			m_pk.push(s.m_pk.data(), s.m_pk.size());
		}

	public:
		static std::string protoToString(uint32_t uri, const mediaSox::Marshallable & req)
		{
			uint32_t len = 0;
			mediaSox::PackBuffer pb;
			mediaSox::Pack hpk(pb);
			mediaSox::Pack pk(pb, 10);

			req.marshal(pk);
			hpk.replace_uint32(4, uri);
			hpk.replace_uint16(8, 0xC8);

			len = HEADER_SIZE + (uint32_t)pk.size();
			hpk.replace_uint32(0, len);

			return std::string(hpk.data(), len);
		}

	//cdn私有协议转成string类型
	public:
		static std::string cdnP2PProtoToString(uint32_t uri, const mediaSox::Marshallable & req) 
		{
			int len = 0;
			mediaSox::PackBuffer pb;
			mediaSox::Pack hpk(pb);
			mediaSox::Pack pk(pb, CDNP2P_PACKET_HEAD_SIZE);
			req.marshal(pk);

			hpk.replace_uint16(0, uri);
			hpk.replace_uint8(6, CDNP2P_PROTO_VERSION);
			len = CDNP2P_PACKET_HEAD_SIZE + pk.size();
			hpk.replace_uint32(2, len);

			return std::string(hpk.data(), len);
		}

	public:
		static void unpack(const char* data, int len, mediaSox::Marshallable& req)
		{
			if (!data || len < 10)
				return;

			mediaSox::Unpack unpak(data+10, len-10);
			req.unmarshal(unpak);
		}

	public:
		void marshall(uint32_t u, const mediaSox::Marshallable &m)
		{
			setUri(u);
			m.marshal(m_pk);
		}

		void endPack()
		{
			m_hpk.replace_uint32(0, m_length);
			m_hpk.replace_uint32(4, m_uri);
			m_hpk.replace_uint16(8, m_resCode);
			m_hpk.replace_uint32(0, (uint32_t)(headerSize() + bodySize()));
		}

		void clear()
		{
			m_pb.resize(0 + HEADER_SIZE);
			m_pk.setPackError(false);
			m_hpk.setPackError(false);
			m_resCode = RES_SUCCESS;
		}

	public:
		bool isPackError() const
		{
			return m_pk.isPackError() || m_hpk.isPackError();
		}

		size_t bodySize()
		{
			return m_pk.size();
		}

		const char* header()
		{
			return m_hpk.data();
		}

		size_t headerSize()
		{
			return HEADER_SIZE;
		}

	protected:
		mediaSox::PackBuffer m_pb;
		mediaSox::Pack m_hpk;
		mediaSox::Pack m_pk;
	};
}

