#pragma once
#include "IntTypes.h"
#include "MediaDef.h"
#include "TransPacket.h"
#include <string>
#include <string.h>

enum NetState
{
	SYSNET_WIFI															= 0,
	SYSNET_MOBILE														= 1,
	SYSNET_DISCONNECT													= 2,
	SYSNET_2G															= 3,
	SYSNET_3G															= 4,
	SYSNET_4G															= 5,
	SYSNET_UNKNOWN														= 127
};

enum PacketType
{
	PT_UNKOWN															= 0,
	PT_RAW_AUDIO														= 1,
	PT_RAW_VIDEO														= 2,
	PT_DECODED_AUDIO													= 3,
	PT_DECODED_VIDEO													= 4,
};

enum ChannelProfile
{
	CHANNEL_PROFILE_LIVE				= 0, //直播 （音质高、交互模式无）（连麦时切换到音质中、交互模式强）
	CHANNEL_PROFILE_COMMUNICATION		= 1, //通信 （音质中、交互模式强）
	CHANNEL_PROFILE_GAME				= 3, //游戏 （音质低、交互模式强）
	CHANNEL_PROFILE_MULTIAUDIOROOM		= 4, //多人语音房间 （音质中、省流量、交互模式强）
};

//音频流量模式
enum AudioFlowMode
{
	AUDIO_FLOW_FULL						= 1, //全流量
	AUDIO_FLOW_MUTE_OPT					= 2, //静默优化
	AUDIO_FLOW_VAD						= 3, //vad
};

struct AVframe
{
	bool m_bAdditionalFrame;								// 是否是补帧
	bool m_bKeyFrame;										// 是否是关键帧（音频的时候标识是否是非静音帧）
	bool m_bFastAccess;										// 是否是快速包
	bool m_bDownlinkResent;									// 是否是下行重传包
	bool m_bDiscarded;										// 音频: 帧丢弃,视频:解码模块丢弃.
	uint8_t m_ssrc;											// 音频区间号
	int m_type;												// 包类型 enum PacketType
	int m_frameType;										// 帧类型 enum FrameType
	int m_netFrameType;
	int	m_netCodec;
	uint32_t m_pullOffset;									// 偏移量
	uint32_t m_durperbyte;									// 每个字节的duration
	uint32_t m_seq;											// 包序号
	uint32_t m_endSeq;										// 组成帧最后一个包的序号
	uint32_t m_idx;											// 帧序号
	uint32_t m_refIdx;										// 最近的一个关键帧的序号
	uint32_t m_capStamp;									// 采集时间戳 
	uint32_t m_recvStamp;									// 接收时间戳
	uint32_t m_duration;									// 时长
	uint32_t m_pendingStamp;								// 放入解码队列时间戳
	uint32_t m_prepareDecodeStamp;							// 推送给解码器时间戳
	uint32_t m_encodedStamp;
	uint32_t m_decodedStamp;								// 解码完毕时间戳
	uint32_t m_playStamp;									// 实际播放时间戳
	uint32_t m_prepareRenderStamp;							// 准备把帧转到renderQueue的时间
	uint32_t m_inRenderQueueStamp;							// 放入renderQueue的时间
	uint32_t m_outRenderQueueStamp;							// 出renderQueue时间
	uint32_t m_width;
	uint32_t m_height;
	uint32_t m_length;										// 媒体数据长度
	uint32_t m_decodedFrameId;								// 经过解码后重新排序的frameId
	uint32_t m_pts;
	uint32_t m_seiSegmPts;									// 由CDN sei中的真实的采集时间戳计算出来的pts
	uint32_t m_dts;
	uint32_t m_audioRenderDelta;							// 音频播放delta
	uint64_t m_streamId;
	void* m_data;											// 媒体数据

	AVframe()
	: m_bAdditionalFrame(false)
	, m_bKeyFrame(false)
	, m_bFastAccess(false)
	, m_bDownlinkResent(false)
	, m_bDiscarded(false)
	, m_ssrc(0)
	, m_type((int)PT_UNKOWN)
	, m_frameType((int)0xff)
	, m_netFrameType((int)0xff)
	, m_netCodec(-1000)
	, m_pullOffset(0)
	, m_durperbyte(0)
	, m_seq(0)
	, m_endSeq(0)
	, m_idx(0)
	, m_refIdx(0)
	, m_capStamp(0)
	, m_recvStamp(0)
	, m_duration(0)
	, m_pendingStamp(0)
	, m_prepareDecodeStamp(0)
	, m_encodedStamp(0)
	, m_decodedStamp(0)
	, m_playStamp(0)
	, m_prepareRenderStamp(0)
	, m_inRenderQueueStamp(0)
	, m_outRenderQueueStamp(0)
	, m_width(0)
	, m_height(0)
	, m_length(0)
	, m_decodedFrameId(0)
	, m_pts(0)
	, m_seiSegmPts(0)
	, m_dts(0)
	, m_audioRenderDelta(0)
	, m_streamId(0)
	, m_data(NULL)
	{
	}

	void resetBuf()
	{
		m_data = NULL;
		m_length = 0;
	}

	void reset()
	{
		m_bAdditionalFrame = false;
		m_bKeyFrame = false;
		m_bFastAccess = false;
		m_bDownlinkResent = false;
		m_bDiscarded = false;
		m_ssrc = 0;
		m_type = (int)PT_UNKOWN;
		m_frameType = 0xff;
		m_netCodec = -1000;
		m_pullOffset = 0;
		m_durperbyte = 0;
		m_seq = 0;
		m_endSeq = 0;
		m_idx = 0;
		m_refIdx = 0;
		m_capStamp = 0;
		m_recvStamp = 0;
		m_duration = 0;
		m_pendingStamp = 0;
		m_prepareDecodeStamp = 0;
		m_encodedStamp = 0;
		m_decodedStamp = 0;
		m_playStamp = 0;
		m_prepareRenderStamp = 0;
		m_inRenderQueueStamp = 0;
		m_outRenderQueueStamp = 0;
		m_width = 0;
		m_height = 0;
		m_decodedFrameId = 0;
		m_pts = 0;
		m_seiSegmPts = 0;
		m_dts = 0;
		m_audioRenderDelta = 0;
		m_streamId = 0;
		m_length = 0;
	}
};

//视频来源
enum VideoSource
{
	VIDEO_SOURCE_YY = 0,
	VIDEO_SOURCE_FLV = 1,
	VIDEO_SOURCE_RTMP = 2
};

//已编码的视频帧，抛给业务转算法
struct VideoEncodedFrame : public mediaSox::Marshallable
{
	uint32_t m_codeId;										// 编码类型 transDefine.h
	uint32_t m_frameType;									// 帧类型 enum VideoFrameType
	uint32_t m_source;										// 数据来源 enum VideoSource
	uint32_t m_frameId;										// 帧序号
	uint32_t m_recvStamp;									// 接收时刻
	uint32_t m_pushDecodeStamp;								// 推解码时刻
	uint32_t m_width;										// 视频宽
	uint32_t m_heigth;										// 视频高
	uint32_t m_dts;											// 编码时间戳/解码时间戳
	uint32_t m_pts;											// 采集时间戳/渲染时间戳
	uint64_t m_streamId;									// 流标识
	std::string m_spspps;									// sps/pps数据
	std::string m_video;									// 视频数据

	VideoEncodedFrame()
		: m_codeId(0)
		, m_frameType(0)
		, m_source(0)
		, m_frameId(0)
		, m_recvStamp(0)
		, m_pushDecodeStamp(0)
		, m_width(0)
		, m_heigth(0)
		, m_dts(0)
		, m_pts(0)
		, m_streamId(0)
		, m_spspps("")
		, m_video("")
	{

	}

	VideoEncodedFrame(VideoEncodedFrame& frame)
	{
		m_codeId = frame.m_codeId;
		m_frameType = frame.m_frameType;
		m_source = frame.m_source;
		m_recvStamp = frame.m_recvStamp;
		m_pushDecodeStamp = frame.m_pushDecodeStamp;
		m_width = frame.m_width;
		m_heigth = frame.m_heigth;
		m_dts = frame.m_dts;
		m_pts = frame.m_pts;
		m_streamId = frame.m_streamId;
		m_spspps.swap(frame.m_spspps);
		m_video.swap(frame.m_video);
	}

	VideoEncodedFrame& operator= (VideoEncodedFrame& frame)
	{
		m_codeId = frame.m_codeId;
		m_frameType = frame.m_frameType;
		m_source = frame.m_source;
		m_recvStamp = frame.m_recvStamp;
		m_pushDecodeStamp = frame.m_pushDecodeStamp;
		m_width = frame.m_width;
		m_heigth = frame.m_heigth;
		m_dts = frame.m_dts;
		m_pts = frame.m_pts;
		m_streamId = frame.m_streamId;
		m_spspps.swap(frame.m_spspps);
		m_video.swap(frame.m_video);
		return *this;
	}

	void reset()
	{
		m_codeId = 0;
		m_frameType = 0;
		m_source = 0;
		m_recvStamp = 0;
		m_pushDecodeStamp = 0;
		m_width = 0;
		m_heigth = 0;
		m_dts = 0;
		m_pts = 0;
		m_streamId = 0;
		m_spspps.clear();
		m_video.clear();
	}

	virtual void marshal(mediaSox::Pack& pak) const
	{
		pak << m_codeId << m_frameType << m_source << m_frameId
			<< m_recvStamp << m_pushDecodeStamp << m_width << m_heigth
			<< m_dts << m_pts << m_streamId;
		pak.push_varstr32(m_spspps.c_str(), m_spspps.size());
		pak.push_varstr32(m_video.c_str(), m_video.size());
	}

	virtual void unmarshal(const mediaSox::Unpack& unpak)
	{
		unpak >> m_codeId >> m_frameType >> m_source >> m_frameId
			>> m_recvStamp >> m_pushDecodeStamp >> m_width >> m_heigth
			>> m_dts >> m_pts >> m_streamId;
		m_spspps = unpak.pop_varstr32();
		m_video = unpak.pop_varstr32();
	}
};

#define MAX_FRAME_LIST (30)

struct AVframeList //about 3.5KB
{
	uint32_t m_size;
	AVframe m_frameArray[MAX_FRAME_LIST];

	AVframeList()
	: m_size(0)
	{
		memset((char*)&m_frameArray[0], 0, (MAX_FRAME_LIST*sizeof(AVframe)));
	}

	bool empty() const
	{
		return (m_size == 0);
	}

	uint32_t size() const
	{
		return m_size;
	}

	bool push_back(AVframe &avFrame)
	{
		if (m_size >= MAX_FRAME_LIST)
		{
			return false;
		}

		m_frameArray[m_size % MAX_FRAME_LIST] = avFrame;
		++ m_size;
		return true;
	}

};

struct AVMediaCodecParameter
{
	//for ffmpeg codec, ignore it for mediacodec of android or hardware codec of iOS.
	int32_t  m_codec_type;
	int32_t  m_codec_id;
	uint32_t m_codec_tag;
	
	/* Audio:
	 *	Andorid: mediacodec decoder: android: MediaFormat.set("csd-0",m_codecSpecDescription).
	 *	ffmpeg decoder: construct the AVCodecParameter codepar, memcpy(codepar.extradata, m_codecSpecDescription).
	 *
	 * Video:
	 *	AVFrame will contains the sps/pps/vps for decoder, so no need to use this.
	 */
	void    *m_codecSpecDescription;
	uint32_t m_codecSpecDescSize;

	int32_t m_bits_per_raw_sample;
	int32_t m_bits_per_coded_sample;
	int32_t m_profile;
	int32_t m_leve;
	int32_t m_format;

	int64_t   m_bit_rate;
	//video.
	uint32_t  m_width;
	uint32_t  m_height;
	uint32_t  m_frame_rate;
	uint32_t  m_gop_size;
	int32_t   m_video_delay;  //B frame number;

	//audio
	uint32_t  m_sample_rate;
	uint32_t  m_channels;
	uint64_t  m_channel_layout;
	int32_t   m_frame_size;
	int32_t   m_initial_padding;
	int32_t   m_tailing_padding;
	int32_t   m_seek_preroll;

	AVMediaCodecParameter()
	:m_codec_type(0),
	m_codec_id(0),
	m_codec_tag(0),
	m_codecSpecDescription(NULL),
	m_codecSpecDescSize(0),
	m_bit_rate(0),
	m_width(0),
	m_height(0),
	m_frame_rate(0),
	m_gop_size(0),
	m_sample_rate(0),
	m_channels(0),
	m_channel_layout(0),
	m_frame_size(0),
	m_initial_padding(0),
	m_tailing_padding(0)
	{
	}
};

struct AVMediaStream
{
	uint32_t  m_startTimeMs; //
	uint32_t  m_totalDurationMs; //
	uint32_t  m_streamIndex;
	uint32_t  m_YYNetCodec;  //@see TransDefine.h
	uint32_t  m_totalFrame; //number of frames in this stream if known or 0
	const char *m_comment;
	bool	m_isVideoStream;
	bool	m_isAudioStream;

	AVMediaCodecParameter m_codecParameter;

	AVMediaStream()
	: m_startTimeMs(0)
	, m_totalDurationMs(0)
	, m_streamIndex(0)
	, m_YYNetCodec(0)
	, m_totalFrame(0)
	, m_comment(NULL)
	, m_isVideoStream(false)
	, m_isAudioStream(false)
	{
	}
};

struct AVMediaStreamList
{
	uint32_t       m_streamCnt;
	AVMediaStream  m_AVMediaStream[24];
	
	AVMediaStreamList()
	: m_streamCnt(0)
	{
	}
};
	
struct FrameTraceAttribute
{
	uint32_t frameIndex;
	uint32_t frameType;
	uint32_t captureStamp;										// dts
	uint32_t recvStamp;
	uint32_t pendingStamp;
	uint32_t prepareDecodeStamp;
	uint32_t decodedStamp;
	uint32_t playStamp;											// 抖动缓冲算出的期望播放时间
	uint32_t prepareRenderStamp;								// 准备把帧转到renderQueue的时间
	uint32_t inRenderQueueStamp;								// 放入renderQueue的时间
	uint32_t outRenderQueueStamp;								// 出renderQueue时间
	uint32_t renderStamp;										// 实际渲染的时间
	uint32_t decodedFrameId;									// 经过解码后重新排序的frameId
	uint32_t pts;
	uint32_t seiSegmPts;
	uint32_t m_audioRenderDelta;								// 音频播放delta
	bool bFastAccess;
	bool bDiscard;												// ios退到后台的时候不解码,直接返回帧丢弃.

	FrameTraceAttribute()
	: frameIndex(0)
	, frameType(0)
	, captureStamp(0)
	, recvStamp(0)
	, pendingStamp(0)
	, prepareDecodeStamp(0)
	, decodedStamp(0)
	, playStamp(0)
	, prepareRenderStamp(0)
	, inRenderQueueStamp(0)
	, outRenderQueueStamp(0)
	, renderStamp(0)
	, decodedFrameId(0)
	, pts(0)
	, seiSegmPts(0)
	, m_audioRenderDelta(0)
	, bFastAccess(false)
	, bDiscard(false)
	{}

	FrameTraceAttribute(const AVframe& frame, uint32_t now)
	: frameIndex(frame.m_idx)
	, frameType(frame.m_frameType)
	, captureStamp(frame.m_capStamp)
	, recvStamp(frame.m_recvStamp)
	, pendingStamp(frame.m_pendingStamp)
	, prepareDecodeStamp(frame.m_prepareDecodeStamp)
	, decodedStamp(frame.m_decodedStamp)
	, playStamp(frame.m_playStamp)
	, prepareRenderStamp(now)
	, inRenderQueueStamp(now)
	, outRenderQueueStamp(frame.m_outRenderQueueStamp)
	, renderStamp(now)
	, decodedFrameId(frame.m_decodedFrameId)
	, pts(frame.m_pts)
	, seiSegmPts(frame.m_seiSegmPts)
	, m_audioRenderDelta(frame.m_audioRenderDelta)
	, bFastAccess(frame.m_bFastAccess)
	, bDiscard(frame.m_bDiscarded)
	{
	}

	void reset()
	{
		frameIndex = 0;
		frameType = 0;
		captureStamp = 0;
		recvStamp = 0;
		pendingStamp = 0;
		prepareDecodeStamp = 0;
		decodedStamp = 0;
		playStamp = 0;
		prepareRenderStamp = 0;
		inRenderQueueStamp = 0;
		outRenderQueueStamp = 0;
		renderStamp = 0;
		decodedFrameId = 0;
		pts = 0;
		seiSegmPts = 0;
		m_audioRenderDelta = 0;
		bFastAccess = false;
		bDiscard = false;
	}
};

struct VideoRenderStausInfo
{
	uint64_t m_groupId;
	uint64_t m_streamId;
	FrameTraceAttribute fat;

	VideoRenderStausInfo()
	: m_groupId(0)
	, m_streamId(0)
	{
		fat.reset();
	}
};

struct PicAddToRenderInfo
{
	uint64_t m_groupId;
	uint64_t m_streamId;
	uint32_t m_discardCnt;

	PicAddToRenderInfo()
	: m_groupId(0)
	, m_streamId(0)
	, m_discardCnt(0)
	{
	}
};

struct TransModInitData
{
	bool bYCMediaBranch;
	uint16_t signalPort;

	TransModInitData()
	: bYCMediaBranch(false)
	, signalPort(0)
	{

	}
};

struct AccountInitData
{
	int iFrameTransMode;
	int *iAppids;
	char *iToken;
	uint32_t iUid;
	uint32_t iTopSid;
	uint32_t iSubSid;
	uint32_t iCookieLen;
	void *iCookie;
	uint32_t iWanIp;
	uint32_t iWanIsp;
	uint32_t iAudioInputQuality;
	uint32_t iFrameNumOfLow;
	uint32_t iFrameNumOfHigh;
	uint32_t iLoginModle;
	uint32_t m_startTime;
	uint32_t m_netState;
	uint64_t m_imsi;
	uint32_t iTokenSize;
	uint32_t iAppIdSize;
	uint32_t sdkVersion;
	uint32_t osVersion;
	uint32_t osSubVersion;
	std::string manufacturer;
	std::string model;
	std::string deviceID;
	std::string phoneOsVersion;
	std::string appInfo;
	bool isIOS10OrHigher;

	AccountInitData()
	: iFrameTransMode(0)
	, iAppids(NULL)
	, iToken(NULL)
	, iUid(0)
	, iTopSid(0)
	, iSubSid(0)
	, iCookieLen(0)
	, iCookie(NULL)
	, iWanIp(0)
	, iWanIsp(0)
	, iAudioInputQuality(0)
	, iFrameNumOfLow(0)
	, iFrameNumOfHigh(0)
	, iLoginModle(0)
	, m_startTime(0)
	, m_netState(SYSNET_UNKNOWN)
	, m_imsi(0)
	, iTokenSize(0)
	, iAppIdSize(0)
	, sdkVersion(0)
	, osVersion(0)
	, osSubVersion(0)
	, isIOS10OrHigher(false)
	{
	}
};

struct ChatItem
{
	ChatItem()
	: uid(0)
	, sid(0)
	, color(0)
	, height(0)
	{

	}

	uint32_t uid;
	uint32_t sid;
	uint32_t color;
	uint32_t height;
	std::string text;
};

typedef enum
{
	MicAnchor = 0,
	MicAttendant = 1,
} MicPos;

typedef enum
{
	PublishModeDefault = 0,
	PublishModePCOnly = 1,
	PublishModeWebAndMobile = 2,
	PublishModeAll = 3,
} PublishMode;

struct VideoUploadConfig
{
	uint32_t m_publishMode;
	uint32_t m_bitRate;

	VideoUploadConfig()
	: m_publishMode(0)
	, m_bitRate(0)
	{
	}
};

struct SessionTextInfo
{
	uint32_t iColor;
	uint32_t iHeight;
	uint32_t iUid;
	uint32_t iSid;
	std::string  chatText;

	SessionTextInfo()
	: iColor(0)
	, iHeight(0)
	, iUid(0)
	, iSid(0)
	{
	}
};


struct VideoDecodeStatInfo
{
	int width;
	int height;
	int framerate;
	int bitrateInKbps;

	VideoDecodeStatInfo()
	: width(0)
	, height(0)
	, framerate(0)
	, bitrateInKbps(0)
	{
	}
};

struct VideoRenderNotify
{
	uint64_t groupId;
	uint64_t streamId;
	uint64_t pts;
	uint64_t renderStamp;
	uint32_t decodedStamp;
	bool bDiscard;

	VideoRenderNotify()
	: groupId(0)
	, streamId(0)
	, pts(0)
	, renderStamp(0)
	, decodedStamp(0)
	, bDiscard(false)
	{
	}
};

struct ChannelUserInfos
{
	std::string channelId;
	bool owner;
	bool uniq;
	uint32_t micNo;
	uint32_t layoutx;
	uint32_t layouty;
	uint32_t layoutw;
	uint32_t layouth;
	uint32_t globalw;
	uint32_t globalh;
	uint32_t quality;
	uint64_t version;

	ChannelUserInfos()
	: owner(false)
	, uniq(false)
	, micNo(0)
	, layoutx(0)
	, layouty(0)
	, layoutw(0)
	, layouth(0)
	, globalw(0)
	, globalh(0)
	, quality(0)
	, version(0)
	{
	}
	
	void reset()
	{
		channelId.clear();
		owner = false;
		uniq = false;
		micNo = 0;
		layoutx = 0;
		layouty = 0;
		layoutw = 0;
		layouth = 0;
		globalw = 0;
		globalh = 0;
		quality = 0;
		version = 0;
	}
};

struct Layout
	: public mediaSox::Marshallable
{
	uint32_t x;
	uint32_t y;
	uint32_t w;
	uint32_t h;

	Layout()
	: x(0)
	, y(0)
	, w(0)
	, h(0)
	{

	}

	virtual void marshal(mediaSox::Pack &pk) const
	{
		pk << x << y << w << h;
	}

	virtual void unmarshal(const mediaSox::Unpack &up)
	{
		up >> x >> y >> w >> h;
	}
};
