#pragma once
#include "EventBase.h"
#include "MediaObj.h"
#include <list>
#include <set>
#include <map>
#include <vector>


class QYYSdkCallTransGetRunData
	: public IMediaEvent
{
public:
	QYYSdkCallTransGetRunData()
	: configKey(0)
	, defaultVal(0)
	, configVal(0)
	{
		m_type = MET_CALL_GET_RUN_DATA;
	}

	uint32_t configKey;
	uint32_t defaultVal;
	uint32_t configVal;
};

class QYYSdkCallOnMediaStatus
	: public IMediaEvent
{
public:
	QYYSdkCallOnMediaStatus()
	: isAudio(false)
	, isStartUpload(false)
	{
		m_type = MET_CALL_ON_MEDIA_STATUS;
	}

	bool isAudio;
	bool isStartUpload;
};

class QYYSdkCallTransSwitchMute
	: public IMediaEvent
{
public:
	QYYSdkCallTransSwitchMute()
	: type(APP_CTRL)
	, isMute(false)
	{
		m_type = MET_CALL_SWITCH_MUTE;
	}

	int type;
	bool isMute;

	enum {
		APP_CTRL,
		DEV_INTR //audio device interrupt
	};
};

class QYYSdkCallTransSwitchMuteByUid
	: public IMediaEvent
{
public:
	QYYSdkCallTransSwitchMuteByUid()
	: uid(0)
	, isMute(false)
	{
		m_type = MET_CALL_SWITCH_MUTE_BY_UID;
	}

	uint32_t uid;
	bool isMute;
};

class QYYSdkCallTransSwitchMuteByStrUid
	: public IMediaEvent
{
public:
	QYYSdkCallTransSwitchMuteByStrUid()
	: isMute(false)
	{
		m_type = MET_CALL_SWITCH_MUTE_BY_STR_UID;
	}

	bool isMute;
	std::string uid;
};


//send vad info
class QYYSdkCallTransEnableVad : public IMediaEvent
{
public:
	QYYSdkCallTransEnableVad()
	: bEnableVad(false)
	{
		m_type = MET_CALL_ENABLE_VAD;
	}

	bool bEnableVad;
};

class QYYSdkCallTransPullOneAudioFrame
	: public IMediaEvent
{
public:
	QYYSdkCallTransPullOneAudioFrame()
	: isCriticalPull(false)
	, uSpeakerUid(0)
	, uPlayDelay(0)
	, bAccelerate(false)
	, accelerateMs(0.0)
	, pRawFrame(NULL)
	{
		m_type = MET_CALL_PULL_ONE_AUDIO_FRAME;
	}

	bool isCriticalPull;
	uint32_t uSpeakerUid;
	uint32_t uPlayDelay;
	bool bAccelerate;
	double accelerateMs;
	AVframe* pRawFrame;
};

class QYYSdkCallTransGetPlayUids
	: public IMediaEvent
{
public:
	QYYSdkCallTransGetPlayUids()
	{
		m_type = MET_CALL_GET_PLAY_UIDS;
	}

	std::list<uint32_t> uids;
};

class QYYSdkCallTransSetDecodeDelay
	: public IMediaEvent
{
public:
	QYYSdkCallTransSetDecodeDelay()
	: type(VIDEO)
	, delay(0)
	, orgAppId(0)
	, userGroupId(0)
	, streamId(0)
	{
		m_type = MET_CALL_SET_DECODE_DELAY;
	}

	int type;
	uint32_t delay;
	uint32_t orgAppId;
	uint64_t userGroupId;
	uint64_t streamId;

	enum
	{
		AUDIO,
		VIDEO
	};
};

class QYYSdkCallTransCalcVolume
	: public IMediaEvent
{
public:
	QYYSdkCallTransCalcVolume()
	: data(NULL)
	, len(0)
	, volume(0)
	{
		m_type = MET_CALL_CALC_VOLUME;
	}

	short *data;
	uint32_t len;
	uint32_t volume;
};

class QYYSdkCallTransUploadAudioData
: public IMediaEvent
{
public:
	QYYSdkCallTransUploadAudioData()
	: m_frameData(NULL)
	, m_rawcodecid(0)
	, m_issrc(0)
	, m_frameLength(0)
	, m_encodeTimestamp(0)
	, m_captureTimestamp(0)
	, m_audioActive(false)
	, m_codecBitRate(0)
	{
		m_type = MET_CALL_UPLOAD_AUDIO_DATA;
	}

	void* m_frameData;
	int m_rawcodecid;
	int m_issrc;
	uint32_t m_frameLength;
	uint32_t m_encodeTimestamp;
	uint32_t m_captureTimestamp;
	bool m_audioActive;
	uint32_t m_codecBitRate;
};

class QYYSdkCallTransUpdateEncoderInfo
	: public IMediaEvent
{
public:
	QYYSdkCallTransUpdateEncoderInfo()
	: appId(0)
	, bitRate(0)
	, frameRate(0)
	, width(0)
	, height(0)
	{
		m_type = MET_CALL_UPDATE_ENCODER_INFO;
	}

	uint32_t appId;
	uint32_t bitRate;
	uint32_t frameRate;
	uint32_t width;
	uint32_t height;
};

class QYYSdkCallTransUploadVideoData
: public IMediaEvent
{
public:
	QYYSdkCallTransUploadVideoData()
	: appid(0)
	, m_ts(0)
	, m_dts(0)
	, m_framelength(0)
	, m_frametype(0)
	, m_framedata(NULL)
	{
		m_type = MET_CALL_UPLOAD_VIDEO_DATA;
	}
	
	uint32_t appid;
	uint32_t m_ts;
	uint32_t m_dts;
	uint32_t m_framelength;
	int m_frametype;
	void *m_framedata;
};

class QYYSdkCallTransNotifyVideoPlayEvent
: public IMediaEvent
{
public:
	QYYSdkCallTransNotifyVideoPlayEvent()
	: eventtype(0)
	, happentime(0)
	, groupid(0)
	, streamid(0)
	{
		m_type = MET_CALL_NOTIFY_VIDEO_PLAY_EVENT;
	}
	
	uint32_t eventtype;
	uint32_t happentime;
	uint64_t groupid;
	uint64_t streamid;
};

class QYYSdkCallTransSetExtraMetaData
: public IMediaEvent
{
public:
	QYYSdkCallTransSetExtraMetaData()
	{
		m_type = MET_CALL_SET_EXTRA_META_DATA;
	}
	
	std::map<uint8_t, uint32_t> metaDatas;
};

class QYYSdkCallTransSetExtraAnchorBroadcastData
: public IMediaEvent
{
public:
	QYYSdkCallTransSetExtraAnchorBroadcastData()
	{
		m_type = MET_CALL_SET_EXTRA_ANCHOR_BROADCAST_DATA;
	}
	
	std::map<uint32_t, uint32_t> intDatas;
	std::map<uint32_t, std::string> stringDatas;
};

class QYYSdkCallTransVideoCaptureInfo
: public IMediaEvent
{
public:
	QYYSdkCallTransVideoCaptureInfo()
	: appid(0)
	, capturestamp(0)
	, width(0)
	, heigth(0)
	, frontcamera(false)
	{
		m_type = MET_CALL_VIDEO_CAPTURE_INFO;
	}
	
	uint32_t appid;
	uint32_t capturestamp;
	uint32_t width;
	uint32_t heigth;
	bool frontcamera;
};

class QYYSdkCallTransNofiyMediaAutoLowlateSwitch
: public IMediaEvent
{
public:
	QYYSdkCallTransNofiyMediaAutoLowlateSwitch()
	: autolowlate(false)
	{
		m_type = MET_CALL_NOTIFY_MEDIA_AUTO_LOWLATE_SWITCH;
	}
	
	bool autolowlate;
};

class QYYSdkCallTransSetFlvParam
: public IMediaEvent
{
public:
	QYYSdkCallTransSetFlvParam()
	: appid(0)
	, uid(0)
	, publishid(0)
	, flvid(0)
	, proxytype(0)
	, coderate(0)
	{
		m_type = MET_CALL_SET_FLV_PARAM;
	}
	
	uint32_t appid;
	uint32_t uid;
	uint32_t publishid;
	uint32_t flvid;
	uint32_t proxytype;
	uint32_t coderate;
	std::string url;
};

class QYYSdkCallTransUpdateWifiInfo
: public IMediaEvent
{
public:
	QYYSdkCallTransUpdateWifiInfo()
	: rssi(0)
	{
		m_type = MET_CALL_UPDATE_WIFI_INFO;
	}
	
	int rssi;
};

class QYYSdkCallTransServiceLinkConnected
: public IMediaEvent
{
public:
	QYYSdkCallTransServiceLinkConnected()
	{
		m_type = MET_CALL_SERVICE_LINK_CONNECTED;
	}
};

class QYYSdkCallTrnsServiceTypeChange
: public IMediaEvent
{
public:
	QYYSdkCallTrnsServiceTypeChange()
	{
		m_type = MET_CALL_SERVICE_TYPE_CHANGE;
	}
};

class QYYSdkCallTransSetAppConfig
: public IMediaEvent
{
public:
	QYYSdkCallTransSetAppConfig()
	: key(0)
	, val(0)
	{
		m_type = MET_CALL_SET_APP_CONFIG;
	}
	
	uint32_t key;
	uint32_t val;
};

class QYYSdkCallTransProtoLinkConnected
: public IMediaEvent
{
public:
	QYYSdkCallTransProtoLinkConnected()
	: bneedrefetch(false)
	{
		m_type = MET_CALL_PROTO_LINK_CONNECTED;
	}
	
	bool bneedrefetch;
};

class QYYSdkCallTransNetworkStateChange
: public IMediaEvent
{
public:
	QYYSdkCallTransNetworkStateChange()
	: netstate(0)
	{
		m_type = MET_CALL_NETWORK_STATE_CHANGE;
	}
	
	uint32_t netstate;
};

class QYYSdkCallTransAppBackground
: public IMediaEvent
{
public:
	QYYSdkCallTransAppBackground()
	: background(false)
	{
		m_type = MET_CALL_APP_BACKGROUND;
	}
	
	bool background;
};

class QYYSdkCallTransSignalProtocol
: public IMediaEvent
{
public:
	QYYSdkCallTransSignalProtocol()
	: uri(0)
	{
		m_type = MET_CALL_SIGNAL_PROTOCOL;
	}
	
	uint32_t uri;
	std::string data;
};

class QYYSdkCallTransSubsidChange
: public IMediaEvent
{
public:
	QYYSdkCallTransSubsidChange()
	: subsid(0)
	{
		m_type = MET_CALL_SUBSID_CHANGE;
	}
	
	uint32_t subsid;
};

class QYYSdkCallTransNofiyChannelJoinStatus
: public IMediaEvent
{
public:
	QYYSdkCallTransNofiyChannelJoinStatus()
	: joined(false)
	{
		m_type = MET_CALL_NOTIFY_CHANNEL_JOIN_STATUS;
	}
	
	bool joined;
};

class QYYSdkCallTransSetChannelMetaData
: public IMediaEvent
{
public:
	QYYSdkCallTransSetChannelMetaData()
	: appid(0)
	, sid(0)
	, subSid(0)
	, bForward(false)
	{
		m_type = MET_CALL_SET_CHANNEL_META_DATA;
	}
	
	uint32_t appid;
	uint32_t sid;
	uint32_t subSid;
	bool bForward;
	std::map<uint32_t, std::map<uint8_t, uint32_t> > metaDatas;
};

class QYYSdkCallTransNotifyRtmpStream
: public IMediaEvent
{
public:
	QYYSdkCallTransNotifyRtmpStream()
	: appid(0)
	, start(false)
	{
		m_type = MET_CALL_NOTIFY_RTMP_STREAM;
	}
	
	uint32_t appid;
	bool start;
	std::map<std::string, std::string> cdn;
};

class QYYSdkCallTransRtmpExtraParam
	: public IMediaEvent
{
public:
	QYYSdkCallTransRtmpExtraParam()
		: appid(0)
	{
		m_type = MET_CALL_RTMP_EXTRA_PARAM;
	}

	uint32_t appid;
	std::map<std::string, std::string> param;
};

class QYYSdkCallTransNotifyVideoRenderEvent
: public IMediaEvent
{
public:
	QYYSdkCallTransNotifyVideoRenderEvent()
	{
		m_type = MET_CALL_NOTIFY_VIDEO_RENDER_EVENT;
	}
	
	std::vector<VideoRenderNotify> notifys;
};

class QYYSdkCallTransSwitchCdnMode
 : public IMediaEvent
{
public:
	QYYSdkCallTransSwitchCdnMode()
	: appId(0)
	, targetMode(0)
	, cdnNum(0)
	{
		m_type = MET_CALL_SWITCH_CDN_MODE;
	}

	uint32_t appId;
	uint32_t targetMode;
	uint8_t cdnNum;
};

class QYYSdkCallTransReqAudioDiagnose
: public IMediaEvent
{
public:
	QYYSdkCallTransReqAudioDiagnose()
	: uReqAudioDiagnose(0)
	{
		m_type = MET_CALLBACK_AUDIO_DIAGNOSE;
	}

	explicit QYYSdkCallTransReqAudioDiagnose(const uint32_t uReqest)
	: uReqAudioDiagnose(uReqest)
	{
		m_type = MET_CALLBACK_AUDIO_DIAGNOSE;
	}

	uint32_t uReqAudioDiagnose;
};

class QYYSdkCallTransNotifyApStatus
 : public IMediaEvent
{
public:
	QYYSdkCallTransNotifyApStatus()
	: apIp(0)
	, apRtt(0)
	, apLastStatus(0)
	, noRes(false)
	, joinSuccess(false)
	{
		m_type = MET_CALL_NOTIFY_AP_STATUS;
	}
	
	uint32_t apIp;
	uint32_t apRtt;
	uint32_t apLastStatus;
	bool noRes;
	bool joinSuccess;
};

class QYYSdkCallTransOpenMic
	: public IMediaEvent
{
public:
	QYYSdkCallTransOpenMic()
	{
		m_type = MET_CALL_OPENMIC;
	}
};

class QYYSdkCallTransSetPublishRtmpParam
: public IMediaEvent
{
public:
	QYYSdkCallTransSetPublishRtmpParam()
	: m_bOpen(false)
	, m_rtmpUrl("")
	, m_playPath("")
	{
		m_type = MET_CALL_SET_PUBLISH_RTMP_PARAM;
	}

	bool m_bOpen;
	std::string m_rtmpUrl;
	std::string m_playPath;
};

class QYYSdkCallTransSidForward
	: public IMediaEvent
{//ü򵥵Ƶת(ĿƵ뵱ǰ½ƵʹͬĿ)
public:
	QYYSdkCallTransSidForward()
	: bStart(true)
	, appId(0)
	, sid(0)
	, subSid(0)
	, modelType(0)
	{
		m_type = MET_CALL_SID_FORWARD;
	}

	bool bStart;
	uint32_t appId;
	uint32_t sid;
	uint32_t subSid;
	uint32_t modelType;
};

class QYYSdkCallTransGetInitialBitRate
	: public IMediaEvent
{
public:
	QYYSdkCallTransGetInitialBitRate()
	: definitionLevel(0)
	, maxBitRate(0)
	, initialBitRate(0)
	{
		m_type = MET_CALL_GET_INITIAL_BITRATE;
	}

	uint32_t definitionLevel;
	uint32_t maxBitRate;
	uint32_t initialBitRate;
};

class QYYSdkCallTransInitUserInfo
	: public IMediaEvent
{
public:
	QYYSdkCallTransInitUserInfo()
	{
		m_type = MET_CALL_INIT_USER_INFO;
	}

	AccountInitData accountData;
};

class QYYSdkCallSetMixStreamConfig
	: public IMediaEvent
{
public:
	QYYSdkCallSetMixStreamConfig()
	: width(0)
	, height(0)
	, bitrate(0)
	, fps(0)
	, param("")
	{
		m_type = MET_CALL_SET_MIX_STREAM_CONFIG;
	}

	uint32_t width;
	uint32_t height;
	uint32_t bitrate;
	uint32_t fps;
	std::map<uint32_t, Layout> streamlayout;
	std::string param;
};

//------------------VOD--------------------//
class QPlayerCallTransSetCacheTime
	: public IMediaEvent
{
public:
	QPlayerCallTransSetCacheTime()
	: url("")
	, minCacheMs(0)
	, maxCacheMs(0)
	{
		m_type = MET_CALL_PLAYER_SET_CACHE_TIME;
	}

	std::string url;
	uint32_t minCacheMs;
	uint32_t maxCacheMs;
};

class QPlayerCallTransMuteLiveAudio
	: public IMediaEvent
{
public:
	QPlayerCallTransMuteLiveAudio()
	: mute(false)
	{
		m_type = MET_CALL_PLAYER_MUTE_LIVE_AUDIO;
	}

	bool mute;
};

class QPlayerCallTransPlay
	: public IMediaEvent
{
public:
	QPlayerCallTransPlay()
	: url("")
	{
		m_type = MET_CALL_PLAYER_PLAY;
	}

	std::string url;
};

class QPlayerCallTransPause
	: public IMediaEvent
{
public:
	QPlayerCallTransPause()
	: url("")
	, bPause(false)
	{
		m_type = MET_CALL_PLAYER_PAUSE;
	}

	std::string url;
	bool bPause;
};

class QPlayerCallTransStop
	: public IMediaEvent
{
public:
	QPlayerCallTransStop()
	: url("")
	{
		m_type = MET_CALL_PLAYER_STOP;
	}

	std::string url;
};

class QPlayerCallTransSeek
	: public IMediaEvent
{
public:
	QPlayerCallTransSeek()
	: url("")
	, position(0)
	{
		m_type = MET_CALL_PLAYER_SEEK;
	}

	std::string url;
	uint32_t position;	//ms
};

class QPlayerCallTransReadData
	: public IMediaEvent
{
public:
	QPlayerCallTransReadData()
	: url("")
	, offset(0)
	, len(0)
	, slave(false)
	{
		m_type = MET_CALL_PLAYER_READ_DATA;
	}

	std::string url;
	uint32_t offset;
	int32_t  len;
	bool slave;
};

class QPlayerCallTransReportErr
	: public IMediaEvent
{
public:
	QPlayerCallTransReportErr()
	: errCode(0)
	{
		m_type = MET_CALL_PLAYER_REPORT_ERRCODE;
	}

	enum
	{
		TR_ERR_DNSRESOLVE				= 0,		// ???????? QTransCallPlayerError::ERR_DNSRESOLVE
		TR_ERR_CONNECT					= 1,		// ???????? QTransCallPlayerError::ERR_CONNECT
		TR_ERR_CONNECT_TIMEOUT			= 2,		// ???????? QTransCallPlayerError::ERR_CONNECT_TIMEOUT
		TR_ERR_RESPONSE_TIMEOUT			= 3,		// ???????? QTransCallPlayerError::ERR_RESPONSE_TIMEOUT
		TR_ERR_HTTP_ERROR				= 4,		// ???????? QTransCallPlayerError::ERR_HTTP_ERROR
		TR_ERR_PROBE					= 5,		// ???????? QTransCallPlayerError::ERR_PROBE
		TR_ERR_READ_HEADER				= 6,		// ???????? QTransCallPlayerError::ERR_READ_HEADER
		TR_ERR_READ_FRAME				= 7,		// ???????? QTransCallPlayerError::ERR_READ_FRAME
		TR_ERR_SEEK						= 8,		// ???????? QTransCallPlayerError::ERR_SEEK

		// ??????????
		TR_ERR_CREATE_DEC_FAILED		= 50,	// ??????????????????????????
		TR_ERR_DECODE_FAILED			= 51,	// ??????????a???

		// ??????????
		TR_ERR_HTTP_SUCC				= 200,	// ??????????????????????????
		TR_ERR_HTTP_NO_CONTENT			= 204,	// No Content ????????????
		TR_ERR_HTTP_USE_PROXY			= 305,	// ??????????2??a
		TR_ERR_HTTP_TMP_REDIRECT		= 307,	// ????????????
		TR_ERR_HTTP_BAD_REQUEST			= 400,	// ??a??????????
		TR_ERR_HTTP_UNAUTHORIZED		= 401,	// ???????????
		TR_ERR_HTTP_FORBIDDEN			= 403,	// ?????????????
		TR_ERR_HTTP_NOT_FOUND			= 404,	// Not Found
		TR_ERR_HTTP_METHOD_NOT_ALLOWED	= 405,	// ??????????????????a
		TR_ERR_HTTP_NOT_ACCEPTED		= 406,	// ??????????????
		TR_ERR_HTTP_PROXY_AUTH_REQ		= 407,	// ?????????2??a??a?????|???
		TR_ERR_HTTP_REQ_TIMEOUT			= 408,	// ??????????????
		TR_ERR_HTTP_SERVER_ERROR		= 500,	// ?????????????????????a???
		TR_ERR_HTTP_BAD_GATEWAY			= 502,	// ??????????a???
		TR_ERR_HTTP_SERV_UNAVILABLE		= 503,	// ???????????????????
		TR_ERR_HTTP_GATEWAY_TIME_OUT	= 504,	// ???????????????
		TR_ERR_HTTP_VERSION_NOT_SUPP	= 505,	//  HTTP ??????????????????????

		TR_ERR_SUCC						= 10000,
	};

	uint32_t errCode;
};

class QPlayerCallTransSendStat
	: public IMediaEvent
{
public:
	QPlayerCallTransSendStat()
	: url("")
	, type(-1)
	{
		m_type = MET_CALL_PLAYER_SEND_STAT;
	}

	std::string url;
	int32_t type;
};

//-----------------------------new live sys api--begin-----------------------------//

class QYYSdkCallTransLiveSetAppInfo : public IMediaEvent
{
public:
	QYYSdkCallTransLiveSetAppInfo()
	: appId(0)
	, sceneId(0)
	{
		m_type = MET_CALL_LIVE_SET_APPINFO;
	}
	
	uint32_t appId;			//sdkͳһ,ͬһappIdµstreamNamesҪ֤Ψһ
	uint32_t sceneId;		//ҵµϸ֣ҵԶ壬ϵͳͳ
};

struct QTransLiveStreamInfo
{
public:
	QTransLiveStreamInfo()
	{

	}

	bool operator < (const QTransLiveStreamInfo& info) const
	{
		return streamName < info.streamName;
	}

	std::string streamName;
	std::map<uint32_t, uint32_t> configs;	//key:  LiveStreamCfgKey::LiveStreamCfgKey
};

class QTransLiveGroupInfo
{
public:
	QTransLiveGroupInfo()
	{

	}

	bool operator < (const QTransLiveGroupInfo& info) const
	{
		return groupName < info.groupName;
	}

	std::string groupName;
	std::map<uint32_t, uint32_t> configs;	//key:  LiveStreamCfgKey::LiveStreamCfgKey
};

//ϵͳΪϵͳ͹ϵͳ
//ýϵͳҪĵϢ
class QYYSdkCallTransLiveSetSubscribeInfo : public IMediaEvent
{
public:
	QYYSdkCallTransLiveSetSubscribeInfo()
	{
		m_type = MET_CALL_LIVE_SET_SUBSCRIBE_INFO;
	}

	std::map<uint32_t, std::set<QTransLiveStreamInfo> > appIdToStreamsAnchor;		//Ҫĵ, key:ĵappid
	std::map<uint32_t, std::set<QTransLiveGroupInfo> > appIdToLoginGroupsAnchor;	//Ҫ, key:ĵȺappid, ΪʱʾȺ飬ȺԶȺ
	std::map<uint32_t, std::set<QTransLiveStreamInfo> > appIdToStreamsAudience;		//Ҫĵ, key:ĵappid
	std::map<uint32_t, std::set<QTransLiveGroupInfo> > appIdToLoginGroupsAudience;	//Ҫ, key:ĵȺappid, ΪʱʾȺ飬ȺԶȺ
};

////ýϵͳҪĵϢ
//class QYYSdkCallTransLiveSetSubscribeAsAudience : public IMediaEvent
//{
//public:
//	QYYSdkCallTransLiveSetSubscribeAsAudience()
//	{
//		m_type = MET_CALL_LIVE_SET_SUBSCRIBE_AS_AUDIENCE;
//	}
//
//	std::map<uint32_t, std::set<QTransLiveStreamInfo> > appIdToStreams;	//Ҫĵ, key:ĵappid
//	std::map<uint32_t, std::set<QTransLiveGroupInfo> > appIdToLoginGroups;	//Ҫ, key:ĵȺappid, ΪʱʾȺ飬ȺԶȺƵ㲥
//};

class QYYSdkCallTransLiveSwitchAnchorSys : public IMediaEvent
{
public:
	QYYSdkCallTransLiveSwitchAnchorSys()
		:isAnchorSys(false)
	{
		m_type = MET_CALL_LIVE_SWITCH_ANCHOR_SYS;
	}
	bool isAnchorSys;	//true:ϵͳfalse:ϵͳ
};

class QYYSdkCallTransLiveStartVideoPublish : public IMediaEvent
{
public:
	QYYSdkCallTransLiveStartVideoPublish()
		: appId(0)
		, isPublishAsStreamName(true)
	{
		m_type = MET_CALL_LIVE_START_VIDEO_PUBLISH;
	}

	uint32_t appId;
	std::string publishStreamName;				//
	bool isPublishAsStreamName;					//ǷҪ͵Ӧϣfalse:ûƹۿʱgroupNames
	std::set<std::string> groupNames;			//ĿȺƣΪ
	std::map<uint32_t, uint32_t> streamCfg;	//Ϣ(key:  LiveStreamCfgKey::LiveStreamCfgKey)
};

class QYYSdkCallTransLiveStartAudioPublish : public IMediaEvent
{
public:
	QYYSdkCallTransLiveStartAudioPublish()
		: appId(0)
		, isPublishAsStreamName(true)
	{
		m_type = MET_CALL_LIVE_START_AUDIO_PUBLISH;
	}

	uint32_t appId;
	std::string publishStreamName;					//
	bool isPublishAsStreamName;						//ǷҪ͵Ӧϣfalse:ûƹۿʱgroupNames
	std::set<std::string> groupNames;				//ĿȺƣΪ
	std::map<uint32_t, uint32_t> streamCfg;		//Ϣ(key:  LiveStreamCfgKey::LiveStreamCfgKey)
};

class QYYSdkCallTransLiveSetPublishConfig : public IMediaEvent
{
public:
	QYYSdkCallTransLiveSetPublishConfig()
	: appId(0)
	{
		m_type = MET_CALL_LIVE_SET_PUBLISH_CONFIG;
	}

	uint32_t appId;
	std::string publishStreamName;				//
	std::map<uint32_t, uint32_t> streamCfg;	//Ϣ(<key:LiveStreamCfgKey>>)
};

class QYYSdkCallTransLiveStopVideoPublish : public IMediaEvent
{
public:
	QYYSdkCallTransLiveStopVideoPublish()
	: appId(0)
	{
		m_type = MET_CALL_LIVE_STOP_VIDEO_PUBLISH;
	}

	uint32_t appId;
	std::string publishStreamName;
};

class QYYSdkCallTransLiveStopAudioPublish : public IMediaEvent
{
public:
	QYYSdkCallTransLiveStopAudioPublish()
	: appId(0)
	{
		m_type = MET_CALL_LIVE_STOP_AUDIO_PUBLISH;
	}

	uint32_t appId;
	std::string publishStreamName;
};

class QYYSdkCallTransLiveSetAvpInfo : public IMediaEvent 
{
public:
	QYYSdkCallTransLiveSetAvpInfo() 
		:m_costTime(0)
	{
		m_type = MET_CALL_LIVE_SET_AVP_INFO;
	}
	std::string m_addrInfo;
	uint32_t m_costTime;      //λms
};

//ѯ·
class QYYSdkCallTransLiveGetStreamLineInfo : public IMediaEvent
{
public:
	QYYSdkCallTransLiveGetStreamLineInfo()
	{
		m_type = MET_CALL_LIVE_GET_STREAM_LINE_INFO;
	}
	std::map<uint32_t, std::set<QTransLiveStreamInfo>> m_appIdToStreams;
};

class QYYSdkCallTransLiveChannelToReportHiido : public IMediaEvent 
{
public:
	QYYSdkCallTransLiveChannelToReportHiido()
	{
		m_type = MET_CALL_LIVE_CHANNEL_TO_REPORT_HIIDO;
	}
	std::string m_tableName;
	std::string m_reportStr;
};

//update token
class QYYSdkCallTransLiveUpdateToken : public IMediaEvent
{
public:
	QYYSdkCallTransLiveUpdateToken()
	{
		m_type = MET_CALL_LIVE_UPDATE_TOKEN;
	}
	std::string m_token;
	std::string m_bizAuthExtInfo;
};

class QYYSdkCallTransLiveJoinChannel : public IMediaEvent
{
public:
	QYYSdkCallTransLiveJoinChannel()
	: m_join(false)
	{
		m_type = MET_CALL_LIVE_JOIN_CHANNEL;
	}
	bool m_join;
	std::string m_channelId;
};

//send msg to ARGO by ap
class QYYSdkCallTransLiveSendMsg2ArGo : public IMediaEvent
{
public:
	QYYSdkCallTransLiveSendMsg2ArGo()
	{
		m_type = MET_CALL_LIVE_SEND_MSG_TO_ARGO;
	}
	uint32_t m_uri;
	std::string m_playLoad;
	std::string m_hashKey;
};

class QYYSdkCallTransLiveSetAreaType : public IMediaEvent
{
public:
	QYYSdkCallTransLiveSetAreaType()
	: m_areaType(0)
	{
		m_type = MET_CALL_LIVE_SET_AREA_TYPE;
	}
	uint32_t m_areaType;
};

class QYYSdkCallTransLiveSetChannelProfile : public IMediaEvent
{
public:
	QYYSdkCallTransLiveSetChannelProfile()
	: m_channelProfile(ChannelProfile::CHANNEL_PROFILE_LIVE)
	{
		m_type = MET_CALL_LIVE_CHANNEL_PROFILE;
	}
	uint32_t m_channelProfile;
};

class QYYSdkCallTransLiveSetABtestConfig : public IMediaEvent
{
public:
	QYYSdkCallTransLiveSetABtestConfig()
	{
		m_type = MET_CALL_LIVE_SET_ABTEST_CONFIG;
	}
	std::map<uint32_t, uint32_t> config;
	std::map<uint32_t, std::string> stringConfig;
};


class QYYSdkCallTransLiveStartPublish : public IMediaEvent
{
public:
	QYYSdkCallTransLiveStartPublish()
	: appid(0)
	{
		m_type = MET_CALL_LIVE_START_PUBLISH;
	}
	uint32_t appid;
	std::string channelId;
	ChannelUserInfos userInfo;
	std::map<std::string, std::map<uint32_t, uint32_t>> streams;
	std::set<uint32_t> speakers;
};

class QYYSdkCallTransLiveStopPublish : public IMediaEvent
{
public:
	QYYSdkCallTransLiveStopPublish()
	: appid(0)
	{
		m_type = MET_CALL_LIVE_STOP_PUBLISH;
	}
	uint32_t appid;
	std::string channelId;
	std::set<std::string> streams;
};

//-----------------------------new live sys api--end-----------------------------//


//independent sdk
class QYYSdkCallTransUploadLogToMT : public IMediaEvent
{
public:
	QYYSdkCallTransUploadLogToMT()
	{
		m_type = MET_CALL_UPLOAD_LOG_TO_MT;
	}
};

//send user app msg data
class QYYSdkCallTransUserAppMsgData : public IMediaEvent
{
public:
	QYYSdkCallTransUserAppMsgData()
	{
		m_type = MET_CALL_LIVE_USER_APP_MSG_DATA;
	}
	std::string m_userData;
};