#pragma once
#include "EventBase.h"
#include "IYYSdkProxy.h"
#include "MediaObj.h"
#include <set>
#include <map>
#include <list>

class IUserInfo
{
public:
	IUserInfo() {}
	virtual ~IUserInfo() {}

public:
	virtual void setUid(uint32_t uid) = 0;
	virtual void setUid(std::string uid) = 0;
	virtual void setSid(uint32_t sid) = 0;
	virtual void setSubSid(uint32_t subsid) = 0;
	virtual void setApWanIp(uint32_t apWanIp) = 0;
	virtual void setLbsWanIp(uint32_t wanIp) = 0;
	virtual void setLbsWanIsp(uint32_t wanIsp) = 0;
	virtual void setNetState(uint32_t netState) = 0;
	virtual void setServiceType(uint32_t type) = 0;
	virtual void initUserInfo(AccountInitData& initData) = 0;
	virtual void setInBackGround(bool bvalue) = 0;
	virtual void setLoudSpeaker(bool status) = 0;
	virtual void setPrepareTime(uint32_t now) = 0;
	virtual void setApToken(const std::string& apToken) = 0;
	virtual void setLoginModle(uint32_t modle) = 0;
	virtual void setSessUInfo(uint32_t uid, uint32_t subSid, uint32_t rolers) = 0;
	virtual void setAvpToken(const std::string& avpToken, const std::string& bizAuthExtInfo) = 0;

public:
	virtual bool isAccelerateMode() const = 0;

public:
	virtual uint32_t getUid() const = 0;
	virtual uint32_t getSid() const = 0;
	virtual uint32_t getSubSid() const = 0;
	virtual uint32_t getNetState() const = 0;
	virtual uint32_t getServiceType() const = 0;
	virtual uint32_t getApWanIp() const = 0;
	virtual uint32_t getLbsWanIp() const = 0;
	virtual uint32_t getLoginModle() const = 0;
	virtual uint32_t getSdkVersion() const = 0;
	virtual uint32_t getTransVersion() const = 0;
	virtual uint32_t getVodPlayCount() const = 0;
};

class ITransCallBack;

class ITransMod
{
protected:
	ITransMod() {}
	virtual ~ITransMod() {}

public:
	virtual void init(IYYSdkProxy* proxy, const TransModInitData& data) = 0;
	virtual void uinit() = 0;
	virtual void call(IMediaEvent* evt) = 0;
    virtual void initTrans(ITransCallBack* pCallBacker, AccountInitData& data, bool bVoiceOnly) = 0;
	virtual void initTrans(ITransCallBack* pCallBacker, bool bVoiceOnly) = 0;
	virtual void uninitTrans() = 0;
	virtual void setVoicOnlySdk(bool isVoicOnly) = 0;

public:
	virtual IUserInfo* getUserInfo() = 0;
	virtual IYYSdkProxy* getProxy() = 0;

};

void createTransMod();
ITransMod* getTransMod();
void releaseTransMod();
uint32_t getTransModVersion();

