#pragma once
#include "EventBase.h"
#include "MediaObj.h"
#include <map>
#include <list>
#include <vector>

class QTransCallYYSdkSignalProtocol
	: public IMediaEvent
{
public:
	QTransCallYYSdkSignalProtocol()
	: module(kMedia2Vedio)
	, msgId(0)
	{
		m_type = MET_CALLBACK_SIGNAL_PROTOCOL;
	}

	int module;
	uint32_t msgId;
	std::string data;

	enum
	{
		kMedia2Vedio = 0,
		kMedia2Audio = 1,
		kMedia2Statics = 2,
		kMedia2Service = 3,
		kMedia2StaticsS2S = 4,//͸��������s2s��ͳ�ƽ���
	};
};

class QTransCallYYSdkLogText
	: public IMediaEvent
{
public:
	QTransCallYYSdkLogText()
	: lvl(0)
	, text(NULL)
	{
		m_type = MET_CALLBACK_LOG_TEXT;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkLogText* evt = new QTransCallYYSdkLogText();
		evt->m_bDup = true;
		evt->lvl = this->lvl;
		if (this->text)
		{
			evt->text = strdup(this->text);
		}
		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		if (this->text != NULL)
		{
			free(this->text);
			this->text = NULL;
		}
		delete this;
	}

	int lvl;
	char *text;
};

class QTransCallYYSdkSignalBroadcast
	: public IMediaEvent
{
public:
	QTransCallYYSdkSignalBroadcast()
	: msgId(0)
	, from(0)
	, sid(0)
	, subSid(0)
	{
		m_type = MET_CALLBACK_SIGNAL_BROADCAST;
	}

	uint32_t msgId;
	uint32_t from;
	uint32_t sid;
	uint32_t subSid;
	std::string data;
};

class QTransCallYYSdkLinkLossRate
	: public IMediaEvent
{
public:
	QTransCallYYSdkLinkLossRate()
	: type(AUDIO)
	, status(DOWN)
	, appid(0)
	, uid(0)
	, lossRate(0)
	, rtt(0)
	{
		m_type = MET_CALLBACK_LINK_LOSS_RATE;
	}
	
	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkLinkLossRate* evt = new QTransCallYYSdkLinkLossRate();
		evt->m_bDup = true;
		evt->type = this->type;
		evt->status = this->status;
		evt->appid = this->appid;
		evt->uid = this->uid;
		evt->lossRate = this->lossRate;
		evt->rtt = this->rtt;
		return evt;
	}
	
	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	int type;
	int status;
	uint32_t appid;
	uint32_t uid;
	uint32_t lossRate;
	uint32_t rtt;

	enum
	{
		DOWN,
		UP
	};

	enum
	{
		AUDIO,
		VIDEO
	};
};

class QTransCallYYSdkSessionStatus
	: public IMediaEvent
{
public:
	QTransCallYYSdkSessionStatus()
	: type(OPEN_AUDIO_FAILED)
	, status(false)
	{
		m_type = MET_CALLBACK_SESSION_STATUS;
	}

	int type;
	bool status;

	enum
	{
		OPEN_AUDIO_FAILED,
		AUDIO_DEVICE_STATED,
		AUDIO_UPLOAD_STATED,
		AUDIO_REJECTED
	};
};

class QTransCallYYSdkLinkStatus
	: public IMediaEvent
{
public:
	QTransCallYYSdkLinkStatus()
	: type(AUDIO)
	, status(MET_CONNECT)
	, appid(0)
	, ip(0)
	, port(0)
	, channelId(0)
	{
		m_type = MET_CALLBACK_LINK_STATUS;
	}
	
	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkLinkStatus* evt = new QTransCallYYSdkLinkStatus();
		evt->m_bDup = true;
		evt->type = this->type;
		evt->status = this->status;
		evt->appid = this->appid;
		evt->ip = this->ip;
		evt->port = this->port;
		evt->channelId = this->channelId;
		return evt;
	}
	
	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	int type;
	int status;
	uint32_t appid;
	uint32_t ip;
	uint16_t port;
	uint32_t channelId;

	enum
	{
		AUDIO,
		VIDEO
	};

	enum
	{
		MET_CONNECT			= 0,
		MET_CONNECTED		= 1,
		MET_DISCONNECTED	= 2,
		MET_SERVER_REJECT	= 3,	// ��������Դ���㣬�ܾ�����
	};
};

class QTransCallYYSdkStreamStatus
	: public IMediaEvent
{
public:
	QTransCallYYSdkStreamStatus()
	: type(AUDIO)
	, status(START)
	, uid(0)
	, publishId(0)
	, userGroupId(0)
	, streamId(0)
	{
		m_type = MET_CALLBACK_STREAM_STATUS;
	}

	int type;
	int status;
	uint32_t uid;
	uint32_t publishId;
	uint64_t userGroupId;
	uint64_t streamId;
	std::map<uint8_t, uint32_t> metaDatas;

	enum
	{
		AUDIO,
		VIDEO
	};

	enum
	{
		START = 0,
		ARRIVE = 1,
		STOP = 2,
        PAUSE = 3,
        RESUME = 4
	};
};

class QTransCallYYSdkSpeakerMicStatus
	: public IMediaEvent
{
public:
	QTransCallYYSdkSpeakerMicStatus()
	: status(START)
	, speakerUid(0)
	, sessionId(0)
	{
		m_type = MET_CALLBACK_SPEAKER_MIC_STATUS;
	}

	int status;
	uint32_t speakerUid;
	uint32_t sessionId;

	enum
	{
		START,
		STOP
	};
};

class QTransCallYYSdkAnchorBroadCast
	: public IMediaEvent
{
public:
	QTransCallYYSdkAnchorBroadCast()
	: uid(0)
	, userGroupId(0)
	, streamId(0)
	{
		m_type = MET_CALLBACK_ANCHOR_BROAD_CAST;
	}

	uint32_t uid;
	uint64_t userGroupId;
	uint64_t streamId;
	std::map<uint32_t, uint32_t> intDatas;
	std::map<uint32_t, std::string> strDatas;
};

class QTransCallYYSdkVideoFrameLoss
	: public IMediaEvent
{
public:
	QTransCallYYSdkVideoFrameLoss()
	: streamId(0)
	, duration(0)
	, frameRate(0)
	, playCnt(0)
	, netLossCnt(0)
	, dicardCnt(0)
	{
		m_type = MET_CALLBACK_VIDEO_FRAME_LOSS;
	}

	uint64_t streamId;
	uint32_t duration;
	uint32_t frameRate;
	uint32_t playCnt;
	uint32_t netLossCnt;
	uint32_t dicardCnt;
};

class QTransCallYYSdkFlvProxyAddr
	: public IMediaEvent
{
public:
	QTransCallYYSdkFlvProxyAddr()
	: uid(0)
	, publishId(0)
	, port(0)
	{
		m_type = MET_CALLBACK_FLV_PROXY_ADDR;
	}
	
	uint32_t uid;
	uint32_t publishId;
	uint16_t port;
	std::string host;
};

class QTransCallYYSdkFlvHttpStatus
	: public IMediaEvent
{
public:
	QTransCallYYSdkFlvHttpStatus()
	: status(kFlvHttpConnect)
	, uid(0)
	, publishId(0)
	, flvId(0)
	{
		m_type = MET_CALLBACK_FLV_HTTP_STATUS;
	}

	int status;
	uint32_t uid;
	uint32_t publishId;
	uint32_t flvId;

	enum FlvHttpLinkStatus
	{
		kFlvHttpConnect = 0,
		kFlvHttpDisconnect = 1,
		kFlvHttpNoResource = 2
	};
};

class QTransCallYYSdkLinkStatics
	: public IMediaEvent
{
public:
	QTransCallYYSdkLinkStatics()
	: type(AUDIO)
	, rtt(0)
	, uplinkSent(0)
	, uplinkRecv(0)
	, downlinkSent(0)
	, downlinkRecv(0)
	, state(0)
	{
		m_type = MET_CALLBACK_LINK_STATICS;
	}

	int type;
	uint32_t rtt;
	uint32_t uplinkSent;
	uint32_t uplinkRecv;
	uint32_t downlinkSent;
	uint32_t downlinkRecv;
	uint32_t state;

	enum
	{
		AUDIO,
		VIDEO
	};
};

class QTransCallYYSdkAudioState
	: public IMediaEvent
{
public:
	QTransCallYYSdkAudioState()
	: state(euNoAudio)
	, sid(0)
	, subSid(0)
	{
		m_type = MET_CALLBACK_AUDIO_STATE;
	}

	int state;
	uint32_t sid;
	uint32_t subSid;

	// todo enum�ظ�����
	enum
	{
		euNoAudio		= 1,	// Ƶ��û��˵��
		euRecvAudio		= 2,	// Ƶ����������
		euRecvNoAudio	= 3,	// Ƶ������˵����������������
	};
};

class QTransCallYYSdkSignalPing
	: public IMediaEvent
{
public:
	QTransCallYYSdkSignalPing()
	: stamp(0)
	{
		m_type = MET_CALLBACK_SIGNAL_PING;
	}

	uint32_t stamp;
};

class QTransCallYYSdkAudioPlayState
	: public IMediaEvent
{
public:
	QTransCallYYSdkAudioPlayState()
	: sid(0)
	, subSid(0)
	, speakerUid(0)
	, plays(0)
	, losses(0)
	, discards(0)
	, duration(0)
	{
		m_type = MET_CALLBACK_AUDIO_PLAY_STATE;
	}

	uint32_t sid;
	uint32_t subSid;
	uint32_t speakerUid;
	uint32_t plays;
	uint32_t losses;
	uint32_t discards;
	uint32_t duration;
};

class QTransCallYYSdkLinkFlow
	: public IMediaEvent
{
public:
	QTransCallYYSdkLinkFlow()
	: type(ALL)
	, status(UP)
	, appid(0)
	, uid(0)
	, flow(0)
	, publishRate(0)
	{
		m_type = MET_CALLBACK_LINK_FLOW;
	}

	int type;
	int status;
	uint32_t appid;
	uint32_t uid;
	uint32_t flow;
	uint32_t publishRate;

	enum
	{
		ALL,
		VIDEO,
		AUDIO
	};

	enum
	{
		UP,
		DOWN
	};
};

class QTransCallYYSdkVideoState
	: public IMediaEvent
{
public:
	QTransCallYYSdkVideoState()
	: streamId(0)
	, reason(0)
	{
		m_type = MET_CALLBACK_VIDEO_STATE;
	}

	uint64_t streamId;
	uint32_t reason;
};

class QTransCallYYSdkVideoPublishStatus
	: public IMediaEvent
{
public:
	QTransCallYYSdkVideoPublishStatus()
	: status(0)
	{
		m_type = MET_CALLBACK_VIDEO_PUBLISH_STATUS;
	}

	uint32_t status;
};

class QTransCallYYSdkEncodeParams
	: public IMediaEvent
{
public:
	QTransCallYYSdkEncodeParams()
	: type(VIDEO)
	, bitRate(0)
	, frameRate(0)
	, width(0)
	, height(0)
	, quality(0)
	, resolutionChanged(false)
	{
		m_type = MET_CALLBACK_ENCODE_PARAMS;
	}

	int type;
	uint32_t bitRate;
	uint32_t frameRate;
	uint32_t width;
	uint32_t height;
	uint32_t quality;
	bool resolutionChanged;

	enum
	{
		VIDEO,
		AUDIO
	};
};

class QTransCallYYSdkAudioChatting
	: public IMediaEvent
{
public:
	QTransCallYYSdkAudioChatting()
	: bChatting(false)
	{
		m_type = MET_CALLBACK_AUDIO_CHATTING;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkAudioChatting* evt = new QTransCallYYSdkAudioChatting();
		evt->m_bDup = true;
		evt->bChatting = this->bChatting;
		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}
	bool bChatting;
};


class QTransCallYYSdkDynamicBitrate
	: public IMediaEvent
{
public:
	QTransCallYYSdkDynamicBitrate()
	: appid(0)
	, uid(0)
	, bitRate(0)
	{
		m_type = MET_CALLBACK_DYNAMIC_BITRATE;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkDynamicBitrate* evt = new QTransCallYYSdkDynamicBitrate();
		evt->m_bDup = true;
		evt->appid = this->appid;
		evt->uid = this->uid;
		evt->bitRate = this->bitRate;

		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	uint32_t appid;
	uint32_t uid;
	uint32_t bitRate;
};

class QTransCallYYSdkChatText
	: public IMediaEvent
{
public:
	QTransCallYYSdkChatText()
	{
		m_type = MET_CALLBACK_CHAT_TEXT;
	}

	std::list<ChatItem> textItems;
};

class QTransCallYYSdkServerRecordRes
	: public IMediaEvent
{
public:
	QTransCallYYSdkServerRecordRes()
	: appId(0)
	{
		m_type = MET_CALLBACK_SERVER_RECORD_RES;
	}

	uint32_t appId;
	std::string businessId;
	std::string programId;
};

struct QTransCallYYSdkStreamStat
{
	std::map<uint32_t, uint32_t> dataMap;

	QTransCallYYSdkStreamStat()
	{
		dataMap.clear();
	}
};

class QTransCallYYSdkVideoStatToApp
	: public IMediaEvent
{
public:
	QTransCallYYSdkVideoStatToApp()
	: statType(0)
	, uid(0)
	{
		m_type = MET_CALLBACK_VIDEO_STATE_TO_APP;
		statMap.clear();
		streamMap.clear();
	}

	// statType��ö�ٶ���
	enum
	{
		ST_VIWER_20S_STAT			= 0,	// ����20�����ͳ��
		ST_PUBLISHER_20S_STAT		= 1,	// ����20�����ͳ��
		ST_VIEW_LOSS_NOTIFY			= 2,	// ����5�뿨��ʾ
		ST_PUBLISHER_LOSS_NOTIFY	= 3,	// ����5�뿨��ʾ
	};

	uint32_t statType;
	uint32_t uid;
	std::map<uint32_t, uint32_t> statMap;
	std::map<uint64_t, QTransCallYYSdkStreamStat> streamMap; // ��Ƶ����ص�ͳ�� streamId -> QTransCallYYSdkStreamStat

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkVideoStatToApp* evt = new QTransCallYYSdkVideoStatToApp();
		evt->m_bDup = true;
		evt->statType = this->statType;
		evt->uid = this->uid;
		evt->statMap = this->statMap;
		evt->streamMap = this->streamMap;
		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}
};

class QTransCallYYSdkVideoP2PStat
	: public IMediaEvent
{
public:
	QTransCallYYSdkVideoP2PStat()
	: appid(0)
	{
		m_type = MET_CALLBACK_VIDEO_P2P_STATE;
	}

	uint32_t appid;
	std::map<uint32_t, uint32_t> statMap;
};

//����ǰ�㲥��֧�ֵ�cdn��·֪ͨ��ҵ���
class QTransCallYYSdkCdnSupport
	: public IMediaEvent
{
public:
	QTransCallYYSdkCdnSupport()
	: appId(0)
	, hasCDN(0)
	{
		m_type = MET_CALLBACK_CDN_SUPPORT;
	}

	uint32_t appId;		//ҵ������
	uint32_t hasCDN;	//ÿһbit����һ��cdn���̣���λ��ʾ��cdn���̵�ǰ����·�������û��
};

class QTransCallYYSdkStreamUnsubscribe
	: public IMediaEvent
{
public:
	QTransCallYYSdkStreamUnsubscribe()
	: groupId(0)
	, streamId(0)
	{
		m_type = MET_CALLBACK_STREAM_UNSUBSCRIBE;
	}

	uint64_t groupId;
	uint64_t streamId;
};

class QTransCallYYSdkVideoDecoderSelected
	: public IMediaEvent
{
public:
	QTransCallYYSdkVideoDecoderSelected()
	: groupId(0)
	, streamId(0)
	, type(0)
	, codecId(0)
	{
		m_type = MET_CALLBACK_VIDEO_DECODER_SELECTED;
	}

	uint64_t groupId;
	uint64_t streamId;
	uint32_t type;
	uint32_t codecId;
};

class QTransCallYYSdkDecodeSlow
	: public IMediaEvent
{
public:
	QTransCallYYSdkDecodeSlow()
	: type(VIDEO)
	, bitRate(0)
	, frameRate(0)
	, decodeRate(0)
	, width(0)
	, height(0)
	, streamId(0)
	{
		m_type = MET_CALLBACK_DECODE_SLOW;
	}

	int type;
	uint32_t bitRate;
	uint32_t frameRate;
	uint32_t decodeRate;
	uint32_t width;
	uint32_t height;
	uint64_t streamId;

	enum
	{
		VIDEO,
		AUDIO
	};
};

class QTransCallYYSdkOnTimeOut
	: public IMediaEvent
{
public:
	QTransCallYYSdkOnTimeOut()
	: times(0)
	, now(0)
	{
		m_type = MET_CALLBACK_ON_TIME_OUT;
	}

	uint32_t times;
	uint32_t now;
};

//ͨ��ý��ǰ��������cdn�Ľ����Ӧ
class QTransCallYYSdkRtmpStreamRes
	: public IMediaEvent
{
public:
	QTransCallYYSdkRtmpStreamRes()
	: appId(0)
	, status((uint16_t)-1)
	{
		m_type = MET_CALLBACK_RTMP_STREAM_RES;
	}

	uint32_t appId;
	uint16_t status; //0-OK; ��0-���������쳣
	std::map<std::string, uint32_t> resCode; //keyΪCDN��ַ��valueΪ����������������ؽ����0-�ɹ�����0-�����쳣������
};

class QTransCallYYSdkNotifyBroadcastGroup
	: public IMediaEvent
{
public:
	QTransCallYYSdkNotifyBroadcastGroup()
	: appId(0)
	, bNewBroadCastGroup(false)
	{
		m_type = MET_CALLBACK_NOTIFY_BROADCAST_GROUP;
	}

	uint32_t appId;
	bool bNewBroadCastGroup;
};

struct QTransCallYYSdkChannelConfig
{
	uint32_t hasVideo;											//�Ƿ�����Ƶ 1:����Ƶ 0������Ƶ
	std::map<uint32_t, uint32_t> metaData;						//��Ƶ����MetaData��Ϣ
public:
	QTransCallYYSdkChannelConfig()
	: hasVideo(0)
	{
	}

	bool operator == (const QTransCallYYSdkChannelConfig& dest) const
	{
		if (hasVideo != dest.hasVideo || metaData.size() != dest.metaData.size())
		{
			return false;
		}

		std::map<uint32_t, uint32_t>::const_iterator srcIt = metaData.begin();
		std::map<uint32_t, uint32_t>::const_iterator destIt = dest.metaData.begin();

		while (srcIt != metaData.end() && destIt != dest.metaData.end())
		{
			if (srcIt->first != destIt->first || srcIt->second != destIt->second)
			{
				return false;
			}

			++ srcIt;
			++ destIt;
		}

		return true;
	}
};

typedef std::map<uint32_t, QTransCallYYSdkChannelConfig> QChannelConfigT;

struct QTransCallYYSdkSpeakerStreamConfig
{
	uint32_t subSid;						//��������Ƶ����
	uint32_t appId;							//������appid
	QChannelConfigT channelConfigs;			//key:channelId

public:
	bool operator == (const QTransCallYYSdkSpeakerStreamConfig& dest) const
	{
		if (subSid != dest.subSid || appId != dest.appId || channelConfigs.size() != dest.channelConfigs.size())
		{
			return false;
		}

		QChannelConfigT::const_iterator it = channelConfigs.begin();
		QChannelConfigT::const_iterator eIt = dest.channelConfigs.begin();
		while (it != channelConfigs.end() && eIt != dest.channelConfigs.end())
		{
			if (it->first == eIt->first && it->second == eIt->second)
			{
				++ it;
				++ eIt;
				continue;
			}

			return false;
		}

		return true;
	}
};


typedef std::map<uint64_t, QTransCallYYSdkSpeakerStreamConfig> QStreamConfigT;

class QTransCallYYSdkNotifyStreamConfig
	: public IMediaEvent
{
public:
	QTransCallYYSdkNotifyStreamConfig()
	{
		m_type = MET_CALLBACK_NOTIFY_STREAM_CONFIG;
	}

	QStreamConfigT streamKeyToConfig;	//key:��32λ������uid����32λ��publishId

public:
	bool operator == (const QTransCallYYSdkNotifyStreamConfig& dest) const
	{
		if (streamKeyToConfig.size() != dest.streamKeyToConfig.size())
		{
			return false;
		}

		QStreamConfigT::const_iterator it = streamKeyToConfig.begin();
		QStreamConfigT::const_iterator eIt = dest.streamKeyToConfig.begin();
		while (it != streamKeyToConfig.end() && eIt != dest.streamKeyToConfig.end())
		{
			if (it->first == eIt->first && it->second == eIt->second)
			{
				++ it;
				++ eIt;
				continue;
			}

			return false;
		}

		return true;
	}
};

class QTransCallYYSdkVideoMetaData
	: public IMediaEvent
{
public:
	QTransCallYYSdkVideoMetaData()
	: publishId(0)
	, streamId(0)
	, userGroupId(0)
	, bitRate(0)
	, frameRate(0)
	{
		m_type = MET_CALLBACK_VIDEO_META_DATA;
	}

	uint32_t publishId;
	uint64_t streamId;
	uint64_t userGroupId;
	uint32_t bitRate;
	uint32_t frameRate;
	std::map<uint8_t, uint32_t> metaDatas;
};

class QTransCallYYSdkAudioDiagnose
	: public IMediaEvent
{
public:
	QTransCallYYSdkAudioDiagnose()
	{
		m_type = MET_CALLBACK_AUDIO_DIAGNOSE;
	}

	std::map<uint8_t, uint32_t> mapDiagnoseRes;
};

//����rtmp����״̬֪ͨ
class QTransCallYYSdkRtmpPublishStatus
	: public IMediaEvent
{
public:
	QTransCallYYSdkRtmpPublishStatus()
	: appId(0)
	, status(0)
	{
		m_type = MET_CALLBACK_RTMP_PUBLISH_STATUS;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkRtmpPublishStatus* evt = new QTransCallYYSdkRtmpPublishStatus();
		evt->m_bDup = true;
		evt->appId = this->appId;
		evt->status = this->status;
		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	uint32_t appId;
	uint32_t status;
};

// rtmp�����������Զ�����Ϣ�ص�
class QTransCallYYSdkRtmpPublishInfo
	: public IMediaEvent
{
public:
	QTransCallYYSdkRtmpPublishInfo()
	{
		m_type = MET_CALLBACK_RTMP_PUBLISH_INFO;
	}

	std::map<std::string, std::string> info;
};

class QTransCallYYSdkRtmpMetaData
	: public IMediaEvent
{
public:
	QTransCallYYSdkRtmpMetaData()
		: streamId(0)
	{
		m_type = MET_CALLBACK_RTMP_META_DATA;
	}

	uint64_t streamId;
	std::map<uint32_t, uint32_t> metaData;
};

class QTransCallYYSdkVideoEncodedFrame
	: public IMediaEvent
{
public:
	QTransCallYYSdkVideoEncodedFrame()
	{
		m_type = MET_CALLBACK_VIDEO_ENCODED_FRAME;
	}

	VideoEncodedFrame frame;
};

class QTransCallYYSdkForwardStatus
	: public IMediaEvent
{
public:
	QTransCallYYSdkForwardStatus()
	: status(FORWARD_SUCCESS)
	, appId(0)
	, publishId(0)
	, subSid(0)
	{
		m_type = MET_CALLBACK_FORWARD_STATUS;
	}

	int status;
	uint32_t appId;
	uint32_t publishId;
	uint32_t subSid;

	enum
	{
		FORWARD_SUCCESS = 0,	//ת���ɹ�
		FORWARD_FAILED = 1,		//ת��ʧ��
		FORWARD_FORBID = 2,		//��ת��Ƶ����Ȩʧ��
		FORWARD_ERROR = 3,		//ת����������
		FORWARD_NOT_SUPPORT = 4,//��֧��Ƶ��ת��
	};
};

// ���������Ƿ����ʱ����ģʽ
class QTransCallYYSdkLowDelayEncodeMode
	: public IMediaEvent
{
public:
	QTransCallYYSdkLowDelayEncodeMode()
		: m_lowDelayMode(0)
	{
		m_type = MET_CALLBACK_LOW_DELAY_ENCODE_MODE;
	}

	uint32_t m_lowDelayMode;
};

// �����������������I֡
class QTransCallYYSdkVideoRequestIFrame
	: public IMediaEvent
{
public:
	QTransCallYYSdkVideoRequestIFrame()
	{
		m_type = MET_CALLBACK_REQUEST_I_FRAME;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkVideoRequestIFrame* evt = new QTransCallYYSdkVideoRequestIFrame();
		evt->m_bDup = true;

		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}
};

// ����ģ���յ���Ƶ֡��������Ⱦ����ʱ��500ms�ص�һ��
class QTransCallYYSdkVideoPlayDelay
	: public IMediaEvent
{
public:
	QTransCallYYSdkVideoPlayDelay()
	: m_playDelay(0)
	, m_streamId(0)
	{
		m_type = MET_CALLBACK_VIDEO_PLAY_DELAY;
	}

	uint32_t m_playDelay;
	uint64_t m_streamId;
};

//���ڻص�ҵ�񣬳�ʱ������Ƶ�����У�ж��SDKԤ��netmod����
class QTransCallYYSdkUninstallSDK
	: public IMediaEvent
{
public:
	QTransCallYYSdkUninstallSDK()
	{
		m_type = MET_CALLBACK_UNINSTALL_SDK;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkUninstallSDK* evt = new QTransCallYYSdkUninstallSDK();
		evt->m_bDup = true;
		evt->appConfigs.swap(this->appConfigs);
		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}
	std::map<uint32_t, uint32_t> appConfigs;
};

//��̨�����·��������˲ɼ�ʱ���У��ֵ
class QTransCallYYSdkPublisherPtsAdjustVal
	: public IMediaEvent
{
public:
	QTransCallYYSdkPublisherPtsAdjustVal()
	: adjustVal(0)
	{
		m_type = MET_CALLBACK_PTS_ADJUST_VAL;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkPublisherPtsAdjustVal* evt = new QTransCallYYSdkPublisherPtsAdjustVal();
		evt->m_bDup = true;
		evt->adjustVal = this->adjustVal;
		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	uint32_t adjustVal;
};

//---------------------VOD-----------------------//
class QTransCallPlayerStateChange : public IMediaEvent
{
public:
	QTransCallPlayerStateChange()
	: state(PLAYER_READY)
	, errorCode(0)
	{
		m_type = MET_CALLBACK_PLAYER_STATE_CHANGE;
	}
	
	std::string url;
	int state;
	int errorCode;
	
	enum
	{
		PLAYER_READY      = 0,
		PLAYER_BUFFERING  = 1,
		//PLAYER_BUFFERFULL = 2,
		PLAYER_PLAYING    = 2,
		PLAYER_ENDED      = 3,
		PLAYER_PAUSED     = 4,
		PLAYER_STOPED     = 5,
		PLAYER_ERROR      = 6,
	};
	
};

class QTransCallPlayerBufferingChange : public IMediaEvent
{
public:
	QTransCallPlayerBufferingChange()
	: persent(0)
	{
		m_type = MET_CALLBACK_PLAYER_BUFFERING_CHANGE;
	}
	
	std::string url;
	uint32_t  persent; //1-100
};

class QTransCallPlayerTotalTime : public IMediaEvent
{
public:
	QTransCallPlayerTotalTime()
	: totalTime(0)
	{
		m_type = MET_CALLBACK_PLAYER_TOTAL_TIME;
	}
	
	std::string url;
	uint32_t totalTime; //ms
};

class QTransCallPlayerPlayedTimeChange : public IMediaEvent
{
public:
	QTransCallPlayerPlayedTimeChange()
	: playedTime(0)
	{
		m_type = MET_CALLBACK_PLAYER_PLAYED_TIME_CHANGE;
	}
	
	std::string url;
	uint32_t playedTime; //ms
};

class QTransCallPlayerCacheTimeChange : public IMediaEvent
{
public:
	QTransCallPlayerCacheTimeChange()
	: cacheTime(0)
	{
		m_type = MET_CALLBACK_PLAYER_CACHE_TIME_CHANGE;
	}
	
	std::string url;
	uint32_t cacheTime; //ms
};

class QTransCallPlayerVideoSize : public IMediaEvent
{
public:
	QTransCallPlayerVideoSize()
	: width(0)
	, height(0)
	{
		m_type = MET_CALLBACK_PLAYER_VIDEO_SIZE;
	}

	std::string url;
	uint32_t width;
	uint32_t height;
};

class QTransCallPlayerVideoStreamStatus : public IMediaEvent
{
public:
	QTransCallPlayerVideoStreamStatus()
	: status(0)
	, uid(0)
	, groupId(0)
	, streamId(0)
	{
		m_type = MET_CALLBACK_PLAYER_VIDEO_STREAM_STATUS;
	}

	std::string url;
	uint32_t status; //START , ARRIVE, STOP
	uint32_t uid;
	uint64_t groupId;
	uint64_t streamId;
};

class QTransCallPlayerError : public IMediaEvent
{
public:
	QTransCallPlayerError()
	: errorCode(0)
	, statusCode(0)
	{
		m_type = MET_CALLBACK_PLAYER_ERROR;
	}
	
	std::string url;
	uint32_t errorCode;   //enum
	uint32_t statusCode;  //http code
	
	enum
	{
		ERR_DNSRESOLVE			= 0,
		ERR_CONNECT				= 1,
		ERR_CONNECT_TIMEOUT		= 2,
		ERR_RESPONSE_TIMEOUT	= 3,
		ERR_HTTP_ERROR			= 4,
		ERR_PROBE				= 5,
		ERR_READ_HEADER			= 6,
		ERR_READ_FRAME			= 7,
		ERR_SEEK				= 8,
		ERR_INFLATE				= 9
	};
};

class QTransCallYYSdkLiveSubscribeStatus 
	: public IMediaEvent
{
public:
	QTransCallYYSdkLiveSubscribeStatus()
	: m_appId(0)
	, m_status(0)
	{
		m_type = MET_CALLBACK_LIVE_SUBSCRIBE_STATUS;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkLiveSubscribeStatus* evt = new QTransCallYYSdkLiveSubscribeStatus();
		evt->m_bDup = true;
		evt->m_appId = this->m_appId;
		evt->m_streamName.assign(this->m_streamName);
		evt->m_status = this->m_status;

		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	uint32_t m_appId;
	std::string m_streamName;
	uint32_t m_status;
};

class QTransCallYYSdkLivePublishStatus 
	: public IMediaEvent
{
public:
	QTransCallYYSdkLivePublishStatus()
	: m_status(0)
	{
		m_type = MET_CALLBACK_LIVE_PUBLISH_STATUS;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkLivePublishStatus* evt = new QTransCallYYSdkLivePublishStatus();
		evt->m_bDup = true;
		evt->m_streamName.assign(this->m_streamName);
		evt->m_status = this->m_status;

		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	std::string m_streamName;
	uint32_t m_status;
};

class QTransCallYYSdkLiveAudioStreamStatus
	: public IMediaEvent
{
public:
	QTransCallYYSdkLiveAudioStreamStatus()
	: m_appId(0)
	, m_status(0)
	, m_uid(0)
	{
		m_type = MET_CALLBACK_LIVE_AUDIOSTREAM_STATUS;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkLiveAudioStreamStatus* evt = new QTransCallYYSdkLiveAudioStreamStatus();
		evt->m_bDup = true;
		evt->m_appId = this->m_appId;
		evt->m_streamName.assign(this->m_streamName);
		evt->m_status = this->m_status;
		evt->m_uid = this->m_uid;
		evt->m_actualUids.assign(this->m_actualUids.begin(), this->m_actualUids.end());

		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	uint32_t m_appId;
	std::string m_streamName;
	int m_status;
	uint32_t m_uid;
	std::vector<uint32_t> m_actualUids;
};

class QTransCallYYSdkLiveVideoStreamStatus
	: public IMediaEvent
{
public:
	QTransCallYYSdkLiveVideoStreamStatus()
	: m_appId(0)
	, m_status(0)
	, m_streamId(0)
	, m_encodeType(0)
	{
		m_type = MET_CALLBACK_LIVE_VIDEOSTREAM_STATUS;			
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkLiveVideoStreamStatus* evt = new QTransCallYYSdkLiveVideoStreamStatus();
		evt->m_bDup = true;
		evt->m_appId = this->m_appId;
		evt->m_streamName.assign(this->m_streamName);
		evt->m_status = this->m_status;
		evt->m_streamId = this->m_streamId;
		evt->m_encodeType = this->m_encodeType;

		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	uint32_t m_appId;
	std::string m_streamName;
	int m_status;
	uint64_t m_streamId;
	uint32_t m_encodeType;
};

class QTransCallYYSdkInvokeGetAudioFrameDuration : public IMediaEvent
{
public:
	QTransCallYYSdkInvokeGetAudioFrameDuration()
	: m_netCodec(0)
	, m_frameDuration(0)
	{
		m_type = MET_CALLBACK_INVOKE_GET_AUDIO_FRAME_DURATION;
	}

	uint32_t m_netCodec;
	uint32_t m_frameDuration;
};

class QTransCallYYSdkInvokeGetAudioDataDuration : public IMediaEvent
{
public:
	QTransCallYYSdkInvokeGetAudioDataDuration()
	: m_netCodec(0)
	, m_duration(0)
	, m_data(NULL)
	, m_dataLen(0)
	{
		m_type = MET_CALLBACK_INVOKE_GET_AUDIO_DATA_DURATION;
	}
	
	uint32_t m_netCodec;
	uint32_t m_duration;
	void* m_data;
	uint32_t m_dataLen;
};

class QTransCallYYSdkInvokeGetAudioDataFrameLen : public IMediaEvent
{
public:
	QTransCallYYSdkInvokeGetAudioDataFrameLen()
	: m_netCodec(0)
	, m_data(NULL)
	, m_dataLen(0)
	, m_frameLen(0)
	{
		m_type = MET_CALLBACK_INVOKE_GET_AUDIO_DATA_FRAME_LEN;
	}

	uint32_t m_netCodec;
	void* m_data;
	uint32_t m_dataLen;
	uint32_t m_frameLen;
};

class QTransCallYYSdkInvokeGetAudioSupportCodec : public IMediaEvent
{
public:
	QTransCallYYSdkInvokeGetAudioSupportCodec()
	{
		m_type = MET_CALLBACK_INVOKE_GET_AUDIO_SUPPORT_CODEC;
	}

	std::vector<uint32_t> m_supportCodec;
};

class QTransCallYYSdkInvokeIsSupportCodec : public IMediaEvent
{
public:
	QTransCallYYSdkInvokeIsSupportCodec()
	: m_netCodec(0)
	, m_bVideo(false)
	, m_bSupport(false)
	{
		m_type = MET_CALLBACK_INVOKE_IS_SUPPORT_CODEC;
	}

	uint32_t m_netCodec;
	bool m_bVideo;
	bool m_bSupport;
};

class QTransCallYYSdkInvokeGetLogFileInfo : public IMediaEvent
{
public:
	QTransCallYYSdkInvokeGetLogFileInfo()
	{
		m_type = MET_CALLBACK_INVOKE_GET_LOG_FILE_INFO;
	}

	std::string m_logPath;
	std::string m_logFileName;
	std::list<std::string> m_logFileList;
};

class QTransCallYYSdkInvokeCreateVideoDecoder : public IMediaEvent
{
public:
	QTransCallYYSdkInvokeCreateVideoDecoder()
	: m_streamId(0)
	, m_videoDecoder(NULL)
	{
		m_type = MET_CALLBACK_INVOKE_CREATE_VIDEO_DECODER;
	}

	std::string m_streamKey;
	uint64_t m_streamId;
	void* m_videoDecoder;
};

class QTransCallYYSdkInvokeDeleteVideoDecoder : public IMediaEvent
{
public:
	QTransCallYYSdkInvokeDeleteVideoDecoder()
	: m_videoDecoder(NULL)
	{
		m_type = MET_CALLBACK_INVOKE_DELETE_VIDEO_DECODER;
	}

	void* m_videoDecoder;
};

class QTransCallYYSdkInvokeGetAudioHiidoStatInfo : public IMediaEvent
{
public:
	enum AudioStatType
	{
		AUDIO_STAT_NONE = 0,
		AUDIO_STAT_CAPTURE_AND_ENCODE,
		AUDIO_STAT_RENDER,
		AUDIO_STAT_DECODE,
	};
	QTransCallYYSdkInvokeGetAudioHiidoStatInfo()
	: m_statType(AUDIO_STAT_NONE)
	, m_uid(0)
	, m_pHiidoInfo(NULL)
	, m_infoLen(0)
	{
		m_type = MET_CALLBACK_INVOKE_GET_AUDIO_HIIDO_STAT_INFO;
	}

	uint32_t m_statType;
	uint32_t m_uid;
	char* m_pHiidoInfo;
	int m_infoLen;
};

class QTransCallYYSdkInvokeGetVideoHiidoStatInfo : public IMediaEvent
{
public:
	enum VideoStatType
	{
		VIDEO_STAT_NONE = 0,
		VIDEO_STAT_ANCHOR,
		VIDEO_STAT_AUDIENCE,
	};
	QTransCallYYSdkInvokeGetVideoHiidoStatInfo()
	: m_statType(VIDEO_STAT_NONE)
	, m_streamId(0)
	, m_pHiidoInfo(NULL)
	, m_infoLen(0)
	{
		m_type = MET_CALLBACK_INVOKE_GET_VIDEO_HIIDO_STAT_INFO;
	}

	uint32_t m_statType;
	uint64_t m_streamId;
	char* m_pHiidoInfo;
	uint32_t* m_infoLen;
};

struct QTransCallYYSdkLiveStreamLineInfo
{
	std::string streaName;
	std::set<uint32_t> lines;
public:
	QTransCallYYSdkLiveStreamLineInfo()
	{
	}

	bool operator < (const QTransCallYYSdkLiveStreamLineInfo& dest) const
	{
		return streaName < dest.streaName;
	}

	bool operator == (const QTransCallYYSdkLiveStreamLineInfo& dest) const
	{
		if (streaName != dest.streaName || lines.size() != dest.lines.size())
		{
			return false;
		}

		std::set<uint32_t>::const_iterator srcIt = lines.begin();
		std::set<uint32_t>::const_iterator destIt = dest.lines.begin();

		while (srcIt != lines.end() && destIt != dest.lines.end())
		{
			if (*srcIt != *destIt)
			{
				return false;
			}
			++ srcIt;
			++ destIt;
		}

		return true;
	}
};

typedef std::map<uint32_t, std::set<QTransCallYYSdkLiveStreamLineInfo>> QLinesConfigT;
class QTransCallYYSdkInvokeNotifyStreamLineInfo : public IMediaEvent
{
public:
	QTransCallYYSdkInvokeNotifyStreamLineInfo()
	: m_curLineSeq((uint32_t) -1)
	, lineFrom((uint32_t) -1)
	{
		m_type = MET_CALLBACK_LIVE_STREAM_LINE_INFO;
	}
	uint32_t m_curLineSeq;
	QLinesConfigT m_appidToLines;
	uint32_t lineFrom;
};

// app authenticate call back
class QTransCallYYSdkBizAuthResNotify : public IMediaEvent
{
public:
	QTransCallYYSdkBizAuthResNotify()
		: m_appid(0)
		, m_uid(0)
		, m_bPublish(true)
		, m_bizAuthResult(0)//0 success
	{
		m_type = MET_CALLBACK_LIVE_BIZ_AUTH_RES_NOTIFY;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkBizAuthResNotify* evt = new QTransCallYYSdkBizAuthResNotify();
		evt->m_bDup = true;
		evt->m_appid = this->m_appid;
		evt->m_uid = this->m_uid;
		evt->m_bPublish = this->m_bPublish;
		evt->m_streamName = this->m_streamName;
		evt->m_groupName = this->m_groupName;
		evt->m_bizAuthResult = this->m_bizAuthResult;

		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	uint32_t m_appid;
	uint32_t m_uid;
	bool m_bPublish;
	std::string m_streamName;
	std::string m_groupName;
	uint32_t m_bizAuthResult;
};

// SDK authenticate callback
class QTransCallYYSdkSDKAuthResNotify : public IMediaEvent
{
public:
	QTransCallYYSdkSDKAuthResNotify()
		: m_appid(0)
		, m_uid(0)
		, m_sdkAuthResult(0) // 0 success
	{
		m_type = MET_CALLBACK_LIVE_SDK_AUTH_RES_NOTIFY;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkSDKAuthResNotify* evt = new QTransCallYYSdkSDKAuthResNotify();
		evt->m_bDup = true;
		evt->m_appid = this->m_appid;
		evt->m_uid = this->m_uid;
		evt->m_sdkAuthResult = this->m_sdkAuthResult;

		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	uint32_t m_appid;
	uint32_t m_uid;
	uint32_t m_sdkAuthResult;
};

// oversea begin
struct QTransStreamInfo
{
public:
	QTransStreamInfo()
	: spkUid(0)
	{
	}
	std::string streamName;		//appid+������, ��һ���»��ߵ�ǰ����appid
	uint32_t spkUid;			//����uid
	std::string url;			//url http����https ȡ���ڵ�һ�������isHttps����
	std::map<uint32_t, uint32_t> streamConfig;	//������id��ֵ, �ο�StreamConfigKey ����ֱ��ʡ����ʵ�
	std::string extAttr;		//Ԥ���ֶ�
	
	bool operator < (const QTransStreamInfo & other) const
	{
		return streamName < other.streamName ||
		(streamName == other.streamName && spkUid < other.spkUid);
	}
	bool operator > (const QTransStreamInfo & other) const
	{
		return streamName > other.streamName ||
		(streamName == other.streamName && spkUid > other.spkUid);
	}
	bool operator == (const QTransStreamInfo & other) const
	{
		return streamName == other.streamName && spkUid == other.spkUid;
	}
};

struct QTransStreamLineBasicInfo
{
public:
	QTransStreamLineBasicInfo()
	: lineSeq(0)
	, providerId(0)
	, urlId(0)
	, isCdn(0)
	, cdnType(0)
	{
	}
	uint32_t lineSeq;		//��·��
	uint32_t providerId;	//����id		0:YY ��0:CDN����id
	uint32_t urlId;			//urlId		urlId
	uint8_t  isCdn;			//�Ƿ�cdn��·
	uint8_t  cdnType;		//cdn��·���� 0:flv, 1:p2p
	std::string extAttr;	//Ԥ���ֶ�
};

struct QTransStreamLineInfo
{
public:
	QTransStreamLineInfo()
	{
	}
	std::set<QTransStreamInfo> streamInfos;	//����Ϣ
	std::string extAttr;	//Ԥ���ֶ�
};

struct QTransStreamLevelInfo
{
public:
	QTransStreamLevelInfo()
	{
	}
	std::map<uint32_t, QTransStreamLineInfo> streamLines;	//��·��Ϣ
};

typedef std::map<uint16_t, QTransStreamLevelInfo> QStreamLevelInfoT;
typedef std::map<uint32_t, QTransStreamLineBasicInfo> QStreamLineInfoT;

class QTransCallYYSdkJoinChannelStatus : public IMediaEvent
{
public:
	QTransCallYYSdkJoinChannelStatus()
	: m_status(JOIN_SUCCESS)
	{
		m_type = MET_CALLBACK_LIVE_JOIN_CHANNEL_STATUS;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkJoinChannelStatus* evt = new QTransCallYYSdkJoinChannelStatus();
		evt->m_bDup = true;
		evt->m_channelId = this->m_channelId;
		evt->m_status = this->m_status;

		return evt;
	}
	
	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	std::string m_channelId; //�����
	uint32_t m_status;
	
	enum
	{
		JOIN_SUCCESS			= 0,
		JOIN_TIMEOUT			= 1,
	};
};

class QTransCallYYSdkStreamInfoStatus : public IMediaEvent
{
public:
	QTransCallYYSdkStreamInfoStatus()
	: m_curLine((uint32_t)-1)
	, m_appId(0)
	, m_reason(STREAM_NO_STREAM)
	{
		m_type = MET_CALLBACK_LIVE_STREAM_INFO_STATUS;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkStreamInfoStatus* evt = new QTransCallYYSdkStreamInfoStatus();
		evt->m_bDup = true;
		evt->m_curLine = this->m_curLine;
		evt->m_appId = this->m_appId;
		evt->m_channelId = this->m_channelId;
		evt->m_reason = this->m_reason;
		evt->m_streamLevelInfo.swap(this->m_streamLevelInfo);
		evt->m_streamLineInfo.swap(this->m_streamLineInfo);
		
		return evt;
	}
	
	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	uint32_t m_curLine;	//Ĭ����·
	uint32_t m_appId;
	std::string m_channelId; //�����
	uint32_t m_reason; //notifyԭ��
	QStreamLevelInfoT m_streamLevelInfo;		//����������=>��·�б�(������λ)
	QStreamLineInfoT m_streamLineInfo;		//����������=>������, �ձ�ʾû����(������λ)
	
	enum
	{
		STREAM_NO_STREAM	= 0,
		STREAM_LEVEL_CHG	= 1,
		STREAM_LINE_CHG		= 1 << 1,
		STREAM_NAME_CHG		= 1 << 2,
		STREAM_URL_CHG		= 1 << 3,
		STREAM_CONFIG_CHG	= 1 << 4,
		STREAM_STOP			= 1 << 5,
		STREAM_ARRIVE		= 1 << 6,
	};
};
// oversea end

//ARGO Res
class QTransCallYYSdkArGoResNotify : public IMediaEvent
{
public:
	QTransCallYYSdkArGoResNotify()
	: m_uri(0)
	{
		m_type = MET_CALLBACK_INVOKE_ARGO_RES_NOTIFY;
		m_playload.clear();
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkArGoResNotify* evt = new QTransCallYYSdkArGoResNotify();
		evt->m_bDup = true;
		evt->m_uri = this->m_uri;
		evt->m_playload = this->m_playload;
		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	uint32_t m_uri;
	std::string m_playload;
};

class QTransCallYYSdkLiveStrUidMap
	: public IMediaEvent
{
public:
	QTransCallYYSdkLiveStrUidMap()
		: m_uid(0)
		, m_strUid("")
	{
		m_type = MET_CALLBACK_LIVE_STRING_UID_MAP_NOTIFY;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkLiveStrUidMap* evt = new QTransCallYYSdkLiveStrUidMap();
		evt->m_bDup = true;
		evt->m_uid = m_uid;
		evt->m_strUid = m_strUid;
		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	uint32_t m_uid;
	std::string m_strUid;
};

class QTransCallYYSdkUserAppMsgData
: public IMediaEvent
{
public:
	QTransCallYYSdkUserAppMsgData()
	{
		m_type = MET_CALLBACK_LIVE_USER_APP_MSG_DATA;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkUserAppMsgData* evt = new QTransCallYYSdkUserAppMsgData();
		evt->m_bDup = true;
		evt->m_msgData = m_msgData;
		evt->m_uid64bit = m_uid64bit;
		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	std::string m_msgData;
	uint64_t m_uid64bit;
};

class QTransCallYYSdkAppMsgDataFailedStatus
: public IMediaEvent
{
public:
	QTransCallYYSdkAppMsgDataFailedStatus()
	: m_failedStatus(0)
	{
		m_type = MET_CALLBACK_LIVE_APP_MSG_DATA_FAILED_STATUS;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkAppMsgDataFailedStatus* evt = new QTransCallYYSdkAppMsgDataFailedStatus();
		evt->m_bDup = true;
		evt->m_failedStatus = m_failedStatus;
		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	uint32_t m_failedStatus;

	enum
	{
		HIGHT_FREQUENCY		= 1,		//����Ƶ��̫�ߣ�ÿ�벻����2��
		LARGE_MSG_DATA		= 2,		//ÿ�η�������̫��ÿ�β��ܳ���200Byte
		NO_PUBLISH_SUCCESS	= 3,		//δ�ɹ�����
	};
};


class QTransCallYYSdkPublisherLossNotify : public IMediaEvent
{
public:
	QTransCallYYSdkPublisherLossNotify()
		: m_appid(0)
		, m_result(0)
	{
		m_type = MET_CALLBACK_LIVE_PUBLISH_LOSS_NOTIFY;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkPublisherLossNotify* evt = new QTransCallYYSdkPublisherLossNotify();
		evt->m_bDup = true;
		evt->m_appid = m_appid;
		evt->m_result = m_result;
		return evt;
	}

	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	uint32_t m_appid;
	uint32_t m_result;
};

class QTransCallYYSdkPublishChannelStatus : public IMediaEvent
{
public:
	QTransCallYYSdkPublishChannelStatus()
	: m_appid(0)
	, m_result(0)
	{
		m_type = MET_CALLBACK_LIVE_PUBLISH_CHANNEL_STATUS;
	}

	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkPublishChannelStatus* evt = new QTransCallYYSdkPublishChannelStatus();
		evt->m_bDup = true;
		evt->m_appid = this->m_appid;
		evt->m_channelId = this->m_channelId;
		evt->m_result = this->m_result;
		return evt;
	}
	
	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}

	uint32_t m_appid;
	std::string m_channelId;
	uint32_t m_result;
};

class QTransCallYYSdkPublishChannelStreamInfo : public IMediaEvent
{
public:
	QTransCallYYSdkPublishChannelStreamInfo()
	: m_appid(0)
	{
		m_type = MET_CALLBACK_LIVE_PUBLISH_CHANNEL_STREAM_INFO;
	}
	
	virtual IMediaEvent* createDup()
	{
		QTransCallYYSdkPublishChannelStreamInfo* evt = new QTransCallYYSdkPublishChannelStreamInfo();
		evt->m_bDup = true;
		evt->m_appid = this->m_appid;
		evt->m_channelId = this->m_channelId;
		evt->m_streams.swap(this->m_streams);
		return evt;
	}
	
	virtual void deleteDup()
	{
		if (!this->m_bDup)
		{
			return;
		}
		delete this;
	}
	
	uint32_t m_appid;
	std::string m_channelId;
	std::map<std::string, std::map<uint32_t, uint32_t>> m_streams;
};

class QTransCallYYSdkPublishRealBitrate : public IMediaEvent
{
public:
    QTransCallYYSdkPublishRealBitrate()
    : m_bitrate(0)
    {
        m_type = MET_CALLBACK_LIVE_PUBLISH_REAL_BITRATE;
    }

    virtual IMediaEvent* createDup()
    {
        QTransCallYYSdkPublishRealBitrate* evt = new QTransCallYYSdkPublishRealBitrate();
        evt->m_bDup = true;
        evt->m_bitrate = this->m_bitrate;
        return evt;
    }

    virtual void deleteDup()
    {
        if (!this->m_bDup) {
            return;
        }
        delete this;
    }

    uint32_t m_bitrate;
};
