#pragma once
// 该文件会被欢聚云以及yysdk同时导出

// MediaLibrary Video Codec
#define VIDEO_CODEC_UNKNOWN	0
#define VIDEO_CODEC_PICTURE	1
#define VIDEO_CODEC_H264	2
#define VIDEO_CODEC_VP8		4
#define VIDEO_CODEC_H265	5

// YY NET CODEC
#define NET_UNKNOWN_CODEC		-1000
#define NET_AACPLUS				1		//HE-AAC-V2 44.1KHz stereo
#define NET_AMRWB				3
#define NET_SILK_16K			2
#define NET_SILK_24K			22
#define NET_AAC_128K			35		//LC-AAC 44.1KHz stereo
#define NET_AAC_160K			36
#define NET_AAC_192K			37
#define NET_AAC_ELD				38
#define NET_AAC_ELD_SBR			39
#define NET_AAC_48K_STEREO      40
#define NET_AAC_44K_MONO        41
#define NET_AAC_48K_MONO        42
#define NET_AAC_ELD_16Khz_MONO  43    // for connect mic
#define NET_AAC_ELD_32Khz_MONO  44    // for connect mic
#define NET_AAC_64K_MONO        45
#define NET_AAC_HEV1_48K        46
#define NET_OPUS_16KHZ			50 
#define NET_OPUS_48KHZ			51
#define NET_OPUS_COMMON			52
#define NET_SPEEX_MODE_8		0
#define NET_SPEEX_MODE_4		21
#define NET_SPEEX_MODE_2		23
#define NET_VIDEO_H264			2000
#define NET_VIDEO_VP8			2001
#define NET_VIDEO_H265			2002
#define NET_PHONE_1ON1_PROTO	98

enum LoginModle
{
	LOGIN_MODULE_CHANNEL												= 0,
	LOGIN_MODULE_LOWLATENCY												= 1,	//lowlatency mode,maybe 1 v n.
	LOGIN_MODULE_LOWLATENCY_1V1											= 2,	//lowlatency and just 1v1.
};

// 从java层传下来的view相关事件
enum ViewNotifyEvent
{
	VNE_START		= 0,
	VNE_END			= 1,
	VNE_PAUSE		= 2,
	VNE_RESUME		= 3,
	VNE_EXIT		= (unsigned int)-1,
};

//AVRecorder Quality/InitData/Message/Message Param
enum MediaLibraryAVRecorderMediaQualityLevel
{
	kMediaLibraryAVRecorderMediaQualityLow								= 0,
	kMediaLibraryAVRecorderMediaQualityMedium							= 1,
	kMediaLibraryAVRecorderMediaQualityHigh								= 2,		//silk	NET_SILK_16K == 2
	kMediaLibraryAVRecorderMediaQualityHighest							= 3,
	kMediaLibraryAVRecorderMediaQualityCustom							= 4,
	kMediaLibraryAVRecorderMediaQualityMusic							= 5,		//aac	NET_AACPLUS == 1
	kMediaLibraryAVRecorderMediaQualityHDVoip							= 6,
	kMediaLibraryAVRecorderMediaQualityMusicHigh						= 7,
	kMediaLibraryAVRecorderMediaQualityMusicLowDelay					= 8,		//eld	NET_AAC_ELD == 38
	kMediaLibraryAVRecorderMediaQualityMusicLowDelaySBR					= 9,
};

// yysdk配置参数
enum YYConfigKey
{
	ACK_MIN_BUFFER														= 101,
	IS_VOICE_PROCESSING													= 102,
	ACK_QUALITY															= 103,
	AUDIO_ENCODE_QUALITY												= 105,
	AUDIO_MODE															= 106,
	AUDIO_LOW_FLOW_MODE													= 107,
	AUDIO_FADEIN_TIME_MS												= 108,

	VCK_MIN_BUFFER														= 201,
	VCK_QUALITY															= 202,
	VCK_MIN_CODE_RATE													= 203,
	VCK_MAX_CODE_RATE													= 204,
	VCK_TOTAL_CODE_RATE													= 206,
	VCK_AUTO_SUBSCRIBE_STREAM											= 208,	// 是否进频道就默认订阅视频流 1 -> 是 0 -> 否(默认)

	CCK_PREFER_BITRATE													= 301,	// 期待播放的码率
	CCK_HARDWARE_DECODE													= 302,	// 是否打开硬解开关，1是 0否
//	CCK_ENABLE_FASTPLAY_HIGHT_QUALITY_MODE								= 303,	// 启动快速接入连贯播放模式, 1启动 0不启动 //注意:废弃掉该app控制开关,老版本该开关关闭,新版本采用新开关CCK_ENABLE_FASTPLAY_HIGHT_QUALITY_MODE_NEW.
	CCK_ANDROID_HARD_DECODE_CRASH										= 304,	// 安卓硬解是否崩溃 1 崩溃 0 - 不崩溃
	CCK_APPLICATION_TYPE												= 305,	// according to applicationType
	CCK_ENABLE_NOTIFY_PICTURE_DATA										= 306,	// hello分支占坑用，避免每次merge conflict
	CCK_ENABLE_LOWLATENCY_MODE											= 307,	// 是否打开低延迟模式:1-是,0-否.(对音视频同时起作用)
	CCK_HARDWARE_ENCODE													= 308,	// 是否打开硬编码开关，1是 0否
	CCK_ENABLE_FLV_MODE													= 309,	// 是否打开FLV模式，1是 0否
	//CCK_MIN_CODE_RATE													= 310,	// 业务设置单路视频上行最小码率(废弃)
	CCK_MAX_CODE_RATE													= 311,	// 业务设置单路视频上行最大码率
	CCK_CUR_CODE_RATE													= 312,	// 业务设置单路视频上行起始码率
	CCK_TOTAL_CODE_RATE													= 313,	// 业务设置多路视频上行总码率
	CCK_USE_CRCONTROL													= 314,	// 业务设置是否使用上行码率控制
	CCK_ENABLE_P2P_MODE													= 315,	// 是否允许p2p传输, 默认允许
	CCK_H265_HARDWARE_DECODE											= 316,	// 是否允许H265硬件解码, 0 - 不允许  1 - 允许
	CCK_H265_HARDWARE_ENCODE											= 317,	// 是否允许H265硬件编码, 0 - 不允许  1 - 允许
	CCK_AUDIO_KEYFRAME_FLAG												= 318,	// 是否允许音频关键帧识别, 0 - 不允许  1 - 允许
																				// 只用于demon配置方便测试,app业务不需要本地配置,由服务器统一配置.
	CCK_ENABLE_FDK_AAC_DECODE											= 319,	// 是否开启FDK AAC解码, 0 - 不开启 1 - 开启
	CCK_JOIN_FETCH_ENABLE												= 320,	// 是否允许加入频道的同时发送获取前端请求
	CCK_DEFAULT_CAMERA													= 330,	// 初始启动摄像头，默认为前置摄像头
	CCK_CAPTURE_VIDEO_ORIENTATION										= 331,	// 视频采集的朝向
	CCK_CAMERA_STABILIZATION											= 332,	// 是否允许光学防抖，建议iPhone 6s+
	CCK_ENABLE_FASTPLAY_HIGHT_QUALITY_MODE_NEW 							= 333,	// 启动快速接入连贯播放模式, 1启动 0不启动
																				// 注意:CCK_ENABLE_FASTPLAY_HIGHT_QUALITY_MODE的新开关.
	CCK_PREFER_CROP_VIDEO												= 334,	// 进频道时，是否优先观看竖屏视频档位，0-不看 1-看
	CCK_IS_VIP_USER														= 335,	// 是否vip用户 0 否 1 是
	CCK_PUBLISH_NEED_MIX												= 336,	// 开播视频是否需要跟观看视频混音, 0-否 1-是
	CCK_ENABLE_RTMP_RECORDER											= 337,	// 录制rtmp解说流
	CCK_VIDEO_ENCODER_TYPE												= 338,	// 编码类型,见enum VideoEncoderType
	CCK_BROCAST_META_DATA_NOW											= 339,	// 是否马上广播metaData信息，0 否 1 是(这个配置在sdk不会被保存,只是触发发广播)
	CCK_JOIN_LOCAL_MEDIA												= 340,	// 媒体进频道但是不获取前端地址，不登录媒体前端
	CCK_LOW_DELAY_MIN_BUFFER											= 341,	// 低延时模式minbuffer（非必填项），业务不设置时传输根据网络情况调整
	CCK_PREFER_SYNC_MIN_BUFFER											= 342,	// 强同步模式下最小缓冲(单位ms)
	CCK_PREFER_SYNC_MAX_BUFFER											= 343,	// 强同步模式下最大缓冲(单位ms)
	CCK_APP_LOWLATE														= 344,	// 频道内业务低延时模式，0-非低延时 1-低延时 退频道前业务设置为0
	CCK_IS_CAPTURE_SCREEN												= 345,	// 是否抓屏开播 0 否 1 是，默认0
	
	CCK_OMX_DECODE														= 351,
	CCK_VOD_HARDWARE_DECODE												= 361,	//点播硬解开关 1硬解 0软解， 不设置则采用直播设置
	
	CCK_GET_AVP_METHOD													= 500,	//获取前端的方式：1->http 0->ap
};

enum CameraType
{
	CAMERA_TYPE_BACK													= 0,
	CAMERA_TYPE_FRONT													= 1,
};

enum VideoQualityMode
{
	VIDEO_QUALITY_LOW													= 0,
	VIDEO_QUALITY_MEDIUM												= 1,
	VIDEO_QUALITY_HIGHT													= 2,
	VIDEO_QUALITY_UNKNOW												= 3,
	VIDEO_QUALITY_CUSTOM												= 4,
};

enum VideoEncodePreset
{
	VIDEO_ENCODE_PRESET_DEFAULT											= 0,
	VIDEO_ENCODE_PRESET_ULTRAFAST										= 1,
	VIDEO_ENCODE_PRESET_SUPERFAST										= 2,
	VIDEO_ENCODE_PRESET_VERYFAST										= 3,
	VIDEO_ENCODE_PRESET_FASTER											= 4,
	VIDEO_ENCODE_PRESET_FAST											= 5,
	VIDEO_ENCODE_PRESET_MEDIUM											= 6,
	VIDEO_ENCODE_PRESET_SLOW											= 7,
};

enum AudioQualityMode
{
	AUDIO_QUALITY_LOW													= 0,
	AUDIO_QUALITY_MEDIUM												= 1,
	AUDIO_QUALITY_HIGHT													= 2,
	AUDIO_QUALITY_UNKNOW												= 3,
	AUDIO_QUALITY_CUSTOM												= 4,
	AUDIO_QUALITY_MUSIC													= 5,
};

enum VideoCapturePreset
{
    VIDEO_CAPTURE_PRESET_AUTO = 0,
    VIDEO_CAPTURE_PRESET_352x288,
    VIDEO_CAPTURE_PRESET_640x480,
    VIDEO_CAPTURE_PRESET_960x540,
    VIDEO_CAPTURE_PRESET_1280x720,
    VIDEO_CAPTURE_PRESET_1920x1080,
};

enum YCExtraMetaDataId
{
	// [80, 95] 预留给应用层设置
	YC_PUBLISHER_APP_RESERVE1											= 80,	// APP设置预留1
	YC_PUBLISHER_APP_RESERVE2											= 81,	// APP设置预留2
	YC_PUBLISHER_APP_RESERVE3											= 82,	// APP设置预留3
	YC_PUBLISHER_APP_RESERVE4											= 83,	// APP设置预留4
	YC_PUBLISHER_APP_RESERVE5											= 84,	// APP设置预留5
	YC_PUBLISHER_APP_RESERVE6											= 85,	// APP设置预留6
	YC_PUBLISHER_APP_RESERVE7											= 86,	// APP设置预留7
	YC_PUBLISHER_APP_RESERVE8											= 87,	// APP设置预留8
	YC_PUBLISHER_APP_RESERVE9											= 88,	// APP设置预留9
	YC_PUBLISHER_APP_RESERVE10											= 89,	// APP设置预留10
	YC_PUBLISHER_APP_RESERVE11											= 90,	// APP设置预留11
	YC_PUBLISHER_APP_RESERVE12											= 91,	// APP设置预留12
	YC_PUBLISHER_APP_RESERVE13											= 92,	// APP设置预留13
	YC_PUBLISHER_APP_RESERVE14											= 93,	// APP设置预留14
	YC_PUBLISHER_APP_RESERVE15											= 94,	// APP设置预留15
	YC_PUBLISHER_APP_RESERVE16											= 95,	// APP设置预留16
	
	YC_PUBLISHER_RESERVE_META7											= 96,	// 预留7
	YC_PUBLISHER_RESERVE_META6											= 97,	// 预留6
	YC_PUBLISHER_RESERVE_META5											= 98,	// 预留5
	YC_PUBLISHER_RESERVE_META4											= 99,	// 预留4
	
	YC_PUBLISHER_MC_POS													= 100,	// value = 0（首麦），
																				// value = 1（被连麦）
	YC_PUBLISHER_CODERATE_TYPE											= 101,	// value = 0（兼容旧版本），
																				// value = 1（给快男pc端看的），
																				// value = 2（给快男web/mobile看的），
																				// value = 3（给快男所有平台看的）
	YC_PUBLISHER_RESERVE_META1											= 102,	// 预留1
	YC_PUBLISHER_RESERVE_META2											= 103,	// 预留2
	YC_PUBLISHER_RESERVE_META3											= 104,	// 预留3
	YC_SERVER_TRANSCODE													= 105,	// 服务器转码
};

//app只能使用以下已有的key，如果确定要增加，需要征得sdk同事同意之后再增加，避免key冲突
enum MetaDataInfoId
{
	// 客户端使用字段使用字段 客户端用80以内的字段
	PUBLISHER_CUR_BIT_RATE												= 7,
	PUBLISHER_MIN_BIT_RATE												= 8,
	PUBLISHER_MAX_BIT_RATE												= 9,
	PUBLISHER_TOTAL_BIT_RATE											= 10,
	PUBLISHER_RESOLUTION												= 11,
	PUBLISHER_FRAME_RATE												= 12,
	PUBLISHER_SUBSTREAM_NUM												= 13,
	PUBLISHER_MIN_PEER_NODE_NUM											= 14,
	PUBLISHER_MAX_PEER_NODE_NUM											= 15,
	PUBLISHER_START_PUBLISH_TIME										= 16,
	PUBLISHER_PUBLISHING_TIME											= 17,	// 仅仅客户端本地使用，不会同步给服务器或者其他客户端
	PUBLISHER_VIDEOSDK_VER												= 31,
	PUBLISHER_CAP_SRC_RESELUTION_RATIO									= 32,
	PUBLISHER_CAP_ENC_INFO												= 33,
	PUBLISHER_CAP_ENC_INFO_EX											= 34,
	PUBLISHER_HIGH_DELAY												= 35,
	PUBLISHER_TOP_SID													= 36,
	PUBLISHER_CAP_ENC_INFO_PLUS											= 37,
	PUBLISHER_MY_MAX_BIT_RATE											= 38,
	PUBLISHER_APP_TYPE													= 39,
	PUBLISHER_PUBLISH_ID												= 40,
	PUBLISHER_RESEND_JITTER												= 41,
	PUBLISHER_CLIENT_TYPE												= 42,	// PC 0 web 1 安卓 2 ios 3
	PUBLISHER_SECRET_KEY												= 43,	// key for PStreamData3 check sum
	PUBLISER_MULTICODERATE_SEND_FRAME_JITTER							= 45,	// 周期内转码服务器发送转码帧的最大间隔
	PUBLISHER_ENCODE_TYPE												= 46,	// 编码类型
	PUBLISHER_CHANNEL_TYPE												= 47,	// 类型见enum VideoChannelType || PUBLISHER_IS_TRANCODE_STREAM
	PUBLISHER_IS_CROP_STREAM											= 49,	// 是否是横竖屏流
	PUBLISHER_COPY_STREAM_FROM_CHANNEL									= 50,	// 新广播下表示转发档视频的来源档位
	PUBLISHER_AUDIO_GROUP												= 51,	// 视频流对应的音频多播组
	PUBLISHER_VIDEO_LINE_ID												= 52,	// 视频线路ID
	PUBLISHER_AUDIO_SHQ													= 53,	// 是否超高音质开播
	PUBLISHER_METADATA_VER												= 54,	// 主播metaData版本号，从1开始，每次变化+1
	PUBLISHER_SUPPORT_SPECIAL_RTMP										= 55,	// 携带特殊标识的RTMP上行，能够使用与主播相同的uid观看音视频

	// app使用字段 [80, 105] [111]预留给应用层设置
	PUBLISHER_APP_RESERVE1												= 80,	// APP设置预留1
	PUBLISHER_APP_RESERVE2												= 81,	// APP设置预留2
	PUBLISHER_APP_RESERVE3												= 82,	// APP设置预留3
	PUBLISHER_APP_RESERVE4												= 83,	// APP设置预留4
	PUBLISHER_APP_RESERVE5												= 84,	// APP设置预留5
	PUBLISHER_APP_RESERVE6												= 85,	// APP设置预留6
	PUBLISHER_APP_RESERVE7												= 86,	// APP设置预留7
	PUBLISHER_APP_RESERVE8												= 87,	// APP设置预留8
	PUBLISHER_APP_RESERVE9												= 88,	// APP设置预留9
	PUBLISHER_APP_RESERVE10												= 89,	// APP设置预留10
	PUBLISHER_APP_RESERVE11												= 90,	// APP设置预留11
	PUBLISHER_APP_RESERVE12												= 91,	// 3人竞技场
	PUBLISHER_APP_RESERVE13												= 92,	// 双摄
	PUBLISHER_APP_RESERVE14												= 93,	// 电影开播(pc)
	PUBLISHER_APP_RESERVE15												= 94,	// APP设置预留15
	PUBLISHER_APP_RESERVE16												= 95,	// APP设置预留16

	PUBLISHER_RESERVE_META7												= 96,	// 预留7
	PUBLISHER_RESERVE_META6												= 97,	// 预留6
	PUBLISHER_RESERVE_META5												= 98,	// 预留5
	PUBLISHER_RESERVE_META4												= 99,	// 预留4

	PUBLISHER_MC_POS													= 100,	// value = 0（首麦），value = 1（被连麦）
	PUBLISHER_CODERATE_TYPE												= 101,	// value = 0（兼容旧版本）
																				// value = 1（给快男pc端看的)
																				// value = 2（给快男web/mobile看的），
																				// value = 3（给快男所有平台看的）
	PUBLISHER_RESERVE_META1												= 102,	// 预留1
	PUBLISHER_RESERVE_META2												= 103,	// 预留2
	PUBLISHER_RESERVE_META3												= 104,	// 预留3
	SERVER_TRANSCODE													= 105,	// 服务器转码
	SERVER_TRANSCODE_TRANS_LEVEL										= 111,	// 由业务指定的转码的档位

	// 服务器使用字段，后续客户端使用字段需要小于100
	SERVER_VALID_TRANSCODE												= 106,	// 由主播前端填写，转码成功（收到TC节点的转码数据）值为1
	SERVER_TRANSCODE_STOPPED											= 107,	// 转码停止，用于源码流通知转码流视频转码已停止
	SERVER_ORI_STREAM_ID_STAMP											= 108,	// 填在转码流的Notify中，记录原码流的StreamId的低32位，与转码流的uid可组成原码流的Streamid
	SERVER_TRANS_CODE_TYPE_3_SUPPORT									= 109,	// 原码流是否已转码1200K的码流，主要用于升级时的过渡，后面会删除
	SERVER_TRANS_CODE_ORI_STREAM_CODE_RATE								= 110,	// 原码UserGroup的totalCodeRate
	//SERVER_TRANSCODE_TRANS_LEVEL										= 111,	//由业务指定的转码的档位
	SERVER_H265_STREAM													= 112,	// 标识该流为H265流
	SERVER_FASTACCESS_MODE												= 113,	// 视频快速接入包的获取方式，1表示客户端自己拉 2表示服务器直接推
	SERVER_FASTACCESS_FIRST_SEQ											= 114,	// 快速接入包最小值，仅在SERVER_FASTACCESS_MODE为1时起作用[first, last]
	SERVER_FASTACCESS_LAST_SEQ											= 115,	// 快速接入包最大值，仅在SERVER_FASTACCESS_MODE为1时起作用[first, last]
	SERVER_FASTACCESS_FIRST_DTS											= 117,	// 快速接入最小帧对应的采集时间，-1表示无效
	SERVER_FASTACCESS_LAST_DTS											= 118,	// 快速接入最大帧对应的采集时间，-1表示无效
	SERVER_STREAM_TYPE													= 200,
	ORI_STREAM_TIMESTAMP												= 201,
	USER_RESEND_LIMIT													= 202,	// 用户维度的重传上限，由服务器填写通知客户端

	PUBLISHER_STREAM_ALIVE												= -1,
};

#if 0
enum ConfigEnum
{
	//FORCE_TCP															= 0,	// default 0
	//UDP_RESEND_TIMES													= 1,	// default 1
	//UDP_RESEND_INTERVAL1												= 2,	// default 3
	//UDP_RESEND_INTERVAL2												= 3,	// default 3
	//UDP_ACTIVE_RESEND_LIMIT											= 4,	// default 400
	//VIDEO_RATE_DOWN_1													= 7,	// default 600
	//VIDEO_RATE_DOWN_2													= 8,	// default 300
	//VIDEO_RATE_UP														= 9,	// default 2000
	//VIDEO_INIT_RATE													= 10,	// default 100
	//VIDEO_ACTIVE_RESEND_TIME_LIMIT									= 12,	// default 800
	VIDEO_QUALITY_MAX_CAPACITY											= 14,	// default 90
	VIDEO_QUALITY_OVERCAP_TOLERATE										= 15,	// default 10
	VIDEO_QUALITY_CAP_EXPECTATION										= 16,	// default 50
	HD_VIDEO_INIT_RATE													= 17,	// default 300
	SUPPORT_P2P															= 22,	// default 0, 0 : not support p2p mode, else support p2p mode
	//P2P_UPLINK_MAX_LIMIT												= 23,	// default 0
	//P2P_UPLINK_MIN_LIMIT												= 24,	// default 0
	P2P_VERSION															= 25,	// default 0, proxy not support p2p; bigger than 0 proxy support p2p version 1
	VIDEO_PROXY_VERSION													= 26,	// default 0:old version, 1:v2
	FORCE_RECONNECT_PROXY												= 27,	// default 0: nothing todo, x >0 : reconnect in (0-x)s
	
	HAS_CONFIGED_BY_PROXY												= 30,	// default 0: is this config available. Only for key 31 and 32.
	MIN_AVAIL_PEER_NUM													= 31,	// default 20: minimum available peer node numbers of p2p
	MAX_SUB_STREAM_NUM													= 32,	// default 10: subStream numbers of p2p
	OPEN_ONE_OFF_SUBSCRIBE												= 33,	// default 0
	// bigger than 0 proxy support one off subscribe
	// bigger than 1 proxy support subscribe cycle detect
	VIDEO_CENTER_GROUP_ID												= 34,	// videoGroupId;
	CLIENT_AREA_TYPE													= 35,	// 客户端所在分区
	MASTER_PROXY_AREA													= 36,	// 主视频前端分区
	SLAVE_PROXY_AREA													= 37,	// 从视频前端分区
	USING_VBR_ENCODE													= 38,	// default 0: using vbr encode
	USING_VAR_SEND_INTERVAL												= 39,	// default 1: using variable send interval
	//MAX_SEND_DELAY													= 40,	// default 1800: max delay of sending
	//MIN_SEND_DELAY													= 41,	// default 1000: min delay of sending
	HD_VIDEO_PLAY_DELAY													= 42,	// default 4000: hd video play delay, set 0 to turn off the switch
	SEND_INTERVAL_REDUNDANCE											= 43,	// default 15: the delta for send interval
	USING_SMOOTH_ENCODE													= 44,	// default 0: using smooth encode pattern
	LD_VIDEO_BIT_RATE													= 45,	// default 0: LD code rate configed by video proxy
	MOB_P2P_PUNCH														= 46,	// 手机p2p打洞开关default 0
	MOB_P2P_DATAFLOW													= 47,	// 手机p2p数据交互开关default 0
	LD_VIDEO_PLAY_DELAY													= 48,	// default 1000: ld video play delay, set 0 to turn off the switch
	HD_VIDEO_BIT_RATE													= 49,	// default 0: HD code rate configed by video proxy
	SUPPORT_CHECK_SUM													= 50,	// default 0: 0 not support, 1 support
	SUPPORT_MERGE_RESEND												= 51,	// default 0: 0 not support, 1 support
	DOWNLINK_RESEND_TIMES												= 52,	// default 0 下行重传上限。旧重传限制，已经被废弃
	//SUPPORT_TCP_DOWNLINK_RESEND										= 53,	// default 0: 0 not support, 1 support
	MERGE_RESEND_MAX_NUM												= 54,	// default 0: not config by proxy, else set the max num that merge resend at a time
	USING_SMOOTH_UPLINK_RESEND											= 55,	// default 0: 0 not using
	USING_SMOOTH_DOWNLINK_RESEND										= 57,	// default 0: 0 not using，服务器也会作为gap size使用
	//UPLOAD_STRATEGY													= 58,	// 上传重传策略, default 0
	//DOWNLOAD_STRATEGY													= 59,	// 下行重传策略, default 0
	//OPEN_DEBUG_LOG													= 60,	// default = 0, not open
	LOW_LATENCY_MODE													= 61,	// default = 0, not open
	PING_MACHINE_ROOM													= 62,	// default = 0, not ping
	SUPPORT_NEW_YY_CHANNEL												= 63,	// default 0: 0 not support, 1 support
	VIDEO_PAYLOAD_SIZE													= 64,	// default = 0, not open
	MULTI_TEST_SWITCH													= 65,	// default = 0, decode force resend (1 << 0),
	//				dynamic external jitter (1 << 1),
	//				recv jitter (1 << 2),
	//				double send speed(1 << 3),
	//				zero latency encode (1 << 4),
	//				external jitter (1 << 5),
	//				first downlink rto (1 << 6)
	//				judge udp link ping timeout (1 << 7)
	//				support delay send (1 << 17)
	//				open lanP2p(1 << 18)
	//				open vp user resend limit(1 << 31)
	FIRST_UPLINK_RTO_PARA												= 66,	// default = 0
	NEXT_UPLINK_RTO_PARA												= 67,	// default = 0
	NEXT_DOWNLINK_RTO_PARA												= 68,	// default = 0
	SYNC_ALL_AUDIO_NOT_PUBLISHER										= 70,	// default = 0 : 0 not support, 1 support
	SUPPORT_READ_INNER_AUDIO_FRAME										= 71,	// default = 1 : 0 not support, 1 support
	FAST_ACCESS_MIN_DOWNLINK_RTO										= 72,	// default = 20
	FAST_ACCESS_INCREASE_STEP											= 73,	// default = 5, [0,10]
	FAST_ACCESS_INCREASE_END_POINT										= 74,	// default = 60
	FAST_ACCESS_DECREASE_START_POINT									= 75,	// default = 200
	SUPPORT_PUBLISHER_SWITCH_PROXY										= 77,	// default = 0 : 0 not support, 1 support
	PUBLISHER_SWITCH_PROXY_PARA											= 78,	// default = 663042 (minSwitchRtt << 16 | minSwitchPercentage << 8 | switchPara) : minSwitchRtt = 10ms, minSwitchPercentage = 30%, switchPara = 0x02
	SWITCH_PROXY_INTERVAL												= 79,	// default = 300 (单位: 秒)
	SWITCH_PROXY_HISTORY_DATA_NUM										= 80,	// default = 5
	USING_EARLY_DECODE_VIDEO											= 81,	// default = 0 :0 not using, 1 using
	FIRST_DOWNLINK_RTO_LIMIT											= 82,	// 首次下行重传rto上限
	NEXT_DOWNLINK_RTO_LIMIT												= 83,	// 非首次下行重传rto上限
	UPLINK_RTO_LIMIT													= 84,	// 上行重传rto上限
	TWENTY_SECOND_DOWNLINK_RESEND_LIMIT									= 85,	// 20s下行请求重传上限，区别于DOWNLINK_RESEND_TIMES，是无条件执行
	ONE_SECOND_DOWNLINK_RESEND_LIMIT									= 86,	// 1s下行请求重传上限
	MAX_SEQ_GAP_SIZE													= 87,	// 最大乱序区间大小，如果乱序超过此区间，则不重传
	SEND_ONE_FRAME_CONSUMING_TIME										= 88,	// 每个帧控制在key SEND_ONE_FRAME_CONSUMING_TIME对应的value内完成第一次发送
	DOWNLINK_DOUBLE_RESEND_TIMES_THRESHOLD								= 89,	// 双份重传阀值，当重传次数超过该阀值就启动双份重传，配合MULTI_TEST_SWITCH isEnhanceDoubleResend使用
	MULTI_TEST_SWITCH_2													= 90,	// 作用与MULTI_TEST_SWITCH相同
	// (1 << 0) -> ext recvStauts
	// (1 << 1) -> 观众端是否考虑主播的resendJitter default 0
	// (1 << 2) -> 主播端是否使用ack可变步长
	// (1 << 3) -> 是否支持检查异常的音频帧采集时间戳 default 0
	// (1 << 4) -> 是否支持改变视频频道属性 default 0
	// (1 << 5) -> 是否支持音频快速接入 default 0
	// (1 << 6) -> 是否支持PStreamData3端到端的校验和
	// (1 << 7) -> 是否支持可用带宽评估 default 0
	// (1 << 8) -> 是否支持渲染抖动缓冲 1 - 支持 0 - 不支持(default)
	// (1 << 9) -> 是否支持链路评分确定打开fec 1 - 支持 0 - 不支持(default)
	// (1 << 10) -> 是否支持主播间低延时 1 - 支持 0 - 不支持(default)
	// (1 << 11) -> 是否支持WEBRTC方式分配可用带宽 1 - 支持 0 - 不支持(default)
	// (1 << 12) -> 是否支持观众间低延时 1 - 支持 0 - 不支持(default)
	// (1 << 13) -> 是否支持视频快速接入合并重传 0 不支持(default) 1 - 支持
	// (1 << 14) -> 是否支持高码率发送
	// (1 << 15) -> 是否支持主动丢帧
	// (1 << 16) -> 是否支持手机端可用带宽评估 1 支持 0 不支持(default)
	// (1 << 17) -> 是否禁止新方式通知app视频流状态
	// (1 << 18) -> 是否使用实际帧率作为带宽评估的调整标准
	// (1 << 19) -> 是否根据音频播放器的缓冲大小来进行音视频同步
	// (1 << 20) -> 是否启动快速接入连贯播放模式(快速接入阶段就同步)
	// (1 << 21) -> 是否打开多人同步功能
	// (1 << 22) -> 是否打开音视频同步砍掉缓冲.
	// (1 << 23) -> 低延时模式是否进行音视频同步 0不同步，1同步
	// (1 << 25) -> 是否打开基于带宽预测的上行流控
	// (1 << 26) -> 是否支持跨频道转发 1 支持 0 不支持
	// (1 << 27) -> 在合流模式下，服务器是否支持计算音频包的带宽
	// (1 << 28) -> 是否开启多路视频同步功能(1: 打开; 0: 关闭; 默认关闭
	// (1 << 29) -> 是否开启用户网络检测
	// (1 << 30) -> 是否打开LAN P2P连通率统计
	// (1 << 31) -> 是否支持cdn模式下连麦 1:支持; 0:不支持; default: 0
	
	FAST_ACCESS_MERGE_RESEND_MAX_NUM									= 91,	// 快速接入最大合并重传包数 default 0
	HAIDO_CONNECT_MODE_SWITCH											= 92,	// 上送海度平台连接方式default = 0 【0:短连接;1:长连接】
	MOB_HAIDO_CONNECT_MODE_SWITCH										= 93,	// 上送海度平台连接方式default = 0 【0:短连接;1:长连接】
	MOB_MULTI_TEST_SWITCH_1												= 94,	// (1 << 0) -> 是否打开上行流控开关 0 表示关闭 1 表示打开 默认关闭
	// (1 << 1) -> 是否禁止开播连麦时低延时编码 0 表示 不禁止 1 表示禁止 默认0
	// (1 << 2) -> 是否允许发送视频补偿包
	// (1 << 3) -> 是否打开激进重传功能; 0 表示 不打开; 1 表示 打开; 默认 0
	// (1 << 4) -> 带宽上限未知时是否固定时间内完成单帧首次发送; 0 表示 不打开; 1 表示 打开; 默认 0
	// (1 << 5) -> 可用带宽很低时，是否禁止发送视频包; 0 表示 不禁止; 1 表示 禁止; 默认 0
	// (1 << 6) -> ios是否使用重构后的视频解码器(6.6版本使用，后继版本更新到bit 9，与sdk版本号(key 136)共同决定是否打开)
	// (1 << 7) -> 当视频发送流量小于可用带宽的2/3时, 并且总出口流量达到可用带宽时, 是否禁止发送视频包; 0 表示 不禁止; 1 表示 禁止; 默认 0
	// (1 << 8) -> android端是否使用重构后的视频解码器
	// (1 << 9) -> ios是否使用重构后的视频解码器，与sdk版本号(key 136)共同决定是否打开
	// (1 << 10) -> 是否允许根据历史音频发送流量分配音频带宽， 0 表示不允许, 1表示允许, 默认不允许
	// (1 << 11) -> 是否禁用弱网连麦优化功能: 0 表示不禁用 1 表示禁用 默认 0
	// (1 << 12) -> 是否打开多人音视频cut buffer 功能: 0 表示启用, 其他表示禁用, 默认启用
	// (1 << 13) -> 是否关闭多人音视频同步时小延时用户尽量不向上靠拢，0 不关闭 1关闭，默认不关闭
	// (1 << 14) -> 是否禁用解码器分析的帧类型， 0：不禁用 1：禁用
	// (1 << 15) -> 是否禁用视频流畅性优化 0：不禁用 1：禁用 默认不禁用
	
	
	MOB_UP_FQ_DROP_PACKET_THRESHOLD										= 95,	// 上行流控flowQueue丢帧的门限, 高16位为低延时门限，低16位为非低延时门限, 单位ms, 默认(1500 << 16) + 3000
	MOB_UP_FQ_NOT_INCREASE_BITRATE_THRESHOLD							= 96,	// 上行流控flowQueue导致不能升码率的门限, 高16位为低延时门限，低16位为非低延时门限, 单位ms，默认(500 << 16) + 1000
	MOB_UP_FQ_DISABLE_FEC_THRESHOLD										= 97,	// 上行流控flowQueue导致关闭FEC的门限, 高16位为低延时门限，低16位为非低延时门限, 单位ms，默认(300 << 16) + 500
	MOB_PUBLISH_MIN_BIT_RATE											= 98,	// 手机开播的最小码率, 单位kbps
	MULTI_TEST_SWITCH_3													= 99,	// 作用与MULTI_TEST_SWITCH相同
																				// (1 << 0) -> 是否使用旧的重传限制逻辑，默认关闭

	CODE_RATE_TYPE														= 101,	// 设置码率类型，默认是0
	SUPPORT_USE_HARDWARE												= 102,	// 设置是否支持硬解码，默认是1
	//	ENABLE_FASTPLAY_HIGHT_QUALITY_MODE									= 103,	// default = 1, 启动快速接入连贯播放模式(快速接入阶段就同步), 0表示disable
	
	ENABLE_UPLINK_EMULATE												= 104,	// default = 0, not support
	UPLINK_RANDOM_LOSS_RATE												= 105,	// default = 0
	UPLINK_RANDOM_MIN_DELAY												= 106,	// default = 0
	UPLINK_RANDOM_MAX_DELAY												= 107,	// default = 0
	ENABLE_DOWNLINK_EMULATE												= 108,	// default = 0, not support
	DOWNLINK_RANDOM_LOSS_RATE											= 109,	// default = 0
	DOWNLINK_RANDOM_MIN_DELAY											= 110,	// defalut = 0
	DOWNLINK_RANDOM_MAX_DELAY											= 111,	// defalut = 0
	UPLINK_RTO_HISTORY_NUM												= 112,	// defalut = 0, 预防上行rto突变时参考的历史值个数
	UPLINK_RESEND_JITTER_REDUNDANCY										= 113,	// default = 40, means 40% redundancy
	OUT_OF_STATUS_SEQ_SERIAL_SEND_TIMES									= 114,	// default = 1
	UPLINK_RSFEC_PARAM													= 115,	// default = 0, 默认关闭
	UPLINK_RSFEC_DELAY_THRESHOLD										= 116,	// default = 600
	UPLINK_RSFEC_INVALID_DELAY_TIMES									= 117,	// default = 3
	UPLINK_RSFEC_BAD_SCORE												= 118,	// default = 1000
	MOB_UPLINK_RSFEC_PARAM												= 119,	// default = 0, 默认关闭, 手机端fec参数设置
	UPLINK_UNACK_STAT_MAX_DELAY											= 120,	// default = 0
	NEW_MOB_P2P_DATAFLOW												= 121,	// default = 0
	//	AV_SYNC_AUDIO_EXTERANL_BUFFER										= 122,	// default = 0 默认关闭 安卓机器同步时是否考虑额外的音频buffer val值高16位为安卓5.0以上机器配置值 低16位为安卓5.0以下机器配置值
	MAX_FAST_ACCESS_INTERVAL											= 123,	// default = 5000 快速接入包序号区间范围
	//	ANDROID_P2P_MIN_API_LEVEL											= 124,	// default = 0 废弃
	ANDROID_P2P_MIN_API_LEVEL											= 125,	// default = 0 默认无视apilevel，否则只针对api level大于该配置的android手机才打开P2P
	KICK_PEER_THRESHOLD													= 126,	// default = 0 可用节点数大于多少，才开始踢人
	MERGE_LINK_REFETCH_PROXY_INTERVAL									= 129,	// default = 0 合流模式下重取视频前端间隔
	NOT_SYNC_AUDIO_IN_LOWDELAY											= 130,	// default = 0 默认关闭 是否在低延时下, 不同步音频包到vsdk
	SYNC_ALL_AUDIO_IN_VSDK												= 131,	// default = 0 : 0 not support; 是否在vsdk同步所有音频数据
	OPT_RESEND_HISTORYRTO_NUM											= 132,	// default = 100, 用于配置激进重传功能中, 历史rto数
	PC_MULTI_TEST_SWITCH_1												= 133,	// PC端专用开关，MOB端不要使用这个
	MOB_SEND_TO_ACK_DELAY_THRESHOLD										= 134,	// default = 26215400(= 400 << 16 | 1000) : 是否打开降低延时rsfec，低延时看高16位，普通模式看低16位
	MOB_LOW_BANDWIDTH_THRESHOLD											= 135,	// default = 19661300(= 300 << 16 | 500) : 降低延时rsfec打开时需要干预分配的最小带宽，低延时看高16位，普通模式看低16位
	SUPPORT_NEW_IOS_DECODER_MIN_SDK_VER									= 136,	// 支持ios新解码器yylive最低版本号，default = 0表示所有版本都支持；否则大于ver的版本号才支持
	MAX_JITTER_BUFFER_GATE												= 137,	// 配置最大抖动
	MIN_JITTER_BUFFER_GATE												= 138,	// 配置最小抖动，有可能覆盖业务设置的值
	AV_SYNC_OVER_MIN_JITTER												= 139,	// cut buffer时判断playbuffer和jitter的差值的阈值
	AV_SYNC_CUT_DOWN_INTERV												= 140,	// cut buffer时缓冲需要超过阈值的时间
	//AV_SYNC_AUDIO_EXTERANL_BUFFER_NEW									= 141,	// default = 0 默认关闭 安卓机器同步时是否考虑额外的音频buffer val值高16位为安卓5.0以上机器配置值 低16位为安卓5.0以下机器配置值
	AV_SYNC_AUDIO_EXTERANL_BUFFER_ANDROID								= 142,	// default = 3276900 默认关闭 安卓机器同步时是否考虑额外的音频buffer val值高16位为安卓5.0以上机器配置值 低16位为安卓5.0以下机器配置值
	AV_SYNC_AUDIO_EXTERANL_BUFFER_OPPO_VIVO								= 143,	// default = 19661000 默认关闭 oppo vivo同步时是否考虑额外的音频buffer oppo读高16位 vivo读低16位
	AV_SYNC_AUDIO_EXTERANL_BUFFER_XIAOMI_HUAWEI							= 144,	// default = 16384150 默认关闭 小米 华为同步时是否考虑额外的音频buffer 小米读高16位 华为读低16位
	CAPTURE_CAMERA_PTS_ADJUSTVAL_OPPO_VIVO								= 145,	// default = 0 默认关闭 oppo vivo主播端pts校正值，oppo读高16位，vivo读低16位(采集摄像头开播)
	CAPTURE_CAMERA_PTS_ADJUSTVAL_XIAOMI_HUWEI							= 146,	// default = 0 默认关闭 小米华为主播端pts校正值，小米读高16位，华为读低16位(采集摄像头开播)
	LOWLATE_IFRAME_MAX_SENDDELAY										= 147,	// default = 100 低延时模式下, 如果I评估出I帧从编码出来到发送完耗时超过该值, 则删掉流控队列中前面的帧
	/*
	 [148,255]是服务器专用的区间，客户端不可以使用!!!
	 SUPPORT_P2P															= 22
	 P2P_UPLINK_MAX_LIMIT												= 23
	 P2P_VERSION															= 25
	 P2P_VERSION_EQUAL_2_TURN_OFF										= 33
	 SUPPORT_CHECK_SUM													= 50
	 USING_BIG_CHANNLE_MODE												= 80
	 */
	
	WEBRTC_DELAY_CHECK_DIIF_VALUE										= 158,	// 服务器的传输延时差值滤波算法，比正常值大多少才算是异常值，默认100
	WEBRTC_DELAY_CHECK_MAX_HEAP_SIZE									= 159,	// 服务器的传输延时差值滤波算法，超过第几大的值，才判断是否为异常值
	PROXY_RESEND_GAP_SIZE												= 160,	// default 32, if server receive video pack which seq is size*step bigger than last one, no resend requst will be send
	REPEATER_SWITCH_ON													= 161,	// repeater开关
	RESEND_APP_FLOW_CONTROL												= 162,	// 前端与客户端间视频包重传的流控模式(业务重传流控)，0为旧的流控，大于0为新的流控
	RESEND_MACHINE_FLOW_CONTROL											= 163,	// 重传包是否进行机器流量的限制，0表示禁用,大于0的值为最低可用重传流量
	FLOW_CONTROL_LIMIT_QUICK_ACCESS										= 165,	// 是否限制每秒快速接入人数，0表示禁用，大于0的值为是每秒最大人数
	EXTEND_STREAMDATACK_ON												= 166,	// 前端支持主播ACK扩展开关
	VIDEO_LIVE_BROADCAST												= 167,	// 1 means, usergroup has live video broadcasting
	VIDEO_BYPASSPROXY_BROADCAST											= 168,
	TOTAL_CODERATE														= 169,	// total coderate of a usergroup
	TRANS_CODE_TYPE1													= 170,	// transcode video type 1
	TRANS_CODE_TYPE2													= 171,	// transcode video type 2
	HLS_USR_VALIDATION_ENABLED											= 172,
	HLS_USR_VALIDATE_MAGIC_KEY											= 173,	// for validating HLS requests
	FLV_USR_VALIDATION_ENABLED											= 174,
	FLV_GOP_CNT_FOR_NEW_USER											= 175,
	FLV_JUST_NEW_VIDEO_TAG												= 176,	// 给用户下发flvtag时是否仅允许从最新的flvtag开始
	FLV_DISABLE_PROXY_FAST_PUSH											= 177,	// 是否禁用前端间快速接入
	FLV_NO_USER_DELAY													= 178,	// 完全没用户之后，多久才变成notAlive，以便销毁掉usergroup不再接收视频数据
	FLV_SEND_METADATA													= 179,	// FLV下行是否发送metadata
	FLV_SPEED_FIRST_FRAMES												= 180,	// FLV初始数据下发量比较多时，是否快进一部分数据
	FLV_SPEED_REMAIN_TIME												= 181,	// FLV初始数据下发量比较多时,不快进的数据时长
	HLS_ADJUST_AUDIO_DTS_TYPE											= 182,	// HLS生成ts文件时是否调整音频dts, 1:只调整YY音频 2:调整rtmp音频 3:都调整
	IP_AREA_NEW_TXT														= 183,
	TRANS_CODE_CHECK_VALID_TRANSCODE_STREAM								= 184,	// 灰度升级用的开关，是否使用新的逻辑判断是否下发转码信息
	CHECK_FORCE_CONNECT_BLACK_LIST_DURATION								= 185,	// 一定时间内不听forceconnect调度的客户端，强行不允许重新连接回来
	TRANS_CODE_NORMAL_TC_TRANS_LIMIT									= 186,	// 普通类型软转码节点的转码CPU使用上限(0-100)
	TRANS_CODE_SPECIAL_TC_TRANS_LIMIT									= 187,	// 专用类型软转码节点的转码CPU使用上限(0-100)
	SAMEAREA_ALOCATE													= 190,	// 分区算法调整(0：主从前端不同分区；非0 主从前端同分区不同机房)
	NEW_GM_SWITCH_FLAG													= 188,	// UserGroup成员管理使用新GM或旧VC的开关，具体可选值见V3_2 GMManager.h
	CODE_RATE_ALLOCATION												= 191,	// 是否使用人数*码率的方式分配前端
	NORMAL_RESEND_RATIO													= 192,	// 普通观众分配的重传比例
	P2P_RESEND_RATIO													= 193,	// P2p观众分配的重传比例
	NO_VIDEO_RESEND_RATIO												= 194,	// 无视频（空连接）用户分配的重传比例
	XCRS_RECORD_SWITCH													= 195,	// send to new record
	CLOSE_WHITE_SPK_CONFIG												= 196,
	ENABLE_DELEGATE_IP_SEND												= 197,	// 是否开启机器转发代理
	PC_P2P_SUBSTREAM_NUM												= 198,	// pc p2p 子流数
	PC_P2P_SUBSCRIB_LIIMIT												= 199,	// pc p2p 竞争订阅比例
	WEB_P2P_SUBSTREAM_NUM												= 200,	// web p2p 子流数
	WEB_P2P_SUBSCRIB_LIMIT												= 201,	// web p2p 竞争订阅比例
	MOB_P2P_SUBSTREAM_NUM												= 202,	// mob p2p 子流数 todo
	MOB_P2P_SUBSCRIB_LIMIT												= 203,	// mob p2p 竞争订阅比例 todo
	TRANS_CODE_TYPE3													= 204,
	HLS_FILL_LOADING_ON_LOSS											= 205,	// HLS前端上，当出现视频丢包时，是否填充预定义的loading的ts
	BANDWIDTH_CALC_MODE													= 206,
	ENABLE_DELEGATE_AREA_SEND											= 207,	//是否开启分区代理转发
	IP_FOREIGN_AREA_NEW_TXT												= 208,
	OVERLOAD_ALLOC_SWITCH_ON											= 209,	//结合负载分配算法开关
	NEW_TRANS_CODE_NOTIFY												= 210,	//是否启用新的转码逻辑
	RANK_LOAD_EQUATION_TYPE												= 211,	//结合负载的rank计算公式类型
	MOB_VIDEO_TYPE_FILTER_CR											= 212,
	UGR_DETECT_TCP_ATTACK												= 213,	// UserManager检测针对开给user端口的tcp流量攻击
	NORMAL_PROXY_OVERLOAD_THRESHOLD										= 214,	//普通前端过载阈值
	HLS_PROXY_OVERLOAD_THRESHOLD										= 215,	// hls前端过载阈值
	PROXY_SEND_LOAD_TIMEOUT												= 216,
	PROXY_BURST_CONTINUE_CPU											= 217,	// 前端cpu变化巨大时，是否持续发送负载一段时间
	PROXY_HAS_DATA_VIDEO_STREAM_NUM_THRESHOLD							= 218,
	PROXY_HAS_DATA_VIDEO_STREAM_NUM_BUSY_THRESHOLD						= 219,
	PROXY_WILL_OVERLOAD_CPU_THRESHOLD									= 220,
	HLS_SEND_LOAD_TIMEOUT												= 221,
	FEC_MAX_SEND_COUNT													= 222,
	PROXY_APPID_USEFOREIGNAREA											= 223,	// proxyType - appid - foreignType
	RESEND_FLOW_MINIMUM													= 224,	// 前端重传流量的最小值，防止前端被占用带宽过高，拒绝客户端重传请求
	NEED_FASTEST_VIDEO_ACCESS											= 225,	// 小时代应用需要尽快出视频，有些特殊处理
	USERGROUP_TIMEOUT_VALUE												= 226,	// 普通前端上UserGroup里用户退光之后，多长时间删除UserGroup
	FASTER_USER_PUSH_SUPPORTED											= 227,	// 更快的用户接入机制，直接推送前端间快速接入数据/不用单独的subscribe
	VIDEO_STREAMS_TO_CLIENT_VIA_TCP										= 228,	// 前面多少秒之内下发的视频包全部走TCP，包括快速接入
	USER_PUSH_ALL_THROUGH_TCP											= 229,	// 快速接入的包是否全部都走推模式
	MAX_PROXY_PUSH_PKT_PER_50MS											= 230,	// 前端间快速接入时每50ms的最大包数
	MAX_USER_PUSH_PKT_PER_SEC											= 231,	// 前端向客户端推送快速接入数据时，每秒最多允许的用户数
	SCREEN_SHOT_SEND_PICTURE_INTERVAL									= 232,	// 截图推送图片频率value时间默认5s appid = 0配置
	NOT_CHECK_YCS_TOKEN_AUTHENTICATION									= 233,	// 如果设置这个开关为1， 则在ycs中不检测从aptoken、vptoken的权限，一律认为通过认证
	WEB_NORMAL_RESEND_RATIO												= 234,	// WEB普通观众分配的重传比例
	WEB_P2P_RESEND_RATIO												= 235,	// WEB P2p观众分配的重传比例
	MOB_NORMAL_RESEND_RATIO												= 236,	// MOB普通观众分配的重传比例
	MOB_P2P_RESEND_RATIO												= 237,	// MOB P2p观众分配的重传比例
	TRANS_CODE_ALLOC_MODE												= 238,	// 1:同机房 2：同分区 4.同ISP 8.全网
	
	//[432-512]客户端使用
	//[432 - 479]预留给传输侧使用
	MULTI_VIDEO_STREAM_MAX_JITTER_BUFFER_GATE							= 432,	// 多人（大于2人）配置最大抖动
	CAPTURE_SCREEN_PTS_ADJUSTVAL_OPPO_VIVO								= 433,	// default = 0 默认关闭 oppo vivo主播端pts校正值，oppo读高16位，vivo读低16位(屏幕捕捉开播)
	CAPTURE_SCREEN_PTS_ADJUSTVAL_XIAOMI_HUWEI							= 434,	// default = 0 默认关闭 小米华为主播端pts校正值，小米读高16位，华为读低16位(屏幕捕捉开播)
	MIN_FULLPATH_BANDWIDTH												= 435,	// default = 200, 全路径带宽探测最低值
	PROXY_MACHINE_DETECT_ANCHOR_ENABLE									= 437,	// 是否启动主播前端探测 default = 0 默认关闭
	PROXY_MACHINE_DETECT_AUDIENCE_ENABLE								= 438,	// 是否启动观众前端探测 default = 0 默认关闭
	PROXY_MACHINE_DETECT_PAYLOAD_SIZE									= 439,	// ping包填充字节数 default = 0 单位:byte
	PROXY_MACHINE_DETECT_PING_INTERVAL									= 440,	// ping发送时间间隔 default = 0 单位:ms
	PROXY_MACHINE_DETECT_DETECT_INTERVAL								= 441,	// 每个机房探测时长 default = 0 单位:ms
	MAX_EXTERNAL_BUFFER													= 442,	// default = 500, if external buffer is smaller than max buffer, we won't skip
	DOWNLINK_RESEND_TIMES_1200											= 443,	// 下行重传限制，码率小于等于1200
	DOWNLINK_RESEND_TIMES_3000											= 444,	// 下行重传限制，码率小于等于3000且大于1200
	DOWNLINK_RESEND_TIMES_6000											= 445,	// 下行重传限制，码率小于等于6000且大于3000
	DOWNLINK_RESEND_TIMES_8000											= 446,	// 下行重传限制，码率小于等于8000且大于6000
	DOWNLINK_RESEND_TIMES_10000											= 447,	// 下行重传限制，码率小于等于10000且大于8000
	DOWNLINK_RESEND_TIMES_16000											= 448,	// 下行重传限制，码率大于10000
	SHOWD_FUNCTION_ENABLE												= 449,	// pc新showd功能的上报和查询开关 default = 0, 打开:1
	AUDIENCE_USE_H5_PULL_STREAM											= 450,	// 观众端h5拉流功能，需要主播端发开播心跳到ap（目前只有比邻有该业务）,默认关闭:0，打开：非0
	AV_SYNC_AUDIO_EXTERANL_BUFFER_MEIZU									= 451,	// default = 150 魅族同步时是否考虑额外的音频buffer
	PROXY_MACHINE_DETECT_SYNC_AVP_INTERVAL								= 452,	//最优接入 前端探测中 发送给pa当前avp信息的周期, default = 0不发送
	/*移动端多流P2P开关*/
	MOB_MULTI_P2P_SWITCH												= 453,	// (1 << 0) -> 是否启动连接P2P服务器 1 启动; 0 不启动;
																				// (1 << 1) -> 是否多流P2P功能 1 启动; 0 不启动;
																				// (1 << 2) -> 多流P2P是否启动音频P2P功能; 1 启动; 0 不启动;
																				// (1 << 3) -> 是否启动打洞时(子)频道的判断功能; 1 启动; 0 不启动;
																				// (1 << 4) -> 是否支持多流圈子变化(p2p流名称变化时不退出P2P服务); 0:不支持;1:支持;
	MOB_MULTI_P2P_UNFILTER_TIME											= 454,	// 收到流通知，多久不对音视频数据进行过滤分发。单位ms，默认值:10000(10s)
	MOB_MULTI_P2P_REMOVEDIFNODE_TIME									= 455,	// 开始剔除不一致的节点的时长。单位ms, 默认值:3000(3s)
	MOB_MULTI_P2P_EXIT_NOP2PSTREAM_TIME									= 456,	// 没P2P流名称时，退出多流P2P的时长。单位ms，默认值:3000(3s)
	MOB_MULTI_P2P_EXIT_INVALIDDATA_TIME									= 457,	// 没收到有效的音视频流数据退出多流P2P的时长.单位ms, 默认值:500ms
	MOB_MULTI_P2P_EXIT_ALLDIFFNODE_TIME									= 458,	// 没收到相同的节点更新退出多流P2P的时长.单位ms, 默认值:30(300ms)
	/*移动端FLV-P2P开关*/
	MOB_FLV_P2P_SWITCH													= 459,	// (1 << 0) -> 是否支持FLV-P2P 0:不支持; 1:支持;
																				// (1 << 1) -> FLV-P2P是否支持音频双路推流 0:不支持; 1:支持;
																				// (1 << 2) -> FLV-P2P是否支持从根节点进行重传 0:不支持; 1:支持;
																				// (1 << 3) -> FLV-P2P是否启动(子)频道的判断功能; 0:不启动; 1:启动;
	MOB_FLV_P2P_REMOVEDIFFNODE_TIME										= 460,	// 开始剔除不一致的节点的时长。单位ms, 默认值:3000(3s)
	MOB_FLV_P2P_CYCLECHECK_INTERVAL										= 461,	// 周期检测发布者的间隔时间【单位s】
	MOB_FLV_P2P_AUDIO_HISTORY_DTS_NUM									= 462,	//FLV-P2P的音频历史的dts(lastDts之前的dts)个数(默认值为5)
	MOB_FLV_P2P_SKIP_AUDIO_INTERVAL										= 463,	//FLV-P2P音频跳帧的时间间隔
	MOB_FLV_P2P_SKIP_VIDEO_INTERVAL										= 464,	//FLV-P2P视频跳帧的时间间隔
	MOB_FLV_P2P_SKIP_AUDIO_WAIT_NUM										= 465,	//FLV-P2P音频跳帧的队列中的帧个数
	MOB_FLV_P2P_SKIP_VIDEO_WAIT_NUM										= 466,	//FLV-P2P视频跳帧的队列中的帧个数
	MOB_FLV_P2P_FORCESUBSCRIBE_SWITCH_RATIO								= 467,	//FLV-P2P强制订阅切换比例
	MOB_FLV_P2P_FORCESUBSCRIBE_CONTINUE_TIME							= 468,	//FLV-P2P强制订阅太多(过半)的持续时间【单位s】

	//[480-512]预留给算法侧使用
	CODEC_PROXY_CONFIG_RESERVER_BEGIN									= 480,  //预留给算法的开始编号
	CODEC_PROXY_CONFIG_RESERVER_END										= 512,  //预留给算法的结束编号
	
	//备注：以下是从媒体云获取前端时下发的配置,孔明那边没有进行统一编号,所以转换为一个较大的key
	VIDEO_PROXY_CODE_RATE												= 1021,	// 视频码率
	VIDEO_PROXY_FRAME_RATE												= 1022,	// 视频帧率
	VIDEO_PROXY_WIDTH													= 1023,	// 视频宽度
	VIDEO_PROXY_HEIGHT													= 1024,	// 视频高度
	VIDEO_PROXY_RATIO_WIDTH												= 1025,	// 宽高比：宽
	VIDEO_PROXY_RATIO_HEIGHT											= 1026	// 宽高比：高
};
#endif

//视频新广播组下Channel类型
enum VideoChannelType
{
	ORI_CHANNEL															= 0,	// 原画Channel
	TRANS_CODE_CHANNEL													= 1,	// 转码Channel
	STREAM_FORWARD_CHANNEL												= 2,	// 转发Channel
};

enum VideoMetaData
{
	MST_VIDEO_STREAM_FLAG												= 1, // 麦序位置
	MST_VIDEO_CLIENNT_TYPE												= 2, // 主播客户端类型，见enum YCPublisherClientType
	MST_VIDEO_RESOLUTION												= 3, // 视频源分辨率,高16位是宽 低16位是高
	MST_VIDEO_BIT_RATE													= 4, // 码率 kbps
	MST_VIDEO_FRAME_RATE												= 5, // 视频源帧率
	MST_VIDEO_ENCODE_TYPE												= 6, // 视频源编码类型（0,：ENCODE_UNKNOW， 1：ENCODE_H264， 2：ENCODE_H265， 3：ENCODE_VP8， 4：ENCODE_VP9）
	MST_VIDEO_AUTO_SUBSCRIBE											= 7, // 视频是否是自动订阅（此种模式下加快出视频速度）

	//以下字段与enum ExtraMetaDataId各字段含义相同
	MST_PUBLISHER_APP_RESERVE1											= 80, // APP设置预留1
	MST_PUBLISHER_APP_RESERVE2											= 81, // APP设置预留2
	MST_PUBLISHER_APP_RESERVE3											= 82, // APP设置预留3
	MST_PUBLISHER_APP_RESERVE4											= 83, // APP设置预留4
	MST_PUBLISHER_APP_RESERVE5											= 84, // APP设置预留5
	MST_PUBLISHER_APP_RESERVE6											= 85, // APP设置预留6
	MST_PUBLISHER_APP_RESERVE7											= 86, // APP设置预留7
	MST_PUBLISHER_APP_RESERVE8											= 87, // APP设置预留8
	MST_PUBLISHER_APP_RESERVE9											= 88, // APP设置预留9
	MST_PUBLISHER_APP_RESERVE10											= 89, // APP设置预留10
	MST_PUBLISHER_APP_RESERVE11											= 90, // APP设置预留11
	MST_PUBLISHER_APP_RESERVE12											= 91, // APP设置预留12
	MST_PUBLISHER_APP_RESERVE13											= 92, // APP设置预留13
	MST_PUBLISHER_APP_RESERVE14											= 93, // APP设置预留14
	MST_PUBLISHER_APP_RESERVE15											= 94, // APP设置预留15
	MST_PUBLISHER_APP_RESERVE16											= 95, // APP设置预留16
	MST_PUBLISHER_RESERVE_META7											= 96, // 预留7
	MST_PUBLISHER_RESERVE_META6											= 97, // 预留6
	MST_PUBLISHER_RESERVE_META5											= 98, // 预留5
	MST_PUBLISHER_RESERVE_META4											= 99, // 预留4
	MST_PUBLISHER_MC_POS												= 100, // value = 0（首麦），value = 1（被连麦）
	MST_PUBLISHER_CODERATE_TYPE											= 101, // value = 0（兼容旧版本）
																				// value = 1（给快男pc端看的)
																				// value = 2（给快男web/mobile看的）
																				// value = 3（给快男所有平台看的）
	MST_PUBLISHER_RESERVE_META1											= 102, // 预留1
	MST_PUBLISHER_RESERVE_META2											= 103, // 预留2
	MST_PUBLISHER_RESERVE_META3											= 104, // 预留3
	MST_SERVER_TRANSCODE												= 105, // 服务器转码
	MST_SERVER_TRANSCODE_TRANS_LEVEL									= 111, // 由业务指定的转码的档位
};

enum YCPublisherClientType
{
	YC_PCT_PC_YY														= 0,	// PC
	YC_PCT_WEB_YY														= 1,	// web
	YC_PCT_ANDROID_YY													= 2,	// 安卓手机
	YC_PCT_IOS_YY														= 3,	// 苹果手机
	YC_PCT_MOB_YY														= 4,	// 不区分手机系统、统称手机类型
	YC_PCT_KNOWN_TYPE													= 5,	// 未知终端类型
};

enum YCServerRecordMode
{
	YC_SRM_SPEAKER														= 0,	// 新录制协议：以主播UID录制
	YC_SRM_CHANNEL														= 1,	// 新录制协议：频道模式录制
	YC_SRM_OLD															= 2,	// 旧录制协议
};

// 视频编码类型定义, 与java层的VideoEncodecType定义对应
enum YCVideoEncodecType
{
	YC_ENCODE_UNKNOW													= 0,	// 未知编码类型
	YC_ENCODE_H264														= 1,	// H264编码
	YC_ENCODE_H265														= 2,	// H265编码
	YC_ENCODE_VP8														= 3,	// VP8编码
	YC_ENCODE_VP9														= 4,	// VP9编码
};

enum AudioStreamState
{
	euAudioStreamStart													= 1,	// 音频流开始
	euAudioStreamStop													= 2,	// 音频流结束
};

enum VideoStreamState
{
	euVideoStreamStart													= 1,	// 视频流开始
	euVideoStreamStop													= 2,	// 视频流结束
	euVideoStreamArrive													= 3,	// 新视频流通知
};

enum VideoRenderState
{
	euVideoRenderStart													= 0,
	euVideoRenderStop													= 1,
};

enum CodeRateChangeResult
{
	euCodeRateUnchanged													= 0,
	euCodeRateChanged													= 1,
};

enum MicPhoneState
{
	euMicPhoneOpen														= 1,
	euMicPhoneClose														= 2,
};

enum CaptureVideoOrientation
{
	CaptureVideoOrientationPortrait										= 1,
	CaptureVideoOrientationPortraitUpsideDown							= 2,
	CaptureVideoOrientationLandscapeRight								= 3,
	CaptureVideoOrientationLandscapeLeft								= 4,
};


enum InnerRunDataKey
{
	IRD_UPLINK_SEND_FLOW												= 100,	// 上行3s发送数据量kbit
	IRD_FLVSTREAM_BITRATE												= 101,	// FLV流3s平均码率
	
	IRD_SUPPORT_HEVC_SOFTWARE_DECODE									= 200,
	IRD_SUPPORT_HEVC_HARDWARE_DECODE									= 201,
	IRD_SUPPORT_HEVC_SOFTWARE_ENCODE									= 202,
	IRD_SUPPORT_HEVC_HARDWARE_ENCODE									= 203,

	IRD_SUPPORT_H264_SOFTWARE_DECODE									= 220,
	IRD_SUPPORT_H264_HARDWARE_DECODE									= 221,
	IRD_SUPPORT_H264_SOFTWARE_ENCODE									= 222,
	IRD_SUPPORT_H264_HARDWARE_ENCODE									= 223,
};

enum AnchorBroadcastDataKey
{
	// 小于ABDK_RESERVER_END的key, 由业务通过setExtraAnchorBroadcastData接口按需设置
	ABDK_ADDR															= 1,	// 主播地址

	ABDK_RESERVER1														= 100,	// 预留1
	ABDK_RESERVER2														= 101,	// 预留2
	ABDK_RESERVER3														= 102,	// 预留3
	ABDK_RESERVER4														= 103,	// 预留4
	ABDK_RESERVER5														= 104,	// 预留5
	ABDK_RESERVER6														= 105,	// 预留6
	ABDK_RESERVER7														= 106,	// 预留7
	ABDK_RESERVER8														= 107,	// 预留8
	ABDK_RESERVER9														= 108,	// 预留9
	ABDK_RESERVER10														= 109,	// 预留10

	ABDK_RESERVER_END													= 127,	// 预留结束位

	// 以下为sdk填的广播数据，业务不需要通过setExtraAnchorBroadcastData接口设置
	// 在抛给业务的回调消息中AnchorBroadcastData中，也会包含以下的key
	ABDK_PHONEINFO														= 200,	// 主播手机型号信息
	ABDK_UPLOADSPEED													= 201,	// 主播上传速度，单位bit/s
	ABDK_NET_TYPE														= 202,	// 主播网络类型，参考MediaVideoMsg.NetState
	ABDK_ACTUAL_FRAME_RATE												= 203,	// 主播实际帧率
	ABDK_ACTUAL_BIT_RATE												= 204,	// 主播实际码率，单位bit/s
	ABDK_RESOLUTION														= 205,	// 主播分辨率，高16位width 低16位height
	ABDK_DROP_FRAME_CNT													= 206,	// 主播主动丢帧数
	ABDK_PUBLISH_RATE													= 207,	// 主播发布成功率
	ABDK_BACKGROUND_TIME												= 208,	// 主播切到后台次数
	ABDK_MAX_CAPTURE_GAP												= 209,	// 最大采集间隔
	ABDK_MIN_FRAME_RATE													= 210,	// 实际编码的最小帧率
	ABDK_DISCONNECT_DURATION											= 211,	// 主播断网时长
};

enum PublisherClientType
{
	PCT_PC_YY															= 0,	// PC
	PCT_WEB_YY															= 1,	// web
	PCT_ANDROID_YY														= 2,	// 安卓手机
	PCT_IOS_YY															= 3,	// 苹果手机
	PCT_MOB_YY															= 4,	// 不区分手机系统、统称手机类型
	PCT_KNOWN_TYPE														= 5,	// 未知终端类型
};

// 视频编码类型定义, 与java层的MediaVideoMsg.VideoEncodecType定义对应
// 注意修改这个定义也要PC端定义统一，因为是主播广播给观众的
enum VideoEncodecType
{
	ENCODE_UNKNOW														= 0,	// 未知编码类型
	ENCODE_H264															= 1,	// H264编码
	ENCODE_H265															= 2,	// H265编码
	ENCODE_VP8															= 3,	// VP8编码
	ENCODE_VP9															= 4,	// VP9编码
	ENCODE_CONFIG_H264													= 100,	// 配置中心H264编码
	ENCODE_CONFIG_H265													= 101,	// 配置中心H265编码
};

//视频编码器类型，软编or硬编
enum VideoEncoderType
{
	E_UNKOWN_ENCODER													= 0,	// 未知编码类型
	E_ANDROID_HARD_ENCODER												= 1,	// android硬编
	E_ANDROID_SOFT_ENCODER												= 2,	// android软编
	E_IOS_HARD_ENCODER													= 3,	// ios硬编
	E_IOS_SOFT_ENCODER													= 4,	// ios软编
};

enum VideoP2PStataticsKey
{
	kVideoP2PDownLinkStreamFlow											= 1,	// 经p2p网络下行视频总流量
	kVideoP2PDownLinkStreamFlowByServer									= 3,	// 经服务器下行视频总流量
	kVideoP2PUplinkStreamFlow											= 34,	// 发送给其他peer视频流量
};

enum ApplicationTypes
{
	huya																= 10057,		// 虎牙直播
	MOBILE_YY															= 15012,		// 手机yy
	edu																	= 10039,		// 100教育
	yyfinance															= 50020,		// YY财经
	yymedia																= 8001,			// YY视听
	YYHD																= 8002,			// YYHD
	yymedical															= 8003,			// YY医疗
	yyfriend															= 8004,			// YY交友
	hello																= 8005,			// Hello
	langren																= 8010,			// 狼人杀
	zhiboji																= 8011,			// 直播机
	YYTV																= 8012,			// YYTV版本,只能观看，不能开播
	yyVoiceAssistant													= 15012002,		// 手游语音助手
};

enum ChannelAudioState
{
	euNoAudio															= 1,	// 频道没人说话
	euRecvAudio															= 2,	// 频道听到声音
	euRecvNoAudio														= 3,	// 频道有人说话，但听不到声音
};

enum ServerRecordMode
{
	SRM_SPEAKER															= 0,	// 新录制协议：以主播UID录制
	SRM_CHANNEL															= 1,	// 新录制协议：频道模式录制
	SRM_OLD																= 2,	// 旧录制协议
};

// 抛给app的视频上行相关统计
enum VideoPublisherStatKey
{
	MST_APPID							= 0,			// 上行对应的appid
	MST_UPLINK_FLOW						= 1,			// 上行总流量
	MST_PUBLISH_RATE					= 2,			// 发布成功率
	MST_PUBLISHER_VP_IP					= 3,			// 视频服务器的IP地址
	MST_VIDEO_UPLINK_LOSSRATE			= 4,			// 视频上行链路丢包率(单位万分率)
	MST_PUBLISHER_LINK_RTT				= 5,			// 视频链路rtt(单位ms)
};

enum VideoViwerStatKey
{
	MST_VIEWER_VP_IP					= 0,			// 视频服务器的IP地址
	MST_USE_VIDEO_CONVERSATION			= 49,			// 是否视频连麦中，1表示连麦，0表示非连麦
	MST_VIDEO_DOWNLINK_LOSSRATE			= 50,			// 视频下行链路丢包率(单位万分率)
	MST_VIEWER_LINK_RTT					= 51,			// 视频链路rtt(单位ms)
	MST_ALL_RECV_PACKET_FLOW 			= 311,			// 观众收到总流量 (单位Byte)
	MST_FROM_SERVER_PACKET_FLOW			= 312,			// 客户端从服务器收到总流量 (单位Byte)
	MST_VIDEO_BAD_QUALITY_COUNT			= 523,			// 视频感官卡次数 StreamStatInfo中的statMap
	MST_STAY_TIME_IN_20S_CYCLE			= 528,			// 统计时长 videoViewerStatInfo中的extMap
};

enum ViewerStreamKey
{
	MST_RECV_BIT_RATE					= 0,			// 视频流实际下载的码率
	MST_VIDEO_DECODED_RESOLUTION		= 564,			// 解码器实际输出的分辨率,高16位宽 低16位高
	MST_VIDEO_DECODED_FRAMERATE			= 565,			// 解码器实际输出的帧率
	MST_VIDEO_DECODED_BITRATE			= 566,			// 解码器实际输出的码率 kbps
	MST_VIDEO_RECV_FRAME_COUNT			= 567,			// 收到帧数 StreamStatInfo中的statMap
	MST_VIDEO_PLAY_LOSS_COUNT 			= 568,			// 网络丢帧数 StreamStatInfo中的statMap
	MST_VIDEO_DISCARD_COUNT 			= 569,			// 解码丢帧数 StreamStatInfo中的statMap
//	MST_VIDEO_RENDER_DISCARD_COUNT		= 570,			// 渲染丢帧数 StreamStatInfo中的statMap
	MST_VIDEO_WATCH_DELAY 				= 571,			// 加载视频延时，看某个treamId第一个周期非0，其他时候为0(单位ms)
	MST_VIDEO_TOTAL_DELAY 				= 572,			// 视频总延迟，从采集到播放所需时间(单位ms)
};

enum PublisherStreamKey
{
	MST_VIDEO_SEND_BIT_RATE 			= 22,			// 主播实际上传的码率 kbps
	MST_VIDEO_ORI_RESOLUTION			= 101,			// 视频源分辨率,高16位宽 低16位高
	MST_VIDEO_ORI_FRAME_RATE			= 102,			// 视频源帧率
	MST_VIDEO_ENCODE_EXP_RESOLUTION		= 103,			// 编码器设置的分辨率,高16位宽 低16位高
	MST_VIDEO_ENCODE_EXP_FRAME_RATE		= 104,			// 编码器设置的帧率
	MST_VIDEO_ENCODE_EXP_BIT_RATE		= 105,			// 编码器设置的初始码率 kbps
	MST_VIDEO_ENCODE_DYN_BIT_RATE		= 106,			// 编码器设置的动态码率 kbps
	MST_VIDEO_ENCODE_REAL_RESOLUTION	= 107,			// 编码器实际输出的分辨率,高16位宽 低16位高
	MST_VIDEO_ENCODE_REAL_FRAME_RATE	= 108,			// 编码器实际输出的帧率
	MST_VIDEO_ENCODE_REAL_BIT_RATE		= 109,			// 编码器实际输出的码率 kbps
};


enum PublisherLossNotifyKey
{
	LNK_PUBLISHER_LOSS_NOTIFY			= 0,			// 主播是否卡，0不卡 1卡
};

enum ViewerLossNotifyKey
{
	LNK_VIEWER_LOSS_NOTIFY				= 0,			// 观众是否卡，参考枚举ViewerLossNotifyValue
};

// 观众卡原因枚举
enum ViewerLossNotifyValue
{
	LNV_VIEWER_NO_LOSS					= 0,			// 观众不卡
	LNV_PUBLISHER_LOSS					= 1,			// 主播卡
	LNV_VIEWER_NET_LOSS					= 2,			// 观众网络卡
	LNV_VIWER_DECODE_LOSS				= 3,			// 观众解码卡
	LNV_VIEW_OTHER_LOSS					= 4,			// 观众其它原因卡
};

enum ChannelMetaDataKey
{
	// 客户端用80以内的字段
	MST_TRANS_CODE_RATE					= 1,			// 转码码率(0：原画，非零：转码码率的视频,一个主播只能上行一个原画档,单位bps)
	MST_TRANS_FRAME_RATE				= 2,			// 转码帧率（转码档位帧率不能为0）
	MST_TRANS_RESOLUTION				= 3,			// 转码分辨率，高16是宽度，低16位是高度(1、宽能被16整除 2、高能被2整除)
	MST_TRANS_CROP						= 4,			// 是否裁剪，横竖屏转码(1：转码 0：不转码)
	MST_COPY_STREAM_FROM_CHANNEL		= 5,			// 转发档，视频源来自指定的档位(1、转发Channel的源Channel不能是一个转发Channel
														// 2、转发档mataData与原始档相同 3、填此key后可以不填1-4)

	// [80, 111] 预留给应用层设置enum ExtraMetaDataId
};

//
// 用户发起的音频诊断请求类型.
//
enum EAudioDiagnose
{
	E_AD_NO_AUDIO = 0,	 	//听不到声音.
	E_AD_BAD_AUDIO = 1,	 	//声音卡.
	E_AD_NOISE_ECHO = 2, 	//有回声.

	E_AD_DONE = 0xffffffff
};

//
// 用户听不到声音的诊断结果.
//
enum ENoAudioDiagnReason
{
	E_NAD_NO_ERRORS 			= 0, 	//没有诊断到异常.
	E_NAD_PEER_NO_SPEAKING 		= 1,	//主播没有说话.
	E_NAD_PEER_NETLOSS			= 2,	//主播网络丢包.
	E_NAD_ME_MUTE 				= 3,	//听众mute禁音.
	E_NAD_ME_DEV_NOT_START  	= 4,	//听众音频设备没有启动.
	E_NAD_ME_DEV_START_FAIL  	= 5,	//听众音频设备启动失败.
	E_NAD_ME_NETLOSS			= 6,	//听众网络丢包.
	E_NAD_ME_NOT_PLAY 			= 7,	//听众音频播放线程异常.
	E_NAD_ME_0_VOLUME 			= 8,	//音量为零.
	E_NAD_ME_DISCONNECT 		= 9,	//听众网络断开.
	E_NAD_ME_NO_FETCH_MP 		= 10,	//听众没有获取到前端资源.
	E_NAD_ME_NO_RECV_PACKET 	= 11,	//听众没有接收到数据包.
	E_NAD_ME_NO_RECV_FRAMES 	= 12,	//听众没有接收到音频帧.
	E_NAD_ME_NO_FOR_PLAY 		= 13,	//听众没有送播放.
	E_NAD_ME_PLAY_NO_VOICE		= 14,	//听众正常播放但没声音.
	E_NAD_ME_MUTE_IGNORED		= 15,	//当前说话人声音被忽略.
};

//
// 用户声音卡的诊断结果.
//
enum EBadAudioReason
{
	E_BAD_NO_ERRORS 			= 0,	//没有诊断到异常.
	E_BAD_PEER_NETLOSS 			= 1,	//主播网络丢包.
	E_BAD_PEER_HIGHRTT 			= 2,	//主播网络rtt高.
	E_BAD_ME_LACK_PLAY 			= 3,	//听众播放线程回调不足.
	E_BAD_ME_NETLOSS 			= 4,	//听众网络丢包.
	E_BAD_ME_HIGHRTT 			= 5,	//听众网络rtt高.
	E_BAD_ME_DISCARD 			= 6,	//听众主动丢弃音频帧.
};

//
// 用户回声的诊断结果.
//
enum EEchoAudioReason
{
	E_EAD_UNKNOWN 				= 0,	//没有诊断到异常.
	E_EAD_AEC_ERROR 			= 1, 	//回声消除异常.
};

//
// 音频上行情况.
//
enum EUploadDiagnResult
{
	E_UP_NO_ERRORS 				= 0,	//音频上行正常.
	E_UP_NO_CAPTURE 			= 1,	//没有音频采集.
	E_UP_CANNT_SPEAK 			= 2,	//没有说话权限.
};

//
// 音频下行情况.
//
enum EDnloadDiagnResult
{
	E_DN_NO_ERROR 				= 0,	//音频下行正常.
	E_DN_NO_RECV				= 1,	//没有收到音频包.
	E_DN_NO_SYSTEM_PLAY			= 2,	//音频播放线程没有回调.
	E_DN_NO_FRAME_PLAY			= 3,	//没有可播放的音频帧.
};

//
// 音频链路情况.
//
enum EAudioLinkResult
{
	E_ALINK_NO_ERROR			= 0,	//连接正常.
	E_ALINK_DISCONNECT 			= 1,	//连接断开.
	E_ALINK_NETLOSS				= 2,	//连接丢包.
	E_ALINK_HIGHRTT				= 3,	//连接rtt高.
};

enum EAudioDiagnResult
{
	E_AD_UID = 0,		//音频主播uid.
	E_AD_APPDIAGN = 1,	//业务发起的诊断类型. EAudioDiagnose
	E_AD_DIAGNRESULT = 2, //诊断结果.ENoAudioDiagnReason, EBadAudioReason, EEchoAudioReason
	E_AD_UPSTATE = 3,	//音频上行状态.EUploadDiagnResult
	E_AD_DNSTATE = 4,	//音频下行状态.EDnloadDiagnResult
	E_AD_LINKSTATE = 5	//连接状态.EAudioLinkResult
};

enum MonthlyPaymentType
{
	MONTHLY_PAYMENT_TYPE_NONE					= 0,
	MONTHLY_PAYMENT_TYPE_CUCC					= 1,	// 联通包月免流,获取前段时带到vc，由vc分配免流前段
	MONTHLY_PAYMENT_TYPE_CTCC					= 2,	// 电信包月免流,获取前段时带到vc，由vc分配免流前段
	MONTHLY_PAYMENT_TYPE_CMCC					= 3,	// 移动包月免流,获取前段时带到vc，由vc分配免流前段
	MONTHLY_PAYMENT_TYPE_CUCC_BY_BACK_SERVER	= 4,	// 联通包月免流,不需要带到vc,联通后台在用户产生订购之后,主动调用yy后台提供的接口
														// 将订购关系（增/删/改）同步给yy
};

#define VIDEO_QUALITY_LOW	VIDEO_QUALITY_LOW_LATENCY

const static uint32_t kYCSVideoHightQualityBuffer = 2000;
const static uint32_t kYCSVideoLowLatencyBuffer = 500; //避免测试安卓语音丢包

enum DefinitionLevel
{
	DEFINITION_LEVEL_STANDARD		= 0,	// 标清
	DEFINITION_LEVEL_HIGH			= 1,	// 高清
	DEFINITION_LEVEL_SUPER			= 2,	// 超清
};

enum VideoFrameType
{
	kVideoUnknowFrame		= 0xFF,  // 8bits
	kVideoIFrame			= 0,
	kVideoPFrame			= 1,
	kVideoBFrame			= 2,
	kVideoPFrameSEI			= 3,     // 0 - 3 is same with YY video packet's frame type.
	kVideoIDRFrame			= 4,
	kVideoSPSFrame			= 5,
	kVideoPPSFrame			= 6,
	kVideoHeaderFrame		= 7,
	kVideoEncodedDataFrame	= 8,
	kVideoH265HeadFrame		= 9,
};

//-----------------------------new live sys--begin--------------------------------------//

enum LiveStreamType		//保持与 LiveStreamAvpValue::STREAM_TYPE_VALUE 取值一致
{
	STREAM_TYPE_UNKNOW	= 0,
	STREAM_TYPE_VIDEO	= 1,
	STREAM_TYPE_AUDIO	= 2,
};

enum LiveStreamProvider
{
	STREAM_PROVIDER_UNKOWN	= 0,
	STREAM_PROVIDER_YYSDK	= 1,	//使用yylive sdk层的采集编码
	STREAM_PROVIDER_MOB_YY	= 2,	//使用手Y业务层的采集编码
	STREAM_PROVIDER_THIRD	= 3,
};

enum LiveStreamCfgKey	//保持与 LiveStreamAvpStreamCfgKey::StreamCfgKey 取值一致
{
	STREAM_CONFIG_KEY_PUBLISHID					= 1,
	STREAM_CONFIG_KEY_SPEAKER_UID				= 2,
	STREAM_CONFIG_KEY_STREAM_TYPE				= 3,	//LiveStreamType
	STREAM_CONFIG_KEY_CODE_RATE					= 4,	//码率,单位 kbps
	STREAM_CONFIG_KEY_ENCODE_TYPE				= 5,	//VideoEncodecType
	STREMA_CONFIG_KEY_AUDIO_CHANNELS			= 6,
	STREAM_CONFIG_KEY_AUDIO_SAMPLERATE			= 7,
	STREAM_CONFIG_KEY_PUBLISH_STREAM_PROVIDER	= 8,	//LiveStreamProvider, 发布的流从 yysdk采集还是手Y自己采集的
	STREAM_CONFIG_KEY_SID_BROADCAST_AUDIO		= 9,	//频道内音频广播标记，0=false,非0=true
	STREAM_CONFIG_KEY_PUBLISHER_MC_POS          = 10,	//mob 标识是首麦还是被连麦
	STREAM_CONFIG_KEY_FRAME_RATE				= 11,	//业务设置的帧率
	STREAM_CONFIG_KEY_RESOLUTION_WIDTH			= 12,
	STREAM_CONFIG_KEY_RESOLUTION_HEIGHT			= 13,
	STREAM_CONFIG_KEY_STREAM_LINE				= 14,	//线路
	STREAM_CONFIG_KEY_STREAM_LINE_GROUP			= 15,	//模板请求线路信息时需要指定
	STREAM_CONFIG_KEY_STREAM_A_V_PAIR_ID		= 16,	//音频和视频配对的pairId
	STREAM_CONFIG_KEY_ENABLE_FAST_ACCESS		= 17,	//是否需要快速接入
};

enum LivePublishStatus	//开播状态通知
{
	LIVE_PUBLISH_SUCCESS		= 0,		//发布成功
	LIVE_PUBLISH_PARAM_ERROR	= 1,		//参数错误
	LIVE_PUBLISH_FAILED			= 2, 		//发布失败
	LIVE_PUBLISH_AUTH_FAIL		= 3,		//鉴权失败
	LIVE_PUBLISH_NOT_ANCHOR_SYS	= 4,		//不在主播系统
};

enum LiveSubcribeStatus	//订阅状态
{
	LIVE_SUBCRIBE_SUCCESS		= 0,		//订阅成功
	LIVE_SUBCRIBE_PARAM_ERROR	= 1,		//参数错误
	LIVE_SUBCRIBE_FAILED		= 2,		//订阅失败
	LIVE_SUBCRIBE_CANCEL		= 3,		//订阅取消
};

enum LiveAudioStreamStatus
{
	LIVE_AUDIOSTREAM_STATUS_START = 1,		//音频流数据到来
	LIVE_AUDIOSTREAM_STATUS_ARRIVE = 2,		//音频流ID到来
	LIVE_AUDIOSTREAM_STATUS_STOP = 3,
	LIVE_AUDIOSTREAM_STATUS_UID_CHANGE = 4,	//音频流中uid发生变化
};

enum LiveVideoStreamStatus
{
	LIVE_VIDEOSTREAM_STATUS_ARRIVE = 1,
	LIVE_VIDEOSTREAM_STATUS_START = 2,
	LIVE_VIDEOSTREAM_STATUS_STOP = 3,
};

//返回给业务的线路信息的来源类型
enum LiveResLineInfoType
{
	FROM_INQUIRY_RES = 0,		//查询线路请求的res中的线路信息返回
	FROM_SERVER_NOTIFY = 1,		//server主动通知的线路信息
	FROM_FETCH_AVP_RES = 2,		//获取前端地址的res中返回的线路信息
};

enum LiveAreaType
{
	LIVE_AREA_DEFAULT	= 0, //默认值(国内)
	LIVE_AREA_RUSSIA	= 1, //俄罗斯
	LIVE_AREA_MALAYSIA	= 2, //马来西亚

	LIVE_AREA_FOREIGN   = 100, //国外（对应国内）
};

enum ABTestConfigType
{
	// <=20的key为出视频速度ABTEST使用,请勿擅自在<=20内增加key
	/*FIRST_VIDEO_ABTEST_PUSH_DOWN_STAMP								= 1,	// 业务点击事件时间点（仅进频道第一次出视频有）
	FIRST_VIDEO_ABTEST_TEMPLATE_UPDATE_STAMP							= 2,	// 业务模板更新时间点（仅进频道第一次出视频有）
	FIRST_VIDEO_ABTEST_STREAM_INFO_STAMP								= 3,	// 业务信息流获取完成时间点（仅进频道第一次出视频有）
	FIRST_VIDEO_ABTEST_SUBSCRIBE_STAMP									= 4,	// 业务订阅时间点（仅进频道第一次出视频有）
	FIRST_VIDEO_ABTEST_CREAT_VEDIO_VIEW_STAMP							= 5,	// 业务创建完成视频容器时间点（仅进频道第一次出视频有）
	FIRST_VIDEO_ABTEST_CREAT_RENDER_VIEW_STAMP							= 6,	// 业务创建完成渲染容器时间点（仅进频道第一次出视频有）
	FIRST_VIDEO_ABTEST_START_PLAY										= 7,	// 业务出视频时间点（仅进频道第一次出视频有）
	FIRST_VIDEO_ABTEST_VALUE											= 10,	// ABTest实验值*/


	/*  20 < key <= 30为通用 ABTest使用，以后有新的ABTest可以复用以下值,防止每次都添加相同含义的Key
	 *  请勿擅自在该范围添加非通用的Key
	 *	目前使用通用Key的有:CDN_FLV_P2P
	 */
	GENERAL_ABTEST_VALUE												= 21,	//通用ABTest实验值(1:关闭 2:打开 -1:未命中实验)

	/*
	 * key = 31 为手Y 7.17 4g网络下默认订阅高清档视频ABTest技术需求占用
	 */
	AUDIENCE_DEFAULT_HD_ABTEST_VALUE									= 31,	//4g网络下默认订阅高清档视频ABTest实验值(1:默认订阅流畅 2:默认订阅高清  -1:未命中实验)
};

enum ABTestStringConfigType
{
	ABTEST_HDID															= 1,	// 海度ID
	ABTEST_TEMPLATE_ID													= 2,	// 模板ID
	ABTEST_TOKEN														= 3,	// 业务token
};

/* 实验名称
 * 因为无法从ABTest后台拿到当前实验的id,sdk内部自己定义区分上报海度
 * 定义规则：名称不能包含‘:’、‘,’符号
 */

#define CDN_FLV_P2P_ABTEST 			 "CDN-FLV-P2P-ABTEST";									// cdn flv p2p需求实验
#define AUDIENCE_4GHD_ABTEST 		 "AUDIENCE-4GHD-ABTEST";								// 观众4G网络下默认订阅高清视频需求实验


//-----------------------------new live sys--end--------------------------------------//

