#pragma once
#include "Header.h"
#include "IntTypes.h"
#include "TransPacket.h"

namespace mediaCore
{
	class Request
		: public Header
	{
	public:
		Request(const char *data, uint32_t sz)
		: m_up(data, sz)
		, m_cpBuffer(NULL)
		, m_newHeader(false)
		{

		}

		Request(const char *data, uint32_t sz, bool copy)
		: m_up(data, sz)
		, m_cpBuffer(NULL)
		, m_newHeader(false)
		{
			if (copy)
			{
				m_cpBuffer = new char[sz];
				memcpy(m_cpBuffer, data, sz);
				m_up.reset(m_cpBuffer, sz);
			}
		}

		virtual ~Request()
		{
			if (m_cpBuffer != NULL)
			{
				delete[] m_cpBuffer;
			}
		}

	public:
		static uint32_t peeklen(const void * d)
		{
			uint32_t i = *((uint32_t*)d);
			return XHTONL(i);
		}

		static bool ifSuccess(uint32_t res)
		{
			return res == RES_SUCCESS;
		}

	public:
		void head()
		{
			unsigned char flag = *(m_up.data() + 3);
			if ((flag & 0x80) > 0)
			{
				uint16_t len = m_up.pop_uint16();
				m_length = len >> 4;
				m_uri = len & 0x000f;
				m_resCode = 200;
				m_newHeader = true;
			}
			else
			{
				m_length = m_up.pop_uint32();
				m_uri = m_up.pop_uint32();
				m_resCode = m_up.pop_uint16();
			}
		}

		mediaSox::Unpack& getPackData()
		{
			return m_up;
		}

	private:
		mediaSox::Unpack m_up;
		char* m_cpBuffer;
		bool m_newHeader;
	};
}
