#pragma once
#include "EventBase.h"
#include "MediaObj.h"
#include <map>
#include <list>
#include "ISmartDnsProxy.h"

class IAudioDecoder
{
public:
	IAudioDecoder() {}
	virtual ~IAudioDecoder() {}

public:
	virtual int  OpenStream(const uint32_t codec) = 0;
	virtual uint32_t GetCodec() = 0;
	virtual bool IsStreamOpened() const = 0;

public:
	virtual void CloseStream() = 0;
	virtual void DecodeAudioFrames(AVframeList &decodingFrames, AVframeList &decodedframes) = 0;
	virtual void checkCodecType(uint32_t codec) = 0;
};

class IVideoDecoder
{
public:
	IVideoDecoder() {}
	virtual ~IVideoDecoder() {}

public:
	virtual void createDecoder(uint32_t codecType, uint32_t micPos, uint32_t fps, bool live) = 0;
	virtual void stopDecode() = 0;
	virtual void addPendingFrame(AVframe& frame) = 0;
	virtual void getDecodedFrameByPts(uint32_t pts, AVframe& decodedPic) = 0;
	virtual void onNotifyDecoderChanged(bool bUseRefactorDecoder) = 0;

public:
	virtual bool isStreamOpened() const = 0;
	virtual bool decodeVideoFrames(AVframe& decodingframe, AVframeList& decodedFrames, bool live) = 0;
	virtual bool isAndroidHardDecoder1() = 0;
	virtual bool isAndroidHardDecoder2() = 0;
	virtual bool isSoftDecoder() = 0;
	virtual bool isIosHardDecoder() = 0;
	virtual bool IsDecodeRenderTogether() = 0;

public:
	virtual uint32_t getDecodeType() = 0;
};

class IAppConfig
{
public:
	IAppConfig() {}
	virtual ~IAppConfig() {}

public:
	virtual void getAppConfigs(std::map<uint32_t, uint32_t>& configs) = 0;
	virtual void setExtraMetaData(std::map<uint8_t, uint32_t>& metaDatas) = 0;
	virtual void setExtraAnchorBroadcastData(std::map<uint32_t, uint32_t>& intDatas, std::map<uint32_t, std::string>& stringDatas) = 0;
	virtual void getExtraMetaData(std::map<uint8_t, uint32_t>& metaDatas) = 0;
	virtual void getExtraAnchorBroadcastData(std::map<uint32_t, uint32_t>& intDatas, std::map<uint32_t, std::string>& stringDatas) = 0;
	virtual void setCodeRateLevel(uint32_t val) = 0;
	virtual void setWatchCropVideo(uint32_t val) = 0;
	virtual void setAudioQuality(uint32_t val) = 0;
	virtual void setAppConfigAudioQuality(uint32_t val) = 0;
	virtual void resetAppConfig() = 0;
	virtual void setFetchVideoProxyMethod(uint32_t fetchMethod) = 0;

public:
	virtual uint32_t getConfigValue(uint32_t key, uint32_t defaultValue) = 0;
	virtual uint32_t getCodeRateLevel() = 0;
	virtual uint32_t getDownLinkRandomLossRate() = 0;
	virtual uint32_t getDownLinkRandomMinJitter() = 0;
	virtual uint32_t getDownLinkRandomMaxJitter() = 0;
	virtual uint32_t getDownlinkBurstLossRate() = 0;
	virtual uint32_t getDownlinkBurstMinJitter() = 0;
	virtual uint32_t getDownlinkBurstMaxJitter() = 0;
	virtual uint32_t getDownlinkBandWidthLimit() = 0;
	virtual uint32_t getUpLinkRandomLossRate() = 0;
	virtual uint32_t getUpLinkRandomMinJitter() = 0;
	virtual uint32_t getUpLinkRandomMaxJitter() = 0;
	virtual uint32_t getUplinkBurstLossRate() = 0;
	virtual uint32_t getUplinkBurstMinJitter() = 0;
	virtual uint32_t getUplinkBurstMaxJitter() = 0;
	virtual uint32_t getUplinkBandWidthLimit() = 0;
	virtual uint32_t getBurstLossCycle() = 0;
	virtual uint32_t getBurstLossPeriod() = 0;
	virtual uint32_t getApplicationType() = 0;
	virtual uint32_t getMaxCodeRate(uint32_t uDefaultMaxRate = 300) = 0;
	virtual uint32_t getCurCodeRate() = 0;
	virtual uint32_t getTotalCodeRate() = 0;
	virtual uint32_t getAudioMinBuffer() = 0;
	virtual uint32_t getAudioQuality() = 0;
	virtual uint32_t getAppConfigAudioQuality() = 0;
	virtual uint32_t getVideoMinJitter() = 0;
	virtual uint32_t getEncodeBitRate(uint32_t defaultBitRate) = 0;
	virtual uint32_t getFlvHttpMode() = 0;
	virtual uint32_t getVideoEncoderType() = 0;
	virtual uint32_t getLowLateMinBuffer() = 0;
	virtual uint32_t getPreferSyncMinBuffer() = 0;
	virtual uint32_t getPreferSyncMaxBuffer() = 0;
	virtual uint32_t getFetchVideoProxyMethod() = 0;

public:
	virtual bool setAppConfig(uint32_t configKey, uint32_t configVal) = 0;
	virtual bool isUseCRControl() = 0;
	virtual bool isCfgEnableFastPlayHightQualityMode() = 0;
	virtual bool isEnableDownLinkEmulate() = 0;
	virtual bool isEnableUpLinkEmulate() = 0;
	virtual bool isAndroidHardDecodeCrash() = 0;
	virtual bool isAppEnableHardwareDecode(uint32_t codecId, bool bDefault, bool live) = 0;
	virtual bool getLowFlowMode() = 0;
	virtual bool isAutoSubcribeStream() = 0;
	virtual bool isEnableWatchCropVideo() = 0;
	virtual bool isVipUser() = 0;
	virtual bool isPublishNeedMix() = 0;
	virtual bool isEnableRtmpRecorder() = 0;
	virtual bool isJoinLocalMedia() = 0;
	virtual bool isCaptureScreen() = 0;
};

class IProxyConfig
{
public:
	IProxyConfig() {}
	virtual ~IProxyConfig() {}

public:
	virtual void resetProxyConfig() = 0;
	virtual void onProxyConfig(const std::map<uint32_t, uint32_t>& config) = 0;
};

class IFrameUtils
{
public:
	IFrameUtils() {}
	virtual ~IFrameUtils() {}

public:
	virtual const char* getFrameTypeDesc(AVframe &frame) = 0;
	virtual uint32_t getCapstampFromVideoStreamData(AVframe &frame) = 0;
	virtual uint32_t getPostampFromVideoStreamData(AVframe &frame) = 0;
	virtual uint32_t getKeyFrameIdxFramSEI(AVframe &frame) = 0;
	virtual int getVideoFrameTypeFromPackType(uint8_t frametype, uint32_t distance) = 0;
	virtual int getVideoCodecType(const char* data,
								  uint32_t length,
								  int frameType,
								  int &realFrameType,
								  bool bDisableParseFrameType) = 0;
	virtual int getUnknowFrameType() = 0;
	virtual int getIFrameType() = 0;
	virtual int getPFrameType() = 0;
	virtual int getBFrameType() = 0;
	virtual int getSEIFrameType() = 0;
	virtual int getIDRFrameType() = 0;
	virtual bool isIFrame(const AVframe &frame) = 0;
	virtual bool isBFrame(const AVframe &frame) = 0;
	virtual bool isPFrame(const AVframe &frame) = 0;
	virtual bool isSEIFrame(const AVframe &frame) = 0;
	virtual bool isVideoKeyFrame(uint32_t frameType) = 0;
	virtual void releaseAVframe(AVframe &frame) = 0;
	virtual void adjustFrameTs(AVframe &frame, int32_t tsDelta) = 0;
	virtual void addAllocNonMemPoolBufferCnt(uint32_t size) = 0;
	virtual void addReleaseNonMemPoolBufferCnt() = 0;
	virtual void addSendToAudioEngineBufferCnt(uint32_t size) = 0;
	virtual void addAllocMemPoolBufferCnt() = 0;
	virtual void addReleaseMemPoolBufferCnt() = 0;
	virtual void showBufferCnt() = 0;
};

class IYYSdkProxy
{
public:
	IYYSdkProxy() {}
	virtual ~IYYSdkProxy() {}

public:
	virtual void callback(IMediaEvent* evt) = 0;

public:
	virtual IAudioDecoder *createAudioDecoder() = 0;
	virtual IVideoDecoder *createVideoDecoder(uint64_t userGroupId,
											  uint64_t streamId,
											  uint32_t orgAppId,
											  bool bUsingRefactorDecoder) = 0;

public:
	virtual void *allocBuff(uint32_t size, bool clear = false, bool bMemPool = false, int alignment = 0) = 0;
	virtual void releaseAudioDecoder(IAudioDecoder *decoder) = 0;
	virtual void releaseVideoDecoder(IVideoDecoder *decoder) = 0;
	virtual void freeBuff(void *data, bool bMemPool = false, bool bStat = true) = 0;
	virtual void setEnableBuffCache(bool isEable) = 0;
	virtual void getLogFileList(std::list<std::string> &fileList) = 0;

public:
	virtual std::string getLogFileName() = 0;
	virtual std::string getLogPath() = 0;
	virtual const char* getWifiLevel(uint32_t rssi) = 0;
	virtual uint64_t getDeviceUid() = 0;
	virtual uint32_t getTickCount() = 0;
	virtual uint32_t getUnixTime() = 0;
	virtual uint32_t getSignalLevel() = 0;
	virtual uint32_t getNetworkType() = 0;
	virtual uint32_t getDurationByNetCodec(int netcodec) = 0;
	virtual uint32_t getFrameDurationByNetCodec(int netcodec, void *data, uint32_t length) = 0;
	virtual int setAndroidThreadPriority(const char* name, int priority) = 0;
	virtual bool checkAudioProcessorByNetCodec(int netcodec) = 0;
	virtual bool getDataFrameLength(int codec, void *data, unsigned int *outLength) = 0;
	virtual bool isSupportNetCodec(int codec) = 0;
	virtual void getSupportAudioCodecTypes(std::vector<unsigned>& codecTypes) = 0;
	virtual void getPublisherEncodeStatInfo(std::map<uint32_t, uint32_t>& itemMap, std::string& statisticString) = 0;
	virtual void getViewerDecodeAndRenderStatInfo(uint64_t streamId, std::map<uint32_t, uint32_t>& itemMap, std::string& statisticString) = 0;
	virtual void getPublisherExtHiddoStatInfo(std::string& statisticString) = 0;
	virtual void getViewerExtHiddoStatInfo(std::string& statisticString) = 0;
	virtual void getChannelsAndSampleRateByNetCodec(int netcodec, uint32_t& channals, uint32_t& sampleRate) = 0;
	virtual bool getAudioCaptureAndEncodeHiidoStatInfo(char*& pCaptureAndEncodeInfo, int& stringLen) = 0;
	virtual bool getAudioRenderHiidoStatInfo(char*& pRenderInfo, int& stringLen) = 0;
	virtual bool getAudioStreamDecodeHiidoStatInfo(uint32_t uid, char*& pDecoderInfo, int& stringLen) = 0;
	virtual bool isUseClockGetTime() = 0;
	virtual void getVideoAnchorEncodeHiidoStatInfo(char* charVideoData, uint32_t* memSize, uint64_t streamId) = 0;
	virtual void getVideoAudienceDecodeHiidoStatInfo(char* charVideoData, uint32_t* memSize, uint64_t streamId) = 0;
	virtual void setThreadName(char* threadName) = 0;

public:
	virtual IAppConfig* getAppConfig() = 0;
	virtual IProxyConfig* getProxyConfig() = 0;
	virtual IFrameUtils* getFrameUtils() = 0;
#ifdef __VOD_SUPPORT__
	virtual ISmartDnsProxy* getSmartDnsProxy() = 0;
#endif
};
