#pragma once
#include "IntTypes.h"
#include "MediaDef.h"

enum Method{
	ROUTE,
	ANSWER,
	END,
	STOP
};

#define HEADER_SIZE 10

class Header
{
public:
	Header()
	: m_length(0)
	, m_uri(0)
	, m_resCode(RES_SUCCESS)
	{
	}

	uint32_t getUri() const
	{
		return m_uri;
	}

	void setUri(uint32_t u)
	{
		m_uri = u;
	}

	uint16_t getResCode() const
	{
		return m_resCode;
	}

	void setResCode(uint16_t res)
	{
		m_resCode = res;
	}

	bool isSuccess() const
	{
		return m_resCode == RES_SUCCESS;
	}

	uint32_t getLength() const
	{
		return m_length;
	}

protected:
	uint32_t m_length;
	uint32_t m_uri;
	uint16_t m_resCode;
};

