#ifndef _AUDIO_CODEC_COMMON_HEADER_
#define _AUDIO_CODEC_COMMON_HEADER_

#include<string>

enum AudioCodecType {
	UNKNOWN_CODEC = -1,       // Error Codec
	AAC_PLUS_CODEC = 1,       // NET_AACPLUS
	AAC_ELD_CODEC = 4,        // ELD mode
	SILK_CODEC = 2,           // NET_SILK_16K
	SPEEX_CODEC_8 = 0,        // NET_SPEEX_MODE_8
	SPEEX_CODEC_4 = 21,       // NET_SPEEX_MODE_4
	SPEEX_CODEC_2 = 23,       // NET_SPEEX_MODE_2
	AAC_LC_CODEC = 35,        // NET_AAC_128K	
	WAV_CODEC = 0xFF,         // Wav Codec, not support speech message player, only recorder
};

enum AacCoderType
{
	LC_AAC = 0,
	EPLUS_AAC = 1,
	ELD_AAC = 2,
};

struct CodecParameter {
	CodecParameter() :
	channels(0),
	sampleRate(0),
	bps(0),
	bitRate(0),
	vbr(0),
	timePerEncodedFrame(0),
	samplePerFrame(0),
	quality(0) {}

	int channels;
	int sampleRate;
	int bps;   // bit per sample 
	int bitRate;
	int vbr;
	int timePerEncodedFrame;
	int samplePerFrame;
	int quality;
};

class IAudioEncoder
{
public:
	virtual ~IAudioEncoder(){}
	virtual void Destroy() = 0;
	virtual int  GetEncoderBytes() = 0;
	virtual bool Init() = 0;
	virtual void Uninit() = 0;
	virtual void Flush() = 0;
	virtual int Encode(const char* pInPCM, int inLen, std::string& outData) = 0; 
	virtual int EncodeLoss(std::string& outData) = 0;
	virtual void SetBitRate(int bitRate) = 0;
	virtual void SetComplexity(int complexity) = 0;
};

class IAudioDecoder
{
public:
	virtual ~IAudioDecoder() {}
	virtual void Destroy() = 0;
	virtual bool Init() = 0;
	virtual void Uninit() = 0;
	virtual void Flush() = 0;
	virtual bool Decode(const char* pInData, int inLen, std::string& outPCM) = 0;
	virtual bool DecodeLoss(std::string& outPCM) = 0;
};

IAudioEncoder*  CreateAudioEncoder(AudioCodecType type);
IAudioDecoder*  CreateAudioDecoder(AudioCodecType type);
CodecParameter GetCodecParameter(AudioCodecType type); 

#endif 
