/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import android.util.Log;
import com.yy.audioengine.AudioEngine;
import com.yy.audioengine.Constant;
import com.yy.audioengine.FilePlayer;
import com.yy.audioengine.IFilePlayerNotify;
import com.yy.audioengine.IKaraokePlaybackNotify;
import com.yy.audioengine.TimeRange;
import java.util.Arrays;

public class KaraokePlayBack
implements IFilePlayerNotify {
    private static String TAG = "KaraokePlayBack";
    private IKaraokePlaybackNotify mNotify;
    private AudioEngine mAudioEngine;
    private FilePlayer mVoicePlayer;
    private FilePlayer mAccompanyFilePlayer;
    private boolean mIsAccompanyOpen;
    private boolean mIsVoiceOpen;
    private boolean mChooseFile;

    public void Init() {
        Log.i((String)TAG, (String)"Init.....");
        this.mAudioEngine = new AudioEngine();
        this.mAudioEngine.StartAudioEngine(Constant.AudioEngineMode.Broadcast);
        this.mVoicePlayer = new FilePlayer();
        this.mAccompanyFilePlayer = new FilePlayer();
        this.mVoicePlayer.EnableEffect(true);
        this.mVoicePlayer.EnableEtb(true);
        this.mVoicePlayer.EnableDrc(true);
        this.mVoicePlayer.SetDenoiseType(Constant.DenoiseModuleType.SpeexNsType);
        this.mVoicePlayer.EnableDenoiser(true);
    }

    public void Destroy() {
        Log.i((String)TAG, (String)"Destroy.....");
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Destroy();
            this.mAccompanyFilePlayer = null;
        }
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.Destroy();
            this.mVoicePlayer = null;
        }
        if (this.mAudioEngine != null) {
            this.mAudioEngine.Destroy();
            this.mAudioEngine = null;
        }
        this.mIsAccompanyOpen = false;
        this.mIsVoiceOpen = false;
        this.mChooseFile = false;
        this.mNotify = null;
    }

    public boolean Open(String voiceFile, String accompanyFile) {
        long accompanyFileTime;
        Log.i((String)TAG, (String)("Open, voiceFile: " + voiceFile + " ,accompanyFile: " + accompanyFile));
        if (!this.OpenVoiceFile(voiceFile)) {
            Log.e((String)TAG, (String)"OpenVoiceFile fail...");
            return false;
        }
        if (!this.OpenAccompanyFile(accompanyFile)) {
            Log.e((String)TAG, (String)"OpenAccompanyFile fail...");
            return false;
        }
        long voiceFileTime = this.mVoicePlayer.GetTotalPlayLengthMS();
        if (voiceFileTime > (accompanyFileTime = this.mAccompanyFilePlayer.GetTotalPlayLengthMS())) {
            this.mChooseFile = true;
            this.mVoicePlayer.RegisterNotify(this);
            this.mVoicePlayer.EnableVolumeNotify(true);
        } else {
            this.mChooseFile = false;
            this.mAccompanyFilePlayer.RegisterNotify(this);
            this.mAccompanyFilePlayer.EnableVolumeNotify(true);
        }
        return true;
    }

    private boolean OpenVoiceFile(String fileName) {
        boolean res = this.mVoicePlayer != null ? this.mVoicePlayer.Open(fileName) : false;
        this.mIsVoiceOpen = res;
        Log.i((String)TAG, (String)("OpenVoiceFile, mIsVoiceOpen:" + this.mIsVoiceOpen));
        return res;
    }

    private boolean OpenAccompanyFile(String fileName) {
        boolean res = this.mAccompanyFilePlayer != null ? this.mAccompanyFilePlayer.Open(fileName) : false;
        this.mIsAccompanyOpen = res;
        Log.i((String)TAG, (String)("OpenAccompanyFile, mIsAccompanyOpen:" + this.mIsAccompanyOpen));
        return res;
    }

    public void Play() {
        Log.i((String)TAG, (String)"Play.....");
        if (this.mIsAccompanyOpen) {
            this.mAccompanyFilePlayer.Play();
        }
        if (this.mIsVoiceOpen) {
            this.mVoicePlayer.Play();
        }
    }

    public void Stop() {
        Log.i((String)TAG, (String)"Stop.....");
        if (this.mIsAccompanyOpen && this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Stop();
        }
        if (this.mIsVoiceOpen && this.mAccompanyFilePlayer != null) {
            this.mVoicePlayer.Stop();
        }
    }

    public void Pause() {
        Log.i((String)TAG, (String)"Pause.....");
        if (this.mIsAccompanyOpen) {
            this.mAccompanyFilePlayer.Pause();
        }
        if (this.mIsVoiceOpen) {
            this.mVoicePlayer.Pause();
        }
    }

    public void Resume() {
        Log.i((String)TAG, (String)"Resume.....");
        if (this.mIsAccompanyOpen) {
            this.mAccompanyFilePlayer.Resume();
        }
        if (this.mIsVoiceOpen) {
            this.mVoicePlayer.Resume();
        }
    }

    public void Seek(long seekTime) {
        Log.i((String)TAG, (String)("Seek, seekTime: " + seekTime));
        if (this.mIsAccompanyOpen) {
            this.mAccompanyFilePlayer.Seek(seekTime);
        }
        if (this.mIsVoiceOpen) {
            this.mVoicePlayer.Seek(seekTime);
        }
    }

    public void SetKaraokePlaybackNotify(IKaraokePlaybackNotify notify) {
        Log.i((String)TAG, (String)("setKaraokePlaybackNotify: " + notify));
        this.mNotify = notify;
    }

    private void EnableReverbEx(boolean enable) {
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.EnableReverbEx(enable);
        }
    }

    private void SetReverbParamEx(float[] array) {
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.SetReverbParameter(array);
        }
    }

    public void EnableReverbNew(boolean enable) {
        Log.i((String)TAG, (String)("EnableReverbNew. enable: " + enable));
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.EnableReverbFv3(enable);
        }
    }

    public void SetReverbNewParam(float[] array) {
        Log.i((String)TAG, (String)("SetReverbNewParam,array: " + Arrays.toString(array)));
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.SetReverbFv3Param(array);
        }
    }

    public void EnableEqualizer(boolean enable) {
        Log.i((String)TAG, (String)("EnableEqualizer. enable: " + enable));
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.EnableEqualizerEx(enable);
        }
    }

    public void SetEqGains(float[] array) {
        Log.i((String)TAG, (String)("SetEqGains,array: " + Arrays.toString(array)));
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.SetEqualizerParameter(array);
        }
    }

    public void EnableCompressor(boolean enable) {
        Log.i((String)TAG, (String)("EnableCompressor. enable: " + enable));
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.EnableCompressor(enable);
        }
    }

    public void SetCompressorParam(int[] array) {
        Log.i((String)TAG, (String)("SetCompressorParam,array: " + Arrays.toString(array)));
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.SetCompressorParameter(array);
        }
    }

    public void EnableLimiter(boolean enable) {
        Log.i((String)TAG, (String)("EnableLimiter. enable: " + enable));
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.EnableLimiter(enable);
        }
    }

    public void SetLimiterParam(float[] array) {
        Log.i((String)TAG, (String)("SetLimiterParam,array: " + Arrays.toString(array)));
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.SetLimiterParam(array);
        }
    }

    public void SetTone(int tone) {
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.SetToneSelValue(tone);
        }
    }

    public void SetEtbValue(int value) {
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.SetTrebleBassVal(value);
        }
    }

    public void EnableDenoise(boolean enable) {
        if (this.mVoicePlayer != null) {
            if (enable) {
                this.mVoicePlayer.SetDenoiseType(Constant.DenoiseModuleType.AecImproveNsType);
            } else {
                this.mVoicePlayer.SetDenoiseType(Constant.DenoiseModuleType.SpeexNsType);
            }
        }
    }

    public void SetVoiceVolume(int volume) {
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.SetPlayerVolume(volume);
        }
    }

    public void SetAccompanyVolume(int volume) {
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.SetPlayerVolume(volume);
        }
    }

    public long GetTotalPlayBackTimeMs() {
        if (this.mVoicePlayer == null || this.mAccompanyFilePlayer == null) {
            return 0L;
        }
        if (this.mChooseFile) {
            return this.mVoicePlayer.GetTotalPlayLengthMS();
        }
        return this.mAccompanyFilePlayer.GetTotalPlayLengthMS();
    }

    public long GetCurrentPlayBackTimeMs() {
        if (this.mVoicePlayer == null || this.mAccompanyFilePlayer == null) {
            return 0L;
        }
        if (this.mChooseFile) {
            return this.mVoicePlayer.GetCurrentPlayTimeMS();
        }
        return this.mAccompanyFilePlayer.GetCurrentPlayTimeMS();
    }

    public boolean SetSingRefLyricTimeRange(TimeRange[] timeRanges, int count) {
        boolean res = this.mAudioEngine != null ? this.mAudioEngine.SetSingRefLyricTimeRange(timeRanges, count) : false;
        return res;
    }

    public boolean SetSingWordTimeFile(String fileName) {
        boolean res = this.mAudioEngine != null ? this.mAudioEngine.SetSingRefLyricFile(fileName) : false;
        return res;
    }

    public boolean SetSingRefMfccFile(String fileName) {
        boolean res = this.mAudioEngine != null ? this.mAudioEngine.SetSingRefMfccFile(fileName) : false;
        return res;
    }

    public boolean SetSingRefPitchFile(String fileName) {
        boolean res = this.mAudioEngine != null ? this.mAudioEngine.SetSingRefPitchFile(fileName) : false;
        return res;
    }

    public boolean OneKeySingingAutoTuneProcess(int mode, String inputPath, String outputPath) {
        boolean res = this.mAudioEngine != null ? this.mAudioEngine.OneKeySingingAutoTuneProcess(mode, inputPath, outputPath) : false;
        return res;
    }

    @Override
    public void OnPlayerEnd() {
        Log.d((String)TAG, (String)"OnPlayerEnd...");
        if (this.mNotify != null) {
            this.mNotify.OnKaraokePlayBackEnd();
        }
    }

    @Override
    public void OnPlayerVolume(int volume, long currentTime, long totalTime) {
        Log.d((String)TAG, (String)("OnPlayerVolume, volume: " + volume + " ,currentTime: " + currentTime + " ,totalTime: " + totalTime));
        if (this.mNotify != null) {
            this.mNotify.OnKaraokePlayBackTimeInfo(currentTime, totalTime);
        }
    }
}

