/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.ISpeechMsgRecorderNotify;

public class SpeechMsgRecorder {
    private long mRecorderCtx;
    private ISpeechMsgRecorderNotify mNotify = null;

    SpeechMsgRecorder(String fileName, int uid, SpeechMsgCodecType codecType, long maxDuration) {
        int codecTypeInt = codecType.ordinal();
        this.mRecorderCtx = this.nativeCreate(this, fileName, uid, codecTypeInt, maxDuration);
    }

    public RECORDER_INIT_STATUS Init() {
        long res = this.nativeInit(this.mRecorderCtx);
        return RECORDER_INIT_STATUS.ERROR_NONE;
    }

    public void Start(ISpeechMsgRecorderNotify notify) {
        this.mNotify = notify;
        this.nativeStart(this.mRecorderCtx);
    }

    public void Stop() {
        this.nativeStop(this.mRecorderCtx);
    }

    public void Pause() {
        this.nativePause(this.mRecorderCtx);
    }

    public void Resume() {
        this.nativeResume(this.mRecorderCtx);
    }

    public void Seek(long seekTime) {
        this.nativeSeek(this.mRecorderCtx, seekTime);
    }

    public void Destroy() {
        this.mRecorderCtx = this.nativeDestroy(this.mRecorderCtx);
    }

    public void EnableReverbEx(boolean enable) {
        this.nativeEnableReverbEx(this.mRecorderCtx, enable);
    }

    public void SetReverbParamEx(float[] parameter_array) {
        this.nativeSetReverbParamEx(this.mRecorderCtx, parameter_array);
    }

    public void EnableReverbFv3(boolean enable) {
        this.nativeEnableReverbFv3(this.mRecorderCtx, enable);
    }

    public void SetReverbFv3Param(float[] parameter_array) {
        this.nativeSetReverbFv3Param(this.mRecorderCtx, parameter_array);
    }

    public void EnableEqualizer(boolean enable) {
        this.nativeEnableEqualizerEx(this.mRecorderCtx, enable);
    }

    public void SetEqGains(float[] parameter_array) {
        this.nativeSetEqGains(this.mRecorderCtx, parameter_array);
    }

    public void EnableCompressor(boolean enable) {
        this.nativeEnableCompressor(this.mRecorderCtx, enable);
    }

    public void SetCompressorParam(int[] parameter_array) {
        this.nativeSetCompressorParam(this.mRecorderCtx, parameter_array);
    }

    public void EnableLimiter(boolean enable) {
        this.nativeEnableLimiter(this.mRecorderCtx, enable);
    }

    public void SetLimiterParam(float[] parameter_array) {
        this.nativeSetLimiterParam(this.mRecorderCtx, parameter_array);
    }

    public void SetVolume(long volume) {
        this.nativeSetVolume(this.mRecorderCtx, volume);
    }

    public void StartAudioPreview() {
        this.nativeStartAudioPreview(this.mRecorderCtx);
    }

    public void StopAudioPreview() {
        this.nativeStopAudioPreview(this.mRecorderCtx);
    }

    private void OnAudioVolumeVisualEvent(long recordTime, long volume) {
        if (this.mNotify != null) {
            this.mNotify.OnAudioVolumeVisual(recordTime, volume);
        }
    }

    private void OnAudioRecordErrorEvent() {
        if (this.mNotify != null) {
            this.mNotify.OnAudioRecordError();
        }
    }

    private void OnGetFirstRecordDataEvent() {
        if (this.mNotify != null) {
            this.mNotify.OnGetFirstRecordData();
        }
    }

    private void OnStopRecordDataEvent(long recordTime, long maxDuration) {
        if (this.mNotify != null) {
            this.mNotify.OnStopRecordData(recordTime, maxDuration);
        }
    }

    private void OnReachMaxDurationEvent(long recordTime, long maxDuration) {
        if (this.mNotify != null) {
            this.mNotify.OnReachMaxDuration(recordTime, maxDuration);
        }
    }

    private native long nativeCreate(Object var1, String var2, int var3, int var4, long var5);

    private native long nativeDestroy(long var1);

    private native long nativeInit(long var1);

    private native void nativeStart(long var1);

    private native void nativeStop(long var1);

    private native void nativePause(long var1);

    private native void nativeResume(long var1);

    private native void nativeSeek(long var1, long var3);

    private native void nativeEnableReverbEx(long var1, boolean var3);

    private native void nativeEnableReverbFv3(long var1, boolean var3);

    private native void nativeEnableEqualizerEx(long var1, boolean var3);

    private native void nativeEnableCompressor(long var1, boolean var3);

    private native void nativeEnableLimiter(long var1, boolean var3);

    private native void nativeSetReverbParamEx(long var1, float[] var3);

    private native void nativeSetReverbFv3Param(long var1, float[] var3);

    private native void nativeSetEqGains(long var1, float[] var3);

    private native void nativeSetCompressorParam(long var1, int[] var3);

    private native void nativeSetLimiterParam(long var1, float[] var3);

    private native void nativeSetVolume(long var1, long var3);

    private native void nativeStartAudioPreview(long var1);

    private native void nativeStopAudioPreview(long var1);

    public static enum SpeechMsgCodecType {
        SpeechMsgCodecSilk,
        SpeechMsgCodecSpeex,
        SpeechMsgCodecEaacPlus,
        SpeechMsgCodecLcAAC,
        SpeechMsgCodecWav;

    }

    public static enum RECORDER_INIT_STATUS {
        ERROR_NONE,
        ERROR_UNKNOWN_CODEC,
        ERROR_ENCODER_INIT,
        ERROR_FILE_OPEN_FAIL;

    }
}

