/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import android.util.Log;
import com.yy.audioengine.AudioConfig;
import com.yy.audioengine.AudioEngine;
import com.yy.audioengine.Constant;
import com.yy.audioengine.FilePlayer;
import com.yy.audioengine.IAudioLibJniInit;
import com.yy.audioengine.IFilePlayerNotify;
import com.yy.audioengine.IKaraokeNotify;
import com.yy.audioengine.IKaraokeScoreNotify;
import com.yy.audioengine.ISpeechMsgRecorderNotify;
import com.yy.audioengine.SpeechMsgRecorder;
import com.yy.audioengine.TimeRange;
import java.util.Arrays;

public class Karaoke
implements IFilePlayerNotify,
ISpeechMsgRecorderNotify,
IKaraokeScoreNotify {
    private static String TAG = "Karaoke";
    private IKaraokeNotify mNotify;
    private AudioEngine mAudioEngine;
    private FilePlayer mMixFilePlayer;
    private FilePlayer mAccompanyFilePlayer;
    private SpeechMsgRecorder mRecorder;
    private boolean mIsMixPlay;
    private boolean mIsMixFileOpened;
    private boolean mIsAccompanyFileOpened;
    private boolean mIsScoreStarted;

    public void Init() {
        Log.i((String)TAG, (String)("Init... isLowLatencyPlayBack: " + AudioConfig.IsEnableLowLatencyPlayBack()));
        if (AudioConfig.IsEnableLowLatencyPlayBack()) {
            IAudioLibJniInit.EnableAndroidOpenSlEs(true);
        }
        this.mAudioEngine = new AudioEngine();
        this.mAudioEngine.StartAudioEngine(Constant.AudioEngineMode.Broadcast);
        this.mAudioEngine.SetLoudspeakerStatus(true);
        this.mMixFilePlayer = new FilePlayer();
        this.mAccompanyFilePlayer = new FilePlayer();
        this.mAccompanyFilePlayer.EnableVolumeNotify(true);
        this.mAudioEngine.EnableKaraokeScoreEx(true);
        this.mAudioEngine.EnableKaraokeScore(true);
        this.mIsMixPlay = false;
        this.mIsMixFileOpened = false;
        this.mIsAccompanyFileOpened = false;
        this.mIsScoreStarted = false;
    }

    public void Destroy() {
        Log.i((String)TAG, (String)"Destroy...");
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Destroy();
            this.mAccompanyFilePlayer = null;
        }
        if (this.mMixFilePlayer != null) {
            this.mMixFilePlayer.Destroy();
            this.mMixFilePlayer = null;
        }
        if (this.mRecorder != null) {
            this.mRecorder.Destroy();
            this.mRecorder = null;
        }
        if (this.mAudioEngine != null) {
            this.mAudioEngine.EnableKaraokeScore(false);
            this.mAudioEngine.Destroy();
            this.mAudioEngine = null;
        }
        if (AudioConfig.IsEnableLowLatencyPlayBack()) {
            IAudioLibJniInit.EnableAndroidOpenSlEs(false);
        }
        this.mNotify = null;
    }

    public void SetKaraokeListener(IKaraokeNotify notify) {
        this.mNotify = notify;
    }

    public boolean OpenInputFile(String mixerFile, String accompanyFile) {
        Log.i((String)TAG, (String)("OpenInputFile, mixerFile: " + mixerFile + " ,accompanyFile: " + accompanyFile));
        if (!this.OpenMixFile(mixerFile)) {
            return false;
        }
        return this.OpenAccompanyFile(accompanyFile);
    }

    public boolean OpenOutputFile(String voiceRecordFile, String accompanyRecordFile) {
        Log.i((String)TAG, (String)("OpenOutputFile, voiceRecordFile: " + voiceRecordFile + " ,accompanyRecordFile: " + accompanyRecordFile));
        if (!this.OpenVoiceRecorder(voiceRecordFile)) {
            Log.e((String)TAG, (String)"OpenVoiceRecorder fail.....");
            return false;
        }
        if (!this.StartAccompanySaver(accompanyRecordFile)) {
            Log.e((String)TAG, (String)"StartAccompanySaver fail.....");
            return false;
        }
        return false;
    }

    private boolean OpenMixFile(String fileName) {
        boolean res = this.mMixFilePlayer != null ? this.mMixFilePlayer.Open(fileName) : false;
        this.mIsMixFileOpened = res;
        Log.d((String)TAG, (String)("OpenMixFile:" + res));
        return res;
    }

    private boolean OpenAccompanyFile(String fileName) {
        boolean res = this.mAccompanyFilePlayer != null ? this.mAccompanyFilePlayer.Open(fileName) : false;
        this.mIsAccompanyFileOpened = res;
        Log.d((String)TAG, (String)("OpenAccompanyFile:" + res));
        return res;
    }

    private boolean OpenVoiceRecorder(String fileName) {
        if (this.mRecorder != null) {
            this.mRecorder.Destroy();
            this.mRecorder = null;
        }
        this.mRecorder = new SpeechMsgRecorder(fileName, 0, SpeechMsgRecorder.SpeechMsgCodecType.SpeechMsgCodecWav, 600000L);
        this.mRecorder.Init();
        return true;
    }

    private boolean StartAccompanySaver(String fileName) {
        boolean res = false;
        if (this.mAccompanyFilePlayer != null) {
            res = this.mAccompanyFilePlayer.StartSaver(fileName);
        }
        return res;
    }

    public void Start() {
        Log.i((String)TAG, (String)("Start...mIsAccompanyFileOpened:  " + this.mIsAccompanyFileOpened + " ,mIsMixFileOpened: " + this.mIsMixFileOpened));
        this.SetOnePlayerMut();
        if (this.mIsAccompanyFileOpened) {
            this.mAccompanyFilePlayer.RegisterNotify(this);
            this.mAccompanyFilePlayer.Play();
        }
        if (this.mIsMixFileOpened) {
            this.mMixFilePlayer.Play();
        }
        if (this.mRecorder != null) {
            this.mRecorder.Start(this);
            if (AudioConfig.IsEnableLowLatencyPlayBack()) {
                this.EnablePlayBack(true);
            } else {
                this.mRecorder.StartAudioPreview();
            }
        }
        if (!this.mIsScoreStarted) {
            this.mIsScoreStarted = true;
            this.mAudioEngine.StartKaraokeScore(this);
        }
    }

    private void SetOnePlayerMut() {
        Log.d((String)TAG, (String)("SetOnePlayerMut...mIsMixPlay: " + this.mIsMixPlay));
        if (this.mIsMixPlay) {
            this.mAccompanyFilePlayer.EnableMute(true);
            this.mMixFilePlayer.EnableMute(false);
        } else {
            this.mAccompanyFilePlayer.EnableMute(false);
            this.mMixFilePlayer.EnableMute(true);
        }
    }

    public void Pause() {
        Log.d((String)TAG, (String)"Pause....");
        if (this.mIsAccompanyFileOpened) {
            this.mAccompanyFilePlayer.Pause();
        }
        if (this.mIsMixFileOpened) {
            this.mMixFilePlayer.Pause();
        }
        if (this.mRecorder != null) {
            this.mRecorder.Pause();
        }
        if (this.mIsScoreStarted) {
            this.mAudioEngine.PauseKaraokeScore(true);
        }
    }

    public void Resume() {
        Log.d((String)TAG, (String)"Resume....");
        if (this.mIsAccompanyFileOpened) {
            this.mAccompanyFilePlayer.Resume();
        }
        if (this.mIsMixFileOpened) {
            this.mMixFilePlayer.Resume();
        }
        if (this.mRecorder != null) {
            this.mRecorder.Resume();
        }
        if (this.mIsScoreStarted) {
            this.mAudioEngine.PauseKaraokeScore(false);
        }
    }

    public void Stop() {
        Log.d((String)TAG, (String)"Stop....");
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Stop();
        }
        if (this.mMixFilePlayer != null) {
            this.mMixFilePlayer.Stop();
        }
        if (this.mRecorder != null) {
            if (AudioConfig.IsEnableLowLatencyPlayBack()) {
                this.EnablePlayBack(false);
            } else {
                this.mRecorder.StopAudioPreview();
            }
            this.mRecorder.Stop();
        }
        if (this.mIsScoreStarted) {
            this.mIsScoreStarted = false;
            this.mAudioEngine.StopKaraokeScore();
        }
        if (this.mAudioEngine != null) {
            this.mAudioEngine.ResetKaraokeScore(0L);
        }
    }

    public boolean Seek(long seekTime) {
        if (this.mMixFilePlayer != null) {
            this.mMixFilePlayer.Seek(seekTime);
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Seek(seekTime);
            this.mAccompanyFilePlayer.SeekSaver(seekTime);
        }
        if (this.mRecorder != null) {
            this.mRecorder.Seek(seekTime);
        }
        if (this.mAudioEngine != null) {
            this.mAudioEngine.ResetKaraokeScore(0L);
        }
        return true;
    }

    public boolean OpenScoreRefFile(String fileName) {
        boolean res = this.mAudioEngine != null ? this.mAudioEngine.OpenScoreRefFile(fileName) : false;
        return res;
    }

    public byte[] SetScoreTimeRange(TimeRange[] timeRanges, int count) {
        byte[] pitchVisual = new byte[count];
        if (this.mAudioEngine != null) {
            Log.i((String)TAG, (String)("SetScoreTimeRange, count: " + count));
            pitchVisual = this.mAudioEngine.SetScoreTimeRange(timeRanges, count);
        }
        return pitchVisual;
    }

    public long GetPlayerTime() {
        long total_time = 0L;
        if (this.mAccompanyFilePlayer != null) {
            total_time = this.mAccompanyFilePlayer.GetTotalPlayLengthMS();
        }
        return total_time;
    }

    public long GetCurrentPlayerTime() {
        long current_time = 0L;
        if (this.mAccompanyFilePlayer != null) {
            current_time = this.mAccompanyFilePlayer.GetCurrentPlayTimeMS();
        }
        return current_time;
    }

    public void SetVoiceVolume(int volume) {
        if (AudioConfig.IsEnableLowLatencyPlayBack()) {
            this.mAudioEngine.SetPlayBackVolume(volume);
        } else if (this.mRecorder != null) {
            this.mRecorder.SetVolume(volume);
        }
    }

    public void SetAccompanyVolume(int volume) {
        if (this.mMixFilePlayer != null) {
            this.mMixFilePlayer.SetPlayerVolume(volume);
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.SetPlayerVolume(volume);
        }
    }

    public void SetTone(int tone) {
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.SetToneSelValue(tone);
        }
        if (this.mMixFilePlayer != null) {
            this.mMixFilePlayer.SetToneSelValue(tone);
        }
    }

    public boolean SetChooseMixFilePlay(boolean mixPlay) {
        if (mixPlay != this.mIsMixPlay) {
            this.mIsMixPlay = mixPlay;
            this.SetOnePlayerMut();
        }
        return true;
    }

    public void EnableSingingAutoTune(boolean enable) {
        this.mAudioEngine.EnableSingingAutoTune(enable);
        long currentPlayingTime = 0L;
        if (this.mAccompanyFilePlayer != null && enable) {
            currentPlayingTime = this.mAccompanyFilePlayer.GetCurrentPlayTimeMS();
            this.mAudioEngine.SetCurrentPlayingPosition(currentPlayingTime);
        }
    }

    public boolean SetSingRefPitchFile(String fileName) {
        boolean res = this.mAudioEngine != null ? this.mAudioEngine.SetSingRefPitchFile(fileName) : false;
        return res;
    }

    private boolean EnablePlayBack(boolean enable) {
        if (this.mAudioEngine != null) {
            this.mAudioEngine.SetPlaybackModeOn(enable);
        }
        return true;
    }

    private void EnableReverbEx(boolean enable) {
        if (this.mRecorder != null) {
            this.mRecorder.EnableReverbEx(enable);
        }
    }

    private void SetReverbParamEx(float[] array) {
        if (this.mRecorder != null) {
            this.mRecorder.SetReverbParamEx(array);
        }
    }

    public void EnableReverbNew(boolean enable) {
        Log.i((String)TAG, (String)("EnableReverbNew. enable: " + enable));
        if (this.mRecorder != null) {
            this.mRecorder.EnableReverbFv3(enable);
        }
    }

    public void SetReverbNewParam(float[] array) {
        Log.i((String)TAG, (String)("SetReverbNewParam,array: " + Arrays.toString(array)));
        if (this.mRecorder != null) {
            this.mRecorder.SetReverbFv3Param(array);
        }
    }

    public void EnableEqualizer(boolean enable) {
        Log.i((String)TAG, (String)("EnableEqualizer. enable: " + enable));
        if (this.mRecorder != null) {
            this.mRecorder.EnableEqualizer(enable);
        }
    }

    public void SetEqGains(float[] array) {
        Log.i((String)TAG, (String)("SetEqGains,array: " + Arrays.toString(array)));
        if (this.mRecorder != null) {
            this.mRecorder.SetEqGains(array);
        }
    }

    public void EnableCompressor(boolean enable) {
        Log.i((String)TAG, (String)("EnableCompressor. enable: " + enable));
        if (this.mRecorder != null) {
            this.mRecorder.EnableCompressor(enable);
        }
    }

    public void SetCompressorParam(int[] array) {
        Log.i((String)TAG, (String)("SetEqGains,array: " + Arrays.toString(array)));
        if (this.mRecorder != null) {
            this.mRecorder.SetCompressorParam(array);
        }
    }

    public void EnableLimiter(boolean enable) {
        Log.i((String)TAG, (String)("EnableLimiter. enable: " + enable));
        if (this.mRecorder != null) {
            this.mRecorder.EnableLimiter(enable);
        }
    }

    public void SetLimiterParam(float[] array) {
        Log.i((String)TAG, (String)("SetLimiterParam,array: " + Arrays.toString(array)));
        if (this.mRecorder != null) {
            this.mRecorder.SetLimiterParam(array);
        }
    }

    @Override
    public void OnPlayerEnd() {
        Log.i((String)TAG, (String)"OnPlayerEnd..");
        if (this.mNotify != null) {
            this.mNotify.OnKaraokePlayEnd();
        }
    }

    @Override
    public void OnPlayerVolume(int volume, long currentTime, long totalTime) {
        if (this.mNotify != null) {
            this.mNotify.OnKaraokeCurrentPlayVolume(volume, currentTime);
        }
    }

    @Override
    public void OnAudioVolumeVisual(long recordTime, long volume) {
        if (this.mNotify != null) {
            this.mNotify.OnKaraokeCurrentRecordVolume(volume, recordTime);
        }
    }

    @Override
    public void OnAudioRecordError() {
    }

    @Override
    public void OnGetFirstRecordData() {
    }

    @Override
    public void OnStopRecordData(long recordTime, long maxDuration) {
    }

    @Override
    public void OnReachMaxDuration(long recordTime, long maxDuration) {
    }

    @Override
    public void OnCalcKaraokeScore(byte score, long lineId) {
        if (this.mNotify != null) {
            Log.i((String)TAG, (String)("OnCalcKaraokeScore...score: " + score + ", lineId: " + lineId));
            this.mNotify.OnKaraokeScore(score, lineId);
        }
    }

    @Override
    public void OnSingerPitchVisual(byte val, long lineId, long wordId, long wordNum) {
        if (this.mNotify != null) {
            Log.i((String)TAG, (String)("OnSingerPitchVisual...val: " + val + ", lineId: " + lineId + " ,wordId: " + wordId + " ,wordNum: " + wordNum));
            this.mNotify.OnKaraokePitch(val, lineId, wordId, wordNum);
        }
    }
}

