/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.Constant;
import com.yy.audioengine.IFilePlayerNotify;

public class FilePlayer {
    private IFilePlayerNotify mNotify = null;
    private long mPlayerCtx = this.nativeCreateFilePlayer(this);

    public void RegisterNotify(IFilePlayerNotify notify) {
        this.mNotify = notify;
    }

    public boolean Open(String FileName) {
        return this.nativeOpen(this.mPlayerCtx, FileName);
    }

    public void Destroy() {
        this.mPlayerCtx = this.nativeDestroy(this.mPlayerCtx);
    }

    public void Play() {
        this.nativePlay(this.mPlayerCtx);
    }

    public void Stop() {
        this.nativeStop(this.mPlayerCtx);
    }

    public void Pause() {
        this.nativePause(this.mPlayerCtx);
    }

    public void Resume() {
        this.nativeResume(this.mPlayerCtx);
    }

    public void EnableLoopPlay(boolean enable) {
        this.nativeEnableLoopPlay(this.mPlayerCtx, enable);
    }

    public void Seek(long targetMS) {
        this.nativeSeek(this.mPlayerCtx, targetMS);
    }

    public void SeekSaver(long targetMS) {
        this.nativeSeekSaver(this.mPlayerCtx, targetMS);
    }

    public void SetPlayerVolume(long volume) {
        this.nativeSetPlayerVolume(this.mPlayerCtx, volume);
    }

    public void EnableVolumeNotify(boolean enable) {
        this.nativeEnableVolumeNotify(this.mPlayerCtx, enable);
    }

    public void SetFeedBackToMicMode(FilePlayerMixerType mode) {
        long modeLong = mode.ordinal();
        this.nativeSetFeedBackToMicMode(this.mPlayerCtx, modeLong);
    }

    public void EnableEffect(boolean enable) {
        this.nativeEnableEffect(this.mPlayerCtx, enable);
    }

    public void EnableReverbEx(boolean enable) {
        this.nativeEnableReverbEx(this.mPlayerCtx, enable);
    }

    public void EnableReverbFv3(boolean enable) {
        this.nativeEnableReverbFv3(this.mPlayerCtx, enable);
    }

    public void EnableEqualizerEx(boolean enable) {
        this.nativeEnableEqualizerEx(this.mPlayerCtx, enable);
    }

    public void EnableCompressor(boolean enable) {
        this.nativeEnableCompressor(this.mPlayerCtx, enable);
    }

    public void EnableLimiter(boolean enable) {
        this.nativeEnableLimiter(this.mPlayerCtx, enable);
    }

    public void SetReverbParameter(float[] parameter_array) {
        this.nativeSetReverbParameter(this.mPlayerCtx, parameter_array);
    }

    public void SetReverbFv3Param(float[] parameter_array) {
        this.nativeSetReverbFv3Param(this.mPlayerCtx, parameter_array);
    }

    public void SetEqualizerParameter(float[] parameter_array) {
        this.nativeSetEqualizerParameter(this.mPlayerCtx, parameter_array);
    }

    public void SetCompressorParameter(int[] parameter_array) {
        this.nativeSetCompressorParam(this.mPlayerCtx, parameter_array);
    }

    public void SetLimiterParam(float[] parameter_array) {
        this.nativeSetLimiterParam(this.mPlayerCtx, parameter_array);
    }

    public void SetToneSelValue(int sel) {
        this.nativeSetToneSelValue(this.mPlayerCtx, sel);
    }

    public void SetTrebleBassVal(int val) {
        this.nativeSetTrebleBassVal(this.mPlayerCtx, val);
    }

    public long GetFileTimeMs() {
        return this.nativeGetTotalPlayLengthMS(this.mPlayerCtx);
    }

    public long GetCurrentPlayTimeMS() {
        return this.nativeGetCurrentPlayTimeMS(this.mPlayerCtx);
    }

    public long GetTotalPlayLengthMS() {
        return this.nativeGetTotalPlayLengthMS(this.mPlayerCtx);
    }

    public boolean StartSaver(String fileName) {
        return this.nativeStartSaver(this.mPlayerCtx, fileName);
    }

    public boolean StopSaver() {
        return this.nativeStopSaver(this.mPlayerCtx);
    }

    public void EnableMute(boolean enable) {
        this.nativeEnableMute(this.mPlayerCtx, enable);
    }

    public void EnableEtb(boolean enable) {
        this.nativeEnableEtb(this.mPlayerCtx, enable);
    }

    public void EnableDrc(boolean enable) {
        this.nativeEnableDrc(this.mPlayerCtx, enable);
    }

    public void EnableDenoiser(boolean enable) {
        this.nativeEnableDenoiser(this.mPlayerCtx, enable);
    }

    public void SetDenoiseType(Constant.DenoiseModuleType aecImproveNsType) {
        this.nativeSetDenoiseType(this.mPlayerCtx, aecImproveNsType.ordinal());
    }

    private void OnPlayerEndEvent() {
        if (this.mNotify != null) {
            this.mNotify.OnPlayerEnd();
        }
    }

    private void OnPlayerVolumeEvent(int volume, long currentTime, long totalTime) {
        if (this.mNotify != null) {
            this.mNotify.OnPlayerVolume(volume, currentTime, totalTime);
        }
    }

    private native long nativeCreateFilePlayer(Object var1);

    private native boolean nativeOpen(long var1, String var3);

    private native long nativeDestroy(long var1);

    private native void nativePlay(long var1);

    private native void nativeStop(long var1);

    private native void nativePause(long var1);

    private native void nativeResume(long var1);

    private native void nativeSeek(long var1, long var3);

    private native void nativeSeekSaver(long var1, long var3);

    private native void nativeSetPlayerVolume(long var1, long var3);

    private native void nativeSetFeedBackToMicMode(long var1, long var3);

    private native long nativeGetTotalPlayLengthMS(long var1);

    private native long nativeGetCurrentPlayTimeMS(long var1);

    private native void nativeSetToneSelValue(long var1, int var3);

    private native void nativeSetTrebleBassVal(long var1, int var3);

    private native void nativeEnableVolumeNotify(long var1, boolean var3);

    private native void nativeEnableLoopPlay(long var1, boolean var3);

    private native void nativeEnableEffect(long var1, boolean var3);

    private native void nativeEnableReverbEx(long var1, boolean var3);

    private native void nativeEnableReverbFv3(long var1, boolean var3);

    private native void nativeEnableEqualizerEx(long var1, boolean var3);

    private native void nativeEnableCompressor(long var1, boolean var3);

    private native void nativeEnableLimiter(long var1, boolean var3);

    private native void nativeSetReverbParameter(long var1, float[] var3);

    private native void nativeSetReverbFv3Param(long var1, float[] var3);

    private native void nativeSetEqualizerParameter(long var1, float[] var3);

    private native void nativeSetCompressorParam(long var1, int[] var3);

    private native void nativeSetLimiterParam(long var1, float[] var3);

    private native boolean nativeStartSaver(long var1, String var3);

    private native boolean nativeStopSaver(long var1);

    private native void nativeEnableMute(long var1, boolean var3);

    private native void nativeEnableEtb(long var1, boolean var3);

    private native void nativeEnableDrc(long var1, boolean var3);

    private native void nativeEnableDenoiser(long var1, boolean var3);

    private native void nativeSetDenoiseType(long var1, int var3);

    public static enum FilePlayerMixerType {
        LocalPlay,
        OverrideMic,
        MixWithMic;

    }
}

