/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import android.util.Log;
import com.yy.audioengine.AudioEngine;
import com.yy.audioengine.Constant;
import com.yy.audioengine.FilePlayer;
import com.yy.audioengine.IAudioRecordToolNotify;
import com.yy.audioengine.IFilePlayerNotify;
import com.yy.audioengine.ISpeechMsgRecorderNotify;
import com.yy.audioengine.SpeechMsgRecorder;

public class AudioRecordTool
implements IFilePlayerNotify,
ISpeechMsgRecorderNotify {
    private static String TAG = "AudioRecordTool";
    private IAudioRecordToolNotify mNotify;
    private AudioEngine mAudioEngine;
    private FilePlayer mAccompanyFilePlayer;
    private SpeechMsgRecorder mRecorder;

    public void initWithAccompanyPath(String accompanyPath) {
        Log.i((String)TAG, (String)("initWithAccompanyPath: " + accompanyPath));
        this.mAudioEngine = new AudioEngine();
        this.mAudioEngine.StartAudioEngine(Constant.AudioEngineMode.Broadcast);
        this.mAudioEngine.SetLoudspeakerStatus(true);
        this.mAccompanyFilePlayer = new FilePlayer();
        this.mAccompanyFilePlayer.EnableVolumeNotify(true);
        this.mAccompanyFilePlayer.Open(accompanyPath);
    }

    public void destroy() {
        if (this.mRecorder != null) {
            this.mRecorder.Destroy();
            this.mRecorder = null;
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Destroy();
            this.mAccompanyFilePlayer = null;
        }
        if (this.mAudioEngine != null) {
            this.mAudioEngine.Destroy();
            this.mAudioEngine = null;
        }
        this.mNotify = null;
    }

    public void setAudioRecordToolNotify(IAudioRecordToolNotify iAudioRecordToolNotify) {
        this.mNotify = iAudioRecordToolNotify;
    }

    public void startPlayAccompany() {
        this.mAccompanyFilePlayer.RegisterNotify(this);
        this.mAccompanyFilePlayer.Play();
    }

    public void startRecord() {
        if (this.mRecorder != null) {
            this.mRecorder.Start(this);
        }
    }

    public void pauseRecord() {
        if (this.mRecorder != null) {
            this.mRecorder.Pause();
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Pause();
        }
    }

    public void resumeRecord() {
        if (this.mRecorder != null) {
            this.mRecorder.Resume();
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Resume();
        }
    }

    public void stopRecord() {
        if (this.mRecorder != null) {
            this.mRecorder.Stop();
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.Stop();
            this.mAccompanyFilePlayer.StopSaver();
        }
    }

    public void setVoiceFilePath(String audioPath) {
        if (this.mRecorder != null) {
            this.mRecorder.Destroy();
            this.mRecorder = null;
        }
        this.mRecorder = new SpeechMsgRecorder(audioPath, 0, SpeechMsgRecorder.SpeechMsgCodecType.SpeechMsgCodecWav, 600000L);
        this.mRecorder.Init();
    }

    public void setAcmpyWavFilePath(String accompanyFilePath) {
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.StartSaver(accompanyFilePath);
        }
    }

    public void setVoiceVolume(int volume) {
        if (this.mRecorder != null) {
            this.mRecorder.SetVolume(volume);
        }
    }

    public void setAccompanyVolume(int volume) {
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.SetPlayerVolume(volume);
        }
    }

    @Override
    public void OnPlayerEnd() {
        Log.i((String)TAG, (String)"OnPlayerEnd...");
        if (this.mNotify != null) {
            this.mNotify.accompanyPlayEnd();
        }
    }

    @Override
    public void OnPlayerVolume(int volume, long currentTime, long totalTime) {
        Log.i((String)TAG, (String)("OnPlayerVolume, volume: " + volume + " ,currentTime: " + currentTime + " ,totalTime: " + totalTime));
        if (this.mNotify != null) {
            this.mNotify.accompanyPlayVolume(volume, currentTime, totalTime);
        }
    }

    @Override
    public void OnAudioVolumeVisual(long recordTime, long volume) {
        if (this.mNotify != null) {
            this.mNotify.voiceRecordVolume(volume, recordTime);
        }
    }

    @Override
    public void OnAudioRecordError() {
    }

    @Override
    public void OnGetFirstRecordData() {
    }

    @Override
    public void OnStopRecordData(long recordTime, long maxDuration) {
    }

    @Override
    public void OnReachMaxDuration(long recordTime, long maxDuration) {
    }
}

