/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.ISpeechMsgPlayerNotify;

public class SpeechMsgPlayer {
    private long mPlayerCtx;
    private ISpeechMsgPlayerNotify mNotify = null;

    SpeechMsgPlayer(String fileName) {
        this.mPlayerCtx = this.nativeCreate(this, fileName);
    }

    public PLAYER_INIT_STATUS Init() {
        this.nativeInit(this.mPlayerCtx);
        return PLAYER_INIT_STATUS.ERROR_NONE;
    }

    public void Start(ISpeechMsgPlayerNotify notify) {
        this.mNotify = notify;
        this.nativeStart(this.mPlayerCtx);
    }

    public void Stop() {
        this.nativeStop(this.mPlayerCtx);
    }

    public void Destroy() {
        this.mPlayerCtx = this.nativeDestroy(this.mPlayerCtx);
    }

    public long FileTime() {
        return this.nativeFileTime(this.mPlayerCtx);
    }

    private void OnAudioPlayStatusEvent(long nowPlayTime, long filePlayTime, long volume) {
        if (this.mNotify != null) {
            this.mNotify.OnAudioPlayStatus(nowPlayTime, filePlayTime, volume);
        }
    }

    private void OnAudioPlayErrorEvent() {
        if (this.mNotify != null) {
            this.mNotify.OnAudioPlayError();
        }
    }

    private void OnFirstStartPlayDataEvent() {
        if (this.mNotify != null) {
            this.mNotify.OnFirstStartPlayData();
        }
    }

    private void OnStopPlayDataEvent(long nowPlayTime, long filePlayTime) {
        if (this.mNotify != null) {
            this.mNotify.OnStopPlayData(nowPlayTime, filePlayTime);
        }
    }

    private void OnReachMaxPlayTimeEvent(long nowPlayTime, long filePlayTime) {
        if (this.mNotify != null) {
            this.mNotify.OnReachMaxPlayTime(nowPlayTime, filePlayTime);
        }
    }

    private native long nativeCreate(Object var1, String var2);

    private native long nativeDestroy(long var1);

    private native int nativeInit(long var1);

    private native void nativeStart(long var1);

    private native void nativeStop(long var1);

    private native long nativeFileTime(long var1);

    public static enum PLAYER_INIT_STATUS {
        ERROR_NONE,
        ERROR_FILE_OPEN,
        ERROR_HEADER_LENGTH,
        ERROR_UNKNOWN_CODEC,
        ERROR_DECODER_INIT;

    }
}

