#ifndef _JVM_H_
#define _JVM_H_

#ifdef ANDROID

#include <jni.h>

class JNIEXPORT Jvm
{
public:
    static Jvm* Instance();
    static void Initialize(JavaVM* jvm, jobject context);
    static void Uninitialize();

    JavaVM* jvm() const { return jvm_; }
    jobject context() const { return context_; }
    JNIEnv* jni() const;

private:
    Jvm(JavaVM* jvm, jobject context);
    ~Jvm();

    JavaVM* const jvm_;
    jobject context_;
};

class AttachCurrentThread
{
public:
    AttachCurrentThread();
    ~AttachCurrentThread();
    JNIEnv* env() { return env_; }
private:
    bool attached_;
    JNIEnv* env_;
};
#endif

#endif