/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.Constant;

public class AudioDecoder {
    private static final String TAG = "AudioDecoder";
    private long mCodecCtx;

    public AudioDecoder(Constant.AudioCoderType codecType) {
        int codec = codecType.ordinal();
        this.mCodecCtx = this.nativeCreateAudioDecoder(codec);
    }

    public void init() {
        this.nativeInit(this.mCodecCtx);
    }

    public void uninit() {
        this.nativeUninit(this.mCodecCtx);
    }

    public void flush() {
        this.nativeFlush(this.mCodecCtx);
    }

    public byte[] decode(byte[] inPcm) {
        return this.nativeDecode(this.mCodecCtx, inPcm);
    }

    public byte[] decodeLoss() {
        return this.nativeDecodeLoss(this.mCodecCtx);
    }

    private native long nativeCreateAudioDecoder(int var1);

    private native void nativeInit(long var1);

    private native void nativeUninit(long var1);

    private native void nativeFlush(long var1);

    private native byte[] nativeDecode(long var1, byte[] var3);

    private native byte[] nativeDecodeLoss(long var1);
}

