/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audioengine;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import org.webrtc.audioengine.AudioManagerAndroid;
import org.webrtc.audioengine.VolumeChangeListener;

public class VolumeChangeReceiver
extends BroadcastReceiver {
    private static final String TAG = "[VolumeChangeReceiver]";
    private static final String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";
    private int mPreCallVolume = 0;
    private int mPreMusicVolume = 0;
    private boolean mVolumeChangeRegistered = false;
    public Context mContext;
    private VolumeChangeListener mVolumeChangeListener;

    public VolumeChangeReceiver(Context context, VolumeChangeListener listener) {
        this.mContext = context;
        this.mVolumeChangeListener = listener;
    }

    public void onReceive(Context context, Intent intent) {
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        try {
            if (intent.getAction().equals(VOLUME_CHANGED_ACTION)) {
                int curCallVolume = audioManager.getStreamVolume(0);
                int curMusicVolume = audioManager.getStreamVolume(3);
                if (curCallVolume != this.mPreCallVolume) {
                    this.mPreCallVolume = curCallVolume;
                    this.mVolumeChangeListener.onSystemVolumeChange(this.mPreCallVolume);
                } else if (curMusicVolume != this.mPreMusicVolume) {
                    this.mPreMusicVolume = curMusicVolume;
                    this.mVolumeChangeListener.onSystemVolumeChange(this.mPreMusicVolume);
                }
            }
        }
        catch (Exception e) {
            AudioManagerAndroid.doLog("[VolumeChangeReceiver]VolumeChangeReceiver onReceive failed: " + e.getMessage());
        }
    }

    public void init() {
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mPreCallVolume = audioManager.getStreamVolume(0);
        this.mPreMusicVolume = audioManager.getStreamVolume(3);
        try {
            IntentFilter filter = new IntentFilter();
            filter.addAction(VOLUME_CHANGED_ACTION);
            this.mContext.registerReceiver((BroadcastReceiver)this, filter);
            this.mVolumeChangeRegistered = true;
            AudioManagerAndroid.doLog("[VolumeChangeReceiver]registerVolumeChangeReceiver");
        }
        catch (Exception e) {
            AudioManagerAndroid.doLog("[VolumeChangeReceiver]VolumeChangeReceiver init failed: " + e.getMessage());
        }
    }

    public void uninit() {
        if (this.mVolumeChangeRegistered) {
            try {
                this.mContext.unregisterReceiver((BroadcastReceiver)this);
                this.mVolumeChangeRegistered = false;
                AudioManagerAndroid.doLog("[VolumeChangeReceiver]unregisterVolumeChangeReceiver ");
            }
            catch (Exception e) {
                AudioManagerAndroid.doLog("[VolumeChangeReceiver]unregisterVolumeChangeReceiver error:" + e.getMessage());
            }
        }
    }
}

