/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audioengine;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import com.yy.audioengine.MainHandler;
import org.webrtc.audioengine.AudioManagerAndroid;
import org.webrtc.audioengine.AudioRoutingListener;

public class AudioRoutingController {
    private static final String TAG = "[AudioRoutingController]";
    private Context mContext;
    private final AudioManager mAudioManager;
    private PhoneStateListener mPhoneStateListener = null;
    private boolean mBluetoothConnected = false;
    private boolean mHeadsetConnected = false;
    private boolean mIsHeadsetNoMic = false;
    private boolean mIsSpeakPhoneOn = false;
    private boolean mPhoneStateListenerRegistered = false;
    private AudioRoutingListener mAudioRoutingListener;
    private boolean mIsHeadsetPlugReceiverRegistered = false;
    private EventHandler mEventHandler;
    private int mCurrentRouter = -1;
    private int mTryConnectBtScoTimes = 0;
    private static final int EVT_HEADSET = 1;
    private static final int EVT_BT_SCO = 2;
    public static final int CMD_FORCE_TO_SPEAKER = 3;
    public static final int CMD_SET_DEFAULT_ROUTING = 4;
    public static final int AudioOutputRoutingDefault = -1;
    public static final int AudioOutputRoutingHeadset = 0;
    public static final int AudioOutputRoutingEarpiece = 1;
    public static final int AudioOutputRoutingHeadsetNoMic = 2;
    public static final int AudioOutputRoutingSpeakerphone = 3;
    public static final int AudioOutputRoutingLoudspeaker = 4;
    public static final int AudioOutputRoutingHeadsetBluetooth = 5;
    private BroadcastReceiver mHeadsetPlugReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.hasExtra("state")) {
                int state = intent.getIntExtra("state", 0);
                if (AudioRoutingController.this.mAudioRoutingListener != null) {
                    AudioRoutingController.this.mAudioRoutingListener.onHeadsetState(state);
                }
                if (state == 1) {
                    int microphone = intent.getIntExtra("microphone", -1);
                    if (microphone == 1) {
                        AudioManagerAndroid.doLog("[AudioRoutingController]Headset w/ mic connected");
                        AudioRoutingController.this.sendEvent(1, 0);
                        AudioRoutingController.this.mIsHeadsetNoMic = false;
                    } else {
                        AudioManagerAndroid.doLog("[AudioRoutingController]Headset w/o mic connected");
                        AudioRoutingController.this.sendEvent(1, 2);
                        AudioRoutingController.this.mIsHeadsetNoMic = true;
                    }
                    AudioRoutingController.this.mHeadsetConnected = true;
                } else if (state == 0) {
                    AudioManagerAndroid.doLog("[AudioRoutingController]Headset disconnected");
                    AudioRoutingController.this.sendEvent(1, -1);
                    AudioRoutingController.this.mHeadsetConnected = false;
                }
            }
        }
    };
    private boolean bluetoothReceiverRegistered = false;
    private BroadcastReceiver bluetoothReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if ("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED".equals(intent.getAction())) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                AudioManagerAndroid.doLog("[AudioRoutingController]BluetoothHeadset.ACTION_CONNECTION_STATE_CHANGED: " + state);
                if (state == 2) {
                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (AudioRoutingController.this.mAudioRoutingListener != null) {
                                AudioRoutingController.this.mAudioRoutingListener.onBluetoothState(1);
                                AudioRoutingController.this.mBluetoothConnected = true;
                                AudioRoutingController.this.sendEvent(2, 5);
                            }
                        }
                    }, 2000L);
                } else if (state == 0 && AudioRoutingController.this.mAudioRoutingListener != null) {
                    AudioRoutingController.this.mAudioRoutingListener.onBluetoothState(0);
                    AudioRoutingController.this.mBluetoothConnected = false;
                    AudioRoutingController.this.sendEvent(2, -1);
                }
            } else if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(intent.getAction())) {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
                AudioManagerAndroid.doLog("[AudioRoutingController]BluetoothAdapter.ACTION_STATE_CHANGED: " + state);
                if (state == 10 && AudioRoutingController.this.mAudioRoutingListener != null) {
                    AudioRoutingController.this.mAudioRoutingListener.onBluetoothState(0);
                    AudioRoutingController.this.mBluetoothConnected = false;
                    AudioRoutingController.this.sendEvent(2, -1);
                }
            } else if ("android.media.ACTION_SCO_AUDIO_STATE_UPDATED".equals(intent.getAction())) {
                int state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -99);
                int previousState = intent.getIntExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", -99);
                AudioManagerAndroid.doLog("[AudioRoutingController]bluetooth AudioManager.ACTION_SCO_AUDIO_STATE_UPDATED prev: " + AudioRoutingController.this.scoStateString(previousState) + ", current: " + AudioRoutingController.this.scoStateString(state));
                if (state == 0 && AudioRoutingController.this.mBluetoothConnected && AudioRoutingController.this.mAudioRoutingListener != null && AudioRoutingController.this.mTryConnectBtScoTimes < 3) {
                    AudioRoutingController.this.mAudioRoutingListener.onBluetoothScoState(1);
                    AudioManagerAndroid.doLog("[AudioRoutingController]try reset bluetooth sco, mTryConnectBtScoTimes:" + AudioRoutingController.this.mTryConnectBtScoTimes);
                    AudioRoutingController.this.mTryConnectBtScoTimes++;
                } else if (state == 1) {
                    AudioRoutingController.this.mTryConnectBtScoTimes = 0;
                }
            } else if ("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED".equals(intent.getAction())) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                int previousState = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                AudioManagerAndroid.doLog("[AudioRoutingController]BluetoothHeadset.ACTION_AUDIO_STATE_CHANGED device: " + device.toString() + ", prev: " + previousState + ",current: " + state);
                switch (state) {
                    case 10: {
                        AudioManagerAndroid.doLog("[AudioRoutingController]Bluetooth audio device " + device + " disconnected");
                        break;
                    }
                    case 11: {
                        AudioManagerAndroid.doLog("[AudioRoutingController]Bluetooth audio device " + device + " connecting");
                        break;
                    }
                    case 12: {
                        AudioManagerAndroid.doLog("[AudioRoutingController]Bluetooth audio device " + device + " connected");
                        break;
                    }
                    default: {
                        AudioManagerAndroid.doLog("[AudioRoutingController]Bluetooth audio device " + device + " event, state=" + state);
                    }
                }
            }
        }
    };

    public AudioRoutingController(Context context, AudioRoutingListener listener) {
        this.mContext = context;
        this.mAudioRoutingListener = listener;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mEventHandler = new EventHandler(Looper.getMainLooper());
    }

    public void init() {
        this.registerBluetoothReceiver();
        this.registerHeadsetPlugReceiver();
        this.registerPhoneStateListener();
    }

    public void uninit() {
        this.unregisterBluetoothReceiver();
        this.unRegisterHeadsetPlugReceiver();
        this.unRegisterPhoneStateListener();
    }

    private boolean isCurrentlyOnMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    private void registerHeadsetPlugReceiver() {
        AudioManagerAndroid.doLog("[AudioRoutingController]registerHeadsetPlugReceiver");
        if (!this.mIsHeadsetPlugReceiverRegistered) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.HEADSET_PLUG");
            this.mContext.registerReceiver(this.mHeadsetPlugReceiver, intentFilter);
            this.mIsHeadsetPlugReceiverRegistered = true;
        }
    }

    private void unRegisterHeadsetPlugReceiver() {
        AudioManagerAndroid.doLog("[AudioRoutingController]unRegisterHeadsetPlugReceiver");
        if (this.mIsHeadsetPlugReceiverRegistered) {
            this.mContext.unregisterReceiver(this.mHeadsetPlugReceiver);
            this.mIsHeadsetPlugReceiverRegistered = false;
        }
    }

    @TargetApi(value=14)
    private boolean isBluetoothHeadsetConnected() {
        try {
            int bluetoothStatusHdset;
            BluetoothAdapter bTAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bTAdapter == null) {
                return false;
            }
            if (!this.mAudioManager.isBluetoothScoAvailableOffCall()) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 14 ? 2 == (bluetoothStatusHdset = bTAdapter.getProfileConnectionState(1)) : !BluetoothAdapter.getDefaultAdapter().getBondedDevices().isEmpty()) {
                return true;
            }
        }
        catch (Exception ex) {
            AudioManagerAndroid.doLog("[AudioRoutingController]detect bluetooth error: " + ex.getMessage());
        }
        return false;
    }

    private String scoStateString(int state) {
        if (state == 0) {
            return "SCO_AUDIO_STATE_DISCONNECTED";
        }
        if (state == 1) {
            return "SCO_AUDIO_STATE_CONNECTED";
        }
        if (state == 2) {
            return "SCO_AUDIO_STATE_CONNECTING";
        }
        if (state == -1) {
            return "SCO_AUDIO_STATE_ERROR";
        }
        return "SCO_NULL";
    }

    private boolean hasPermission(Context context, String permission2) {
        return context.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    private void registerBluetoothReceiver() {
        if (!this.hasPermission(this.mContext, "android.permission.BLUETOOTH") || !this.hasPermission(this.mContext, "android.permission.BLUETOOTH_ADMIN")) {
            AudioManagerAndroid.doLog("[AudioRoutingController]bluetooth permission failed.");
            return;
        }
        try {
            if (!this.bluetoothReceiverRegistered) {
                IntentFilter audioFilter = new IntentFilter();
                audioFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
                audioFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
                audioFilter.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
                this.mContext.registerReceiver(this.bluetoothReceiver, audioFilter);
                this.bluetoothReceiverRegistered = true;
            }
        }
        catch (Exception e) {
            AudioManagerAndroid.doLog("[AudioRoutingController]registerBluetoothReceiver error, " + e.getMessage());
        }
        if (this.mAudioRoutingListener == null) {
            return;
        }
        if (this.isBluetoothHeadsetConnected()) {
            this.mAudioRoutingListener.onBluetoothState(1);
            this.mBluetoothConnected = true;
        } else {
            this.mAudioRoutingListener.onBluetoothState(0);
            this.mBluetoothConnected = false;
        }
        AudioManagerAndroid.doLog("[AudioRoutingController]registerBluetoothReceiver");
    }

    private void unregisterBluetoothReceiver() {
        if (!this.hasPermission(this.mContext, "android.permission.BLUETOOTH") || !this.hasPermission(this.mContext, "android.permission.BLUETOOTH_ADMIN")) {
            return;
        }
        if (this.isBluetoothScoOn(this.mContext)) {
            this.startOrStopBluetoothSco(false);
        }
        if (this.bluetoothReceiverRegistered) {
            this.mContext.unregisterReceiver(this.bluetoothReceiver);
            this.bluetoothReceiverRegistered = false;
        }
    }

    private boolean isBluetoothScoOn(Context context) {
        return this.mAudioManager.isBluetoothScoOn();
    }

    private void registerPhoneStateListener() {
        if (this.isCurrentlyOnMainThread()) {
            AudioManagerAndroid.doLog("[AudioRoutingController]registerPhoneStateListener...run on main thread");
            this.listenTelState();
        } else {
            AudioManagerAndroid.doLog("[AudioRoutingController]registerPhoneStateListener...run on async thread");
            MainHandler.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    AudioRoutingController.this.listenTelState();
                }
            });
        }
    }

    private void unRegisterPhoneStateListener() {
        if (this.isCurrentlyOnMainThread()) {
            AudioManagerAndroid.doLog("[AudioRoutingController]unRegisterPhoneStateListener...run on main thread");
            this.notListenTelState();
        } else {
            AudioManagerAndroid.doLog("[AudioRoutingController]unRegisterPhoneStateListener...run on async thread");
            MainHandler.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    AudioRoutingController.this.notListenTelState();
                }
            });
        }
    }

    public void setSpeakerphoneOn(boolean on) {
        this.mAudioManager.setSpeakerphoneOn(on);
        AudioManagerAndroid.doLog("[AudioRoutingController]setSpeakerphoneOn: " + on);
        this.mIsSpeakPhoneOn = on;
        this.sendEvent(3, on ? 3 : 1);
    }

    public void startOrStopBluetoothSco(boolean start) {
        try {
            if (start) {
                this.mAudioManager.setBluetoothScoOn(true);
                this.mAudioManager.startBluetoothSco();
            } else {
                this.mAudioManager.stopBluetoothSco();
                this.mAudioManager.setBluetoothScoOn(false);
            }
            AudioManagerAndroid.doLog("[AudioRoutingController]startOrStopBluetoothSco: " + start);
        }
        catch (Exception ex) {
            AudioManagerAndroid.doLog("[AudioRoutingController]startOrStopBluetoothSco exception: " + ex.getMessage());
        }
    }

    private void listenTelState() {
        try {
            if (this.mPhoneStateListener == null) {
                this.mPhoneStateListenerRegistered = true;
                this.mPhoneStateListener = new MediaPhoneStateListener();
                ((TelephonyManager)this.mContext.getSystemService("phone")).listen(this.mPhoneStateListener, 32);
            }
        }
        catch (Exception ex) {
            AudioManagerAndroid.doLog("[AudioRoutingController]MediaPhoneStateListener listenTelState Error, can't listen, " + ex.getMessage());
        }
    }

    private void notListenTelState() {
        try {
            if (this.mPhoneStateListener != null) {
                ((TelephonyManager)this.mContext.getSystemService("phone")).listen(null, 32);
                this.mPhoneStateListener = null;
                this.mPhoneStateListenerRegistered = false;
            }
        }
        catch (Exception ex) {
            AudioManagerAndroid.doLog("[AudioRoutingController]MediaPhoneStateListener notListenTelState Error, can't listen, " + ex.getMessage());
        }
    }

    private void onAudioRoutingChanged(int routing) {
        if (this.mAudioRoutingListener == null) {
            return;
        }
        if (routing != this.mCurrentRouter) {
            AudioManagerAndroid.doLog("[AudioRoutingController]onAudioRoutingChanged: " + this.getAudioRouteDesc(routing));
            this.mAudioRoutingListener.onAudioRoutingChanged(routing);
            this.mCurrentRouter = routing;
        }
    }

    private void sendEvent(int event, int arg) {
        if (this.mEventHandler != null) {
            Message m = this.mEventHandler.obtainMessage(event, arg, 0);
            this.mEventHandler.sendMessage(m);
        }
    }

    public int queryAudioOutputRouting() {
        try {
            if (this.mBluetoothConnected) {
                return 5;
            }
            if (this.mAudioManager.isWiredHeadsetOn()) {
                return this.mIsHeadsetNoMic ? 2 : 0;
            }
            return this.mAudioManager.isSpeakerphoneOn() ? 3 : 1;
        }
        catch (Exception ex) {
            AudioManagerAndroid.doLog("[AudioRoutingController]querySpeakerStatus exception: " + ex.getMessage());
            return -1;
        }
    }

    private String getAudioRouteDesc(int route) {
        switch (route) {
            case -1: {
                return "Default";
            }
            case 0: {
                return "Headset";
            }
            case 1: {
                return "Earpiece";
            }
            case 2: {
                return "HeadsetOnly";
            }
            case 3: {
                return "Speakerphone";
            }
            case 4: {
                return "Loudspeaker";
            }
            case 5: {
                return "HeadsetBluetooth";
            }
        }
        return "Unknown";
    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg == null) {
                return;
            }
            AudioManagerAndroid.doLog("[AudioRoutingController]EventHandler handleMessage: msg.what: " + msg.what + " ,msg.arg1: " + msg.arg1 + ", mHeadsetConnected: " + AudioRoutingController.this.mHeadsetConnected + ", mBluetoothConnected:" + AudioRoutingController.this.mBluetoothConnected);
            switch (msg.what) {
                case 1: {
                    int router = msg.arg1;
                    if (router != -1) {
                        AudioRoutingController.this.onAudioRoutingChanged(msg.arg1);
                        break;
                    }
                    if (router != -1 || !AudioRoutingController.this.mBluetoothConnected) break;
                    AudioRoutingController.this.onAudioRoutingChanged(5);
                    break;
                }
                case 2: {
                    int router = msg.arg1;
                    if (router != -1) {
                        AudioRoutingController.this.onAudioRoutingChanged(router);
                        break;
                    }
                    if (!AudioRoutingController.this.mHeadsetConnected) {
                        AudioRoutingController.this.onAudioRoutingChanged(AudioRoutingController.this.mIsSpeakPhoneOn ? 3 : 1);
                        break;
                    }
                    AudioRoutingController.this.onAudioRoutingChanged(AudioRoutingController.this.mIsHeadsetNoMic ? 2 : 0);
                    break;
                }
                case 3: {
                    int router = msg.arg1;
                    if (AudioRoutingController.this.mHeadsetConnected || AudioRoutingController.this.mBluetoothConnected) break;
                    AudioRoutingController.this.onAudioRoutingChanged(router);
                    break;
                }
            }
        }
    }

    private class MediaPhoneStateListener
    extends PhoneStateListener {
        private boolean mInCall = false;

        private MediaPhoneStateListener() {
        }

        public void onCallStateChanged(final int state, final String incomingNumber) {
            if (AudioRoutingController.this.mPhoneStateListenerRegistered && AudioRoutingController.this.mAudioRoutingListener != null) {
                MainHandler.getInstance().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        AudioManagerAndroid.doLog("[AudioRoutingController]MediaPhoneStateListener: " + state + ",incomingNumber " + incomingNumber);
                        switch (state) {
                            case 0: {
                                if (!MediaPhoneStateListener.this.mInCall) break;
                                MediaPhoneStateListener.this.mInCall = false;
                                AudioRoutingController.this.mAudioRoutingListener.onPhoneCallState(0);
                                AudioManagerAndroid.doLog("[AudioRoutingController]MediaPhoneStateListener Not in Call");
                                break;
                            }
                            case 1: 
                            case 2: {
                                if (MediaPhoneStateListener.this.mInCall) break;
                                MediaPhoneStateListener.this.mInCall = true;
                                AudioRoutingController.this.mAudioRoutingListener.onPhoneCallState(1);
                                AudioManagerAndroid.doLog("[AudioRoutingController]MediaPhoneStateListener in Call");
                                break;
                            }
                        }
                    }
                }, 2000L);
            }
        }
    }
}

