/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.ISpeechMsgPlayerNotify;

public class SpeechMsgPlayer {
    private long mPlayerCtx;
    private ISpeechMsgPlayerNotify mNotify = null;

    SpeechMsgPlayer(String fileName) {
        this.mPlayerCtx = this.nativeCreate(this, fileName);
    }

    public PLAYER_INIT_STATUS init() {
        this.nativeInit(this.mPlayerCtx);
        return PLAYER_INIT_STATUS.ERROR_NONE;
    }

    public void start(ISpeechMsgPlayerNotify notify) {
        this.mNotify = notify;
        this.nativeStart(this.mPlayerCtx);
    }

    public void stop() {
        this.nativeStop(this.mPlayerCtx);
    }

    public void destroy() {
        this.mPlayerCtx = this.nativeDestroy(this.mPlayerCtx);
    }

    public long fileTime() {
        return this.nativeFileTime(this.mPlayerCtx);
    }

    private void onAudioPlayStatusEvent(long nowPlayTime, long filePlayTime, long volume) {
        if (this.mNotify != null) {
            this.mNotify.onAudioPlayStatus(nowPlayTime, filePlayTime, volume);
        }
    }

    private void onAudioPlayErrorEvent() {
        if (this.mNotify != null) {
            this.mNotify.onAudioPlayError();
        }
    }

    private void onFirstStartPlayDataEvent() {
        if (this.mNotify != null) {
            this.mNotify.onFirstStartPlayData();
        }
    }

    private void onStopPlayDataEvent(long nowPlayTime, long filePlayTime) {
        if (this.mNotify != null) {
            this.mNotify.onStopPlayData(nowPlayTime, filePlayTime);
        }
    }

    private void onReachMaxPlayTimeEvent(long nowPlayTime, long filePlayTime) {
        if (this.mNotify != null) {
            this.mNotify.onReachMaxPlayTime(nowPlayTime, filePlayTime);
        }
    }

    private native long nativeCreate(Object var1, String var2);

    private native long nativeDestroy(long var1);

    private native int nativeInit(long var1);

    private native void nativeStart(long var1);

    private native void nativeStop(long var1);

    private native long nativeFileTime(long var1);

    public static enum PLAYER_INIT_STATUS {
        ERROR_NONE,
        ERROR_FILE_OPEN,
        ERROR_HEADER_LENGTH,
        ERROR_UNKNOWN_CODEC,
        ERROR_DECODER_INIT;

    }
}

