/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import android.os.Build;
import com.yy.audioengine.AudioConfig;
import com.yy.audioengine.IAudioLibJniInit;
import com.yy.audioengine.IKaraokePlaybackNotify;
import com.yy.audioengine.MainHandler;
import com.yy.audioengine.YALog;
import java.util.Arrays;

public class KaraokePlayBack {
    private static String TAG = "[KaraokePlayBack]";
    private IKaraokePlaybackNotify mNotify;
    private long mCtx;

    public void init() {
        YALog.info(TAG + "Init...IsEnableLowLatencyPlayBack: " + AudioConfig.isEnableLowLatencyPlayBack());
        if (AudioConfig.isEnableLowLatencyPlayBack()) {
            IAudioLibJniInit.enableAndroidOpenSlEs(true);
        }
        if (Build.MODEL.equalsIgnoreCase("A1601")) {
            YALog.info(TAG + "Init, oppo A1601 enable openslesout....");
            IAudioLibJniInit.enableAndroidOpenSlEs(true);
        }
        this.mCtx = this.nativeCreateKaraokePlayBack(this);
    }

    public void destroy() {
        YALog.info(TAG + "Destroy.....");
        this.nativeDestroyKaraokePlayBack(this.mCtx);
        this.mCtx = 0L;
        this.mNotify = null;
        if (AudioConfig.isEnableLowLatencyPlayBack()) {
            IAudioLibJniInit.enableAndroidOpenSlEs(false);
        }
        if (Build.MODEL.equalsIgnoreCase("A1601")) {
            YALog.info(TAG + "Destroy, oppo A1601 disable openslesout....");
            IAudioLibJniInit.enableAndroidOpenSlEs(false);
        }
    }

    public boolean open(String voiceFile, String accompanyFile) {
        YALog.info(TAG + "Open, voiceFile: " + voiceFile + " ,accompanyFile: " + accompanyFile);
        return this.nativeOpen(this.mCtx, voiceFile, accompanyFile);
    }

    public void play() {
        YALog.info(TAG + "Play.....");
        this.nativePlay(this.mCtx);
    }

    public void stop() {
        YALog.info(TAG + "Stop.....");
        this.nativeStop(this.mCtx);
    }

    public void pause() {
        YALog.info(TAG + "Pause.....");
        this.nativePause(this.mCtx);
    }

    public void resume() {
        YALog.info(TAG + "Resume.....");
        this.nativeResume(this.mCtx);
    }

    public void seek(long seekTime) {
        YALog.info(TAG + "Seek, seekTime: " + seekTime);
        this.nativeSeek(this.mCtx, seekTime);
    }

    public void setKaraokePlaybackNotify(IKaraokePlaybackNotify notify) {
        YALog.info(TAG + "setKaraokePlaybackNotify: " + notify);
        this.mNotify = notify;
    }

    public void enableReverbNew(boolean enable) {
        YALog.info(TAG + "EnableReverbNew. enable: " + enable);
        this.nativeEnableReverbNew(this.mCtx, enable);
    }

    public void setReverbNewParam(float[] array) {
        YALog.info(TAG + "SetReverbNewParam,array: " + Arrays.toString(array));
        this.nativeSetReverbNewParam(this.mCtx, array);
    }

    public void enableEqualizer(boolean enable) {
        YALog.info(TAG + "EnableEqualizer. enable: " + enable);
        this.nativeEnableEqualizer(this.mCtx, enable);
    }

    public void setEqGains(float[] array) {
        YALog.info(TAG + "SetEqGains,array: " + Arrays.toString(array));
        this.nativeSetEqGains(this.mCtx, array);
    }

    public void enableCompressor(boolean enable) {
        YALog.info(TAG + "EnableCompressor. enable: " + enable);
        this.nativeEnableCompressor(this.mCtx, enable);
    }

    public void setCompressorParam(int[] array) {
        YALog.info(TAG + "SetCompressorParam,array: " + Arrays.toString(array));
        this.nativeSetCompressorParam(this.mCtx, array);
    }

    public void enableLimiter(boolean enable) {
        YALog.info(TAG + "EnableLimiter. enable: " + enable);
        this.nativeEnableLimiter(this.mCtx, enable);
    }

    public void setLimiterParam(float[] array) {
        YALog.info(TAG + "SetLimiterParam,array: " + Arrays.toString(array));
        this.nativeSetLimiterParam(this.mCtx, array);
    }

    public void setVoiceOffset(int offsetTime) {
        YALog.info(TAG + "SetVoiceOffset: " + offsetTime);
        this.nativeSetVoiceOffset(this.mCtx, offsetTime);
    }

    public void setTone(int tone) {
        YALog.info(TAG + "SetTone: " + tone);
        this.nativeSetTone(this.mCtx, tone);
    }

    public void setEtbValue(int value) {
        YALog.info(TAG + "SetEtbValue: " + value);
        this.nativeSetEtbValue(this.mCtx, value);
    }

    public void enableDenoise(boolean enable) {
        YALog.info(TAG + "EnableDenoise: " + enable);
        this.nativeEnableDenoise(this.mCtx, enable);
    }

    public void enableDrc(boolean enable) {
        YALog.info(TAG + "EnableDrc: " + enable);
        this.nativeEnableDrc(this.mCtx, enable);
    }

    public void setVoiceVolume(int volume) {
        YALog.info(TAG + "SetVoiceVolume: " + volume);
        this.nativeSetVoiceVolume(this.mCtx, volume);
    }

    public void setAccompanyVolume(int volume) {
        YALog.info(TAG + "SetAccompanyVolume: " + volume);
        this.nativeSetAccompanyVolume(this.mCtx, volume);
    }

    public long getTotalPlayBackTimeMs() {
        return this.nativeGetTotalPlayBackTime(this.mCtx);
    }

    public long getCurrentPlayBackTimeMs() {
        return this.nativeGetCurrentPlayerTime(this.mCtx);
    }

    public void enableLoopPlay(boolean enable) {
    }

    public boolean openAutoToneFilePlayer(String fileName) {
        boolean res = this.nativeOpenAutoToneFilePlayer(this.mCtx, fileName);
        YALog.info(TAG + "OpenAutoToneFilePlayer: " + fileName + " ,res: " + res);
        return res;
    }

    public boolean stopAutoToneFilePlayer() {
        YALog.info(TAG + "StopAutoToneFilePlayer...");
        return this.nativeStopAutoToneFilePlayer(this.mCtx);
    }

    public void chooseAutoToneFilePlayer(boolean isAutoTonePlay) {
        YALog.info(TAG + "ChooseAutoToneFilePlayer, isAutoTonePlay: " + isAutoTonePlay);
        this.nativeChooseAutoToneFilePlayer(this.mCtx, isAutoTonePlay);
    }

    public boolean isAutoToneFilePlaying() {
        return this.nativeIsAutoToneFilePlaying(this.mCtx);
    }

    private void onPlayerEnd() {
        YALog.info(TAG + "OnPlayerEnd...");
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (KaraokePlayBack.this.mNotify != null) {
                    KaraokePlayBack.this.mNotify.onKaraokePlayBackEnd();
                }
            }
        });
    }

    private void onPlayerVolume(long volume, final long currentTime, final long totalTime) {
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (KaraokePlayBack.this.mNotify != null) {
                    KaraokePlayBack.this.mNotify.onKaraokePlayBackTimeInfo(currentTime, totalTime);
                }
            }
        });
    }

    private native long nativeCreateKaraokePlayBack(Object var1);

    private native void nativeDestroyKaraokePlayBack(long var1);

    private native boolean nativeOpen(long var1, String var3, String var4);

    private native void nativePlay(long var1);

    private native void nativePause(long var1);

    private native void nativeResume(long var1);

    private native void nativeStop(long var1);

    private native boolean nativeSeek(long var1, long var3);

    private native long nativeGetTotalPlayBackTime(long var1);

    private native long nativeGetCurrentPlayerTime(long var1);

    private native void nativeSetVoiceVolume(long var1, int var3);

    private native void nativeSetAccompanyVolume(long var1, int var3);

    private native void nativeSetTone(long var1, int var3);

    private native void nativeEnableDenoise(long var1, boolean var3);

    private native void nativeEnableDrc(long var1, boolean var3);

    private native void nativeSetEtbValue(long var1, int var3);

    private native void nativeSetVoiceOffset(long var1, int var3);

    private native boolean nativeOpenAutoToneFilePlayer(long var1, String var3);

    private native boolean nativeStopAutoToneFilePlayer(long var1);

    private native boolean nativeChooseAutoToneFilePlayer(long var1, boolean var3);

    private native boolean nativeIsAutoToneFilePlaying(long var1);

    private native void nativeEnableReverbNew(long var1, boolean var3);

    private native void nativeSetReverbNewParam(long var1, float[] var3);

    private native void nativeEnableEqualizer(long var1, boolean var3);

    private native void nativeSetEqGains(long var1, float[] var3);

    private native void nativeEnableCompressor(long var1, boolean var3);

    private native void nativeSetCompressorParam(long var1, int[] var3);

    private native void nativeEnableLimiter(long var1, boolean var3);

    private native void nativeSetLimiterParam(long var1, float[] var3);
}

