/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.AudioConfig;
import com.yy.audioengine.IAudioLibJniInit;
import com.yy.audioengine.IKaraokeNotify;
import com.yy.audioengine.LineInfo;
import com.yy.audioengine.MainHandler;
import com.yy.audioengine.TimeRange;
import com.yy.audioengine.YALog;

public class Karaoke {
    private static String TAG = "[Karaoke]";
    private IKaraokeNotify mNotify;
    private long mCtx;

    public void init() {
        YALog.info(TAG + "Init...isEnableLowLatencyPlayBack: " + AudioConfig.isEnableLowLatencyPlayBack());
        if (AudioConfig.isEnableLowLatencyPlayBack()) {
            IAudioLibJniInit.enableAndroidOpenSlEs(true);
        }
        this.mCtx = this.nativeCreateKaraoke(this);
    }

    public void destroy() {
        YALog.info(TAG + "Destroy....");
        this.nativeDestroyKaraoke(this.mCtx);
        this.mCtx = 0L;
        if (AudioConfig.isEnableLowLatencyPlayBack()) {
            IAudioLibJniInit.enableAndroidOpenSlEs(false);
        }
        this.mNotify = null;
    }

    public void setKaraokeListener(IKaraokeNotify notify) {
        YALog.info(TAG + "SetKaraokeListener, notify: " + notify);
        this.mNotify = notify;
    }

    public boolean openInputFile(String mixerFile, String accompanyFile) {
        YALog.info(TAG + "OpenInputFile, mixerFile: " + mixerFile + " ,accompanyFile: " + accompanyFile);
        return this.nativeOpenInputFile(this.mCtx, mixerFile, accompanyFile);
    }

    public boolean openOutputFile(String voiceRecordFile, String accompanyRecordFile) {
        YALog.info(TAG + "OpenOutputFile, voiceRecordFile: " + voiceRecordFile + " ,accompanyRecordFile: " + accompanyRecordFile);
        return this.nativeOpenOutputFile(this.mCtx, voiceRecordFile, accompanyRecordFile);
    }

    public boolean openMixFile(String mixFile) {
        YALog.info(TAG + "OpenMixFile, mixFile: " + mixFile);
        return this.nativeOpenMixFile(this.mCtx, mixFile);
    }

    public boolean openAccompanyFile(String accompanyFile) {
        YALog.info(TAG + "OpenAccompanyFile, accompanyFile: " + accompanyFile);
        return this.nativeOpenAccompanyFile(this.mCtx, accompanyFile);
    }

    public void start() {
        YALog.info(TAG + "Start....");
        this.nativeStart(this.mCtx);
    }

    public void pause() {
        YALog.info(TAG + "Pause....");
        this.nativePause(this.mCtx);
    }

    public void resume() {
        YALog.info(TAG + "Resume....");
        this.nativeResume(this.mCtx);
    }

    public void stop() {
        YALog.info(TAG + "Stop....");
        this.nativeStop(this.mCtx);
    }

    public boolean seek(long seekTime) {
        YALog.info(TAG + "Seek, seekTime: " + seekTime);
        return this.nativeSeek(this.mCtx, seekTime);
    }

    public boolean seekToEnd(long seekTime) {
        YALog.info(TAG + "SeekToEnd, seekTime: " + seekTime);
        return this.nativeSeekToEnd(this.mCtx, seekTime);
    }

    public boolean setLyricPauseTime(long pauseTime) {
        YALog.info(TAG + "SetPause, pauseTime: " + pauseTime);
        return this.nativeSetLyricPauseTime(this.mCtx, pauseTime);
    }

    public byte[] setScoreTimeRange(TimeRange[] timeRanges, int count) {
        return this.nativeSetScoreTimeRange(this.mCtx, timeRanges, count);
    }

    public void setLineInfo(LineInfo[] lineInfo, int lineNum) {
        this.nativeSetLineInfo(this.mCtx, lineInfo, lineNum);
    }

    public long getPlayerTime() {
        return this.nativeGetPlayerTime(this.mCtx);
    }

    public long getCurrentPlayerTime() {
        return this.nativeGetCurrentPlayerTime(this.mCtx);
    }

    public void setVoiceVolume(int volume) {
        YALog.info(TAG + "SetVoiceVolume: " + volume);
        this.nativeSetVoiceVolume(this.mCtx, volume);
    }

    public void setAccompanyVolume(int volume) {
        YALog.info(TAG + "SetAccompanyVolume: " + volume);
        this.nativeSetAccompanyVolume(this.mCtx, volume);
    }

    public void setTone(int tone) {
        YALog.info(TAG + "SetTone: " + tone);
        this.nativeSetTone(this.mCtx, tone);
    }

    public void setDisplayTolerate(float lowValue, float highValue) {
        YALog.info(TAG + "SetDisplayTolerate, lowValue" + lowValue + " ,highValue: " + highValue);
        this.nativeSetDisplayTolerate(this.mCtx, lowValue, highValue);
    }

    public boolean setChooseMixFilePlay(boolean mixPlay) {
        YALog.info(TAG + "SetChooseMixFilePlay: " + mixPlay);
        return this.nativeSetChooseMixFilePlay(this.mCtx, mixPlay);
    }

    public boolean enablePlayBack(boolean enable) {
        YALog.info(TAG + "EnablePlayBack: " + enable);
        return this.nativeEnablePlayBack(this.mCtx, enable);
    }

    public boolean isRecordPlayBackEnable() {
        return this.nativeIsRecordPlayBackEnable(this.mCtx);
    }

    public void enableReverbNew(boolean enable) {
        this.nativeEnableReverbNew(this.mCtx, enable);
    }

    public void setReverbNewParam(float[] array) {
        this.nativeSetReverbNewParam(this.mCtx, array);
    }

    public void enableEqualizer(boolean enable) {
        this.nativeEnableEqualizer(this.mCtx, enable);
    }

    public void setEqGains(float[] array) {
        this.nativeSetEqGains(this.mCtx, array);
    }

    public void enableCompressor(boolean enable) {
        this.nativeEnableCompressor(this.mCtx, enable);
    }

    public void setCompressorParam(int[] array) {
        this.nativeSetCompressorParam(this.mCtx, array);
    }

    public void enableLimiter(boolean enable) {
        this.nativeEnableLimiter(this.mCtx, enable);
    }

    public void setLimiterParam(float[] array) {
        this.nativeSetLimiterParam(this.mCtx, array);
    }

    private void onPlayerEnd() {
        if (this.mNotify != null) {
            this.mNotify.onKaraokePlayEnd();
        }
    }

    private void onPlayerVolume(final long volume, final long currentTime, final long totalTime) {
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (Karaoke.this.mNotify != null) {
                    Karaoke.this.mNotify.onKaraokeCurrentPlayVolume(volume, currentTime, totalTime);
                }
            }
        });
    }

    private void onAudioVolumeVisual(final long volume, final long recordTime) {
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (Karaoke.this.mNotify != null) {
                    Karaoke.this.mNotify.onKaraokeCurrentRecordVolume(volume, recordTime);
                }
            }
        });
    }

    private void onAudioRecordError() {
        YALog.error(TAG + "onAudioRecordError...");
        if (this.mNotify != null) {
            this.mNotify.onKaraokeInitError();
        }
    }

    private void onCalcKaraokeScore(byte score, long lineId) {
        if (this.mNotify != null) {
            this.mNotify.onKaraokeScore(score, lineId);
        }
    }

    private void onSingerPitchVisual(byte val, long lineId, long wordId, long wordNum) {
        if (this.mNotify != null) {
            this.mNotify.onKaraokePitch(val, lineId, wordId, wordNum);
        }
    }

    private void onFirstPlayData() {
        YALog.info(TAG + "onFirstPlayData...");
        if (this.mNotify != null) {
            this.mNotify.onKaraokeFirstPlayData();
        }
    }

    private native long nativeCreateKaraoke(Object var1);

    private native void nativeDestroyKaraoke(long var1);

    private native boolean nativeOpenInputFile(long var1, String var3, String var4);

    private native boolean nativeOpenOutputFile(long var1, String var3, String var4);

    private native boolean nativeOpenMixFile(long var1, String var3);

    private native boolean nativeOpenAccompanyFile(long var1, String var3);

    private native void nativeStart(long var1);

    private native void nativePause(long var1);

    private native void nativeResume(long var1);

    private native void nativeStop(long var1);

    private native boolean nativeSeek(long var1, long var3);

    private native boolean nativeSeekToEnd(long var1, long var3);

    private native boolean nativeSetLyricPauseTime(long var1, long var3);

    private native byte[] nativeSetScoreTimeRange(long var1, TimeRange[] var3, long var4);

    private native void nativeSetLineInfo(long var1, LineInfo[] var3, long var4);

    private native long nativeGetPlayerTime(long var1);

    private native long nativeGetCurrentPlayerTime(long var1);

    private native void nativeSetVoiceVolume(long var1, int var3);

    private native void nativeSetAccompanyVolume(long var1, int var3);

    private native void nativeSetTone(long var1, int var3);

    private native void nativeSetDisplayTolerate(long var1, float var3, float var4);

    private native boolean nativeSetChooseMixFilePlay(long var1, boolean var3);

    private native boolean nativeEnablePlayBack(long var1, boolean var3);

    private native boolean nativeIsRecordPlayBackEnable(long var1);

    private native void nativeEnableReverbNew(long var1, boolean var3);

    private native void nativeSetReverbNewParam(long var1, float[] var3);

    private native void nativeEnableEqualizer(long var1, boolean var3);

    private native void nativeSetEqGains(long var1, float[] var3);

    private native void nativeEnableCompressor(long var1, boolean var3);

    private native void nativeSetCompressorParam(long var1, int[] var3);

    private native void nativeEnableLimiter(long var1, boolean var3);

    private native void nativeSetLimiterParam(long var1, float[] var3);
}

