/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.AudioEngine;
import com.yy.audioengine.Constant;
import com.yy.audioengine.FilePlayer;
import com.yy.audioengine.IAudioRecordToolNotify;
import com.yy.audioengine.IFilePlayerNotify;
import com.yy.audioengine.ISpeechMsgRecorderNotify;
import com.yy.audioengine.MainHandler;
import com.yy.audioengine.SpeechMsgRecorder;
import com.yy.audioengine.YALog;

public class AudioRecordTool
implements IFilePlayerNotify,
ISpeechMsgRecorderNotify {
    private static String TAG = "[AudioRecordTool]";
    private IAudioRecordToolNotify mNotify;
    private AudioEngine mAudioEngine;
    private FilePlayer mAccompanyFilePlayer;
    private SpeechMsgRecorder mRecorder;

    public void initWithAccompanyPath(String accompanyPath) {
        YALog.info(TAG + "initWithAccompanyPath: " + accompanyPath);
        this.mAudioEngine = new AudioEngine();
        this.mAudioEngine.startAudioEngine(Constant.AudioEngineMode.Broadcast);
        this.mAudioEngine.setLoudspeakerStatus(true);
        this.mAccompanyFilePlayer = new FilePlayer();
        this.mAccompanyFilePlayer.enableVolumeNotify(true);
        this.mAccompanyFilePlayer.open(accompanyPath);
    }

    public void destroy() {
        YALog.info(TAG + "destroy...");
        if (this.mRecorder != null) {
            this.mRecorder.destroy();
            this.mRecorder = null;
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.destroy();
            this.mAccompanyFilePlayer = null;
        }
        if (this.mAudioEngine != null) {
            this.mAudioEngine.destroy();
            this.mAudioEngine = null;
        }
        this.mNotify = null;
    }

    public void setAudioRecordToolNotify(IAudioRecordToolNotify iAudioRecordToolNotify) {
        YALog.info(TAG + "setAudioRecordToolNotify...");
        this.mNotify = iAudioRecordToolNotify;
    }

    public void startRecord() {
        YALog.info(TAG + "startRecord...");
        if (this.mRecorder != null) {
            this.mRecorder.start(this);
        }
    }

    public void pauseRecord() {
        YALog.info(TAG + "pauseRecord...");
        if (this.mRecorder != null) {
            this.mRecorder.pause();
        }
    }

    public void resumeRecord() {
        YALog.info(TAG + "resumeRecord...");
        if (this.mRecorder != null) {
            this.mRecorder.resume();
        }
    }

    public void stopRecord() {
        YALog.info(TAG + "stopRecord...");
        if (this.mRecorder != null) {
            this.mRecorder.stop();
        }
    }

    public void startPlayAccompany() {
        YALog.info(TAG + "startPlayAccompany...");
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.registerNotify(this);
            this.mAccompanyFilePlayer.play();
            this.mAccompanyFilePlayer.enableLoopPlay(true);
        }
    }

    public void pauseAccompany() {
        YALog.info(TAG + "pauseAccompany...");
        if (this.mAccompanyFilePlayer != null) {
            // empty if block
        }
    }

    public void resumeAccompany() {
        YALog.info(TAG + "resumeAccompany...");
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.resume();
        }
    }

    public void stopAccompany() {
        YALog.info(TAG + "stopAccompany...");
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.stop();
        }
    }

    public void setVoiceFilePath(String audioPath) {
        YALog.info(TAG + "setVoiceFilePath: " + audioPath);
        if (this.mRecorder != null) {
            this.mRecorder.destroy();
            this.mRecorder = null;
        }
        this.mRecorder = new SpeechMsgRecorder(audioPath, 0, SpeechMsgRecorder.SpeechMsgCodecType.SpeechMsgCodecWav, 600000L);
        this.mRecorder.init();
    }

    public void setAcmpyWavFilePath(String accompanyFilePath) {
        YALog.info(TAG + "setAcmpyWavFilePath: " + accompanyFilePath);
        if (this.mAccompanyFilePlayer != null) {
            // empty if block
        }
    }

    public void setVoiceVolume(int volume) {
        if (this.mRecorder != null) {
            this.mRecorder.setVolume(volume);
        }
    }

    public void setAccompanyVolume(int volume) {
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.setPlayerVolume(volume);
        }
    }

    @Override
    public void onPlayerEnd() {
        YALog.info(TAG + "OnPlayerEnd...");
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (AudioRecordTool.this.mNotify != null) {
                    AudioRecordTool.this.mNotify.accompanyPlayEnd();
                }
            }
        });
    }

    @Override
    public void onPlayerVolume(int volume, long currentTime, long totalTime) {
        if (this.mNotify != null) {
            this.mNotify.accompanyPlayVolume(volume, currentTime, totalTime);
        }
    }

    @Override
    public void onAudioVolumeVisual(long recordTime, long volume) {
        if (this.mNotify != null) {
            this.mNotify.voiceRecordVolume(volume, recordTime);
        }
    }

    @Override
    public void onAudioRecordError() {
        if (this.mNotify != null) {
            this.mNotify.onAudioRecordError();
        }
    }

    @Override
    public void onGetFirstRecordData() {
        if (this.mNotify != null) {
            this.mNotify.onGetFirstRecordData();
        }
    }

    @Override
    public void onStopRecordData(long recordTime, long maxDuration) {
        if (this.mNotify != null) {
            this.mNotify.onStopRecordData(recordTime, maxDuration);
        }
    }

    @Override
    public void onReachMaxDuration(long recordTime, long maxDuration) {
        YALog.info(TAG + "OnReachMaxDuration, recordTime: " + recordTime + " ,maxDuration: " + maxDuration);
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (AudioRecordTool.this.mNotify != null) {
                    AudioRecordTool.this.mNotify.onReachMaxDuration();
                }
            }
        });
    }
}

